/*
 * The Legend Lives!
 *
 * Executable and source code are
 *
 *                 Copyright (C) 1995 by David M. Baggett
 *
 * All rights reserved, except as follows:
 * 
 *    Electronic redistribution is permitted, but only if not for profit.
 *    Specifically, you may provide copies in electronic form ONLY if you
 *    do not charge anything beyond the distribution media cost AND if you
 *    do not alter the source code in any way.
 *
 * Note that the author reserves all rights to derivative works and
 * products.  This includes ports and enhanced versions.  The author will
 * typically grant permission for these when asked, but this will be
 * dealt with on a case by case basis only.
 *
 */

/*
 * The matter mover class
 */
class mattermover: Thing
	ismover = true
	autoreset = nil	// mover automatically resets to (0, 0, 0) after move?
	sdesc = "matter mover"
	ldesc = {
		I(); "Matter mover technology hit the scene in 2062VK, 
		just two years before the formation of the Republic. 
		In the hundred or so years since its introduction 
		it's become the primary means of transportation 
		throughout the galaxy. ";
		
		if (self.location = startroom or self.location = adapod) {
			"In fact, it's usually the only exit
			provided in private dwellings like the one
			you're currently in "; note(exitnote); ".";
		}
		if (self.location = startroom) {
			P(); I();
			"Your machine is a roughly person-sized jet 
			black capsule. Bigger ones exist for 
			transporting goods and larger creatures; 
			yours is a typical domestic model, if a bit 
			on the cheap side.  Simply entering the 
			matter mover will activate it."; P(); 
		
			I(); "As is typical, this matter mover has three 
			dials, color coded red, green, and blue.  You 
			set each dial to a number between 0 and 
			10,000, and together the three numbers 
			comprise the receiving station's address ";
			note(matternote); ".  To transport, the 
			receiver must first grant permission to the 
			sender, otherwise the transmission is 
			prohibited.  Many public institutions allow 
			access from all sources; private dwelling 
			movers usually only allow calls from specific 
			individuals or addresses."; P();
		}
		else {
			" This model is quite similar to the one in
			your pod."; P();	
		}
		
		self.address; P();	// Print this machine's address
	
		"Current dial settings: (";
		self.r.printsetting; ", ";
		self.g.printsetting; ", ";
		self.b.printsetting; ")";
	}
	accepting = true	// Assume this machine accepts visitors
	sending = true		// Assume it allows moves out
	address = { ""; }	// No address info by default
	r = { return nil; }
	g = { return nil; }
	b = { return nil; }
	colorspace = { return nil; }
	system = { return nil; }
	planet = { return nil; }
				
	noun = 'mover' 'mattermover' 'matter-mover' 'matter'
	adjective = 'matter'

	verDoTurnto(actor, io) = {}
	doTurnto(actor, io) = {
		if (io <> listObj) {
			"You can either set the matter mover dials
			separately (\"turn red dial to 100\") or set
			them all at once with a command like
			\"set mover to (100, 200, 300)\".";

			return;
		}

		if (length(listObj.value) < 3) {
			"You can set all the mover dials at once
			with a command like
			\"set mover to (100, 200, 300)\".";
		}
		else if (length(listObj.value) > 3) {	
			"The matter mover only has three dials.";
		}
		else {
			local	i;
			
			for (i := 1; i <= 3; i++) {
				if (datatype(listObj.value[i]) <> 1) {
					"All the dial settings must
					be numbers.";

					return;
				}
			}

			self.r.setting := listObj.value[1];
			self.g.setting := listObj.value[2];
			self.b.setting := listObj.value[3];

			"Mover dials set.";
		}
	}
	verDoEnter(actor) = { }
	doEnter(actor) = {
		local desination;

		if (autodialer.isin(self.location))
			autodialer.addselection(self);

		destination := self.checkaddr(actor);
		
		if (destination = nil)
			return;

		"An instant after stepping into
		the chamber, you feel every molecule
		in your body seared off in a flash.  You
		then appear in another matter mover, seemingly
		no worse for wear, but very glad Akmi
		lost the matter mover contract years ago.
		You step out of the machine and look
		around...\b";

		global.colorspace := destination.colorspace;
		global.system := destination.system;
		global.planet := destination.planet;
		Me.travelto(destination.location);
				
		self.reset;
		destination.reset;

		if (autodialer.isin(destination.location))
			autodialer.addselection(destination);
	}
	verDoSitin(actor) = { self.verDoEnter(actor); }
	verDoLiein(actor) = { self.verDoEnter(actor); }
	verDoGetin(actor) = { self.verDoEnter(actor); }
	doSitin(actor) = { self.doEnter(actor); }
	doLiein(actor) = { self.doEnter(actor); }
	doGetin(actor) = { self.doEnter(actor); }

	checkaddr(actor) = {
		local destination;

		/*
		 * Gavin has entered this matter mover.
		 * First we determine what mover (if any) has the
		 * address specified by the dials.  Then we
		 * ask that mover for "permission to board."
		 * If it gives the OK, we move Gavin to the
		 * destination's location.
		 */
		destination := nil;	// assume invalid address

		/*
		 * Loop back
		 */
		if (	self.r.setting = 0 and
			self.g.setting = 0 and
			self.b.setting = 0) destination := self;
		else {
			/*
			 * Search through all movers in the game
			 * to find our destination.
			 */
			local i, o, movers, len;
		
			movers := global.moverlist;
			len := length(movers);
			i := 1;
			while (i <= len) {
				o := movers[i];
				if (	self.r.setting = o.ar and
					self.g.setting = o.ag and
					self.b.setting = o.ab) {

					destination := o;
					break;
				}
				i := i + 1;
			}
		}

		/*
		 * See if we've got a valid address and an accepting
		 * matter mover.
		 */
		if (destination) {
			if (destination = self) {
				"A polite female voice informs you,
				\"Loop-back test passed; verification
				code 931R.  No errors detected.\"";

				return nil;
			}
			else if (not self.sending) {
				"Nothing happens.";
				
				return nil;
			}
			else if (destination.accepting) {
				return destination;
			}
			else {
				self.badaddress;
				return nil;
			}
		}
		else {
			self.badaddress;		
			return nil;
		}
	}
	reset = {
		if (self.autoreset) {
			self.r.setting := 0;
			self.g.setting := 0;
			self.b.setting := 0;
		}
	}
	
	badaddress = {
		"A polite female voice says, \"Your move cannot be 
		completed as dialed.  Please check the number and 
		dial again, and make sure your receiving party has 
		granted you permission to access their mover. If you 
		need assistance, please contact the operator for your 
		local colorspace. Thank you.\"";
	}
;
exitnote: object
	footnote = {
		"In actuality all dwellings are required by law to 
		have some kind of escape hatch, though this 
		regulation is difficult to enforce.";
	}
;
matternote: object	// So all matter movers share this footnote
	footnote = {
		"Matter mover addresses are sometimes referred to as 
		\"colors\" because the dials are associated with 
		component colors red, green, and blue.  Movers within 
		a single geographic area will generally have colors 
		within one small range.  Since it's easier to 
		remember a name than a range of numbers, some 
		portions of the galaxy are routinely referred to by 
		their address group or colorspace name; for example,
		\"<<global.colorspace>>\" is approximately where you
		are now."; P();

		I(); "The setting (0, 0, 0), black,  puts the matter mover in
		loop-back mode, and is only used for testing
 		purposes.  Public movers often set themselves to black
 		after each move to protect the privacy of the last user;
 		domestic models do not normally have this capability."; P();

		I(); "You can set mover coordinates either by turning the dials
		or with a command like \"set mover to (100, 200, 300)\".";
	}
;

/*
 * The RGB dial class, for use with matter movers
 */
class rgbdial: Dial
	sdesc = { self.color; " matter mover dial"; }
	minsetting = 0
	maxsetting = 10000
	noun = 'dial'
	plural = 'dials'

	printsetting = { say(self.setting); }
;
class reddial: rgbdial
	color = "red"
	adjective = 'r' 'red' 'mover' 'mattermover' 'matter'
;
class greendial: rgbdial
	color = "green"
	adjective = 'g' 'green' 'mover' 'mattermover' 'matter'
;
class bluedial: rgbdial
	color = "blue"
	adjective = 'b' 'blue' 'mover' 'mattermover' 'matter'
;

/*
 * The enterviewer class
 */
class ev: Dial
	hasxdesc = nil
 
	sdesc = "Enterviewer (EV)"
	adesc = { "an <<self.sdesc>>"; }
	ldesc = {
		self.initsetting;

		if (self.hasxdesc)
			self.xdesc;
		else {
			I(); "The Akmi Kristl Kleer Kwality PM "; note(evnote);
			" Enterviewer is visually unimpressive, particularly
			considering you've seen about ten thousand identical
			models before.  (Akmi sometimes has a hard time
			letting go once they've found a formula that works.)
			It's orange, it's mauve, it's purple.  It's squat and
			has functionless dimples all over its irregularly
			shaped bulbous case.  The screen is nearly square and
			inset at a jaunty angle. In short, a typical product
			of the Akmi Aesthetix Division "; note(evnote2); "."; P();

			I(); "The EV has a tuning dial; you can choose from
			thousands of different stations from across the
			galaxy. The dial goes from 1 to 100,000 and is
			currently set to "; say(self.setting); "."; P();
	
			I(); self.watchdesc;
		}
	}

	watchdesc = {
		local	t;

		self.initsetting;

		/*
		 * We want the enterviewer program to change every
		 * three turns, and we have 10 total programs.
		 * So we get the turn count mod 30 and divide that
		 * by three to see what channel should be on.
		 */
		t := global.turns;
		t := t - 30 * (t / 30);
		t /= 3;

		/*
		 * Now we tell the player what's coming out of the EV,
		 * based on the station it's set to.
		 */
		if (self.setting = 52109) {
			/*
			 * Progressive music videos from an older time
			 */
			"On the EV, Progressive 52109 is playing the music 
			video for ";

			if (t = 0)
				"\"Cyberspace Meltdown,\" by The Slag Puppies";
			else if (t = 1)
				"\"Dream Terminator,\" by Crucial Taunt";
			else if (t = 2)
				"\"Hop Surfers, Tel Surfers,\" by Rad Doodz";
			else if (t = 3)
				"\"Value Added S\ E\ X,\" by The Infirmed";
			else if (t = 4)
				"\"Tentacled Tyrant,\" by Going Too Kuwl";
			else if (t = 5)
				"\"Cal and his C.A.M.E.L.,\" by Softly Ozark";
			else if (t = 6)
				"\"Oh God I'm so Utterly Depressed,\" by
					Sickeningly Jovial";
			else if (t = 7)
				"\"Pop Sux Rox,\" by Pop Sux Rox";
			else if (t = 8)
				"\"Zing Tschang Tum,\" by ZZiT PHyT";
			else if (t = 9)
				"\"Give me the XES in Excess,\" by ToonSmiths";	
			".";
		} 
		else if (self.setting = 12345) {
			/*
			 * The greenpeace station.
			 * Socically aware music, save-the-galaxy talk, and
			 * stuff like that.
			 */
			"Some galactically-aware people are ";
			if (t = 0)
				"complaining about light pollution";  
			else if (t = 1)
				"discussing the harmful effects of excess
				light on certain types of flora";
			else if (t = 2)
				"protesting on the surface of Plast,
				the synthetic cheese planet that
				houses Akmi Galactic Headquarters";
			else if (t = 3)
				"looking disgustedly upon a large Akmi
				Syntheplast dumping site";
			else if (t = 4)
				"involved in a violent struggle with
				a Pooka wearing a Nodbing coat";
			else if (t = 5)
				"chaining themselves to the engines of
				a soon-to-depart starship";
			else if (t = 6)
				"holding hands and dancing around in a 
				circle";
			else if (t = 7)
				"espousing the virtues of organic foods";
			else if (t = 8)
				"frowning upon a pink cube of Akmi Phood";
			else if (t = 9)
				"asking a shifty-eyed political official
				questions";
			" on the EV.";
		}
		else if (self.setting = 778) {
			/*
			 * Bass Masters and other shows.
			 * The working class people in the more remote
			 * parts of the galaxy love this stuff.
			 */
			"The EV features ";
			if (t = 0)
				"\"Gik Masters,\" a program about
				catching Giks.";
			else if (t = 1)
				"a show in which viewers in the audience
				pretend to be famous personalities.  They
				are very bad actors.";
			else if (t = 2)
				"an advertisement for SleezCo Glop Goo (tm),
				a popular product that tastes foul and causes
				certain death within 5 years of use.";
			else if (t = 3)
				"an advertisement for a personal levitation
				unit that allows the owner to navigate about
				the domicile without exerting any effort
				whatsoever.";
			else if (t = 4)
				"a pink creature waving its arms about
				wildly and spitting green gunk.";
			else if (t = 5)
				"a wretched and very badly dubbed 
				drama involving short red
				creatures that look something like hamsters.";
			else if (t = 6)
				"\"Hard Driver,\" a program about the latest
				and greatest starships and their owners.";
			else if (t = 7)
				"a program that gives tips on how to
				use your C.A.M.E.L. more effectively.";
			else if (t = 8)
				"a guy showing you all the neat stuff
				in his toolbox.";
			else if (t = 9)
				"the Pan-Galactic Lottery drawing.
				(Unfortunately, you didn't win this time.)";
		}
		else if (self.setting = 99999) {
			/*
			 * Talk shows
			 */
			"On the EV a talk show host babbles on about ";

			if (t = 0)
				"how everyone should be nicer to each other.";
			else if (t = 1)
				"the technical difficulties the staff can't
				seem to get fixed at the moment.";
			else if (t = 2)
				"freakish Wurf babies that aren't two-headed.";
			else if (t = 3)
				"how much weight she's lost since last week.";
			else if (t = 4)
				"how silly the last audience member's comments
				were.";
			else if (t = 5)
				"what the has-been actors she has on her show
				are doing now.";
			else if (t = 6)
				"nose-picking as an early symptom of
				latent misogynistic tendencies.";
			else if (t = 7)
				"how hard thinking can be in this day
				and age.";
			else if (t = 8)
				"the miserable state of education in the
				Republic today.";
			else if (t = 9)
				"kinky sexual practices which she seems
				to be quite familiar with.";
		}
		else if (self.setting = 80180) {
			/*
			 * Sports, 37 hours a day.
			 */
			"Channel 80180, your 37-hour sports network, 
			is now featuring ";

			if (t = 0)
				"people throwing things.";
			else if (t = 1)
				"starship races in the Wumsley Wormhole.";
			else if (t = 2)
				"starships pulling heavy things like
				asteroids.";
			else if (t = 3)
				"tennis.";
			else if (t = 4)
				"something that appears to be complete
				chaos, with small furry animals running
				around willy-nilly.";
			else if (t = 5)
				"slamball, the bloody sport that's all
				the rage these days.  This tournament
				game features the Hop Hellions and the
				Tel Mu-tel-ators.  A player was just given
				5 seconds in the penalty box for beheading
				an opponent.  His teammates are now protesting
				the unusual severity of the sanction.";
			else if (t = 6)
				"two green tentacled creatures concentrating
				over a went board.";
			else if (t = 7) {
				"golf.  Yippee "; note(golfnote); ".";
			}
			else if (t = 8)
				"a sport that seems to involve blowing
				things up.";
			else if (t = 9)
				"a tall pink creature standing motionless
				in a field.";
		}
		else if (self.setting = 361) {
			/*
			 * Religious programming (Duhdhists)
			 */
			"Channel 361, the Duhdhist Broadcasting Network,
			is currently enlightening viewers with ";
			
			if (t = 0)
				"\"Igdoof Sits on the Egg,\" a tale
				of fate and retribution.";
			else if (t = 1)
				"\"The Story of Kuulest and the Useless,
				Untutored, Untrained, Utterly Inept Slave.\""; 
			else if (t = 2)
				"a program on life and death in the game
				of went.";
			else if (t = 3)
				"an exposition on the egg.";
			else if (t = 4)
				"omelette recipes.";
			else if (t = 5)
				"a discussion of the evils of egg 
				substitutes.";
			else if (t = 6)
				"a \"Hotline to Duhdha\" hour.";
			else if (t = 7)
				"a serene waterfall scene.  Hmmm...  It looks
				like there's something glistering behind
				the waterfall...";
			else if (t = 8)
				"a philosophical discussion about silence
				and its use in not making noise.";
			else if (t = 9)
				"a panel of experts discussing Duhdha's
				reason for never answering any questions
				with straight answers.";
		}
		else if (self.setting = 1) {
			/*
			 * Kiddie programming
			 */
			"The EV is showing the Kidz Korner, an all-day,
			all-night children's network.  At the moment you
			see ";

			if (t = 0)
				"an advertisement for a doll that belches
				loudly when you squeeze it.";
			else if (t = 1)
				"an advertisement for a yo-yo that snaps
				back and maims the careless child, thereby
				teaching patience and precision.";
			else if (t = 2)
				"an advertisement for Dawgon Yummee Froot
				Snax, Akmi's latest permutation on the
				\"take edible syntheplast, paint it bright
				colors, mold it into shapes that vaguely
				resemble fruit, and sell it to unsuspecting
				parents for huge profits\" ploy.";
			else if (t = 3)
				"an advertisement for a new kind of
				action figure that shoots Actual Real
				Deadly Laser Beams out of its eyes.";
			else if (t = 4)
				"an advertisement for \"Super Sucrose
				'N' Fat Globules,\" the delicious new
				cereal from KrudKo.  Along with three
				cups of barley, a bowl of prunes, and
				a chicken leg, it's a complete breakfast!";
			else if (t = 5)
				"an advertisement for the All-New Improved
				Akmi Cheezerang.";
			else if (t = 6)
				"an advertisement for channel 69, the
				37-hour sex network.";
			else if (t = 7)
				"an advertisement for the Kidz Korner."; 
			else if (t = 8)
				"an advertisement for Sniff 'n' Smile --
				one whiff and you're on Cloud 9!";
			else if (t = 9)
				"an advertisement for the \"Li'l Strumpet
				Makeup Kit.\"";
		}
		else if (self.setting = 69) {
			/*
			 * The 37-hour sex channel.
			 */
			"Channel 69, the 37-hour-a-day pornography channel,
			is currently featuring yet another entirely
			X-rated romp.  I'm sure you can imagine this
			quite adequately on your own.";
		}
		else if (self.setting = 1000) {
			/*
			 * Channel 1000, Top 40 music videos
			 */
			"The EV is tuned to Hot Hits 1000, the 
			\"newest, coolest, most outrageous\" music video
			station.  Yep, it's pop, 37 hours a day.  Right
			now you see the video for ";
			
			if (t = 0) {
#ifndef	DEMO
				if (sketch.wrotesong)
					"\"Me & Gavin Kuulin' on Irata
					with the CAMELs,\" by Timon Sketch
					and the Hoi-Polloi";
				else
#endif
					"\"I Want a Girl with Green Hair
					and Horns,\" by Timon Sketch and
					the Hoi-Polloi";
			}
			else if (t = 1)
				"\"Cook those Honey Buns,\"
				by Sprinkler System";
			else if (t = 2)
				"\"Better Get a Letter,\" by Rockweiler"; 
			else if (t = 3)
				"\"Enough Ain't Enough,\" by Bud Nova";
			else if (t = 4)
				"\"Innocence Lost, Paradise Found,\"
				by Cherry and Plum Blossom";
			else if (t = 5)
				"\"Do Me Love,\" by the Bottles";
			else if (t = 6)
				"\"Surf, Surf, Surf that Wormhole,\"
				by Rad Doodz";
			else if (t = 7)
				"\"Misty Mountains of Moopa,\" by
				Simply Stylish";
			else if (t = 8)
				"\"Akmi Boogie,\" by The Akmi Dam Mellodyc
				Myuusik Groop";
			else if (t = 9)
				"\"Short Length Walkabout,\" by No";
			".";
		}
		else if (self.setting = 28182) {
			/*
			 * The cartoon channel
			 */
			"The EV is tuned to CARTOON MEGASTATION, the
			channel that features nothing but animation
			all day and all night long.   The present
			selection is ";

			if (t = 0)
				"\"The Aksons,\" a look at the wacky,
				whimsy-filled, fancy-free lives of a typical
				working-class family of Akmi employees.";
			else if (t = 1)
				"\"Wings of Love Droid Princess Exciting,\"
				a dubbed masterpiece that sports convertible
				robots, impossibly well-built women wearing
				bikini-shaped armor, and lots and lots of
				gratuitous explosions.  Great stuff!";
			else if (t = 2)
				"a horrible kiddie show with dancing
				KrudKo cereal boxes and the like.";
			else if (t = 3)
				"\"The Kitschy and Retchy Show,\" which
				seems to be about a mouse with poor taste
				in clothing and a cat with a rather
				delicate stomach.  They don't seem to get
				along very well.";
			else if (t = 4)
				"\"Differential Duck,\" the zany adventures
				of a brilliant crime-fighting fowl who placed
				out of calculus as a gosling.";
			else if (t = 5)
				"a nauseating farce involving badly
				voice-acted renditions of popular
				video game characters.";
			else if (t = 6)
				"\"Hallucinatia,\" a semi-coherent animated
				ballet about, well, something or other.";
			else if (t = 7)
				"\"Stupendous Man,\" the popular 
				exposition of the life of a superhero
				and his encounters with, among other
				supervillains, the evil genius \"Doctor
				Derkins.\"";
			else if (t = 8)
				"\"Dream Lime,\" an inexplicably titled
				X-rated work that is unintentionally
				hilarious.";
			else if (t = 9)
				"some truly vomitous schlock about
				overly-cute space ponies with rainbow
				colored ribbons in their manes and 
				high-pitched speaking voices.";
		}
		/* more stations here */
		else if (self.setting = (self.setting / 11) * 11) {
			"The signal is fading in and out.  It sounds
			like music, but you can't tell what kind, and
			the picture is rolling like crazy.";
		}
		else if (self.setting = (self.setting / 7) * 7) {
			"The broadcast features some alien waving its
			appendages about and babbling
			away in a language you don't understand a
			word of.  Assuming, that is, that the
			language HAS words.  You can't really tell.";
		}
		else if (self.setting = (self.setting / 5) * 5) {
			"The EV's getting two overlapping signals,
			the result being that you can't make much
			out except an occasional \"Gilligan!\"";
		}
		else if (self.setting = (self.setting / 3) * 3) {
			if (rndchance(50)) {
				"The EV's blaring an obnoxious advertisement
				for some dreadful alien hygiene product you'd
				rather not know anything about.";
			}
			else {
				"The EV features a noxious talk show.
				The current topic is ";

				if (rndchance(50)) {
					if (rndchance(50)) {
						"androgynous prostitutes
						whose parents didn't force
						them to make their beds
						every day or eat their
						vegetables";
					}
					else {
						"the biological difficulties
						involved in inter-species
						dating";
					}
				}
				else {
					if (rndchance(50)) {
						"problems with excess hair";
					}
					else {
						"creatures who decide to
						get a species change
						operation to please their
						significant others";
					}
				}
				
				".";
			}
		}
		else if (self.setting = (self.setting / 2) * 2) {
			"The EV's picking up some of that
			dreadful SofToonz, Akmi's lame excuse for 
			music, complete with pictures of serene
			landscapes and moire patterns.  They pipe this kind
			of drivel into
			buildings throughout the galaxy because it's been
			found to excite fewer species than any
			other kind of stimulation "; note(kuggles); ".";
		}
		else {
			"There's nothing but static and weird noises
			coming out of the EV.";
		}
	}
		
	initsetting = {
		/*
		 * Set the EV to a random frequency to start out if
		 * it hasn't already been initialized.
		 */
		if (self.setting = 0) {
			self.setting := rnd(100000);
		}
	}

	verDoTurnon(actor) = {
		"No, no, that really is what EV programming is 
		like these days.  The Enterviewer is on and 
		quite functional.  You were expecting something
		entertaining or informative, I suppose?";
	}
	verDoTurnoff(actor) = {
		"What?  Why would you want to?  Anyway, there's
		no off switch.";
	}

	verDoWatch(actor) = {}
	doWatch(actor) = { self.watchdesc; }

	minsetting = 1
	maxsetting = 100000
	noun = 'dial'
	adjective = 'enterviewer' 'ev' 'television' 'tv'
			'boob' 'tube' 'receiver'
;
evnote: object
	footnote = {
		"PM stands for Photonic Modulation, a technique that
		converts sound and images into light.  The light is then
		accelerated to beyond its normal speed via the same
		mechanism used in matter movers.  (Look, don't ask me,
		I didn't invent the stuff!)";
	}
;
evnote2: object
	footnote = {
		"Type \"watch ev\" to get just a description of what's
		on the screen.";
	}
;
kuggles: object
	footnote = {
		"It does have, however, an unusually stimulating effect on the
		Kuggles of Foon, who use similar sounds in their mating
		rituals.  This is a seemingly infinite source of
		amusement for every other species in the galaxy.";
	}
;
golfnote: object
	footnote = { "No offense to you golf fans.  (Snicker.)"; }
;
class pourable: Item
	liquiddesc = "liquid"

	verDoPouron(acto, io) = {}
	doPouron(actor, io) = {
		if (io = self) {
			"Nice idea, but not in this universe.";
		}
		else if (io = Me) {
			"Pouring "; self.liquiddesc; " on yourself
			doesn't seem like the best idea, frankly.";
		}
		else
			self.poureffect(actor, io);
	}
	
	poureffect(actor, o) = {
		if (isclass(o, Actor))
			"Pouring stuff on people isn't going to
			make you popular, you know.";
#ifndef	DEMO
		else if (isclass(o, fencedecoration))
			"You pour some of the <<self.liquiddesc>> on 
			<<o.objthedesc(actor)>>. Sparks fly, and there
			is a loud ZAP.";
#endif
		else 
			"You pour some of the <<self.liquiddesc>> on 
			<<o.objthedesc(actor)>>. \^<<o.subjprodesc>> <<o.is>>
			\ now a bit wet.";
	}
;

//
// A decoration that's in multiple places at once.
//
class floatingdecoration: Floating
	location = {
		if (find(self.loclist, Me.location) <> nil)
			return Me.location;
		else
			return nil;
	}
;
