#charset "us-ascii"

#include <adv3.h>
#include <en_us.h>

#ifndef _BIGNUM_H_
#include <bignum.h>
#endif

 /*
  Typical file build order:
    crom_part.t
    crom_body.t
    diabolical.t <-- main one
    me.t
    crom_npc1-5.t
    hints1.t
    topics1.t
    startrooms.t
    gameclok.t
    flags.t
    lookDir.t
    pathfind.t
    crom_wrd.t
    crom_obj.t
    crom_mod.t
    yesnomaybe.t
  */
  
  /*
      2010 Halloween Contest Entry:   Diabolical

      A "strongly suggested" 10 game room limit.
  
      No game engine restrictions

      Your game should have one of the following themes:
            * Costumes and/or Halloween party
            * Haunted house
            * Encounter with monsters/witches
            * Halloween pranks (maybe that backfire)

   */


/* *** A FOOTNOTE OBJECT! 
 * Use in a string of text like so:  " <<verstionTwoPointO_Footnote.noteRef>> ";
 * 
 * Added this footnote 6/9/2019 to credits (for without having visited that lake the idea 
 * for this game would never have been possible) - Cleo Kraft
 */
verstionTwoPointO_Footnote: Footnote "Version 2.0.0 Tidbits<.p>
                  Expanded the mansion basement \"plug\" area by the dragon.<.p>
                  Added some options at startup. Players can now choose to see html link exits in 
                  the room descriptions for more user friendly game play or else keep the links out
                  for a more traditional text adventure experience.<.p>
                  Fixed form saver and girling booth controls bug (we never use these booths on 
                  anyone but the player so some buggy code was remmed out).<.p>
                  Allow normalized player to give Kimmy the magic book and wand so that 'ask kimmy to turn me into a girl' works.<.p>
                  Added a mirror in the mansion basment dressing room.<.p>
                  Concept History: <i>The lake in this game was inspired by a tiny island in
                  Lake Alpine in the California Sierra Nevada mountains. From the nearby
                  campgrounds you can actually wade over to the island. Ever since camping
                  there I always wondered what it would be like to visit a much bigger lake
                  with a much, much bigger island to explore</i>. - Cleo Kraft ";
    

versionInfo: GameID
    gameRunning = 1 // if 2 then we're in "One Freaky Summer" the bonus game within the game
    IFID = 'd5f58d59-0db2-7379-47fa-d187004c6f12'
    name = versionInfo.gameRunning == 1 ? 'Diabolical' : 'One Freaky Summer'
    byline = 'by Cleo Kraft'
    htmlByline = 'by <a href="mailto:nowhere@nada.net">
                  Cleo Kraft</a>'
    version = '2.0.0' // older ones were 1.0.1, 1.0.2 etc. 2.0 is from 6/6/2019   
    authorEmail = 'Cleo Kraft <katechelonis@gmail.com>, Lashek <lashek@xeraweb.com>'
    desc = versionInfo.gameRunning == 1 ? '<p>This game was originally created by Cleo Kraft as an entry into 
           the <a href=\"http://tfgamessite.com/phpbb3/viewtopic.php?f=12&t=1478">2010 Halloween Contest</a> but 
           has been extended by Lashek (and now <i>re-extended</i> by Cleo Kraft... so tag Lashek, you\'re it (grin)!)</p>
           <p>Diabolical - a transgender transformation adventure. Left on the shore of a mysterious and strange island
        in the center of a huge, remote mountain lake, your adventure begins.</p>' : '<p>One Freaky Summer is the bonus game within the 
        game Diabolical. It is a transgender transformation adventure with age regression. You start out in your bedroom after a heated 
        argument with your little sister.</p>'
    htmlDesc = desc
    /* ******** 
     * Other Optional Fields
     */
    ReleaseDate = '6-JAN-2019' // '25-DEC-2012' // '21-FEB-2007'
    Language = 'en-US'
    LicenseType = 'Freeware' // can be: Freeware, Public Domain, Shareware, Commercial, Commercial Demo, Other
    CopyingRules = 'No-Cost Only' // Compilations Allowed' // Can be: Prohibited, At-Cost Only, No Restrictions, No-Cost Only, Nominal Cost Only, Other
    PresentationProfile = 'Multimedia' // can be 'Plain Text' or 'Multimedia' or 'Default' (user defined) - TADS 3 handles HTML no matter what this setting is set to
    showCredit() { 
       /* ********
        * Show Our credits
        */
        versionInfo.desc();
       "Version history: 
        <br>2.0.0 Beta created in Tads 3 Library version 3.1.3 by Cleo Kraft (in development eff. 6/6/2019)<<verstionTwoPointO_Footnote.noteRef>>\n
        <br>1.0.3 Beta created in Tads 3 Library version 3.1.2 by Lashek\n
        <br>1.0.2 Beta created in Tads 3 Library version 3.0.18 by Cleo Kraft - release: 10/29/2010\n
        <br>1.0.1 Beta created in Tads 3 Library version 3.0.18 by Cleo Kraft\n
        <br>1.0.0 Beta created in Tads 3 Library version 3.0.18 by Cleo Kraft - release: 12SEP2010\n
        \b";
    }
   
 showAbout(){
        say(versionInfo.desc);
        "<br>IFID: <<versionInfo.IFID>>\n";
        "<br>Be sure to check out the TF Games Website at
        <a href=\"http://tfgames.site\">http://tfgames.site</a><br><br>
        To start a transcript of your adventure at any time please use the command \'<i><b>script</b></i>\'<br>
        </p>";
        
        /*
         *   OLD LINK:
         *   "Be sure to check out the TF Games Website at <a
         *   href=\"http://www.tfgamessite.com\">http://www.tfgamessite.com</a><br><br>
         *   To start a transcript of your adventure at any time please use the
         *   command \'<i><b>script</b></i>\'<br> </p>";
         */
 }
;

/*
 *  Added some Spanish handling for direction commands - 6/6/2019 - Cleo Kraft
 *
 *  NOTE: This doesn't mean we have to ADD the Spanish directions into
 *        the game. This just helps the parser understand and route the words
 *        to the correct direction understanding. 
 *           EX:  > afuera
 *
 *                > What do you want to get out of?
 */
spanishInitObj: PreinitObject
   execute() {
        DefineDirection(norte, Compass, 1000);// north
        DefineDirection(sur, Compass, 1100);// south
        DefineDirection(este, Compass,  1200);// east
        DefineDirection(oeste, Compass,  1300);// west
        DefineDirection(noroeste, Compass, 1400);// northeast
        DefineDirection(noreste, Compass, 1500);// northwest
        DefineDirection(suroeste, Compass, 1600);// southwest
        DefineDirection(sureste, Compass, 1700);// southeast
        DefineDirection(arriba, Vertical, 3000);// up
        DefineDirection(abajo, Vertical, 3100);// down
        /*
         * The compiler didn't like this stuff but that's how file en_us.t handled it.
         * It shouldn't matter now but if we want to make the game bi-lingual we should
         * fix the following remmed out stuff later.  - Cleo Kraft 6/6/2019 
         */
        //DefineDirection(en, Relative, 5000)
        //    defaultConnector(loc) { return noTravelIn; }
        //;// in
        //DefineDirection(afuera, Relative, 5100)
        //    defaultConnector(loc) { return noTravelOut; }
        //;// out
        
        DefineLangDir(norte, 'norte', 'de vuelta a');// north
        DefineLangDir(sur, 'sur', 'de vuelta a');// south
        DefineLangDir(este, 'este', 'de vuelta a');// east
        DefineLangDir(oeste, 'oeste', 'de vuelta a');// west
        DefineLangDir(noroeste, 'noroeste', 'de vuelta a');// northeast
        DefineLangDir(noreste, 'norteste', 'de vuelta a');// northwest
        DefineLangDir(suroeste, 'suroeste', 'de vuelta a');// southwest
        DefineLangDir(sureste, 'sureste', 'de vuelta a');// southeast
        DefineLangDir(arriba, 'arriba', 'atrs');// up
        DefineLangDir(abajo, 'abajo', 'atrs');// down
        DefineLangDir(en, 'en', 'atrs');// in
        DefineLangDir(afuera, 'afuera', 'atrs');// out

   }
;// end spanishInitObj


grammar directionName: 'norte' : DirectionProd
       dir = northDirection
;

grammar directionName: 'sur' : DirectionProd
       dir = southDirection
;

grammar directionName: 'este' : DirectionProd
       dir = eastDirection
;

grammar directionName: 'oeste' : DirectionProd
       dir = westDirection
;

grammar directionName: 'noroeste' : DirectionProd
       dir = northeastDirection
;

grammar directionName: 'norteste' : DirectionProd
       dir = northwestDirection
;

grammar directionName: 'suroeste' : DirectionProd
       dir = southwestDirection
;

grammar directionName: 'sureste' : DirectionProd
       dir = southeastDirection
;

grammar directionName: 'arriba' : DirectionProd
       dir = upDirection
;

grammar directionName: 'abajo' : DirectionProd
       dir = downDirection
;

grammar directionName: 'en' : DirectionProd
       dir = inDirection
;

grammar directionName: 'afuera' : DirectionProd
       dir = outDirection
;

/*
 *  ... END Spanish direction command handling - 6/6/2019 - Cleo Kraft
 */

gameMain: GameMainDef
    /* the initial player character is 'me' */
    playerName = 'Jake' 
    stuckDetectorCount = 0 // bonus game uses a daemon to help out the player once in awhile OR introduce silly random events, etc.
    zort = 0 // egg number
    initialPlayerChar = me
    bonusGameRunning = nil
    betaTester = nil
    allowHtmlLinks = nil
    skipIntro = nil
    allowYouMeMixing = true // true or nill - allow the use of You or Me to refer to selfs (true is default anyway) 
    usePastTense = nil // start the game using the past tense... default is nil. this is optional. See: en_us.t
    showedFootnoteTwo = nil // have we shown the footnote about the "rest" command?
    noSexNotify {
          "<br><table bgcolor=black>
               <tr><td><font color=yellow>In your mind you hear a voice: You have changed into a little girl and as such,
               from here on out through the remainder of your time here you are now barred from all adult content. Have 
               fun and play nice, sweetie. - <i>the pixy enforcers society team</i></font></td></tr></table>";

    }
    // showExitsInStatusline = -1 // nil // optional value - set in showIntro() below.... 
   /*  The following function returns 0 or 1 always.  
    *  This is for use in making sure true/nil returns back 0 or 1 always
    *  Example: if(gameMain.tf(someValue) == 1){ "Do something. "; }    
    */    
   tf(iVal){
         if((iVal== nil) || (iVal==0)) return 0;
         if((iVal== 1) || (iVal==true)) return 1;
         return 0;// false or 0 if anything else
   }
   /* These variables are for in case the player answers a silly retorical question given by the parser
    * 
    * Based on tads2 file "answerme.t" by Scott Steinfath.
    * Converted to tads3 by Cleo K.
    */
   questionAsked = nil  // determines whether a question was asked
   QuestionTurn = 0     // turn in which question was asked
   Qyes = nil           // "yes" response
   Qno = nil            // "no" response
   Qmaybe = nil         // "maybe" response

   retoricReplyYes = "What do you mean \"Yes\"? I don\'t see how that applies here. "
   retoricReplyNo = "What do you mean \"No\"? I don\'t see how that applies here. "
   
    // *** some added for zoompics by Cleo K.
    zoompicallowed = 0 // 1 for allowed
    zoompicfilesm = ''
    zoompicfilelg = ''
    // *** added for expanding the game - by Cleo K.
    girlType = 'normal' // normal or abysmal
    is_a_zombie = nil
    femaleFirstName = 'Audrey' 
    is_a_girl = nil // or true
    is_a_little_girl = nil  // or true old stat used in NeverWinter Nights module - out dated but putting it here anyway
    likesBeingAGirl = 0 // 
    likesGuys = 0
    likesGirls = 100
    likesBeingABoy = 100 // measure 0-100 of how much you like being male or female
    likesBeingALittleGirl = 0
    submissiveness = 0 
    likesBeingSubmissive = 0
    likesMirrors = 0 // sometimes looking in the mirror (if attractive enough) increases how much you like mirrors
    // *** Note: For description stuff (for looking in mirrors) - SEE file: crom_body.t  ...class: CromexxHuman ...method: firstPersondDesc  
    /*
     *  gActor.
     *     is_A_Little_Girl = nil // nil or true 
     *     is_A_Girl = nil // nil or true
     *     bindingStrength = 0 // this magically "binds" you to this current body if it is 100%
     *     percentGirlified = 0 // only really useful on TF machines - natural born girls should NEVER have this value set
     *     pcRace = 'human' // 'human', 'elf', 'dwarf', etc.
     *     pcAge = 18 // default
     *     pcHeight = "6'\ 0\""
     *     pcHair = "brown" // default
     *     pcEyes = "blue" // default  
     *
     */
    // *** binding strength
    binding = 0 // bound to current form if 100+
    // *** birth control pills taken
    birthControlPillsTaken = 0 
    // *** night or day?
    generalTime = 'night' // 'night', 'morning', 'day', 'dawn', 'dusk'
    // *** behavior 
    actsLikeAGirl = 0
    actsLikeALittleGirl = 0
    actsLikeABoy = 100
    // *** binding, etc.
    bindingStrength = 0 // bound to form - if 100% then return to normal impossible under most circumstances
    isShrunk = nil // true or nil - if true you're shrunk down in size (usally to mouse size or something)    
    sizeBindingStrength = 0 // if 100 then bound to your current size - if tiny then stuck that way for good
    shrunkSize = 0 // 0=normal, higher values equal greater shrink size. 1=3 ft. tall, 2=1.5 feet tall, 3=6 inches tall, 4=3 inches tall, 5= 1 inch tall, 6= half an inch tall    
    // *** added for oopsnote (so we don't over do it) see crom_mod.t, modify playerMessages
    showOopsNote = 1 // 0 won't do it. we'll show one time, then stop
   
   /* ******
    * Introduction
    */
   showIntro(){
     /* ******
      * Special H+ char starts HTML in TADS
      * Note: You only need to do this ONCE, when the game
      * starts running. 
      *   Try:
      *      replace commonInit: function { "\H+"; }
      *  
      */
     "\H+";// turns on HTML parser in tads (use \H- to turn it off again). Does nothing if no HTML tads emulator)
     clearScreen(); // clear screen or else you "see" the "H+" command
     "<body bgcolor=black><font color=red><b>WARNING: This is an adult fiction text adventure game. Though there is no sex,
     it might be mentioned (but not described). This game contains transgendered themes including changing into the 
     opposite sex as well as instances of age progression/regression and adult topics (not swearing but certain descriptions
     are intended for adult audiences), so this game is advised for mature players only. If you\'re looking where you shouldn\'t
     then there\'s stuff there intended for adults. Otherwise it\'s basically G-rated allowing freedom for dirty minded adults to <i>try</i>
     things and at least get some sort of parser response.<br><br>Thank you.</b><br></font>&nbsp;&nbsp;&nbsp;
     &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<font color=red><b>- Cleo Kraft</b></font></body><br><br>";

     inputManager.pauseForMore(true);// better than using just the morePrompt()
     clearScreen(); // clear screen or else you "see" the "H+" command

     iDone = 0; 
     local sName = '';
     do{
        "<br>What is your first name (male)? ";
        sName = inputManager.getInputLine(nil, nil);
        sName = sName.toLower();
        if(sName != ''){
          sName = '\^' + sName;
          sName = sName.findReplace([' '], ['']);// strip out whitespace
          "You wish to be called <b><<sName>></b>, is this correct? ";
          s0 = inputManager.getInputLine(nil, nil);
          s0 = s0.toLower();
          if((s0 == 'y') || 
             (s0 == 'yes')
            ){ 
              iDone++;
          }
        }
     }while(iDone==0);
     
     iDone = 0; 
     s0 = '';
     do{
        "<br>Show room exit links in room description text (y/n)? ";
        s0 = inputManager.getInputLine(nil, nil);
        s0 = s0.toLower();
        if((s0 == 'y') || 
             (s0 == 'yes') || 
             (s0 == 'n') ||
             (s0 == 'no')
            ){ 
              iDone++;
        }
     }while(iDone==0);
     if((s0 == 'y') || (s0 == 'yes')){        
        gameMain.allowHtmlLinks = true;
     }else{
        gameMain.allowHtmlLinks = nil;       
     }
     
     iDone = 0; 
     s0 = '';
     do{
        "<br>Skip intro (y/n)? ";
        s0 = inputManager.getInputLine(nil, nil);
        s0 = s0.toLower();
        if((s0 == 'y') || 
             (s0 == 'yes') || 
             (s0 == 'n') ||
             (s0 == 'no')
            ){ 
              iDone++;
        }
     }while(iDone==0);
     if((s0 == 'y') || (s0 == 'yes')){        
        gameMain.skipIntro = true;
     }else{
        gameMain.skipIntro = nil;       
     }
     
     /*
      *   added on 6/6/2019 - Cleo Kraft [Adds the name given to the main player
      *   character in the game so me.vocabWords is updated - allows player to
      *   refer to the name they had given].
      *
      *   For example: If the player types in "Bozo" in the above prompt then
      *   later in the game tries "Examine Bozo" ... the parser knows the player
      *   is referring to themself.
      *
      */
     gameMain.playerName = sName;
     local s4 = sName.findReplace(['\^'], ['']);// strip off junk the parser grabbed in the above routine
     cmdDict.addWord(me, s4, &noun);// (me, 'object' &noun); 
     
     Name = s4;// sName;
     ProperName = s4;// sName;

     // Spanish
     // cmdDict.addWord(north, 'norte', &noun); // fails! 
        
     // ** string break
     clearScreen();
    
     if(!gameMain.skipIntro){
        "<br>\n<p>A small motor boat drops you off on a tiny dock on an island in the center of an enormous mountain lake. Off in the distance to the west, 
        you can just barely make out the tiny glowing dots of lights emanating from a small village. The boat captain waves goodbye as he drives away into 
        the sunset. \"Goodbye!\" he shouts while laughing at you, \"and good luck in that crazy place!\"</p>
         
        <h1>Diabolical</h1>
        <.p>You left your suitcase and important belongings back at the small villa you rented in town. You don\'t even have your
        cellphone with you - out here such technology would be useless anyway. You can\'t believe you actually listened
        to the rantings and ravings of the drunken old man in the tavern the night before and decided to visit this place
        to satisfy your growing curiosity, mainly about the women. Hardly any single beautiful girls in town at all and
        <i>this</i> is the place he claimed where the action was. There were other stories too, suggestions of a mad scientist
        living here in a remote estate. Bizarre experiments, strange goings on... people vanishing, mostly never to return but
        those few who did were said to have appeared back in town years later and seemed to have remained the same age as when
        they left - as though they hadn\'t aged a day... and the stories. Sex changes, body swaps, shrinking machines... all 
        too incredible to believe and yet so tantalizing. You had to come here and see for yourself. The old man gave you 
        specific instructions to avoid the place but you had to come out and see anyway. You had to bribe the boat captain 
        with a sizable sum of cash to even get him to drop you off for the night, though the way he was laughing at you 
        and waving goodbye you\'re not so sure he\'ll be back in the morning to pick you up as planned.<.p>";
        // ** string break
        inputManager.pauseForMore(true);// better than using just the morePrompt()
        "<HR ALIGN=CENTER NOSHADE><br>\nNot wishing to get robbed out here you left your wallet and important belongings locked away in a safe back at the villa. The only thing of
        any value in your posession is a traveller\'s check in case of emergency but you doubt anyone out here would accept it but
        it might be useful in case you have to pay the boat captain again.<.p>
        The few others in town you talked to about this place seemed frightened at the mere mention of the island, as though 
        Dracula himself lived way out here. No one but the old man would even talk to you about it. You didn\'t tell anyone you
        were coming out here. Not even your girlfriend Sherrie back home. She couldn\'t join you on your vacation plans because
        she claimed she was saving it for the holidays. Even if you\'d told her she would never ever let you
        come out here on this island alone. Especially if she knew all the stories and rumors you heard. Women, beautiful women
        all around... and a machine that could change your sex. You know for a fact Sherrie wouldn\'t let you set foot a hundred
        miles from this place if she knew any of that. She\'s so jealous of losing you but at the same time your relationship with
        her hasn\'t been going as far as you\'d hoped and it\'s clear by the way she\'s been treating you lately that you\'re not 
        exactly living up to her high expectations. You know darn well she could have taken even a couple days of vacation to be with
        you on this trip, yet she claimed she wanted to save it. She doesn\'t want you looking at other women yet she hasn\'t gone
        out with you in over two weeks, using one excuse after the other. It\'s only a matter of time now before she dumps you for another
        man. You\'ve had other relationships end this way before. The gradual drifting apart and then the sudden phonecall about \"I think
        it\'s time we started seeing other people.\" She <i>avoids</i> you now, yet in the back of your mind you know she\'s probably a little
        jealous you went on vacation anyway without her. Still, you can\'t wait forever to find out the inevitable. Time to start looking
        for someone new, and if you get lucky here tonight, all the better.<.p>
        You needed this vacation, maybe even more so because Sherrie\'s been letting the relationship drift apart and it\'s been bringing
        you down. You needed to get away from all that, to clear your head about your girl troubles and maybe start looking for someone
        new. There\'s another aspect to all this now that you\'ve heard all the stories about this place and that\'s the sex change
        option. Sex change... now <i>that</i> would be a vacation, you think. To see how the other half lives. To have a woman\'s body
        at your beck and call any time you please. To feel those sexy soft curves from <i>inside</i>... The idea sends shivers of excitement
        up and down your spine. To become the object of your own desire. You\'re crazy about women and this would just send you right over
        the edge and to the brink of absolute extasy. The downside is you\'d be oogled by every strange man you meet in public and maybe
        get hit on all the time. You\'re not thrilled by the idea of any of that, let alone the thought that you might actually wind up
        in bed with a man. You have no attraction at all towards guys and the thought of sleeping with one, even as a woman, really creeps
        you out and makes you sick to your stomach. Maybe if you could just turn into a girl and have a night of fun all by yourself...<.p>";
        // ** string break
        inputManager.pauseForMore(true);// better than using just the morePrompt()
        "<HR ALIGN=CENTER NOSHADE><br>\nYou glance at the trailhead at the end of the dock and realize you hadn\'t really planned
        this all out. It\'s not like you can just walk right up to the mad scientist\'s door and knock on it and say \"hi, I\'m here 
        for a night of fun. Show me your best inventions right now please.\" and expect a positive response.<.p>
        It\'s disturbingly silent here. Just the sound of a light breeze blowing across the lake and the waters gently lapping up
        on the sandy white beach. The sun just went down though you can still see pretty well thanks to the full moon but that jungle
        looks absolutely pitch black. Luckily for you there\'s a little brass lantern sitting atop a small wooden pole at the end of
        the dock. It\'s not on and hopefully it still works. If so, your action is clear. Get to the mansion and sneak inside somehow
        and find one of those inventions without getting caught. Have a night of snooping around fun and return back to the docks in
        the morning and leave this place with no one the wiser. At least... you hope that\'s how it\'ll all work out anyway.<.p> ";
        // ** string break
        inputManager.pauseForMore(true);// better than using just the morePrompt()
     }else{
         "<h1>Diabolical</h1>";// show this if player skipped intro
     }
            
     hintManager.topHintMenuObj = topHintMenu; 

 #ifdef __DEBUG
     "Initializing version <<versionInfo.version>> of <<versionInfo.name>>...\n";
    
     // Simple Room counter...
    local myRoomList = new List();
        for(local oRoom = firstObj(Room); oRoom != nil; oRoom = nextObj(oRoom, Room)){
            myRoomList += oRoom;
    }
    "There are <<myRoomList.length()>> rooms in this game (not including simulated rooms extended using counters, etc.)\n";
 #endif /* __DEBUG */
     
        randomize();
        timeDelay(200);
        tempPlayerClothes.moveInto(gPlayerChar);
        tempPlayerClothes.makeWornBy(gPlayerChar);
        gameMain.zoompicallowed=1;
        gameMain.zoompicfilesm = 'intro_imgsm.jpg';
        gameMain.zoompicfilelg = 'intro_img.jpg';
        resetCromexxDefaultPromptColors();// set the colors to defaults
        libGlobal.playerChar.moveInto(startRoom); 
    }

    cromexxCLS(){
        clearScreen();
        gameMain.resetCromexxDefaultPromptColors();
    }

    resetCromexxDefaultPromptColors(){
    "<BODY bgcolor=white
             text=black
             alink=blue
             link=purple
             input=black
             >";
    }

setAboutBox(){
 "\H+\n
  <ABOUTBOX>\n";
  versionInfo.showAbout();
  "</aboutbox>";
}
 scoreRankTable = 
      [ 
         [ 0, 'a tourist'], 
         [ 5, 'a novice explorer'], 
         [ 10, 'a willing amateur'], 
         [ 15, 'an apprentice adventurer'], 
         [ 25, 'an accomplished adventurer'], 
         [ 40, 'a hero'] 
        ] 
    // maxScore = 43 // you can put this in or leave it out if you have a scoring system (score system auto-tallies the max score)

 /* show our end-of-game message */
showGoodbye()
{
 "<p>Thanks for playing Diabolical!</p>\b";
}

showMyMsgWhenGameWon(){
 "Congratulations! You\'ve defeated the diabolical mad scientist, saved the world and
  won the game!<p><br>
 <br>Cleo Kraft<p><br>";
}
;



