#charset "us-ascii"
#include <advlite.h>

ralph: Actor 'tall old man; distinguished older; gentleman ghost; him' @stockRoom
    "<<if (!hasBeenNamed)>>The distinguished-looking older
    gentleman<<else>>Sir Ralph<<end>> has wavy hair and is wearing a light brown
    suit. He's faintly transparent --- you can see the furniture and the walls through
    him --- a fact that suggests he may be a ghost. "
    refuseCommandMsg = '<q>Mmm.</q> He doesn\'t seem to be paying much attention. '
    shouldNotKissMsg = 'He might misunderstand your intentions. '
    cannotEatMsg = 'Ectoplasm is not known to be very nourishing. '
    shouldNotAttackMsg = 'You probably wouldn\'t be able to injure a ghost. '
    cannotTakeMsg = 'Your hands would probably pass right through him. '
    cannotTakeFromActorMsg (obj) {
        if (gDobj == brownSuit) return 'The brown suit wouldn\'t fit you. ';
        else return '{The ralph} won\'t let you have {the dobj}. ';
    }
    globalParamName = 'ralph'
    hasBeenNamed = nil
    makeProper() {
        addVocab ('Sir Ralph;; Warburton-Leaming');
        hasBeenNamed = true;
    }
    dobjFor(LookThrough) {
        verify() {}
        check() {}
        action() {
            "The objects behind him in the room are gauzily and waveringly visible. ";
        }
    }
;

+ brownSuit: Wearable 'light brown suit; well tailored'
    "{The ralph}'s suit is well tailored. "
    wornBy = ralph
;

+ ralphPreening: ActorState
    specialDesc = "{The ralph} is standing in front of the tall mirror, admiring his own
        reflection. "
    stateDesc = "At the moment, he's admiring himself in the tall mirror. "
;

++ DefaultAnyTopic
    "Perhaps it would be better not to disturb him. "
;

+ ralphHovering: ActorState
    isInitState = true
    firstSpecialDescPrinted = nil
    makeGhostFamiliar() { tGhost.familiar = true; }
    specialDesc () {
        if (!firstSpecialDescPrinted) {
            firstSpecialDescPrinted = true;
            "When you first enter, <<makeGhostFamiliar()>>a tall, distinguished-looking older
            gentleman is sitting in the easy chair, flipping through the pages of a large
            book. <<travelGuide.moveInto(endTable)>>When he sees you, he shuts the book, sets it on the end table beside the
            chair, and stands. <q>Ah, good afternoon,</q> he says. <q>So very nice of you
            to stop by.</q> Oddly, he doesn't seem entirely solid. As he moves around, you
            can sort of see whatever is <i>behind</i> him. ";
        }
        else "{The ralph} hovers quite near your elbow, smiling faintly at you. ";
    }
    beforeAction () {
        if (gActionIs(ConsultAbout)) {
            "Before you can find what you're looking for in the book, {the ralph}
            leans in and riffles the pages rapidly. <q>I'm sure you'll find every page fascinating,</q>
            he says enthusiastically. <q>Here, let me just show you....</q> ";
            exit;
        }
    }
    // If Sir Ralph is not in the ralphPreening state, you won't be able to leave:
    beforeTravel (traveler, connector) {
        "As you move toward the door, suddenly {the ralph} is directly in front of you,
        blocking your path. <q>Oh, but surely you'd like to hear more about my amazing
        travels and adventures!</q> he protests.<<tAdventures.makeFamiliar()>> <q>Really,
        you mustn't leave quite yet!
        Once, <<exploitList.doScript()>>....</q> He goes on in this vein for quite some time, his voice
        droning on as he details his exploits, but you quickly lose the thread of the
        story. ";
        exit;
    }
    exploitList: ShuffledEventList { [
        'in the upper reaches of the Zamboni River, I was attacked by an entire
        flotilla of crocodiles. Armed only with a small pocket knife, I',
        'deep in the Arctic waste, I was forced to eat my dog team in order to avoid
        starvation',
        'in the midst of a terrific sandstorm in the Arabian Peninsula, my camel was
        treacherously stolen by my native guide',
        'while climbing in the Himalayas, I came upon a creature with white fur and
        long fangs. Though it walked upright like a man',
        'during a parachute jump, both my main chute and my reserve chute failed to open.
        As I plummeted toward the onrushing Earth',
        'while deep in a labyrinthine cave system beneath the jungle in Vietnam, I
        was assaulted by a flock of bats the size of giant condors. At that precise
        moment my lamp went out',
        'on a deep sea diving expedition in the Marianas Trench, my air hose became
        entangled. At first I assumed this to have been an accident, but shortly a
        giant squid'
    ] }
;

++ TellTopic [tSamantha, tPromDress]
    "Your tale of woe fails to elicit much in the way of interest, much less
    sympathy. <q>Have I ever told you about the peculiar fashion choices of the women
    of the Andaman Islands?</q> he replies. "
;

++ AskForTopic @travelGuide
    "<q>My book? Really, I couldn't possibly part with it.</q> He shakes his head
    dismissively. "
;

++ AskTopic @travelGuide
    "<q>This,</q> he says proudly, <q>is the record of my travels to distant places.</q> "
;

++ DefaultAskTellTopic, ShuffledEventList
    [
        '<q>How intriguing,</q> he replies. ',
        
        '<q>How fascinating,</q> he replies. ',
        
        '<q>I\'m sorry,</q> he says. <q>I drifted off for just a moment there.</q> ',
        
        '<q>You look quite intelligent,</q> he says. <q>I\'m not entirely sure
        I would be able to add to your store of knowledge.</q> ',
        
        '<q>I do wish I knew a bit more about that subject,</q> he admits. '
    ]
;

++ DefaultGiveShowTopic, ShuffledEventList
    [
        '<q>How intriguing,</q> he says. ',
        
        '<q>That\'s really fascinating,</q> he remarks. ',
        
        '<q>I\'m sorry,</q> he says. <q>I drifted off for just a moment there.</q> ',
        
        '<q>I\'m not acquisitive,</q> he says. <q>I already have all that I
        could possibly desire. But thank you for showing me.</q> ',
        
        '<q>An admirable find,</q> he says. <q>I\'m sure you must feel quite
        proud to have acquired such a thing.</q> '
    ]
;

++ CommandTopic [LookIn, Examine]
    "<q>This is a beautiful mirror,</q> you say, pointing to it. <q>As handsome and distinguished-looking
    as you are, I'm sure you must use it from time to time to make sure your hair isn't mussed.</q>\b
    <q>Well, actually,</q> he admits, <q>now that you mention it....</q> He steps toward the mirror
    and examines his reflection with care, touching his hair, straightening his collar, and then
    striking a series of dignified poses. He seems quite taken with his reflection, in fact. This
    activity <<ralph.setState(ralphPreening)>>continues<<ralphAch.awardPointsOnce()>> for some time. "
    matchDobj = tallMirror
    allowAction = true
;

++ showMirror: ShowTopic @tallMirror
    "<q>This is a beautiful mirror,</q> you say, pointing to it. <q>As handsome and distinguished-looking
    as you are, I'm sure you must use it from time to time to make sure your hair isn't mussed.</q>\b
    <q>Well, actually,</q> he admits, <q>now that you mention it....</q> He steps toward the mirror
    and examines his reflection with care, touching his hair, straightening his collar, and then
    striking a series of dignified poses. He seems quite taken with his reflection, in fact. This
    activity <<ralph.setState(ralphPreening)>>continues<<ralphAch.awardPointsOnce()>> for some time. "
;

++ TellTopic @tallMirror
    "<q>This is a beautiful mirror,</q> you say, pointing to it. <q>As handsome and distinguished-looking
    as you are, I'm sure you must use it from time to time to make sure your hair isn't mussed.</q>\b
    <q>Well, actually,</q> he admits, <q>now that you mention it....</q> He steps toward the mirror
    and examines his reflection with care, touching his hair, straightening his collar, and then
    striking a series of dignified poses. He seems quite taken with his reflection, in fact. This
    activity <<ralph.setState(ralphPreening)>>continues<<ralphAch.awardPointsOnce()>> for some time. "
;

++ ralphHimself: AskTopic, StopEventList @ralph
    [
        '<q>Who are you?</q> you ask.\b
        <q>I,</q> the old man says, drawing himself up grandly to his full height, <q>am
        Sir Ralph Warburton-Leaming, famed explorer.<<ralph.makeProper>> I\'m sure
        you\'ve heard of me.</q> ',
        
        '<q>What are you doing here, Sir Ralph, if you don\'t mind my asking. There
        doesn\'t seem to be much in this little room to explore.</q>\b
        <q>As to that, my dear --- I\'m resting. Taking a brief sojourn before undertaking
        my next arduous and stimulating exploration. I\'ve been told that a Japanese company is planning to
        send a private expedition to the Moon....</q> ',
        
        '<q>I notice I can sort of see through you,</q> you comment. <q>You wouldn\'t by
        any chance be a ghost, would you? I mean, do you remember dying?</q>\b
        He shrugs lightly. <q>Death would only be another adventure. Speaking of which,
        have I told you about the time I was trapped by a cave-in in a diamond mine in South Africa?</q> ',
        
        'Asking Sir Ralph anything more about himself would only give him an excuse to
        trot out more boring stories. '
    ]
;

++ AskTopic @travelGuide
    "<q>Is that your book?</q> you ask.<.p><q>It is indeed. So nice of you to notice! Between
    the pages of this book are detailed my many travels to distant locations.</q> "
;

++ adventureTopic: AskTopic, StopEventList @tAdventures
    [
        '<q>I wouldn\'t mind hearing about your adventures,</q> you comment. <q>You must
        have had an exciting life.</q>\b
        <q>How kind of you to ask,</q> {the ralph} replies. <q>There are so many that
        I hardly know where to start. There was the time I was attacked by a great white
        shark while scuba-diving near the Great Barrier Reef. Would you like to hear about that?
        Silly of me --- of course you would! Well, as I\'m sure you know, the great white
        is the most fearsome predator to be found anywhere in the ocean....</q> He drones
        on for quite a while, detailing his adventure. If you had a mirror handy, you
        could probably watch your own eyes glazing over. ',
        
        '<q>Have you had any other adventures?</q> you ask.\b
        <q>Oh, my dear, you have no idea! Once, in the Amazon jungle, I came upon a
        singularly terrifying scene --- a mortal combat between a panther and a gigantic
        python. When they saw me, they stopped attacking one another and came toward me,
        the both of them, with hunger shining in their eyes. My rifle had jammed....</q>
        He continues in this vein (or perhaps \'vain\') for a good long while, as you do
        your best to stifle a prodigious yawn. ',
        
        'With only the slightest bit of encouragement, {the ralph} regales you with
        more tales of his explorations and exploits, each more improbable than the last. '
    ]
;
        