#charset "us-ascii"
#include <advlite.h>

// The nouns for this class are given bullshit plurals, so that when the player
// enters 'players' or 'guys, it will go to the CollectiveGroup.

class CardPlayer: Fixture, Actor
    vocab = 'card player{xxxqqq};; guy{qqqxxx} man{xqxqxq}'
    actorSpecialDesc = ''
    isHim = true
    shouldNotKissMsg = 'That would certainly disrupt the card game. '
    cannotEatMsg = 'Cannibalism? Really? '
    shouldNotAttackMsg = 'That would disrupt the card game '
;

playersGroup: CollectiveGroup, Actor 'card players;; men themselves people; them' @untendedGarden
    desc {
        "The card players are sitting on benches around the picnic table. One of
        them is a redhead, one is bald, and one is blond. ";
    }
    possAdj = 'the card players\''
    isListed = true
    specialDesc = ""
    myObjects = [al, bob, chuck]
    collectiveActions = [Examine, Attack, Kiss, AskFor]

    cannotTakeMsg = 'You\'d never be able to carry all three of them. '
    cannotEatMsg = 'Cannibalism? Really? '
    cannotAttackMsg = 'So far, they have done you no harm. '
    dobjFor(Kiss) {
        check () { "But you're happily married! "; }
    }
    
    // Note: We can add AskAbout and other conversational actions here, by including them in
    // isCollectiveAction, above. (???) But we'll need to think carefully about whether the card players
    // will ever drop into a ConversationReadyState and need to be greeted. This is perhaps
    // even more significant with TalkTo, which is likely to trigger greeting protocols.
    // Currently (6/9/22), 'talk to card players' doesn't yet work.
;

+ menPausing: ActorState
    isInitState = true
    stateDesc = "Though cards are strewn across the table, the men have paused in their game in order to
        talk with you. ";
;

++ AskTopic @playingCards
    "<q>Nice deck, isn't it?</q> one of them says. <q>You could say we borrowed it
    from a nice lady.</q> One of the other men chuckles. "
;

++ AskTopic @playersGroup
    "<q>We're just three ordinary guys,</q> one of them says. "
;

++ AskTopic @stoneAngel
    "<q>That thing? Looks kinda sad, don't it?</q> "
;
+++ AltTopic
    "<q>Nice harp music. Good idea, givin' it that harp.</q> "
    isActive = harpMusic.isIn(untendedGarden)
;

++ DefaultAskTellTopic, ShuffledEventList
    [
        'The card players glance at one another and shrug.
        <q>We\'re just havin\' a friendly game here,</q> one of them
        says. <q>If you want to talk about somethin\', maybe ask somebody
        else.</q> ',
        
        '<q>Quiz show ended last week,</q> one of them says. The others chuckle. ',
        
        '<q>Do you know what she\'s talkin\' about?</q> one of the men
        says. <q>Me, I got no clue.</q> ',
        
        'The three of them kick the topic around for a few seconds, but there\'s
        no consensus. '
    ]
;

++ DefaultGiveShowTopic, ShuffledEventList
    [
        '<q>Thanks, but no thanks,</q> one of the men says. ',
        
        '<q>Naw, you keep it,</q> one of the men replies. ',
        
        '<q>It\'s not my birthday,</q> one of them says. <q>Either of you guys havin\'
        a birthday today? No? Didn\'t think so.</q> ',
        
        '<q>We got everything we need,</q> one of the men tells you. '
    ]
;

++ TellTopic @tCheating
    "<q>Excuse me,</q> you say. <q>Maybe it's none of my business, but while I was
    watching from the balcony I happened to notice
    him slipping a card out of his back pocket.</q> You point at the red-haired man.<.p>
    The red-haired man gets red in the face and says loudly, <q>What do you think you're
    talkin' about?</q><.p>
    The other two men look at one another, eyebrows raised and
    then nodding. <q>That'd explain why he always
    wins,</q> one of them says. <q>Cheatin', are ya, Al?</q><.p>
    What starts as an argument swiftly devolves into an altercation. Within moments,
    the other two card players are trying to lay hands on the redhead. He breaks and runs,
    and they run after him. Rather suddenly, <<playingCards.playersGone>>you're alone in the garden. "
;
//-----------------
// al
//-----------------

al: CardPlayer '+; handsome blond;; him' @cardTableBenches
    "A handsome man, about 40, with a full head of blond hair in a wind-swept style
    perhaps reminiscent of Robert Redford. "
    disambigName = 'blond card player'
    globalParamName = 'al'
;

+ alSitting: ActorState
    isInitState = true
    stateDesc = "He's holding a handful of cards, but he's looking mainly at you, not at the cards. "
;

++ AskTopic @playingCards
    "<q>Nice deck, isn't it?</q> he says. <q>You could say we borrowed it
    from a nice lady.</q> One of the other men chuckles. "
;

++ AskTopic @playersGroup
    "<q>We're just three ordinary guys,</q> he says. "
;

++ AskTopic @stoneAngel
    "<q>That thing? Looks kinda sad, don't it?</q> "
;
+++ AltTopic
    "<q>Nice harp music. Good idea, givin' it that harp.</q> "
    isActive = harpMusic.isIn(untendedGarden)
;

++ DefaultAskTellTopic, ShuffledEventList
    [
        'The card players glance at one another and shrug.
        <q>We\'re just havin\' a friendly game here,</q> he
        says. ',
        
        '<q>Quiz show ended last week,</q> he says. The others chuckle. ',
        
        '<q>Do you know what she\'s talkin\' about?</q> he says to his
        companions. <q>Me, I got no clue.</q> ',
        
        'The three of them kick the topic around for a few seconds, but there\'s
        no consensus. '
    ]
;

++ DefaultGiveShowTopic, ShuffledEventList
    [
        '<q>Thanks, but no thanks,</q> he says. ',
        
        '<q>Naw, you keep it,</q> he replies. ',
        
        '<q>It\'s not my birthday,</q> he says. <q>Either of you guys havin\'
        a birthday today? No? Didn\'t think so.</q> ',
        
        '<q>We got pretty much everything we need,</q> he tells you. '
    ]
;

++ AskTellTopic @tCheating
    "<q>Excuse me,</q> you say. <q>Maybe it's none of my business, but while I was
    watching from the balcony I happened to notice
    him slipping a card out of his back pocket.</q> You point at the red-haired man.<.p>
    The red-haired man gets red in the face and says loudly, <q>What do you think you're
    talkin' about?</q><.p>
    The other two men look at one another meaningfully. <q>That'd explain why he always
    wins,</q> one of them says. <q>Cheatin', are ya, Al?</q><.p>
    What starts as an argument swiftly devolves into an altercation. Within moments,
    the other two card players are trying to lay hands on the redhead. He breaks and runs,
    and they run after him. Rather suddenly, <<playingCards.playersGone>>you're alone in the garden. "
;

++ DefaultAnyTopic, ShuffledEventList
    [
        'He shrugs. <q>Don\'t know much about that,</q> he admits. ',
        
        '<q>Can\'t tell you anything you\'d care to know,</q> he replies. ',
        
        '<q>That\'s a real puzzler, that is,</q> he says. ',
        
        'He scratches his head. <q>You got me,</q> he responds. '
    ]
;

//-----------------
// bob
//-----------------

bob: CardPlayer '+; burly bald;; him' @cardTableBenches
    "A heavyset bald man, about 50, with a knobby skull and a wide, mobile mouth. "
    disambigName = 'bald card player'
    globalParamName = 'bob'
;

+ bobSitting: ActorState
    isInitState = true
    stateDesc = "He's holding a handful of cards, but he's looking mainly at you, not at the cards. "
;

++ AskTopic @playingCards
    "<q>Nice deck, isn't it?</q> he says. <q>You could say we borrowed it
    from a nice lady.</q> One of the other men chuckles. "
;

++ AskTopic @playersGroup
    "<q>We\'re just three ordinary guys,</q> he says. "
;

++ AskTopic @stoneAngel
    "<q>That thing? Looks kinda sad, don\'t it?</q> "
;
+++ AltTopic
    "<q>Nice harp music. Good idea, givin\' it that harp.</q> "
    isActive = harpMusic.isIn(untendedGarden)
;

++ DefaultAskTellTopic, ShuffledEventList
    [
        'The card players glance at one another and shrug.
        <q>We\'re just havin\' a friendly game here,</q> he
        replies. ',
        
        '<q>Quiz show ended last week,</q> he says. The others chuckle. ',
        
        '<q>Do you know what she\'s talkin\' about?</q> he says to his
        companions. <q>Me, I got no clue.</q> ',
        
        'The three of them kick the topic around for a few seconds, but there\'s
        no consensus. '
    ]
;

++ DefaultGiveShowTopic, ShuffledEventList
    [
        '<q>Thanks, but no thanks,</q> he says. ',
        
        '<q>Naw, you keep it,</q> he replies. ',
        
        '<q>It\'s not my birthday,</q> he says. <q>Either of you guys havin\'
        a birthday today? No? Didn\'t think so.</q> ',
        
        '<q>We got pretty much everything we need,</q> he tells you. '
    ]
;

++ AskTellTopic @tCheating
    "<q>Excuse me,</q> you say. <q>Maybe it's none of my business, but while I was watching
    from the balcony I happened to notice
    him slipping a card out of his back pocket.</q> You point at the red-haired man.<.p>
    The red-haired man gets red in the face and says loudly, <q>What do you think you're
    talkin' about?</q><.p>
    The other two men look at one another meaningfully. <q>That'd explain why he always
    wins,</q> one of them says. <q>Cheatin', are ya, Al?</q><.p>
    What starts as an argument swiftly devolves into an altercation. Within moments,
    the other two card players are trying to lay hands on the redhead. He breaks and runs,
    and they run after him. Rather suddenly, <<playingCards.playersGone>>you're alone in the garden. "
;

++ DefaultAnyTopic, ShuffledEventList
    [
        'He shrugs. <q>Don\'t know much about that,</q> he admits. ',
        
        '<q>Can\'t tell you anything you\'d care to know,</q> he replies. ',
        
        '<q>That\'s a real puzzler, that is,</q> he says. ',
        
        'He scratches his head. <q>You got me,</q> he responds. '
    ]
;

//-----------------
// chuck
//-----------------

chuck: CardPlayer '+; red-haired; redhead; him' @cardTableBenches
    "A red-headed man with freckles. "
    disambigName = 'red-haired card player'
    globalParamName = 'chuck'
;

+ chuckSitting: ActorState
    isInitState = true
    stateDesc = "He's holding a handful of cards, but he's looking mainly at you, not at the cards. "
;

++ AskTopic @playingCards
    "<q>Nice deck, isn't it?</q> he says. <q>You could say we borrowed it
    from a nice lady.</q> One of the other men chuckles. "
;

++ AskTopic @playersGroup
    "<q>We're just three ordinary guys,</q> he says. "
;

++ AskTopic @stoneAngel
    "<q>That thing? Looks kinda sad, don't it?</q> "
;
+++ AltTopic
    "<q>Nice harp music. Good idea, givin' it that harp.</q> "
    isActive = harpMusic.isIn(untendedGarden)
;

++ DefaultAskTellTopic, ShuffledEventList
    [
        'The card players glance at one another and shrug.
        <q>We\'re just havin\' a friendly game here,</q> he
        says. ',
        
        '<q>Nice of you to drop by and chat,</q> he says. ',
        
        '<q>Quiz show ended last week,</q> he says. The others chuckle. ',
        
        '<q>Do you know what she\'s talkin\' about?</q> he says to his
        companions. <q>Me, I got no clue.</q> ',
        
        'The three of them kick the topic around for a few seconds, but there\'s
        no consensus. '
    ]
;

++ DefaultGiveShowTopic, ShuffledEventList
    [
        '<q>Thanks, but no thanks,</q> he says. ',
        
        '<q>You keep it,</q> he tells you. <q>I think I got one just like it at home.</q> ',
        
        '<q>Naw, you keep it,</q> he replies. ',
        
        '<q>It\'s not my birthday,</q> he says. <q>Either of you guys havin\'
        a birthday today? No? Didn\'t think so.</q> ',
        
        '<q>We got pretty much everything we need,</q> he tells you. '
    ]
;

++ AskTellTopic @tCheating
    "<q>Excuse me,</q> you say. <q>Maybe it's none of my business, but while I was watching
    from the balcony I happened to notice
    you slipping a card out of your back pocket.</q><.p>
    The red-haired man gets red in the face and says loudly, <q>What do you think you're
    talkin' about?</q><.p>
    The other two men look at one another meaningfully. <q>That'd explain why he always
    wins,</q> one of them says. <q>Cheatin', are ya, Al?</q><.p>
    What starts as an argument swiftly devolves into an altercation. Within moments,
    the other two card players are trying to lay hands on the redhead. He breaks and runs,
    and they run after him. Rather suddenly, <<playingCards.playersGone>>you're alone in the garden. "
;

++ DefaultAnyTopic, ShuffledEventList
    [
        'He shrugs. <q>Don\'t know much about that,</q> he admits. ',
        
        '<q>Can\'t tell you anything you\'d care to know,</q> he replies. ',
        
        '<q>That\'s a real puzzler, that is,</q> he says. ',
        
        'He scratches his head. <q>You got me,</q> he responds. '
    ]
;
