#charset "us-ascii"

#include <adv3.h>
#include <en_us.h>


connectorIntoPong : OneWayRoomConnector,PongRoomSet
	-> pongHighway1N0
	noteTraversal(traveler) {
		if(traveler==gPlayerChar) {
			gPlayerChar.posture = standing;
		}
	}
		
	endPongGame() {
		"\b
		The ball flies out into the void to the west. You hear a loud <q>BZZZZZZZ!</q>.\b
		*** Game Over ***\b
		";
	}	
;


class PongRoomSet : RoomInSet
	roomSetId = 'PongRoomSet'
	
	notifyBeforeArriving() {
		if(pongBall.daemon==nil) {
			pongBall.daemon = new Daemon(pongBall, &doStuff, 1);			
		}
	}

	notifyBeforeLeaving() {
		if(pongBall.daemon!=nil) {
			pongBall.daemon.removeEvent();
			pongBall.daemon = nil;
		}
		
		pongBall.reset();
		whiteLimo1.reset();
		pongHighway1N0.reset();
	}
;





class PongHighway1 : PongRoomSet,OutdoorRoom
	desc = "The west is a dark void. It's as if you were staring into the night sky on a cloudy
	moonless night. The dark void to the east is similar, but far in the distance you can see a
	short white line. "
;

MultiInstance
	locationList = [pongHighway1N2,pongHighway1N1,pongHighway1N0,pongHighway1S1,pongHighway1S2]
	instanceObject : Decoration {
		'(long) (north-south) (north) (south) (nearly) (almost) (perfectly) (transparent) (clear) glass glass-like material/highway' 'highway' "The highway is made of a nearly transparent glass-like material.
		It's a good thing you don't suffer from vertigo!
		Anyone afraid of heights would probably have had a heart attack the moment they stepped onto it. "
	}
;
+ Decoration 'glass-like glass/material' 'glass-like material'
	"It looks very solid. You are probably in no danger of falling into the void. "
;
+ Decoration 'west infinite dark void' 'void'
	"It's very dark. There aren't even any stars anywhere. "
;

MultiLoc,Distant
	'east white opponent opponent\'s short long bus/line' 'white line'
	"It's hard to make out details, but there is a white line far away in the east.
	it looks like it could be a long white bus. "
	locationList = [pongHighway1N2,pongHighway1N1,pongHighway1N0,pongHighway1S1,pongHighway1S2]
;


pongGarage : PongRoomSet,Room 'blank room'
	"This is a nearly featureless room. To the south is the highway.
	On the wall is a black button of the <q>what-does-this-do</q> variety.
	There are small circular outlines in the walls, ceiling, and floor. "
	south = pongHighway1N2
	
	xPos = -3
	yPos = 3
;
+ circularOutlines : Fixture '(small) circular outline/outlines' 'outlines'
	"Each outline looks almost like it was drawn in pencil. The outlines appear on all the walls,
	the ceiling, and the floor, and are of varying sizes
	ranging from the diameter of your arm to about half a meter wide. "
	isPlural = true
;
+ garageButton : Button, Component 'black button' 'black button'
	"This is a simple black button. "
	dobjFor(Push) {
		verify() {
			if(gPlayerChar.isIn(whiteLimo1)) {
				"You can't reach the button from inside the limo. ";
				exit;
			}
		}
		action() {
			if(whiteLimo1.isIn(pongGarage) && whiteLimo1.damageLevel>0) {
				"Nearly all the outlines open up revealing long steel mechanical arms.
				Some of the arms are holding tools while others are holding parts
				like bolts and white paneling.
				One large arm is holding a big magnet.<.p>
				
				They all spring into action at once. The arms that weren't holding anything grab
				hold of the damaged panels on your limo and tear them off violently. One
				arm attempts to open the hood of the car, but it won't go, so another arm
				uses a jackhammer to get it off.<.p>
				
				Arms poke and wrench and twist and replace various parts of the engine. Then, 
				a new hood is placed over the engine and welded in place. New panels are
				welded into place all over the car. The magnet grabs the roof of the
				car and lifts it up so that additional work can be done underneath.<.p>
				
				While the car is in the air a huge hole opens in the floor and a bunch of
				the arms push the wreckage from your car into it. The hole in the floor
				closes up and the car dropped to the ground with a huge thud.
				Finally, the car is filled up with fuel and
				waxed and buffed until it looks sparkling new again.<.p>
				
				All the arms withdraw back into their holes which close up behind them.
				The room is once again a nearly featureless room.<.p>
				";
				
				achieve.awardPointsOnce();

				whiteLimo1.damageLevel = 0;
				whiteLimo1.wasFixed = true;
				whiteLimo1.justFixed = true;
			} else {
				"Nothing obvious happens. ";
				exit;
			}
		}
		
	}
	
	achieve : Achievement {+1 "fixing the limo"}
;

pongHighway1N2 : PongHighway1 'highway north 2'
	desc {
		"This is the north end of the north-south highway. The highway abruptly ends here.
		To the north is a dark opening in the void. There is a simple sign above the opening. ";
		inherited;
	}
	north = pongGarage
	south = pongHighway1N1
	xPos = -3
	yPos = 2
;
+ Decoration 'simple sign' 'sign'
	"The sign above the door simply says \"The Pit\"."
;

pongHighway1N1 : PongHighway1 'highway north 1'
	desc {
		"This is near the north end of the north-south highway. ";
		inherited;
	}
	north = pongHighway1N2
	south = pongHighway1N0
	xPos = -3
	yPos = 1
;
pongHighway1N0 : PongHighway1 'highway middle'
	desc {
		if(isFirstTimeThisTime) {
			"\b
			Holy crap!<BR>
			<BR>
			<BR>
			Now you know how Rainbow Brite feels when she rides her pony over a rainbow!
			You are in an infinite dark void standing on a long north-south highway made of
			almost perfectly clear glass.
			\b";
		}
		
		"This is the middle of the highway. It continues to the north and south. ";
		inherited;
		isFirstTimeThisTime = nil;
	}
	north = pongHighway1N1
	south = pongHighway1S1
	xPos = -3
	yPos = 0
	
	
	reset() {
		isFirstTimeThisTime = true;
	}
	
	isFirstTimeThisTime = true
;
pongHighway1S1 : PongHighway1 'highway south 1'
	desc {
		"This is near the south end of the north-south highway. ";
		inherited;
	}
	north = pongHighway1N0
	south = pongHighway1S2
	xPos = -3
	yPos = -1
;
pongHighway1S2 : PongHighway1 'highway south 2'
	desc {
		"This is the south end of the north-south highway. The highway abruptly ends here. ";
		inherited;
	}
	north = pongHighway1S1
	xPos = -3
	yPos = -2
;



// This is just the place where the pong ball is while it's moving.
pongVoidMiddle : PongRoomSet,OutdoorRoom
;



whiteLimo1 : PongRoomSet, Car 'your (white) limo/car' 'white limo'
	@pongHighway1S1
	desc {
		if(damageLevel > 0)
			"Your poor limo! The side panels are smashed terribly. The front fender is twisted
			into the hood and every piece of plastic and glass on the car has been smashed
			to bits. Luckily it still appears to run, but only just barely. ";
		else if(wasFixed==true)
			"Your beautiful white stretch limo looks brand new! It doesn't look like
			it was ever damaged! Car dealerships would kill to have a repair shop like that! ";
		else
			"This is a beautiful white stretch limo. It sparkles! ";
	}
	
	useSpecialDesc = (!gPlayerChar.isIn(self))
	specialDesc = "Your limo is parked here. "
	
	damageLevel = 0
	wasFixed = nil
	justFixed = nil
	
	isUndamaged {return damageLevel==0;}

	reset() {
		damageLevel = 0;
		wasFixed = nil;
		justFixed = nil;
		newCarSmell.moveInto(nil);
		moveIntoForTravel(pongHighway1S1);
	}

	dobjFor(SitOn) {
		action() {
			if(justFixed==true) {
				"Just as you open the door to get into the car a little hole opens up in the
				wall and another arm reaches out. It sprays something into your car
				and withdraws back into its hole again which promptly closes up behind it. ";
				
				newCarSmell.moveInto(self);
				justFixed = nil;
			}
			
			inherited;
		}
	}
	
	dobjFor(Fix) {
		verify() {}
		check() {}
		action() {
			if(isUndamaged)
				"It doesn't need to be fixed. It's currently in perfect condition. ";
			else
				"It needs to be fixed, but you have no ability to fix this mess. Perhaps
				there is a mechanic in the area? ";
		}
	}
	
	bounceBall() {
		if(damageLevel==0) {
			callWithSenseContext(self,sight,{:
				"The ball crashes into the side of the car rending metal in a way that would
				make a car aficionado weep. The limo tilts up on two wheels, the ball still
				embedded in its side. For a moment it stays there, poised on two wheels with
				a big white ball sticking out of it like the peanut in a half eaten M&M.\b
				
				Then the car comes crashing down onto all four wheels again. The ball is thrust
				from the car back over to the east. The car has accomplished its task, but
				it has been beaten up pretty badly in the process. It probably couldn't
				sustain another hit like that and survive. "
				});
				
			damageLevel = 1;
		} else {
			callWithSenseContext(self,sight,{:
				"The already damaged limo can't take another hit. The ball rips into one side
				of the limo and out the other side. "
				});

			connectorIntoPong.endPongGame();
			
//			endGame("Apparently the level of reality is very high in this game because
//				the ball rips your body apart and ends your game in a very permanent way.
//				You're dead now. ");
			nestedAction(StopPlaying);
			return;
		}
	}

	xPos {return location.xPos;}
	yPos {return location.yPos;}
;
+ Component 'wheel*wheels' 'wheels'
	"They're of the appropriate shape for driving on smoothly. They are, for instance, not square.
	Nor are they triangular. They are round wheels. "
	isPlural = true
;

newCarSmell : SimpleOdor 'new car smell' 'new car smell'
    "Mmmm. New car smell. "
;

	
	
/*
x-3  x-2 x-1 x=0 x+1 x+2 x+3
----------------------------
y+2   O	  O	  O	  O	  O   |
y+1	  O	  O	  O	  O	  O	  |
y+0	  O	  O	  O	  O	  O	  |
y-1	  O	  O	  O	  O	  O	  |
y-2	  O	  O	  O	  O	  O	  |
*/

class xyPos : Distant
	xPos = 0
	yPos = 0
;

MultiLoc,Distant 'white ball/sphere' 'white ball'
	"It's a white sphere hurtling through the void. "
	initialLocationClass = PongHighway1
;


pongBall : Distant 'white ball' 'white ball' @pongVoidMiddle
	desc {
		switch(xPos) {
			case -3: "The massive ball is right on top of you! It's huge! "; break;
			case -2: "The ball is absolutely humongous and very near! "; break;
			case -1: "The ball is definitely in the area. It is quite huge. "; break;
			case  0: "The ball is big but appears to still be a ways away. "; break;
			case  1: "The ball is a medium sized point in the distance. "; break;
			case  2: "The ball is a small white pinpoint in the distance. "; break;
			case  3: "The ball is a tiny white pinpoint in the distance. "; break;
		}		
		
		switch(xDir) {
			case -1:
				{
					local ballYDest = nextYDest();
					local playerY = gPlayerChar.roomLocation.yPos;
					
					if(playerY==nil)
						exit;
					
					if(ballYDest>playerY) {
						"It appears to be moving toward a point north of you. ";
					} else if(ballYDest==playerY) {
						"It appears to be moving straight toward you. ";
					} else {
						"It appears to be moving toward a point south of you. ";
					}
				}
				break;
			case  0:
				switch(yDir) {
					case  1: "It appears to be moving north. "; break;
					case  0: "It does not appear to be moving at all. "; break;
					case -1: "It appears to be moving south. "; break;
				}
				break;
			case  1:
				switch(yDir) {
					case  1: "It appears to be moving east. "; break;
					case  0: "It appears to be moving east. "; break;
					case -1: "It appears to be moving east. "; break;
				}
				break;
		}
	}
		
	reset() {
		posIx = 1;
		delay = locs[posIx][3];
	}
	
	nextYDest() {
		for(local i=posIx; i<=locs.length; ++i) {
			if(locs[i][1]==-3 || locs[i][1]==3)
				return locs[i][2];
		}
		return locs[locs.length][2];
	}
	
    
	// An array of arrays in the form [xPos,yPos,speed].
	// Note that a speed of 1 means that the ball will move every other turn.
	locs = [
		[ 2, 0, 2],
		[ 1, 0, 2],
		[ 0, 0, 2],
		[-1, 0, 2],
		[-2, 0, 2],
		[-3, 0, 2],
		
		[-2, 0, 1],
		[-1, 0, 1],
		[ 0, 0, 1],
		[ 1, 0, 1],
		[ 2, 0, 1],
		[ 3, 0, 1],
		
		[ 2, 0, 0],
		[ 1, 0, 0],
		[ 0, 0, 0],
		[-1, 0, 0],
		[-2, 0, 0],
		[-3, 0, 0]
		]
		
	
	posIx = 1
	delay = locs[posIx][3]
	

	doStuff {
		if(delay==0) {
			// The ball moves on this turn.
			
			if(xPos==-2 && xDir==-1) {
				// Skip past the part where it's in xPos=-3.
				// It's necessary to do it this way in order for xDir to work properly.
				// If I just removed that part from the list of locations then xDir wouldn't
				// work properly in the part where the ball hit the edge.
				incPosIx();
			
				// WEST SIDE HIT
				// If the ball is just about to hit then check to see if they lose or bounce
				// the ball.
				
				if(whiteLimo1.location.xPos==xPos && whiteLimo1.location.yPos==yPos) {
					whiteLimo1.bounceBall();
				} else {
					if(gPlayerChar.roomLocation.xPos==xPos && gPlayerChar.roomLocation.yPos==yPos) {
						// player is in room as ball goes past their side
					} else {
						// player is not in room as ball goes past their side
					}
					
					connectorIntoPong.endPongGame();
					
					nestedAction(StopPlaying);
					return;
				}
			} else if(xPos==2 && xDir==1) {
				incPosIx();
				
				"A rending of metal emanates from your opponent's car as the ball bounces
				into it. ";
			}
		
			incPosIx();
			
			delay = locs[posIx][3];
		} else {
			// The ball doesn't move into a new room on this turn.
			--delay;
		}
		
		if(!isGameWon()) {
			if(!gPlayerChar.isIn(pongGarage))
				desc;
		} else {
			"The other driver miscalculates and is unable to get into the proper position
			in time. They overshoot and end up getting clipped in the back by the ball
			as it whizzes past. You can hear a faint scream of rage as their car tumbles
			over the edge and into oblivion.\b";
			
			pongMachine.winGame();
			// This is done to prevent any messages about standing up. Otherwise this would
			// be handled automatically.
			if(gPlayerChar.isIn(whiteLimo1)) {
				gPlayerChar.moveIntoForTravel(gPlayerChar.roomLocation);
				gPlayerChar.posture = standing;
			}
			nestedAction(StopPlaying);
			
			//posIx = 1;
		}
	}
	
	
	isGameWon() {
		return posIx >= locs.length;
	}
	
	incPosIx() {
		if(posIx < locs.length) {
			++posIx;
		}
	}
	
	

	xPos {return locs[posIx][1];}
	yPos {return locs[posIx][2];}
	speed {return locs[posIx][3];}
	
	xDir {
		local nextPosIx = posIx + 1;
		if(nextPosIx > locs.length)
			nextPosIx = 1;

		local dist = locs[nextPosIx][1] - locs[posIx][1];
		if(dist > 0)
			return 1;
		else if(dist == 0)
			return 0;
		else
			return -1;
	}
	
	yDir {
		local nextPosIx = posIx + 1;
		if(nextPosIx > locs.length)
			nextPosIx = 1;

		local dist = locs[nextPosIx][2] - locs[posIx][2];
		if(dist > 0)
			return 1;
		else if(dist == 0)
			return 0;
		else
			return -1;
	}
	
	daemon = nil
;


/*
nextToTheButton : NominalPlatform
	location = pongGarage
	name = 'wall'
	actorInPrep = 'against'
;
*/
mechanic : Person '(blue) (overalls) mechanic/guy' 'guy'
	"The guy is slouching against the wall near the button. "
	
	location=pongGarage
	
	specialDesc = "A guy in blue overalls is slouching against the wall. "
	
	isHim = true
	posture = standing
;
+ Decoration '(typical) blue overalls' 'blue overalls'
	"They're typical blue overalls. What type of person wears blue overalls? "
;
+ AskTellTopic @mechanic  topicResponse="<q>Don't worry about me. I do what I do.</q> ";
+ AskTellTopic @whiteLimo1
	topicResponse {
		if(whiteLimo1.isUndamaged())
			"<q>Looks pretty sweet!</q> ";
		else
			"<q>Had a bit of an accident have we?</q> ";
	}
;
+ AskTellTopic @pongBall  topicResponse="<q>People just keep hitting it back and forth. I can't imagine why.</q> ";
+ AskTellTopic @garageButton  topicResponse="<q>It's for pressing.</q> ";
+ AskTellTopic @circularOutlines  topicResponse="<q>Don't worry about them. They do what they do.</q> ";


+ mechanicCommentsAboutBeingInCar : ConvAgendaItem,FurtherDelayableAgendaItem
    isReady = ( inherited() && whiteLimo1.isIn(pongGarage) && !whiteLimo1.isUndamaged() && gPlayerChar.isIn(whiteLimo1) )
	invokeItem() {
		"<q>It looks like your car is pretty messed up, but I can't fix it until you get out of the car.</q> ";
		isDone = true;
	}
	
	initiallyActive = true
	isDone = nil
;

/*
+ mechanicCommentsAboutNiceCar : ConvAgendaItem,FurtherDelayableAgendaItem
    isReady = ( inherited() && whiteLimo1.isIn(pongGarage) && whiteLimo1.isUndamaged() && gPlayerChar.isIn(pongGarage) )
	invokeItem() {
		"The guy scratches his head, <q>Nice car. There doesn't seem to be anything wrong with it though.</q> ";
		isDone = true;
	}
	
	initiallyActive = true
	isDone = nil
;
*/

+ mechanicPushesButton : ConvAgendaItem,FurtherDelayableAgendaItem
    isReady = ( inherited() && whiteLimo1.isIn(pongGarage) && !whiteLimo1.isUndamaged() && !gPlayerChar.isIn(whiteLimo1) )
//&& hasWaitedRequiredDelay(1)	
	invokeItem() {
		"The guy walks over and pushes the button and says, <q>Ok, here we go!</q> ";
		nestedAction(Push,garageButton);
//		isDone = true;
	}
	
	initiallyActive = true
	isDone = nil
;

