/* Copyright (C) 1992 Pete Chown.

   Here is my latest adventure game, Napoleon (see the documentation
   if you don't know why it's called that).  Have fun... (don't cheat,
   even though you've got the source :-) ).

   This game is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 1, or (at your option)
   any later version.

   The game is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   The GNU General Public License is often shipped with GNU software, and
   is generally kept in a file called COPYING or LICENSE.  If you do not
   have a copy of the license, write to the Free Software Foundation,
   675 Mass Ave, Cambridge, MA 02139, USA. */

#include "adv.h"

#ifdef UNIX

#include <termios.h>

#ifdef HAS_UNISTD
#include <unistd.h>
#endif

#endif

#ifndef TIOCGWINSZ
static int screenx = 80,screeny = 24;
#else
static int screenx = 0,screeny = 0;
#endif
static int lineswritten = 0;

int delay;

#ifdef UNIX
static void getscreenx(void)
{
#ifdef TIOCGWINSZ

  struct winsize window_size;

  ioctl(0,TIOCGWINSZ,& window_size);
  screenx = (int) window_size.ws_col;
  screeny = (int) window_size.ws_row;

#else

  fail();

#endif
}
#endif

#ifdef UNIX
static void winchhandler(int signo)
{
  signo = signo;

  getscreenx();
  signal(SIGWINCH,& winchhandler);
}
#endif

extern void more(void)
{
  printf("-- more; press return --");
  while(getchar() != '\n');
  lineswritten = 0;
}

extern void format(char *fmt,...)
{
  va_list args;
  char buf [16384],*here = buf,*linestart = buf,*lineend = buf;
  bool hardnewline = TRUE;

#ifdef UNIX

  if(screenx == 0) {
    getscreenx();
    signal(SIGWINCH,& winchhandler);
  }

#endif

  va_start(args,fmt);
  vsprintf(buf,fmt,args);
  va_end(args);

  do {
    if(isspace(*here) || *here == 0) {
      lineend = here;
      hardnewline = *here == '\n';
    }
    if(here - linestart == screenx || *here == '\n') {
      *lineend = 0;
      printf("%s\n",linestart);
      linestart = lineend + 1;
      if(! hardnewline) while(*linestart == ' ') linestart++;
      lineswritten++;
      if(lineswritten == screeny - 1) {
	more();
      }
    }
    here++;
  } while(*here != 0);
  printf("%s\n",linestart);
}

#ifdef PURE_ANSI

static char *readline(char *prompt)
{
  char buffer [16384],*result;

  printf("%s",prompt);
  fgets(buffer,16384,stdin);
  buffer [strlen(buffer) - 1] = 0;
  result = malloc(strlen(buffer) + 1);
  strcpy(result,buffer);
  return result;
}

#endif

extern char *getline(char *prompt,int function)
{
  static char *lineread;
  time_t starttime,endtime;

  if(lineread != 0) free(lineread);

  starttime = time(0);
  lineread = readline(prompt);
  endtime = time(0);
  delay = (int) difftime(endtime,starttime);

#ifdef UNIX

  switch(function)
  {
  case LINE_HISTORY:
    if(*lineread != 0) add_history(lineread);
    break;
  case LINE_NO_HISTORY:
    break;
  default:
    fail();
  }

#endif

  lineswritten = 0;
  return lineread;
}

#ifndef HAS_XMALLOC

/* xmalloc.c -- safe versions of malloc and realloc */

/* Copyright (C) 1991 Free Software Foundation, Inc.

   This file is part of GNU Readline, a library for reading lines
   of text with interactive input and history editing.

   Readline is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the
   Free Software Foundation; either version 1, or (at your option) any
   later version.

   Readline is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with Readline; see the file COPYING.  If not, write to the Free
   Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. */

#include <stdio.h>

static void memory_error_and_abort ();

/* **************************************************************** */
/*								    */
/*		   Memory Allocation and Deallocation.		    */
/*								    */
/* **************************************************************** */

/* Return a pointer to free()able block of memory large enough
   to hold BYTES number of bytes.  If the memory cannot be allocated,
   print an error message and abort. */

/* Changed these functions to return a void *, rather than a char *.
   In other words they are now more like ANSI malloc than K&R malloc.
   -- PC, 24.09.92  */

void *
xmalloc (bytes)
     int bytes;
{
  char *temp = (char *)malloc (bytes);

  if (!temp)
    memory_error_and_abort ("xmalloc");
  return (temp);
}

void *
xrealloc (pointer, bytes)
     void *pointer;
     int bytes;
{
  char *temp;

  if (!pointer)
    temp = (char *)malloc (bytes);
  else
    temp = (char *)realloc (pointer, bytes);

  if (!temp)
    memory_error_and_abort ("xrealloc");
  return (temp);
}

static void
memory_error_and_abort (fname)
     char *fname;
{
  fprintf (stderr, "%s: Out of virtual memory!\n", fname);
  abort ();
}

#endif
