%{ /* Hey emacs, this file is in -*- Fundamental -*- mode */

/* Copyright (C) 1992 Pete Chown.

   Here is my latest adventure game, Napoleon (see the documentation
   if you don't know why it's called that).  Have fun... (don't cheat,
   even though you've got the source :-) ).

   This game is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 1, or (at your option)
   any later version.

   The game is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   The GNU General Public License is often shipped with GNU software, and
   is generally kept in a file called COPYING or LICENSE.  If you do not
   have a copy of the license, write to the Free Software Foundation,
   675 Mass Ave, Cambridge, MA 02139, USA. */

/* You should be editing lang.y.  Do NOT EDIT lang.c as your edits will
   just be thrown away. */

#include "adv.h"

%}

%union {
  char string [20];
  int integer;
}

%token NORTH SOUTH WEST EAST NORTHWEST NORTHEAST SOUTHWEST SOUTHEAST
%token UP DOWN INVENTORY LOAD LOOK QUIT SAVE SCORE GO EXAMINE ALL
%token EVERYTHING IN INTO ON OFF TO GET DROP TAKE PUT INV RESTORE
%token ONTO UNDER UNDERNEATH AT BELOW THE AND READ TWIRL TURN
%token SAY ASK ABOUT YES NO HELLO HI GOODBYE BYE HACK PLAY WITH
%token NOUGHTS CROSSES GIVE THROW OVER JUMP TOUCH UNLOCK OPEN BRIEF
%token VERBOSE NORMAL RECORD DRINK WAIT KISS SEARCH CLIMB

%token QUOTE FULLSTOP COMMA SEMICOLON

%token <string> NOUN ADJECTIVE

%type <integer> object noun_group

%start line

%%

line:		paragraph
	|	command

paragraph:	sentence
	|	sentence separator paragraph
	|

command:	QUIT				{ dead = TRUE; }
	|	SAVE				{ savegame(); }
	|	load				{ loadgame(); }
	|	HACK				{ hack(); }
	|	BRIEF				{ flags [0] = 1; }
	|	VERBOSE				{ flags [0] = 2; }
	|	NORMAL				{ flags [0] = 0; }

load:		LOAD
	|	RESTORE

sentence:	GO direction			{ moveplayer(); }
	|	direction			{ moveplayer(); }
	|	special
	|	fullsentence
	|	direct_speech

direction:	NORTH				{ direction = NORTH; }
	|	SOUTH				{ direction = SOUTH; }
	|	WEST				{ direction = WEST; }
	|	EAST				{ direction = EAST; }
	|	NORTHWEST			{ direction = NORTHWEST; }
	|	NORTHEAST			{ direction = NORTHEAST; }
	|	SOUTHWEST			{ direction = SOUTHWEST; }
	|	SOUTHEAST			{ direction = SOUTHEAST; }
	|	UP				{ direction = UP; }
	|	DOWN				{ direction = DOWN; }

special:	LOOK				{ descr = TRUE; looked = TRUE; }
	|	SCORE				{ format("You have visited %d%% of the game.",score); }
	|	inventory			{ inventory(yaccplayer); }

inventory:	INVENTORY
	|	INV

separator:	FULLSTOP
	|	SEMICOLON

fullsentence:	examine objects			{ examine(); }
	|	READ objects			{ do_read(); }
	|	get objects			{ get(); }
	|	DROP objects			{ drop(); }
	|	THROW objects			{ throw(0); }
	|	THROW objects OVER object	{ throw($4); }
	|	THROW objects DOWN		{ throw(0); }
	|	THROW objects AT object		{ throw($4); }
	|	PUT objects in object		{ put($4,& objects [$4].inside); }
	|	PUT objects on object		{ put($4,& objects [$4].above); }
	|	PUT objects under object	{ put($4,& objects [$4].below); }
	|	turn_variant
	|	play_variant
	|	GIVE objects TO object		{ give($4); }
	|	GIVE object objects		{ give($2); }
	|	JUMP				{ jump(0); }
	|	JUMP OVER object		{ jump($3); }
	|	TOUCH object			{ touch($2); }
	|	UNLOCK object			{ unlock($2,0); }
	|	OPEN object			{ unlock($2,0); }
	|	UNLOCK object WITH object	{ unlock($2,$4); }
	|	OPEN object WITH object		{ unlock($2,$4); }
	|	RECORD object			{ record($2,0); }
	|	RECORD object WITH object	{ record($2,$4); }
	|	RECORD object ON object		{ record($2,$4); }
	|	DRINK object			{ drink($2); }
	|	WAIT				{ do_wait(); }
	|	KISS object			{ kiss($2); }
	|	SEARCH object			{ search($2); }
	|	LOOK IN object			{ search($3); }
	|	CLIMB object			{ climb($2); }

examine:	EXAMINE
	|	LOOK AT

get:		TAKE
	|	GET

in:		IN
	|	INTO

on:		ON
	|	ONTO

under:		UNDER
	|	UNDERNEATH
	|	BELOW

objects:	ALL				{ all = TRUE; }
	|	object				{ addobject($1); }
	|	object COMMA objects		{ addobject($1); }
	|	object AND objects		{ addobject($1); }
	|	object COMMA AND objects	{ addobject($1); }

object:		noun_group			{ $$ = $1; if($$ < 1) YYERROR; }
	|	THE noun_group			{ $$ = $2; if($$ < 1) YYERROR; }

noun_group:	NOUN				{ $$ = getobject($1); }
	|	adjective noun_group		{ $$ = $2; }

adjective:	ADJECTIVE			{ addadjective($1); }

turn_variant:	TWIRL objects			{ twirl(); }
	|	TWIRL ON objects		{ twirl(); }
	|	TURN objects			{ turn(); }

play_variant:	PLAY object			{ play($2); }
	|	PLAY WITH object		{ play($3); }
	|	PLAY NOUGHTS AND CROSSES	{ playnandc(104); }
	|	PLAY NOUGHTS AND CROSSES WITH object	{ playnandc($6); }

direct_speech:	SAY TO object quote speech quote	{ speech($3,0); }
	|	SAY quote speech quote TO object	{ speech($6,0); }
	|	SAY quote speech quote		{ speech(getbeastie(),0); }
	|	object COMMA speech		{ speech($1,0); }
	|	ASK object ABOUT ssf objects csf	{ speech($2,1); }

quote:		QUOTE
	|

speech:		ssf speech_text csf

ssf:						{ speechflag = TRUE; }

csf:						{ speechflag = FALSE; }

speech_text:	greeting			{ said = 0; }
	|	LOOK AT object			{ said = 1; subject = $3; }
	|	EXAMINE object			{ said = 1; subject = $2; }
	|	YES				{ said = 2; }
	|	NO				{ said = 3; }
	|	farewell			{ said = 4; }
	|	object				{ said = 5; subject = $1; }

greeting:	HELLO
	|	HI

farewell:	GOODBYE
	|	BYE

%%

#ifdef DAVID_PILLINGS_BISON

#include "lex.c"
#include "parse.c"

#endif
