/* Copyright (C) 1992 Pete Chown.

   Here is my latest adventure game, Napoleon (see the documentation
   if you don't know why it's called that).  Have fun... (don't cheat,
   even though you've got the source :-) ).

   This game is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 1, or (at your option)
   any later version.

   The game is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   The GNU General Public License is often shipped with GNU software, and
   is generally kept in a file called COPYING or LICENSE.  If you do not
   have a copy of the license, write to the Free Software Foundation,
   675 Mass Ave, Cambridge, MA 02139, USA. */

#include "adv.h"

extern void resumscore(void)
{
  int i,roomsvisited = 0;

  for(i = 0;objects [i].examine != 0;i++)
  {
    if(objects [i].objtype.visited) roomsvisited++;
  }

  score = (+(roomsvisited * 100)) / i;
}

/* detachfromchain() has a rather obscure function: it deletes the object
   from the list it is currently in, ready to be reattached somewhere else.
   It is included as a special function on the basis that removing an object
   from a list is very much harder than adding it.  */

extern void detachfromchain(int this)
{
  int parent = objects [this].parent,*whichchain = 0;

  if(objects [parent].above == this) whichchain = & objects [parent].above;
  if(objects [parent].below == this) whichchain = & objects [parent].below;
  if(objects [parent].inside == this) whichchain = & objects [parent].inside;
  if(objects [parent].next == this) whichchain = & objects [parent].next;

  if(whichchain == 0) fail(); /* Parent pointer goes to the wrong place */

  *whichchain = objects [this].next;
  if(objects [this].next != 0) objects [objects [this].next].parent = parent;
}

/* addtochain() puts an object into a specified chain.  */

extern void addtochain(int toadd,int parent,int *chain)
{
  objects [toadd].parent = parent;
  objects [toadd].next = *chain;
  objects [*chain].parent = toadd;
  *chain = toadd;
}

extern int getroom(int player)
{
  int room = player;

  while(objects [room].objtype.room == FALSE) room = objects [room].parent;

  return room;
}

extern bool ancestor(int elder,int younger)
{
  while(younger != 0)
  {
    younger = objects [younger].parent;
    if(younger == elder) return TRUE;
  }

  return FALSE;
}

static void listchain(int this,char *start,char *end)
{
  bool reportedone = FALSE;
  int nextone = -1;
  char buffer [4096] = "";

  while(this != 0)
  {
    if(! objects [this].objtype.virtual) {
      if(nextone != -1) {
	if(reportedone) {
	  strcat(buffer,", ");
	  strcat(buffer,objects [nextone].longname);
	} else {
	  reportedone = TRUE;
	  strcat(buffer,start);
	  strcat(buffer,objects [nextone].longname);
	}
      }
      nextone = this;
    }
    this = objects [this].next;
  }
  if(nextone != -1) {
    if(reportedone) {
      strcat(buffer," and ");
      strcat(buffer,objects [nextone].longname);
      strcat(buffer,end);
    } else {
      sprintf(buffer,"%s%s%s",start,objects [nextone].longname,end);
    }
  }
  if(*buffer != 0) format("%s",buffer);
}

static char *subst(char *template,char *substitution)
{
  static char buffer [60],*name;

  name = strchr(substitution,' ') + 1;
  if(name == (char *) 1) name = substitution;
  sprintf(buffer,template,name);
  return buffer;
}

static void recursivelist(int);

static void recursivelistchain(int this)
{
  while(this != 0)
  {
    recursivelist(this);
    this = objects [this].next;
  }
}

static void recursivelist(int this)
{
  char *longname = objects [this].longname;

  listchain(objects [this].above,subst("On the %s, there is ",longname),".\n");
  if(! objects [this].objtype.opaque) {
    listchain(objects [this].below,subst("Under the %s, there is ",longname),".\n");
    if(objects [this].objtype.alive)
      listchain(objects [this].inside,subst("The %s is carrying ",longname),".\n");
    else listchain(objects [this].inside,subst("Inside the %s, there is ",longname),".\n");
  }
  recursivelistchain(objects [this].above);
  if(! objects [this].objtype.opaque) {
    recursivelistchain(objects [this].below);
    recursivelistchain(objects [this].inside);
  }
}

static bool luminous(int this)
{
  if(this == 0) return FALSE;
  return objects [this].objtype.luminous || luminous(objects [this].above) || luminous(objects [this].below) || luminous(objects [this].inside) || luminous(objects [this].next);
}

extern bool illuminated(int room)
{
  return objects [room].objtype.luminous || luminous(objects [room].inside);
}

extern void describe_room(int player,bool look_called)
{
  int room = getroom(player),this = objects [room].inside;
  char buffer [10] = "";
  bool verbosedescription = flags [0] == 2
    || (flags [0] == 0 && ! objects [getroom(player)].objtype.visited) || look_called;

  if(hacker) sprintf(buffer," [%0d]",room);
  if(illuminated(room)) {
    if(verbosedescription)
      format("\n%s%s\n\n%s\n",objects [room].longname,buffer,objects [room].examine);
    else format("\n%s%s\n",objects [room].longname,buffer);
    listchain(this,"There is "," here.\n");
    recursivelistchain(this);
  } else {
    format("It's pitch dark.\n\nIn the distance, someone calls, 'Get the gia"
"nt spider woken up!'\nCloser by, someone shouts, 'Wake up you lazy slob!  Wa"
"ke up, wake up, I tell you!'\n");
  }

  if(! objects [getroom(player)].objtype.visited) {
    objects [getroom(player)].objtype.visited = 1;
    resumscore();
  }

  postdescription(player);
}

extern void inventory(int player)
{
  if(objects [player].inside == 0) {
    format("You aren't carrying anything!");
  } else {
    listchain(objects [player].inside,"You are carrying ",".\n");
    recursivelistchain(objects [player].inside);
  }
}
