DEFINT A-Z

DECLARE SUB AddProName (b$, x%)
DECLARE FUNCTION GetSupport (lo, b$)
DECLARE FUNCTION BadCommand% (b$)
DECLARE SUB AddPronoun (b$)
DECLARE SUB PlayAndSleep (Repeat%, CanExit%, s$)
DECLARE SUB SetUndoInfo ()
DECLARE FUNCTION VerbUndo% (b$)
DECLARE SUB SetLo (x%)
DECLARE FUNCTION StoreUndo (a$)
DECLARE FUNCTION GetDate$ ()
DECLARE FUNCTION VerbLoad2% (a$)
DECLARE FUNCTION VerbSave2% (a$, b$)
DECLARE SUB SetSpecial (x1%, y1!)
DECLARE FUNCTION GetCanHold% ()
DECLARE FUNCTION GetUo$ (x%, y%)
DECLARE FUNCTION IsVerb% (t$, b$)
DECLARE FUNCTION VerbMove (b$)
DECLARE FUNCTION VerbCut (b$)
DECLARE FUNCTION VerbThrow (b$)
DECLARE FUNCTION VerbRepair% (b$)
DECLARE FUNCTION VerbBuy% (b$)
DECLARE FUNCTION VerbPress% (b$)
DECLARE FUNCTION VerbInsert% (b$)
DECLARE FUNCTION VerbInject% (b$)
DECLARE FUNCTION VerbWear% (b$)
DECLARE FUNCTION VerbMiscel (b$)
DECLARE FUNCTION VerbHypnotize (b$)
DECLARE SUB CheckKilledRoom (c$)
DECLARE FUNCTION VerbGive% (b$)
DECLARE FUNCTION VerbSit (b$)
DECLARE FUNCTION VerbTurn (b$)
DECLARE FUNCTION VerbClose (b$)
DECLARE FUNCTION GetNoDir$ (lo, x)
DECLARE FUNCTION VerbOpen% (b$)
DECLARE FUNCTION VerbUnlock% (b$)
DECLARE FUNCTION VerbSpray (b$)
DECLARE FUNCTION HasDirection% (b$)
DECLARE FUNCTION GetMaxItems% ()
DECLARE FUNCTION GetOc$ (x)
DECLARE FUNCTION GetObject% (x)
DECLARE FUNCTION GetSpecial! (x)
DECLARE FUNCTION VerbUnplug% (b$)
DECLARE FUNCTION VerbDrink% (b$)
DECLARE FUNCTION VerbPour% (b$)
DECLARE FUNCTION VerbPut% (b$)
DECLARE FUNCTION VerbGet% (b$)
DECLARE FUNCTION AlterInput$ (b$)
DECLARE FUNCTION VerbLook% (b$)
DECLARE SUB ExitGame ()
DECLARE SUB InitGameData ()
DECLARE SUB AskExitGame (b$, Whicht)
DECLARE FUNCTION VerbEat% (b$)
DECLARE FUNCTION IsColor% (a$)
DECLARE FUNCTION IsPrep% (b$, prep$)
DECLARE FUNCTION IsNoun (b$, noun$)
DECLARE FUNCTION IsNoun2 (b$, noun$)
DECLARE FUNCTION IsItem% (a$, Itemno%)
DECLARE FUNCTION GetResource$ (lo, tag$)

DECLARE FUNCTION VerbTalk (b$)
DECLARE SUB DisplayRoom (lo%)
DECLARE FUNCTION VariFile (a$)
DECLARE FUNCTION VerbLoadGame (a$)
DECLARE FUNCTION VerbInventory (a$)
DECLARE FUNCTION VerbLookAtItems (a$)
DECLARE FUNCTION VerbGetDrop (a$)
DECLARE FUNCTION GetRoomTitle$ (lo%)
DECLARE SUB LocTitle (a$)
DECLARE SUB GPrint (Text$, TX, TY, Col)
DECLARE FUNCTION AskYesNo (prom$, Which)
DECLARE SUB Oprint (a$)
DECLARE SUB ClearLine ()
DECLARE FUNCTION VerbSaveGame% (a$)

DECLARE SUB ShowArray (Style%, WhichArray%)
DECLARE SUB SetDirections (lo%)
DECLARE SUB CreateArray (Text$, ml%, WhichArray%, StartOver%)
DECLARE SUB SetRoomPic (lo%)
DECLARE SUB AddLine (WhichArray%, Text$, ResetColors)
DECLARE FUNCTION ParseCommand (a$)

DECLARE FUNCTION IsDirection% (a$)
DECLARE FUNCTION CheckDirection (DirNum%)
DECLARE FUNCTION GetRoomDesc$ (lo%)
DECLARE FUNCTION RemoveColor$ (b$)

CONST MaxSpecial = 50
CONST MaxItems = 25
CONST MAXARRAYSIZE = 60
CONST MaxUndo = 100 '*** Allow the last 100 commands to be UNDONE!

COMMON SHARED TextMode
COMMON SHARED BwMode   'configurable
COMMON SHARED MusicOn
COMMON SHARED SoundOn
COMMON SHARED AllUpper 'configurable
COMMON SHARED Box1Size 'This is set by code, not configurable
COMMON SHARED Box2Size 'This is set by code, not configurable
COMMON SHARED a$
COMMON SHARED lo AS INTEGER
COMMON SHARED Fbuff AS STRING * 8960 'For Fonts
COMMON SHARED ScrollArray() AS STRING * 96
COMMON SHARED bs1$, bs2$, bs3$, bs4$, bs5$, bs6$, bs0$, bsb$

DIM SHARED ScrollArray(MAXARRAYSIZE, 1 TO 2) AS STRING * 96
DIM SHARED UnderstandObject$(MaxItems, 1 TO 5):  'Will accept up to FIVE nouns for each object
DIM SHARED ObjectCalled$(MaxItems):    'What the object is called in the Room & Inventory
DIM SHARED Special(MaxSpecial) AS LONG
DIM SHARED UndoSpecial(MaxSpecial) AS LONG
DIM SHARED O(MaxItems) AS INTEGER
DIM SHARED UndoO(MaxItems) AS INTEGER
DIM SHARED LDir(100, 3)  AS INTEGER   'What limitations on movement are there?
DIM SHARED CanHold, FileExists, ErrorFound
DIM SHARED DataChange AS INTEGER
DIM SHARED PlayerDied AS INTEGER
DIM SHARED UndoLo AS INTEGER
DIM SHARED KeepIt$, KeepThem$, KeepHim$, KeepHer$

Uo1: 'What words are "understood" to be this item for GET/LOOK/DROP
DATA "CUP","CUP","MUG","CUP","CUP"
DATA "CIGS", "CIGAR", "PACK", "CIGAR", "CIGAR"
DATA "PILL", "TABLET", "CAPSULE", "MEDIC", "DRUG"
DATA "OFFICE KEY", "OFFICE", "KEY", "KEY", "KEY"
DATA "CASH","BUCK","MONEY","$","STACK"
DATA "NOTE","PAPER","NOTE","PAPER","NOTE"
DATA "VALENT","CARD","VALANT","CARD","CARD"
DATA "WELDER","GOGGLE","SHADES","SPECTACLE", "GOGGLE"
DATA "GLASS","LENS","DARK","GLASS","LENS"
DATA "CAFETER","TRAY","PLATE","TRAY","CAFATE"
DATA "BAG","SALT","SALT","SALT","SALT"
DATA "SYRINGE", "HYPODERM", "NEEDLE", "NEEDLE", "HYPO"
DATA "KNIFE","DAGGER","KNIFE","KNIFE","GLASS"
DATA "GUN","PISTOL","WEAPON","WATERGUN","GUN"
DATA "BOWL","POTATO","SOUP","FOOD","SOUP"
DATA "ROTTEN","ROTTON","POTATO","PATOTO","PATATO"
DATA "BUTTER","BLOB","GLOB","BUTTER","PARKAY"
DATA "PASSCARD","PASS","CARD","PASS","PASS"
DATA "GEAR","COG","GEAR","COG","GEAR"
DATA "NAPKIN", "NAPKIN", "NAPKIN", "PAPER TOWL", "PAPER TOWEL"
DATA "WRENCH", "TOOL", "PLIARS", "WRENCH", "PLYERS"
DATA "SPRAY", "INSECT SPR", "CAN", "BUGSPR", "BUG SPR"
DATA "UMBREL", "PARASO", "PARESO", "PARESA", "UMBRELLA"
DATA "BOOK", "TEXT", "NONFIC", "NOVEL", "HARDBAC"
DATA "MASTER KEY", "MASTER", "KEY", "KEY", "KEY"
DATA "xxx", "xxx", "xxx", "xxx", "xxx"
DATA "xxx", "xxx", "xxx", "xxx", "xxx"
DATA "xxx", "xxx", "xxx", "xxx", "xxx"
DATA "xxx", "xxx", "xxx", "xxx", "xxx"
DATA "xxx", "xxx", "xxx", "xxx", "xxx"
DATA "xxx", "xxx", "xxx", "xxx", "xxx"
DATA "xxx", "xxx", "xxx", "xxx", "xxx"
DATA "xxx", "xxx", "xxx", "xxx", "xxx"
DATA "xxx", "xxx", "xxx", "xxx", "xxx"
DATA "xxx", "xxx", "xxx", "xxx", "xxx"
DATA "xxx", "xxx", "xxx", "xxx", "xxx"
DATA "xxx", "xxx", "xxx", "xxx", "xxx"
DATA "xxx", "xxx", "xxx", "xxx", "xxx"

Uo2: 'What inventory CALLS this item when typing INV.
DATA "cup", "pack of cigarettes", "pill", "office key"
DATA "stack of crazy bucks"
DATA "note", "valentine card","pair of welder's goggles"
DATA "glass lens","cafeteria tray","bag of salt", "hypodermic syringe"
DATA "glass knife","water gun","bowl of potato soup","rotten potato"
DATA "glob of butter", "passcard", "gear", "napkin", "wrench"
DATA "can of insect spray", "umbrella","book", "master key"
DATA "xxx","xxx","xxx","xxx","xxx","xxx","xxx","xxx"
DATA "xxx","xxx","xxx","xxx","xxx"

Uo3: 'Where each item is LOCATED
DATA 100, 100, 100, 100, 100, 35, 100, 100, 100, 100, 31, 100
DATA 100,100,100,100,100,100,100,100,100,100,100,100,100

NoFile: FileExists = 0: RESUME NEXT
WatchError: ErrorFound = 1: RESUME NEXT

SUB AddProName (b$, x)
    IF x = 1 THEN KeepHim$ = b$
    IF x = 2 THEN KeepHer$ = b$
END SUB

SUB AddPronoun (b$)
    KeepIt$ = b$
    KeepThem$ = KeepThem$ + " " + b$
END SUB

FUNCTION AlterInput$ (b$)

a$ = UCASE$(b$)

'*** Let's see if our sentence contains the word IT or THEM to handle
'*** pronoun parsing!

IF RIGHT$(a$, 3) = " IT" THEN b$ = LEFT$(b$, LEN(b$) - 3) + " " + KeepIt$: a$ = UCASE$(b$)
IF RIGHT$(a$, 5) = " THEM" THEN b$ = LEFT$(b$, LEN(b$) - 5) + KeepThem$: a$ = UCASE$(b$)
IF RIGHT$(a$, 4) = " HER" THEN b$ = LEFT$(b$, LEN(b$) - 4) + " " + KeepHer$: a$ = UCASE$(b$)
IF RIGHT$(a$, 4) = " HIM" THEN b$ = LEFT$(b$, LEN(b$) - 4) + " " + KeepHim$: a$ = UCASE$(b$)
IF INSTR(a$, " IT ") THEN
    b$ = LEFT$(b$, INSTR(a$, " IT ") - 1) + " " + KeepIt$ + " " + RIGHT$(b$, LEN(a$) - (INSTR(a$, " IT ") + 3))
    a$ = UCASE$(b$)
END IF
IF INSTR(a$, " THEM ") THEN
    b$ = LEFT$(b$, INSTR(a$, " THEM ") - 1) + " " + KeepThem$ + " " + RIGHT$(b$, LEN(a$) - (INSTR(a$, " THEM ") + 5))
    a$ = UCASE$(b$)
END IF
IF INSTR(a$, " HER ") THEN
    b$ = LEFT$(b$, INSTR(a$, " HER ") - 1) + " " + KeepHer$ + " " + RIGHT$(b$, LEN(a$) - (INSTR(a$, " HER ") + 4))
    a$ = UCASE$(b$)
END IF
IF INSTR(a$, " HIM ") THEN
    b$ = LEFT$(b$, INSTR(a$, " HIM ") - 1) + " " + KeepHim$ + " " + RIGHT$(b$, LEN(a$) - (INSTR(a$, " HIM ") + 4))
    a$ = UCASE$(b$)
END IF

IF lo = 6 THEN
    IF LEFT$(a$, 9) = "CLIMB LAD" THEN b$ = "down"
END IF

IF lo = 8 OR lo = 16 THEN
    IF (IsVerb(a$, "ENTER") OR LEFT$(a$, 6) = "DRIVE ") AND IsNoun(a$, "CAR") THEN b$ = "OPEN CAR DOOR"
END IF

IF lo = 12 THEN
    IF LEFT$(a$, 9) = "CLIMB LAD" THEN b$ = "up"
END IF

IF lo = 17 THEN
    IF IsVerb(a$, "INSERT") AND IsItem(a$, 19) AND GetObject(19) = 0 AND IsNoun(a$, "APPARATUS") THEN
        b$ = "REPAIR APPARATUS WITH GEAR"
    END IF
    IF IsVerb(a$, "PUT") AND IsNoun(a$, "APPARATUS") AND GetObject(1) = 0 AND (IsItem(a$, 1) OR INSTR(a$, "WATER") OR (INSTR(a$, "SALT") AND GetSpecial(1) = 4)) THEN
        b$ = "POUR SALTWATER INTO FUNNEL"
    END IF
    IF IsVerb(a$, "PUT") AND GetSpecial(22) = 1 AND IsItem(a$, 17) AND GetObject(1) = 0 AND (IsItem(a$, 1) > 0 OR (INSTR(a$, " ICE") > 0 AND GetSpecial(1) = 3)) THEN
        b$ = "GET BUTTER IN CUP"
    END IF
END IF

IF lo = 27 OR lo = 36 THEN
    IF LEFT$(a$, 5) = "TAKE " AND (INSTR(a$, " BATH") OR INSTR(a$, " SHOWER")) THEN
        b$ = "GET INTO TUB"
    END IF
END IF

IF lo = 27 OR lo = 36 THEN
    IF LEFT$(a$, 5) = "FILL " AND IsItem(a$, 1) AND O(1) = 0 THEN
        b$ = "GET WATER IN CUP": GOTO vout
    END IF
END IF

IF O(10) = 0 THEN
    IF IsVerb(a$, "PUT") AND IsItem(a$, 10) AND (IsPrep(a$, "INSIDE") OR INSTR(a$, " UNDER")) THEN
        IF INSTR(a$, " SHIRT") OR INSTR(a$, " CLOTHE") THEN
            b$ = "WEAR TRAY": GOTO vout
        END IF
    END IF
    IF (LEFT$(a$, 4) = "USE " OR IsVerb(a$, "PUT")) AND IsItem(a$, 10) THEN
        IF INSTR(a$, " SELF") OR INSTR(a$, "MYSELF") THEN
            b$ = "WEAR TRAY": GOTO vout
        END IF
    END IF
END IF

IF lo = 32 OR lo = 33 OR lo = 34 THEN
    IF LEFT$(a$, 10) = "MOVE MATTR" OR LEFT$(a$, 10) = "LIFT MATTR" THEN
        b$ = "LOOK UNDER MATTRESS"
    END IF
END IF

IF lo = 33 THEN
    IF LEFT$(a$, 8) = "MOVE RUG" OR LEFT$(a$, 8) = "LIFT RUG" THEN
        b$ = "LOOK UNDER RUG"
    END IF
END IF

IF IsVerb(a$, "POUR") OR LEFT$(a$, 4) = "MIX " THEN
    IF (IsItem(a$, 1) OR IsNoun(a$, "WATER")) AND GetObject(1) = 0 THEN
        IF IsItem(a$, 11) AND GetObject(11) = 0 THEN
            b$ = "PUT SALT INTO CUP"
        END IF
    END IF
END IF

IF (IsVerb(a$, "THROW") OR IsVerb(a$, "PUT")) AND IsItem(a$, 11) AND GetObject(11) = 0 THEN
    IF IsNoun(a$, "SQUID") AND lo = 18 AND GetSpecial(8) = 0 THEN
        b$ = "POUR SALT ON SQUID"
    END IF
END IF

IF IsItem(a$, 8) AND GetObject(8) = 0 THEN
    IF INSTR(a$, " SELF") OR INSTR(a$, " MYSELF") OR INSTR(a$, " FACE") OR INSTR(a$, " EYES") THEN
        b$ = "WEAR GOGGLES"
    END IF
END IF

'*** Check to see if we're "talking" directly to a person
bsb$ = a$: x1 = INSTR(bsb$, " "): y1 = INSTR(bsb$, ",")
IF (y1 < x1 AND y1 > 0) OR x1 = 0 THEN x1 = y1
IF x1 > 1 THEN
    IF lo = 21 AND IsNoun(" " + LEFT$(bsb$, x1 - 1), "JESUS") THEN b$ = "TALK " + b$: GOTO vout
    IF lo = 28 AND IsNoun(" " + LEFT$(bsb$, x1 - 1), "GUARD") THEN b$ = "TALK " + b$: GOTO vout
    IF lo = 28 AND IsNoun(" " + LEFT$(bsb$, x1 - 1), "GORDON") THEN b$ = "TALK " + b$: GOTO vout
    IF lo = 28 AND IsNoun(" " + LEFT$(bsb$, x1 - 1), "JENKINS") THEN b$ = "TALK " + b$: GOTO vout
    IF lo = 15 AND IsNoun(" " + LEFT$(bsb$, x1 - 1), "SANDY") THEN b$ = "TALK " + b$: GOTO vout
    IF lo = 7 AND IsNoun(" " + LEFT$(bsb$, x1 - 1), "TODD") THEN b$ = "TALK " + b$: GOTO vout
    IF lo = 5 AND IsNoun(" " + LEFT$(bsb$, x1 - 1), "KANDI") THEN b$ = "TALK " + b$: GOTO vout
    IF lo = 11 AND IsNoun(" " + LEFT$(bsb$, x1 - 1), "ROB") THEN b$ = "TALK " + b$: GOTO vout
    IF lo = 9 AND IsNoun(" " + LEFT$(bsb$, x1 - 1), "SOCRATES") THEN b$ = "TALK " + b$: GOTO vout
    IF lo = 10 AND IsNoun(" " + LEFT$(bsb$, x1 - 1), "NAPOLEON") THEN b$ = "TALK " + b$: GOTO vout
    IF lo = 3 AND IsNoun(" " + LEFT$(bsb$, x1 - 1), "XAVIER") THEN b$ = "TALK " + b$: GOTO vout
    IF lo = 26 AND IsNoun(" " + LEFT$(bsb$, x1 - 1), "GOAT") THEN b$ = "TALK " + b$: GOTO vout
    IF lo = 2 AND IsNoun2(" " + LEFT$(bsb$, x1 - 1), "ELLA") THEN b$ = "TALK " + b$: GOTO vout
    IF lo = 4 AND IsNoun2(" " + LEFT$(bsb$, x1 - 1), "HEYWOOD") THEN b$ = "TALK " + b$: GOTO vout
END IF

vout: AlterInput$ = b$
END FUNCTION

SUB AskExitGame (b$, Whicht)

PlayerDied = 1
IF Whicht = 1 THEN
    IF MusicOn <> 0 THEN PlayAndSleep 0, 1, "$C#F@F.D.C.."
    t = AskYesNo("`2(`%Q`7`2)`0uit`7, `2(`%U`7`2)`0ndo Move`7, `2(`%R`7`2)`0estore`7, `2(`%S`7`2)`0tart Over`2:", 3)
ELSE
    t = AskYesNo(GetResource$(39, "NT9"), 1)
    IF t = 1 THEN t = 4 ELSE t = 5
END IF
IF TextMode > 0 THEN Oprint "`7`7"
IF t = 5 THEN EXIT SUB
IF t <= 1 THEN ExitGame
IF t = 2 THEN
    nul = StoreUndo(b$) 'Reset the undo counters too!
    x = StoreUndo("UNDO")
    IF x = 0 THEN
        t = 4 '**** Can't UNDO so let's start over.
    ELSE
        'SetUndoInfo 'Make sure we initialize our undo registers
        'nul = StoreUndo("RESET") 'Reset the undo counters too!
        '** comment that out because we should allow for multiple
        '** levels of under, even after a death!
    END IF
END IF

IF t = 3 THEN
    SetUndoInfo 'Make sure we initialize our undo registers
    nul = StoreUndo("RESET") 'Reset the undo counters too!
    x = VerbLoad2("LOAD")
    IF x = 2 THEN
        DisplayRoom lo
        AddLine 2, "`2Your saved game is now loaded. Thank you.", 1
    ELSE
        t = 4 '*** can't load, so let's start over.
    END IF
END IF

IF t = 4 THEN
    InitGameData
    SetUndoInfo 'Make sure we initialize our undo registers
    nul = StoreUndo("RESET") 'Reset the undo counters too!
    DisplayRoom lo
    AddLine 2, "`2You have started at the beginning. Type `0LOAD`2 to restore a saved game if you have one.", 1
END IF

END SUB

FUNCTION BadCommand (b$)

x = IsItem(b$, 0)

IF IsVerb(b$, "UNPLUG") THEN
    AddLine 2, GetResource$(0, "UNPLUG0"), 1
    BadCommand = 1: EXIT FUNCTION
END IF

IF IsVerb(b$, "TALK") THEN
    AddLine 2, GetResource$(39, "NOTALK"), 1
    BadCommand = 1: EXIT FUNCTION
END IF

IF IsVerb(b$, "ENTER") THEN
    AddLine 2, GetResource$(38, "NOENTER"), 1
    BadCommand = 1: EXIT FUNCTION
END IF

IF IsVerb(b$, "GET") THEN
    IF x > 0 AND (GetObject(x) = 0) THEN
        AddLine 2, GetResource$(38, "NOGET1") + " " + GetOc$(x) + ".", 1
    ELSE
        AddLine 2, GetResource$(38, "NOGET2"), 1
    END IF
    BadCommand = 1: EXIT FUNCTION
END IF
IF IsVerb(b$, "DROP") THEN
    AddLine 2, GetResource$(38, "NODROP"), 1
    BadCommand = 1: EXIT FUNCTION
END IF
IF IsVerb(b$, "LOOK") THEN
    AddLine 2, GetResource$(38, "NOLOOK"), 1
    BadCommand = 1: EXIT FUNCTION
END IF
'IF IsVerb(b$, "TALK") THEN
'    AddLine 2, GetResource$(38, "NOTALK"), 1
'    BadCommand = 1: EXIT FUNCTION
'END IF
IF IsVerb(b$, "EAT") THEN
    IF x > 0 AND (GetObject(x) = 0) THEN
        AddLine 2, GetResource$(38, "NOEAT1") + " " + GetOc$(x) + ".", 1
    ELSE
        AddLine 2, GetResource$(38, "NOEAT2"), 1
    END IF
    BadCommand = 1: EXIT FUNCTION
END IF
IF IsVerb(b$, "WEAR") THEN
    IF x > 0 AND (GetObject(x) = 0) THEN
        AddLine 2, GetResource$(38, "NOWEAR1") + " " + GetOc$(x) + ".", 1
    ELSE
        AddLine 2, GetResource$(38, "NOWEAR2"), 1
    END IF
    BadCommand = 1: EXIT FUNCTION
END IF
IF IsVerb(b$, "POUR") THEN
    AddLine 2, GetResource$(38, "NOPOUR"), 1
    BadCommand = 1: EXIT FUNCTION
END IF
IF IsVerb(b$, "UNLOCK") THEN
    IF x > 0 AND (GetObject(x) = 0) THEN
        AddLine 2, GetResource$(38, "NOUNLOCK1") + " " + GetOc$(x) + ".", 1
    ELSE
        AddLine 2, GetResource$(38, "NOUNLOCK2"), 1
    END IF
    BadCommand = 1: EXIT FUNCTION
END IF
IF IsVerb(b$, "OPEN") THEN
    IF x > 0 AND (GetObject(x) = 0) THEN
        AddLine 2, GetResource$(38, "NOOPEN1") + " " + GetOc$(x) + ".", 1
    ELSE
        AddLine 2, GetResource$(38, "NOOPEN2"), 1
    END IF
    BadCommand = 1: EXIT FUNCTION
END IF
IF IsVerb(b$, "THROW") THEN
    IF x > 0 AND (GetObject(x) = 0) THEN
        AddLine 2, GetResource$(38, "NOTHROW1") + " " + GetOc$(x) + ".", 1
    ELSE
        AddLine 2, GetResource$(38, "NOTHROW2"), 1
    END IF
    BadCommand = 1: EXIT FUNCTION
END IF

'IF VerbDrink(b$) <> 0 THEN GOTO ExitParse
'IF VerbPut(b$) <> 0 THEN GOTO ExitParse
'IF VerbUnplug(b$) <> 0 THEN GOTO ExitParse
'IF VerbClose(b$) <> 0 THEN GOTO ExitParse
'IF VerbGive(b$) <> 0 THEN GOTO ExitParse
'IF VerbInject(b$) <> 0 THEN GOTO ExitParse
'IF VerbPress(b$) <> 0 THEN GOTO ExitParse
'IF VerbInsert(b$) <> 0 THEN GOTO ExitParse
'IF VerbRepair(b$) <> 0 THEN GOTO ExitParse
'IF VerbBuy(b$) <> 0 THEN GOTO ExitParse
'IF VerbTurn(b$) <> 0 THEN GOTO ExitParse
'IF VerbSit(b$) <> 0 THEN GOTO ExitParse
'IF VerbMove(b$) <> 0 THEN GOTO ExitParse
'IF VerbSpray(b$) <> 0 THEN GOTO ExitParse
'IF VerbCut(b$) <> 0 THEN GOTO ExitParse

END FUNCTION

SUB CheckKilledRoom (c$)

'*** See if we've entered a room that has KILLED us.
    IF GetSpecial(38) = 1 AND GetObject(23) = 0 THEN
        'Umbrella is open indoors!
         IF NOT (lo = 16 OR (lo = 26 AND GetSpecial(37) = 0)) THEN
            AddLine 2, GetResource$(0, "UMBRELLA2"), 1
            : AskExitGame c$, 1: EXIT SUB
         END IF
    END IF
    IF lo = 1 THEN
        IF Special(35) = 0 THEN
            AddLine 2, GetResource$(lo, "KILLED"), 1
            : AskExitGame c$, 1: EXIT SUB
        END IF
    END IF
    IF lo = 21 THEN
        IF GetSpecial(17) = 0 AND GetSpecial(36) = 2 THEN
            SetSpecial 17, 1: SetDirections lo
            AddLine 2, GetResource$(lo, "MANLEAVES"), 1
            EXIT SUB
        END IF
    END IF
    IF lo = 31 THEN
        IF Special(12) < 1 THEN
            AddLine 2, GetResource$(lo, "TOOBRIGHT"), 1
            : AskExitGame c$, 1: EXIT SUB
        ELSE
            '*** Do this so that if they find the salt, their water will get cold.
            IF GetSpecial(18) = 0 THEN 'If water in the tub is still HOT....
                SetSpecial 18, 1
                'Also, if cup has water, make it get cool or melt if frozen.
                IF GetObject(1) = 0 THEN
                    IF GetSpecial(1) = 1 THEN
                        SetSpecial 1, 2: 'Cup now contains COLD water instead.
                        AddLine 2, GetResource$(lo, "COOLOFF"), 1
                    END IF
                    IF GetSpecial(1) = 3 THEN
                        SetSpecial 1, 2: 'Cup now contains COLD water instead.
                        AddLine 2, GetResource$(lo, "MELTED"), 1
                    END IF
                END IF
            END IF
            '******
        END IF
    END IF

    IF lo = 34 THEN
        IF Special(14) < 1 THEN
            IF Special(13) < 1 OR O(10) <> 0 THEN
                AddLine 2, GetResource$(lo, "STABFRONT"), 1
                : AskExitGame c$, 1: EXIT SUB
            END IF
            '** otherwise the guy is here and awake, but he can't stab you.
            AddLine 2, GetResource$(lo, "NOSTAB"), 1
        END IF
    END IF
    IF lo = 35 THEN
        IF Special(14) < 1 THEN
            AddLine 2, GetResource$(lo, "STABBED"), 1
            : AskExitGame c$, 1: EXIT SUB
        END IF
    END IF
END SUB

SUB DisplayRoom (lo)

    LocTitle GetRoomTitle$(lo)

    'PRINT "HERE #1"

    IF TextMode = 0 THEN
        'PRINT "HERE #2"
        CreateArray RemoveColor$(GetRoomDesc$(lo)), Box1Size, 1, 1
    ELSE
        'PRINT "HERE #2"
        CreateArray GetRoomDesc$(lo), Box1Size, 1, 1
    END IF
    
    'PRINT "HERE #6"
    ShowArray 0, 1

    SetRoomPic lo
    SetDirections lo

END SUB

FUNCTION GetCanHold
    GetCanHold = CanHold
END FUNCTION

FUNCTION GetDate$

GetDate$ = LEFT$(TIME$, 5) + " on " + RIGHT$(DATE$, 4) + "-" + LEFT$(DATE$, 5)

END FUNCTION

FUNCTION GetMaxItems
GetMaxItems = MaxItems
END FUNCTION

FUNCTION GetObject (x1)
    GetObject = O(x1)
END FUNCTION

FUNCTION GetOc$ (x1)
    GetOc$ = LTRIM$(RTRIM$(ObjectCalled$(x1)))
END FUNCTION

FUNCTION GetSpecial! (x1)
    GetSpecial! = Special(x1)
END FUNCTION

FUNCTION GetUo$ (x, y)
    GetUo$ = LTRIM$(RTRIM$(UnderstandObject$(x, y)))
END FUNCTION

FUNCTION HasDirection (b$)
t$ = LCASE$(b$)
IF ASC(RIGHT$(t$, 1)) < 65 THEN t$ = LEFT$(t$, LEN(t$) - 1) 'get rid of a period if any.
'Don't confuse this for the "IsDirection" function. This function, unlike
'that one, will try to determine if the current text string CONTAINS a
'direction, instead of whether or not it IS one in its entirety.
    IF INSTR(t$, " n ") OR RIGHT$(t$, 2) = " n" OR INSTR(t$, " nor ") OR RIGHT$(t$, 4) = " nor" OR INSTR(t$, " north ") OR RIGHT$(t$, 6) = " north" THEN HasDirection = 1: GOTO OutHasDir
    IF INSTR(t$, " s ") OR RIGHT$(t$, 2) = " s" OR INSTR(t$, " sou ") OR RIGHT$(t$, 4) = " sou" OR INSTR(t$, " south ") OR RIGHT$(t$, 6) = " south" THEN HasDirection = 2: GOTO OutHasDir
    IF INSTR(t$, " e ") OR RIGHT$(t$, 2) = " e" OR INSTR(t$, " eas ") OR RIGHT$(t$, 4) = " eas" OR INSTR(t$, " east ") OR RIGHT$(t$, 5) = " east" THEN HasDirection = 3: GOTO OutHasDir
    IF INSTR(t$, " w ") OR RIGHT$(t$, 2) = " w" OR INSTR(t$, " wes ") OR RIGHT$(t$, 4) = " wes" OR INSTR(t$, " west ") OR RIGHT$(t$, 5) = " west" THEN HasDirection = 4: GOTO OutHasDir
    IF INSTR(t$, " ne ") OR RIGHT$(t$, 3) = " ne" OR INSTR(t$, " northea ") OR RIGHT$(t$, 7) = " northe" OR INSTR(t$, " northeast ") OR RIGHT$(t$, 10) = " northeast" THEN HasDirection = 7: GOTO OutHasDir
    IF INSTR(t$, " se ") OR RIGHT$(t$, 3) = " se" OR INSTR(t$, " southea ") OR RIGHT$(t$, 7) = " southe" OR INSTR(t$, " southeast ") OR RIGHT$(t$, 10) = " southeast" THEN HasDirection = 8: GOTO OutHasDir
    IF INSTR(t$, " sw ") OR RIGHT$(t$, 3) = " sw" OR INSTR(t$, " southwe ") OR RIGHT$(t$, 7) = " southw" OR INSTR(t$, " southwest ") OR RIGHT$(t$, 10) = " southwest" THEN HasDirection = 9: GOTO OutHasDir
    IF INSTR(t$, " nw ") OR RIGHT$(t$, 3) = " nw" OR INSTR(t$, " northwe ") OR RIGHT$(t$, 7) = " northw" OR INSTR(t$, " northwest ") OR RIGHT$(t$, 10) = " northwest" THEN HasDirection = 10: GOTO OutHasDir
    HasDirection = 0
OutHasDir: END FUNCTION

SUB InitGameData

CanHold = 7
SetLo 22 'Starting Room #

FOR x = 1 TO MaxSpecial: Special(x) = 0: NEXT x
Special(21) = 1 'Elevator is on floor #1

RESTORE Uo1
FOR x = 1 TO MaxItems
    FOR y = 1 TO 5
        READ UnderstandObject$(x, y)
    NEXT y
NEXT x
RESTORE Uo2
FOR x = 1 TO MaxItems
    READ ObjectCalled$(x)
NEXT x
RESTORE Uo3
FOR x = 1 TO MaxItems
    READ O(x)
NEXT x

'Make a random color codes puzzle
a$ = "0": y! = 0
FOR x = 1 TO 6
    WHILE INSTR(a$, LTRIM$(RTRIM$(STR$(y!)))) > 0
       y! = INT(6 * RND(1)) + 1
    WEND
    a$ = a$ + LTRIM$(RTRIM$(STR$(y!)))
NEXT
Special(11) = VAL(RIGHT$(a$, 6))

'Make a Hot Tub Floor puzzle
Special(20) = INT(998 * RND(1)) + 1001

'Make random code for Shock Therapy Door!
Special(26) = VAL("1" + LTRIM$(STR$(INT(2 * RND(1)))) + LTRIM$(STR$(INT(2 * RND(1)))) + LTRIM$(STR$(INT(2 * RND(1)))))

'Make a random color code for bomb wire puzzle
a$ = "0": y! = 0
FOR x = 1 TO 6
    WHILE INSTR(a$, LTRIM$(RTRIM$(STR$(y!)))) > 0
       y! = INT(6 * RND(1)) + 1
    WEND
    a$ = a$ + LTRIM$(RTRIM$(STR$(y!)))
NEXT
Special(33) = VAL(RIGHT$(a$, 6))

END SUB

FUNCTION IsColor (a$)
    b$ = UCASE$(a$): x = 0
    IF INSTR(b$, " RED") THEN x = 1
    IF INSTR(b$, " PURPL") THEN x = 2
    IF INSTR(b$, " YELLO") THEN x = 3
    IF INSTR(b$, " BLUE") THEN x = 4
    IF INSTR(b$, " GREEN") THEN x = 5
    IF INSTR(b$, " ORANGE") THEN x = 6
    IsColor = x
END FUNCTION

FUNCTION IsDirection (t$)
    IF t$ = "n" OR t$ = "nor" OR t$ = "north" OR t$ = "go n" OR t$ = "go nor" OR t$ = "go north" OR t$ = "walk n" OR t$ = "walk nor" OR t$ = "walk north" THEN IsDirection = 1: GOTO OutIsDirection
    IF t$ = "s" OR t$ = "sou" OR t$ = "south" OR t$ = "go s" OR t$ = "go sou" OR t$ = "go south" OR t$ = "walk s" OR t$ = "walk sou" OR t$ = "walk south" THEN IsDirection = 2: GOTO OutIsDirection
    IF t$ = "e" OR t$ = "eas" OR t$ = "east" OR t$ = "go e" OR t$ = "go eas" OR t$ = "go east" OR t$ = "walk e" OR t$ = "walk eas" OR t$ = "walk east" THEN IsDirection = 3: GOTO OutIsDirection
    IF t$ = "w" OR t$ = "wes" OR t$ = "west" OR t$ = "go w" OR t$ = "go wes" OR t$ = "go west" OR t$ = "walk w" OR t$ = "walk wes" OR t$ = "walk west" THEN IsDirection = 4: GOTO OutIsDirection
    IF t$ = "u" OR t$ = "up" OR LEFT$(t$, 4) = "go u" OR t$ = "climb" OR LEFT$(t$, 7) = "climb u" THEN IsDirection = 5: GOTO OutIsDirection
    IF t$ = "d" OR t$ = "down" OR LEFT$(t$, 4) = "go d" OR t$ = "climb" OR LEFT$(t$, 7) = "climb d" OR t$ = "climb down" THEN IsDirection = 6: GOTO OutIsDirection
    IF t$ = "ne" OR t$ = "northea" OR t$ = "go ne" OR t$ = "northeast" OR t$ = "north east" OR t$ = "go northeast" OR t$ = "walk ne" OR t$ = "walk northeast" THEN IsDirection = 7: GOTO OutIsDirection
    IF t$ = "se" OR t$ = "southea" OR t$ = "go se" OR t$ = "southeast" OR t$ = "south east" OR t$ = "go southeast" OR t$ = "walk se" OR t$ = "walk southeast" THEN IsDirection = 8: GOTO OutIsDirection
    IF t$ = "sw" OR t$ = "southwe" OR t$ = "go sw" OR t$ = "southwest" OR t$ = "south west" OR t$ = "go southwest" OR t$ = "walk sw" OR t$ = "walk southwest" THEN IsDirection = 9: GOTO OutIsDirection
    IF t$ = "nw" OR t$ = "northwe" OR t$ = "go nw" OR t$ = "northwest" OR t$ = "north west" OR t$ = "go northwest" OR t$ = "walk nw" OR t$ = "walk northwest" THEN IsDirection = 10: GOTO OutIsDirection
    IsDirection = 0
OutIsDirection:
END FUNCTION

FUNCTION IsItem (a$, Itemno)
'this function determines if the COMMAND contains the name of an item
'Usage: ItemNumber=IsItem(a$, 0) -- returns the item # contained.
'Usage: RetVal=IsItem(a$,2) -- returns 1 if item #1 is contained!

g = 0

IF Itemno = 0 THEN
    FOR x = 1 TO MaxItems
        FOR y = 1 TO 5
            IF g = 0 THEN
                IF INSTR(UCASE$(a$), GetUo$(x, y)) > 1 THEN g = x
            END IF
        NEXT y
    NEXT x
ELSE
    FOR y = 1 TO 5
        IF INSTR(UCASE$(a$), GetUo$(Itemno, y)) > 0 THEN g = 1
    NEXT y
END IF

IsItem = g
IF g > 0 THEN AddPronoun (GetUo$(g, 1))

END FUNCTION

FUNCTION IsNoun (b$, noun$)

a$ = UCASE$(b$): noun$ = UCASE$(noun$)

IF noun$ = "WIRE" THEN
    IF INSTR(a$, " WIRE") OR INSTR(a$, "RED") OR INSTR(a$, "BLUE") OR INSTR(a$, "GREEN") OR INSTR(a$, "BLACK") OR INSTR(a$, "GREY") OR INSTR(a$, "GRAY") OR INSTR(a$, "BROWN") THEN
        AddPronoun (noun$): IsNoun = 1: EXIT FUNCTION
    END IF
END IF

IF noun$ = "BUGS" THEN
    IF INSTR(a$, " BUG") OR INSTR(a$, " INSEC") OR INSTR(a$, " SPIDE") THEN
        AddPronoun (noun$): IsNoun = 1: EXIT FUNCTION
    END IF
END IF

IF noun$ = "BOMB" THEN
    IF INSTR(a$, " BOMB") OR INSTR(a$, " EXPLO") OR INSTR(a$, " WIRE") OR INSTR(a$, " TRIGG") OR INSTR(a$, " DETON") THEN
        AddPronoun (noun$): IsNoun = 1: EXIT FUNCTION
    END IF
END IF

IF noun$ = "CABINET" THEN
    IF INSTR(a$, " CABIN") OR INSTR(a$, " YELLOW") OR INSTR(a$, " DOOR") THEN
        AddPronoun (noun$): IsNoun = 1: EXIT FUNCTION
    END IF
END IF

'IF noun$ = "CALENDAR" THEN
'    IF INSTR(a$, " CALEND") OR INSTR(a$, " FEBRUARY") THEN
'        AddPronoun (noun$): IsNoun = 1: EXIT FUNCTION
'    END IF
'END IF

IF noun$ = "CAR" THEN
    IF INSTR(a$, " CAR") OR INSTR(a$, " AUTO") OR INSTR(a$, " VEHIC") THEN
        AddPronoun (noun$): IsNoun = 1: EXIT FUNCTION
    END IF
END IF

IF noun$ = "STATUE" THEN
    IF INSTR(a$, " STONE") OR INSTR(a$, " STATUE") OR INSTR(a$, " WALL") OR INSTR(a$, " INSET") OR INSTR(a$, " ENCLOS") OR INSTR(a$, " FOUNT") OR INSTR(a$, "BIRDB") THEN
        AddPronoun (noun$): IsNoun = 1: EXIT FUNCTION
    END IF
END IF

IF noun$ = "SHOCK" THEN
    IF INSTR(a$, " CHAIR") OR INSTR(a$, " SHOCK") THEN
        AddPronoun (noun$): IsNoun = 1: EXIT FUNCTION
    END IF
END IF

IF noun$ = "FAN" THEN
    IF INSTR(a$, " FAN") OR INSTR(a$, " VENT") OR INSTR(a$, " BLADE") THEN
        AddPronoun (noun$): IsNoun = 1: EXIT FUNCTION
    END IF
END IF

IF noun$ = "DIAL" THEN
    IF INSTR(a$, " DIAL") OR INSTR(a$, " KNOB") OR INSTR(a$, " INTENS") OR INSTR(a$, " SETTING") OR INSTR(a$, " ADJUST") THEN
        AddPronoun (noun$): IsNoun = 1: EXIT FUNCTION
    END IF
END IF

IF noun$ = "MESSAGE" THEN
    IF INSTR(a$, " MESSAG") OR INSTR(a$, "NOTE") OR INSTR(a$, "FLYER") THEN
        AddPronoun (noun$): IsNoun = 1: EXIT FUNCTION
    END IF
END IF

IF noun$ = "#" THEN
    IF INSTR(a$, "0") OR INSTR(a$, "1") OR INSTR(a$, "2") OR INSTR(a$, "3") OR INSTR(a$, "4") OR INSTR(a$, "5") OR INSTR(a$, "6") OR INSTR(a$, "7") OR INSTR(a$, "8") OR INSTR(a$, "9") THEN
        AddPronoun (noun$): IsNoun = 1: EXIT FUNCTION
    END IF
END IF

IF noun$ = "PLANT" THEN
    IF INSTR(a$, " PLANT") OR INSTR(a$, " FLOWER") OR INSTR(a$, " BUSH") OR INSTR(a$, " FLORA") OR INSTR(a$, " FOLLIAGE") THEN
        AddPronoun (noun$): IsNoun = 1: EXIT FUNCTION
    END IF
END IF

IF noun$ = "BUTTON" THEN
    IF INSTR(a$, " BUTTON") OR INSTR(a$, " NUMBER") THEN
        AddPronoun (noun$): IsNoun = 1: EXIT FUNCTION
    END IF
END IF

IF noun$ = "DUFFEL" THEN
    IF INSTR(a$, " DUFFEL") OR INSTR(a$, " DUFFLE") OR INSTR(a$, " BLACK") OR INSTR(a$, " BAG") THEN
        AddPronoun (noun$): IsNoun = 1: EXIT FUNCTION
    END IF
END IF

IF noun$ = "APPARATUS" THEN
    IF INSTR(a$, " DEVICE") OR INSTR(a$, " FUNNEL") OR INSTR(a$, " APPARAT") OR INSTR(a$, " APARAT") OR INSTR(a$, " SALINE") OR INSTR(a$, " SOLUTION") OR INSTR(a$, " MACHINE") OR INSTR(a$, " CONVERT") OR INSTR(a$, " RECEPT") THEN
        AddPronoun (noun$): IsNoun = 1: EXIT FUNCTION
    END IF
END IF

IF noun$ = "PANEL" THEN
    IF INSTR(a$, " PANEL") THEN
        AddPronoun (noun$): IsNoun = 1: EXIT FUNCTION
    END IF
END IF

IF noun$ = "CHAIR" THEN
    IF INSTR(a$, " CHAIR") OR INSTR(a$, " SEAT") OR INSTR(a$, " WOODEN") THEN
        AddPronoun (noun$): IsNoun = 1: EXIT FUNCTION
    END IF
END IF

IF noun$ = "WATER" THEN
    IF INSTR(a$, "WATER") OR INSTR(a$, " LIQUID") THEN
        AddPronoun (noun$): IsNoun = 1: EXIT FUNCTION
    END IF
END IF

IF noun$ = "ARSENIC" THEN
    IF INSTR(a$, " ARSENIC") OR INSTR(a$, " ARSANIC") OR INSTR(a$, " POISON") THEN
        AddPronoun (noun$): IsNoun = 1: EXIT FUNCTION
    END IF
END IF

IF noun$ = "JESUS" THEN
    IF INSTR(a$, " MAN") OR INSTR(a$, " GUY") OR INSTR(a$, " JESUS") OR INSTR(a$, " HAROLD") OR INSTR(a$, " VAUGHN") THEN
        AddProName noun$, 1: AddPronoun (noun$): IsNoun = 1: EXIT FUNCTION
    END IF
END IF

IF noun$ = "JENKINS" THEN
    IF INSTR(a$, " JENKIN") OR INSTR(a$, " WOMAN") OR INSTR(a$, " GIRL") OR INSTR(a$, " FEMALE") OR INSTR(a$, " MISS") OR INSTR(a$, " LASS") OR INSTR(a$, " LADY") THEN
        AddProName noun$, 2: AddPronoun (noun$): IsNoun = 1: EXIT FUNCTION
    END IF
END IF

IF noun$ = "XAVIER" THEN
    IF INSTR(a$, " XAVIER") OR INSTR(a$, " ONASS") OR INSTR(a$, " MAN") OR INSTR(a$, " GUY") THEN
        AddProName noun$, 1: AddPronoun (noun$): IsNoun = 1: EXIT FUNCTION
    END IF
END IF

IF noun$ = "SANDY" THEN
    IF INSTR(a$, " SANDY") OR INSTR(a$, " WOMAN") OR INSTR(a$, " GIRL") OR INSTR(a$, " FEMALE") OR INSTR(a$, " MISS") OR INSTR(a$, " LASS") OR INSTR(a$, " LADY") THEN
        AddProName noun$, 2: AddPronoun (noun$): IsNoun = 1: EXIT FUNCTION
    END IF
END IF

IF noun$ = "GUARD" THEN
    IF INSTR(a$, " GUARD") THEN
        AddPronoun (noun$): IsNoun = 1: EXIT FUNCTION
    END IF
END IF

IF noun$ = "SOCRATES" THEN
    IF INSTR(a$, " SOCRAT") OR INSTR(a$, " MAN") OR INSTR(a$, " MALE") OR INSTR(a$, " GUY") OR INSTR(a$, " DUDE") THEN
        AddProName noun$, 1: AddPronoun (noun$): IsNoun = 1: EXIT FUNCTION
    END IF
END IF

IF noun$ = "NAPOLEON" THEN
    IF INSTR(a$, " NAPOL") OR INSTR(a$, " MAN") OR INSTR(a$, " MALE") OR INSTR(a$, " GUY") OR INSTR(a$, " DUDE") THEN
        AddProName noun$, 1: AddPronoun (noun$): IsNoun = 1: EXIT FUNCTION
    END IF
END IF

IF noun$ = "GOAT" THEN
    IF INSTR(a$, " GOAT") OR INSTR(a$, " PAGAN") OR INSTR(a$, " DRUID") OR INSTR(a$, " MAN") OR INSTR(a$, " PEOPLE") OR INSTR(a$, " MEN") OR INSTR(a$, " GUY") THEN
        AddProName noun$, 1: AddPronoun (noun$): IsNoun = 1: EXIT FUNCTION
    END IF
END IF

IF noun$ = "ROB" THEN
    IF INSTR(a$, " ROB") OR INSTR(a$, " BOB") OR INSTR(a$, " PSYCHO") OR INSTR(a$, " JANIT") OR INSTR(a$, " MAN") OR INSTR(a$, " GUY") THEN
        AddProName noun$, 1: AddPronoun (noun$): IsNoun = 1: EXIT FUNCTION
    END IF
END IF

IF noun$ = "TODD" THEN
    IF INSTR(a$, " TODD") OR INSTR(a$, " MAN") OR INSTR(a$, " GUY") OR INSTR(a$, " NURSE") THEN
        AddProName noun$, 1: AddPronoun (noun$): IsNoun = 1: EXIT FUNCTION
    END IF
END IF

IF noun$ = "KANDI" THEN
    IF INSTR(a$, " KANDI") OR INSTR(a$, " WOMAN") OR INSTR(a$, " GIRL") OR INSTR(a$, " LADY") OR INSTR(a$, " NURSE") THEN
        AddProName noun$, 2: AddPronoun (noun$): IsNoun = 1: EXIT FUNCTION
    END IF
END IF

IF noun$ = "CHUCK" THEN
    IF INSTR(a$, " CHUCK") OR INSTR(a$, " SANDERS") OR INSTR(a$, " MAN") OR INSTR(a$, " GUY") OR INSTR(a$, " HOMICID") OR INSTR(a$, " MANIAC") THEN
        AddProName noun$, 1: AddPronoun (noun$): IsNoun = 1: EXIT FUNCTION
    END IF
END IF

IF noun$ = "GORDON" THEN
    IF INSTR(a$, " GORDON") OR INSTR(a$, " GORDEN") OR INSTR(a$, " GORDY") OR INSTR(a$, " MAN") OR INSTR(a$, " MALE") OR INSTR(a$, " GUY") OR INSTR(a$, " DUDE") THEN
        AddProName noun$, 1: AddPronoun (noun$): IsNoun = 1: EXIT FUNCTION
    END IF
END IF

IF noun$ = "FRIDGE" THEN
    IF INSTR(a$, " REFRIG") OR INSTR(a$, " REFRIDG") OR INSTR(a$, " FRIDGE") OR INSTR(a$, " ICEBOX") OR INSTR(a$, "FREEZER") THEN
        AddPronoun (noun$): IsNoun = 1: EXIT FUNCTION
    END IF
END IF

IF noun$ = "TABLE" THEN
    IF INSTR(a$, " TABLE") OR INSTR(a$, " CONFER") THEN
        AddPronoun (noun$): IsNoun = 1: EXIT FUNCTION
    END IF
END IF

IF noun$ = "DESK" THEN
    IF INSTR(a$, " DESK") OR INSTR(a$, " TABLE") THEN
        AddPronoun (noun$): IsNoun = 1: EXIT FUNCTION
    END IF
END IF

IF noun$ = "DOOR" THEN
    IF INSTR(a$, " DOOR") OR INSTR(a$, " ENTRAN") THEN
        AddPronoun (noun$): IsNoun = 1: EXIT FUNCTION
    END IF
END IF

IF noun$ = "CELLDOOR" THEN
    IF INSTR(a$, " DOOR") OR INSTR(a$, " ENTRAN") OR INSTR(a$, " CELL") THEN
        AddPronoun (noun$): IsNoun = 1: EXIT FUNCTION
    END IF
END IF

IF noun$ = "BED" THEN
    IF INSTR(a$, " BED") THEN
        AddPronoun (noun$): IsNoun = 1: EXIT FUNCTION
    END IF
END IF

IF noun$ = "MATTRESS" THEN
    IF INSTR(a$, " MATTR") OR INSTR(a$, " SHEET") THEN
        AddPronoun (noun$): IsNoun = 1: EXIT FUNCTION
    END IF
END IF

IF noun$ = "RUG" THEN
    IF INSTR(a$, " FLOORMAT") OR INSTR(a$, " RUG") THEN
        AddPronoun (noun$): IsNoun = 1: EXIT FUNCTION
    END IF
END IF

IF noun$ = "SQUID" THEN
    IF INSTR(a$, " SQUID") OR INSTR(a$, " OCTOP") OR INSTR(a$, "OCTAP") THEN
        AddPronoun (noun$): IsNoun = 1: EXIT FUNCTION
    END IF
END IF

IF noun$ = "TRUNK" THEN
    IF INSTR(a$, " TRUNK") THEN
        AddPronoun (noun$): IsNoun = 1: EXIT FUNCTION
    END IF
END IF

IsNoun = 0: EXIT FUNCTION

END FUNCTION

FUNCTION IsPrep (b$, prep$)

a$ = UCASE$(b$): prep$ = UCASE$(prep$)

IF prep$ = "UNDER" THEN
    IF INSTR(a$, " UNDER ") OR INSTR(a$, " BELOW ") OR INSTR(a$, " BENEATH ") THEN
        IsPrep = 1: EXIT FUNCTION
    END IF
END IF

IF prep$ = "BEHIND" THEN
    IF INSTR(a$, " BEHIND") THEN
        IsPrep = 1: EXIT FUNCTION
    END IF
END IF

IF prep$ = "INSIDE" THEN
    IF INSTR(a$, " INSIDE ") OR INSTR(a$, " INTO ") OR INSTR(a$, " IN ") THEN
        IsPrep = 1: EXIT FUNCTION
    END IF
END IF

END FUNCTION

FUNCTION IsVerb (t$, b$)

a$ = UCASE$(t$): b$ = UCASE$(b$)

IF b$ = "LOOK" THEN
    IF LEFT$(a$, 7) = "SEARCH " OR LEFT$(a$, 2) = "X " OR LEFT$(a$, 5) = "LOOK " OR LEFT$(a$, 4) = "EXAM" OR LEFT$(a$, 5) = "READ " THEN
        IsVerb = 1: EXIT FUNCTION
    END IF
END IF

IF b$ = "ENTER" THEN
    IF LEFT$(a$, 6) = "ENTER " OR LEFT$(a$, 7) = "GET IN " OR LEFT$(a$, 8) = "GET INSI" OR LEFT$(a$, 8) = "GET INTO" THEN
        IsVerb = 1: EXIT FUNCTION
    END IF
END IF

IF b$ = "GET" THEN
    IF LEFT$(a$, 4) = "GET " OR LEFT$(a$, 5) = "TAKE " OR LEFT$(a$, 7) = "PICK UP" OR LEFT$(a$, 2) = "G " OR LEFT$(a$, 5) = "HOLD " OR LEFT$(a$, 5) = "ACQUI" OR LEFT$(a$, 4) = "ACQ " THEN
        IsVerb = 1: EXIT FUNCTION
    END IF
END IF

IF b$ = "DROP" THEN
    IF LEFT$(a$, 5) = "DROP " OR LEFT$(a$, 4) = "LEAV" OR LEFT$(a$, 5) = "LOSE " THEN
        IsVerb = 1: EXIT FUNCTION
    END IF
END IF

IF b$ = "TALK" THEN
    IF LEFT$(a$, 4) = "ASK " OR LEFT$(a$, 4) = "SAY " OR LEFT$(a$, 5) = "TALK " OR LEFT$(a$, 5) = "SPEAK" OR LEFT$(a$, 5) = "WARN " OR LEFT$(a$, 5) = "TELL " THEN
        IsVerb = 1: EXIT FUNCTION
    END IF
END IF

IF b$ = "GIVE" THEN
    IF LEFT$(a$, 5) = "GIVE " OR LEFT$(a$, 5) = "TRADE" OR LEFT$(a$, 5) = "BRIBE" OR LEFT$(a$, 5) = "OFFER" OR LEFT$(a$, 4) = "PAY " OR LEFT$(a$, 5) = "SELL " THEN
        IsVerb = 1: EXIT FUNCTION
    END IF
END IF

IF b$ = "SAVE" THEN
    IF LEFT$(a$, 5) = "SAVE " OR a$ = "SAVE" THEN
        IsVerb = 1: EXIT FUNCTION
    END IF
END IF

IF b$ = "LOAD" THEN
    IF LEFT$(a$, 5) = "LOAD " OR LEFT$(a$, 6) = "RESTOR" OR a$ = "LOAD" THEN
        IsVerb = 1: EXIT FUNCTION
    END IF
END IF

IF b$ = "QUIT" THEN
    IF a$ = "Q" OR a$ = "EXIT" OR a$ = "QUIT" OR a$ = "STOP" OR a$ = "END" THEN
        IsVerb = 1: EXIT FUNCTION
    END IF
END IF

IF b$ = "OPEN" THEN
    IF LEFT$(a$, 5) = "OPEN " OR LEFT$(a$, 5) = "PULL " THEN
        IsVerb = 1: EXIT FUNCTION
    END IF
END IF

IF b$ = "HYPNOTIZE" THEN
    IF LEFT$(a$, 6) = "HYPNOT" THEN
        IsVerb = 1: EXIT FUNCTION
    END IF
END IF

IF b$ = "UNDO" THEN
    IF a$ = "UNDO" OR LEFT$(a$, 5) = "UNDO " THEN
        IsVerb = 1: EXIT FUNCTION
    END IF
END IF

IF b$ = "I" THEN
    IF a$ = "I" OR a$ = "INV" OR a$ = "INVENT" OR a$ = "INVENTORY" OR a$ = "ITEMS" OR a$ = "ITEM" THEN
        IsVerb = 1: EXIT FUNCTION
    END IF
END IF

IF b$ = "BUY" THEN
    IF LEFT$(a$, 4) = "BUY " OR LEFT$(a$, 7) = "PURCHAS" THEN
        IsVerb = 1: EXIT FUNCTION
    END IF
END IF

IF b$ = "CLOSE" THEN
    IF LEFT$(a$, 6) = "CLOSE " OR LEFT$(a$, 5) = "PUSH " OR LEFT$(a$, 5) = "SHUT " THEN
        IsVerb = 1: EXIT FUNCTION
    END IF
END IF

IF b$ = "MOVE" THEN
    IF LEFT$(a$, 5) = "MOVE " OR LEFT$(a$, 5) = "PUSH " OR LEFT$(a$, 5) = "PULL " OR LEFT$(a$, 5) = "OPEN " THEN
        IsVerb = 1: EXIT FUNCTION
    END IF
END IF

IF b$ = "UNLOCK" THEN
    IF LEFT$(a$, 5) = "UNLOC" OR LEFT$(a$, 6) = "UNFAST" THEN
        IsVerb = 1: EXIT FUNCTION
    END IF
END IF

IF b$ = "LOCK" THEN
    IF LEFT$(a$, 5) = "LOCK " THEN
        IsVerb = 1: EXIT FUNCTION
    END IF
END IF

IF b$ = "INSERT" THEN
    IF LEFT$(a$, 5) = "INSER" OR LEFT$(a$, 4) = "PUT " OR LEFT$(a$, 6) = "PLACE " THEN
        IsVerb = 1: EXIT FUNCTION
    END IF
END IF

IF b$ = "POUR" THEN
    IF LEFT$(a$, 5) = "POUR " OR LEFT$(a$, 5) = "DUMP " OR LEFT$(a$, 6) = "EMPTY " OR LEFT$(a$, 7) = "UNFILL " THEN
        IsVerb = 1: EXIT FUNCTION
    END IF
END IF

IF b$ = "PUT" THEN
    IF LEFT$(a$, 4) = "PUT " OR LEFT$(a$, 5) = "PLACE" OR LEFT$(a$, 4) = "SET " OR LEFT$(a$, 6) = "INSERT" THEN
        IsVerb = 1: EXIT FUNCTION
    END IF
END IF

IF b$ = "JUMP" THEN
    IF LEFT$(a$, 4) = "JUMP" OR LEFT$(a$, 4) = "LEAP" THEN
        IsVerb = 1: EXIT FUNCTION
    END IF
END IF

IF b$ = "SCORE" THEN
    IF a$ = "SCORE" OR a$ = "POINTS" OR a$ = "POINT" THEN
        IsVerb = 1: EXIT FUNCTION
    END IF
END IF

IF b$ = "DIG" THEN
    IF a$ = "DIG" OR LEFT$(a$, 4) = "DIG " THEN
        IsVerb = 1: EXIT FUNCTION
    END IF
END IF

IF b$ = "HELP" THEN
   IF a$ = "HELP" THEN
       IsVerb = 1: EXIT FUNCTION
   END IF
END IF

IF b$ = "CLIMB" THEN
    IF LEFT$(a$, 6) = "CLIMB " OR LEFT$(a$, 6) = "GO UP " THEN
        IsVerb = 1: EXIT FUNCTION
    END IF
END IF

IF b$ = "EAT" THEN
    IF LEFT$(a$, 4) = "EAT " OR LEFT$(a$, 6) = "SWALLO" OR LEFT$(a$, 7) = "INGEST " OR LEFT$(a$, 7) = "INJEST " OR LEFT$(a$, 7) = "CONSUME" THEN
        IsVerb = 1: EXIT FUNCTION
    END IF
END IF

IF b$ = "DRINK" THEN
    IF LEFT$(a$, 5) = "DRINK" OR LEFT$(a$, 6) = "SWALLO" OR LEFT$(a$, 7) = "INGEST " OR LEFT$(a$, 7) = "INJEST " OR LEFT$(a$, 7) = "CONSUME" THEN
        IsVerb = 1: EXIT FUNCTION
    END IF
END IF

IF b$ = "UNP" + "LUG" THEN
    IF LEFT$(a$, 6) = "UNPLUG" OR (LEFT$(a$, 5) = "PULL " AND INSTR(a$, "PLUG")) OR (LEFT$(a$, 5) = "REMOV" AND INSTR(a$, "PLUG")) OR (LEFT$(a$, 5) = "PULL " AND INSTR(a$, "CORD")) OR (LEFT$(a$, 5) = "REMOV" AND INSTR(a$, "CORD")) THEN
        IsVerb = 1: EXIT FUNCTION
    END IF
END IF

IF b$ = "WEAR" THEN
    IF LEFT$(a$, 5) = "WEAR " OR LEFT$(a$, 7) = "PUT ON " OR LEFT$(a$, 4) = "DON " THEN
        IsVerb = 1: EXIT FUNCTION
    END IF
END IF

IF b$ = "UNWEAR" THEN
    IF LEFT$(a$, 7) = "UNWEAR " OR LEFT$(a$, 9) = "TAKE OFF " OR LEFT$(a$, 5) = "DOFF " OR LEFT$(a$, 5) = "REMOV" THEN
        IsVerb = 1: EXIT FUNCTION
    END IF
END IF

IF b$ = "INJECT" THEN
    IF LEFT$(a$, 6) = "SEDATE" OR LEFT$(a$, 6) = "INJECT" OR LEFT$(a$, 6) = "SHOOT " OR LEFT$(a$, 6) = "STICK " OR LEFT$(a$, 5) = "POKE " OR (LEFT$(a$, 5) = "GIVE " AND (INSTR(a$, " SHOT") OR INSTR(a$, " INJECT"))) THEN
        IsVerb = 1: EXIT FUNCTION
    END IF
END IF

IF b$ = "PRESS" THEN
    IF LEFT$(a$, 6) = "PRESS " OR LEFT$(a$, 5) = "PUSH " OR LEFT$(a$, 6) = "TOUCH " OR LEFT$(a$, 6) = "PUNCH " THEN
        IsVerb = 1: EXIT FUNCTION
    END IF
END IF

IF b$ = "REPAIR" THEN
    IF LEFT$(a$, 6) = "REPAIR" OR LEFT$(a$, 4) = "FIX " THEN
        IsVerb = 1: EXIT FUNCTION
    END IF
END IF

IF b$ = "THROW" THEN
    IF LEFT$(a$, 6) = "THROW " OR LEFT$(a$, 5) = "TOSS " THEN
        IsVerb = 1: EXIT FUNCTION
    END IF
END IF

IF b$ = "TURN" THEN
    IF LEFT$(a$, 5) = "TURN " OR LEFT$(a$, 6) = "TWIST " OR LEFT$(a$, 6) = "ROTATE" OR LEFT$(a$, 5) = "SPIN " OR LEFT$(a$, 4) = "SET " OR LEFT$(a$, 6) = "ADJUST" THEN
        IsVerb = 1: EXIT FUNCTION
    END IF
END IF

IF b$ = "SIT" THEN
    IF LEFT$(a$, 4) = "SIT " OR LEFT$(a$, 4) = "SET " OR LEFT$(a$, 6) = "RELAX " OR LEFT$(a$, 6) = "LOUNGE" OR LEFT$(a$, 6) = "PERCH " THEN
        IsVerb = 1: EXIT FUNCTION
    END IF
END IF

IF b$ = "KILL" THEN
    IF LEFT$(a$, 5) = "KILL " OR LEFT$(a$, 7) = "DESTROY" OR LEFT$(a$, 7) = "ATTACK " THEN
        IsVerb = 1: EXIT FUNCTION
    END IF
END IF

IF b$ = "SPRAY" THEN
    IF LEFT$(a$, 6) = "SPRAY " THEN
        IsVerb = 1: EXIT FUNCTION
    END IF
END IF

IF b$ = "CUT" THEN
    IF LEFT$(a$, 4) = "CUT " OR LEFT$(a$, 6) = "SEVER " OR LEFT$(a$, 5) = "CHOP " THEN
        IsVerb = 1: EXIT FUNCTION
    END IF
END IF

IF b$ = "USE" THEN
    IF LEFT$(a$, 4) = "USE " THEN
        IsVerb = 1: EXIT FUNCTION
    END IF
END IF

IF b$ = "VERSION" THEN
    IF a$ = "V" OR a$ = "VER" OR a$ = "VERS" OR a$ = "VERSION" THEN
        IsVerb = 1: EXIT FUNCTION
    END IF
END IF

IsVerb = 0
END FUNCTION

SUB LocTitle (a$)

IF TextMode > 0 THEN
    Oprint CHR$(13) + "`4**`@**`%** " + UCASE$(a$) + CHR$(13)
ELSE
    LINE (150, 3)-(308, 9), 0, BF
    x = 149 + INT((158 - (LEN(a$) * 6)) / 2)
    GPrint UCASE$(a$), x, 4, 255
END IF
END SUB

FUNCTION ParseCommand (a$)

'*** First let's store a value that indicates NOTHING has changed....
'*** This will be set whenever values actually do change...
DataChange = 0: PlayerDied = 0: KeepString$ = a$

b$ = LCASE$(LTRIM$(RTRIM$(KeepString$)))
b$ = AlterInput$(b$) 'In case we want a different handler to to parse this
KeepIt$ = "": KeepThem$ = "": KeepHim$ = "": KeepHer$ = ""
'**************************************************** N/S/E/W/NE/SE/SW/NW/U/D
tt = IsDirection(b$)
IF tt > 0 THEN
    ee = CheckDirection(tt)
    IF ee = 0 THEN
       AddLine 2, GetNoDir$(lo, tt), 1
    ELSE
        SetLo ee
        DisplayRoom lo
        CheckKilledRoom (KeepString$)
    END IF
    GOTO ExitParse
END IF
'****************************************************************** QUIT/EXIT
IF b$ = "l" OR b$ = "loo" OR b$ = "look" OR b$ = "x" THEN DisplayRoom lo: GOTO ExitParse

IF IsVerb(b$, "QUIT") THEN ParseCommand = -1: GOTO OutParseCommand

IF TextMode = 0 THEN AddLine 2, "`!..." + UCASE$(KeepString$), 1

IF VerbUndo(b$) <> 0 THEN GOTO ExitParse
IF VerbSave2(b$, GetRoomTitle$(lo) + "." + CHR$(13) + "It was saved at " + GetDate$) <> 0 THEN MovesMade = MovesMade - 1: GOTO ExitParse
nul = VerbLoad2(b$)
IF nul <> 0 THEN
    IF nul = 2 THEN
        DisplayRoom lo
        AddLine 2, "`2Your saved game is now loaded. Thank you.", 1
    END IF
    GOTO ExitParse
END IF

IF IsVerb(b$, "VERSION") THEN
    a$ = "Lunatix: The Insanity Circle, Version 1.1 (COMP99)"
    AddLine 2, a$, 1
    GOTO ExitParse
END IF
IF VerbGet(b$) <> 0 THEN GOTO ExitParse
IF VerbGetDrop(b$) <> 0 THEN GOTO ExitParse
IF VerbLookAtItems(b$) <> 0 THEN GOTO ExitParse
IF VerbLook(b$) <> 0 THEN GOTO ExitParse
IF VerbInventory(b$) <> 0 THEN GOTO ExitParse
IF VerbTalk(b$) <> 0 THEN GOTO ExitParse
IF VerbEat(b$) <> 0 THEN GOTO ExitParse
IF VerbDrink(b$) <> 0 THEN GOTO ExitParse
IF VerbPut(b$) <> 0 THEN GOTO ExitParse
IF VerbPour(b$) <> 0 THEN GOTO ExitParse
IF VerbUnplug(b$) <> 0 THEN GOTO ExitParse
IF VerbUnlock(b$) <> 0 THEN GOTO ExitParse
IF VerbOpen(b$) <> 0 THEN GOTO ExitParse
IF VerbClose(b$) <> 0 THEN GOTO ExitParse
IF VerbGive(b$) <> 0 THEN GOTO ExitParse
IF VerbWear(b$) <> 0 THEN GOTO ExitParse
IF VerbInject(b$) <> 0 THEN GOTO ExitParse
IF VerbPress(b$) <> 0 THEN GOTO ExitParse
IF VerbInsert(b$) <> 0 THEN GOTO ExitParse
IF VerbRepair(b$) <> 0 THEN GOTO ExitParse
IF VerbBuy(b$) <> 0 THEN GOTO ExitParse
IF VerbTurn(b$) <> 0 THEN GOTO ExitParse
IF VerbSit(b$) <> 0 THEN GOTO ExitParse
IF VerbMove(b$) <> 0 THEN GOTO ExitParse
IF VerbSpray(b$) <> 0 THEN GOTO ExitParse
IF VerbThrow(b$) <> 0 THEN GOTO ExitParse
IF VerbCut(b$) <> 0 THEN GOTO ExitParse
IF VerbHypnotize(b$) <> 0 THEN GOTO ExitParse
IF GetSupport(lo, b$) <> 0 THEN GOTO ExitParse '*** Support for this room!
IF GetSupport(42, b$) <> 0 THEN GOTO ExitParse '*** Support for all rooms!
IF VerbMiscel(b$) <> 0 THEN GOTO ExitParse
IF BadCommand(b$) <> 0 THEN GOTO ExitParse

'********************************************************* DID NOT UNDERSTAND
a = INT(4 * RND(1)) + 1
IF a = 1 THEN
    AddLine 2, "`2Your logic, although interesting, is flawed.", 1
END IF
IF a = 2 THEN
    AddLine 2, "`2In a perfect world, that might have worked.", 1
END IF
IF a = 3 THEN
    AddLine 2, "`2Your efforts result in nothing.", 1
END IF
IF a = 4 THEN
    AddLine 2, "`2That's a pretty crazy idea, but it didn't work.", 1
END IF

ExitParse:
ParseCommand = 0
IF DataChange > 0 AND PlayerDied = 0 THEN
    '*** Here, we store info for the UNDO COMMAND
    nul = StoreUndo(KeepString$)
    SetUndoInfo 'Make sure we initialize our undo registers
END IF

OutParseCommand: END FUNCTION

SUB SetLo (x)
    IF lo <> x THEN
        lo = x
        DataChange = 1
    END IF
END SUB

SUB SetObject (x1, y1)
    IF O(x1) <> y1 THEN
        O(x1) = y1
        DataChange = 1
    END IF
END SUB

SUB SetSpecial (x1, y1!)
    IF Special(x1) <> y1! THEN
        Special(x1) = y1!
        DataChange = 1
    END IF
END SUB

SUB SetUndoInfo

'*** store the latest info as our "UNDO" info
FOR x = 1 TO MaxSpecial: UndoSpecial(x) = Special(x): NEXT x
FOR x = 1 TO MaxItems: UndoO(x) = O(x): NEXT x
UndoLo = lo

END SUB

FUNCTION StoreUndo (a1$)

STATIC WhichUndo AS INTEGER
STATIC OnTheStack

IF UCASE$(a1$) = "RESET" THEN
    WhichUndo = 0
    OnTheStack = 0
    StoreUndo = 1
    EXIT FUNCTION
END IF

IF UCASE$(a1$) <> "UNDO" THEN
    '**** STORE UNDO
    WhichUndo = WhichUndo + 1
    IF WhichUndo > MaxUndo THEN WhichUndo = 1
    OnTheStack = OnTheStack + 1
    IF OnTheStack > MaxUndo THEN OnTheStack = MaxUndo
    x = VerbSave2("UNDO" + STR$(WhichUndo), a1$)
    StoreUndo = 1: EXIT FUNCTION
ELSE
    '**** RETREIVE UNDO
    IF OnTheStack > 0 THEN
        Lold = lo
        x = VerbLoad2("UNDO" + STR$(WhichUndo))
        IF x = 2 THEN
            SetDirections (lo) '*In case available directions have changed
            IF lo <> Lold THEN
                DisplayRoom lo 'Update this room, directions, etc.
            ELSE
                SetRoomPic lo 'Update the picture just in case
            END IF
            WhichUndo = WhichUndo - 1
            IF WhichUndo < 1 THEN WhichUndo = MaxUndo
            OnTheStack = OnTheStack - 1
            IF OnTheStack < 1 THEN OnTheStack = 0
            SetUndoInfo 'Make sure we initialize our undo registers
            StoreUndo = 1
            IF MusicOn <> 0 THEN PlayAndSleep 0, 1, "#EDC"
        ELSE
            StoreUndo = 0
        END IF
    ELSE
        AddLine 2, "`2No commands can be undone at this time.", 1
        StoreUndo = 0
    END IF
END IF

END FUNCTION

FUNCTION VariFile (b$)

    FileExists = 1
    ON ERROR GOTO NoFile
    OPEN b$ FOR INPUT SHARED AS #2
    CLOSE #2
    'SetStandardErrorTrap
    ON ERROR GOTO 0
    VariFile = FileExists

END FUNCTION

FUNCTION VerbLoad2 (a$)

b$ = a$
ErrorFound = 0
Comment$ = "This is a test. This is only a test."
RecNo = 1
SSize = 6 'Size to allot for SPECIALS
OSize = 3 'Size to allot for OBJECT LOCATIONS
CSize = 4 'Size to allot for the SCORE
RSize = 2 'Size to allot for the ROOM #
MSize = 8 'Size to allot for moves made.
TSize = 80 'Size to allot for "text or comments"
Vsize = 20 'Size to allot for the "validation" checksum number.
RecSize = (SSize * MaxSpecial) + (OSize * MaxItems) + RSize + CSize + MSize + TSize + Vsize

IF IsVerb(b$, "LOAD") <> 0 THEN
    WhichType = 1
    GameFile$ = "LunaTix"
    IF LEN(b$) > 4 THEN
        RecNo = VAL(RIGHT$(b$, 2))
        IF RecNo < 1 OR RecNo > 9 THEN RecNo = 0
    ELSE
        RecNo = 0
    END IF
    GOTO VLoadCont
END IF

IF IsVerb(b$, "UNDO") <> 0 THEN
    WhichType = 2: RecNo = VAL(RIGHT$(b$, LEN(b$) - 5))
    IF RecNo > 0 THEN
        'GameFile$ = "LunUndo"
        GameFile$ = "LunaTix"
        RecNo = RecNo + 9
        GOTO VLoadCont
    END IF
END IF

VerbLoad2 = 0: EXIT FUNCTION

VLoadCont:
IF RecNo = 0 THEN
    RecNo = AskYesNo("`2Which save do you wish to RESTORE? `0(`%1 `7to `%9`7`0)`2:", 2)
    IF TextMode > 0 THEN Oprint "`7`7"
    IF RecNo = 0 THEN VerbLoad2 = 1: EXIT FUNCTION
END IF

'*** Otherwise, LOAD the position in the game!!! :)

DIM Tempo(MaxItems) 'Where item is LOCATED. 0=In Inventory!!
DIM TempSpecial(MaxSpecial) AS LONG 'How many "Special" things are there?
DIM TempScore AS INTEGER, TempMovesMade AS INTEGER

IF VariFile(GameFile$ + ".SGM") = 0 THEN
    IF WhichType = 1 THEN
        AddLine 2, "`2You haven't saved a game yet.", 1
    END IF
    IF WhichType = 2 THEN
        AddLine 2, "`2No Undo information exists.", 1
    END IF
    VerbLoad2 = 1: EXIT FUNCTION
END IF

ON ERROR GOTO WatchError

OPEN GameFile$ + ".SGM" FOR RANDOM SHARED AS #2 LEN = RecSize
FIELD #2, SSize * MaxSpecial AS b1$, OSize * MaxItems AS b2$, RSize AS b3$, CSize AS b4$, MSize AS B5$, TSize AS b6$, Vsize AS b7$
IF ErrorFound <> 0 THEN GOTO VerbLoad2Error
Check$ = "": c1! = 0: c2! = 0

GET #2, RecNo

FOR x = 1 TO MaxSpecial
    'INPUT #2, TempSpecial(x)
    TempSpecial(x) = VAL(MID$(b1$, (x * SSize) - (SSize - 1), SSize))
    c1! = c1! + TempSpecial(x) + 3
NEXT x

IF ErrorFound <> 0 THEN GOTO VerbLoad2Error

FOR x = 1 TO MaxItems
    'INPUT #2, Tempo(x)
    Tempo(x) = VAL(MID$(b2$, (x * OSize) - (OSize - 1), OSize))
    c2! = c2! + Tempo(x) + 4
NEXT x
c2! = c2! + VAL(B5$)

IF ErrorFound <> 0 THEN GOTO VerbLoad2Error

'RSize AS B3$, CSize AS b4$, MSize AS b5$, TSize AS b6$, Vsize AS b7$
TempLo = VAL(b3$)
TempScore = VAL(b4$)
TempMovesMade = VAL(B5$)
TempText$ = LTRIM$(RTRIM$(b6$))
OldCheck$ = LTRIM$(RTRIM$(b7$))
Check$ = LTRIM$(RTRIM$(STR$(c1!))) + "295" + LTRIM$(RTRIM$(STR$(TempScore))) + LTRIM$(RTRIM$(STR$(c2!))) + "56" + LTRIM$(RTRIM$(STR$(TempLo * 13)))

CLOSE #2

IF ErrorFound <> 0 THEN GOTO VerbLoad2Error

IF OldCheck$ <> Check$ THEN
    IF WhichType = 1 THEN
        AddLine 2, "`2Sorry. You have attempted to load an INVALID save position for this game!", 1
    END IF
    IF WhichType = 2 THEN
        AddLine 2, "`2Undo information is invalid. Cannot undo the last move.", 1
    END IF
    'SetStandardErrorTrap
    ON ERROR GOTO 0
    VerbLoad2 = 1
    EXIT FUNCTION
END IF

'*** Let's make sure they really want to do this...

IF WhichType = 1 THEN
    IF TextMode > 0 THEN Oprint "`7`7"
    a$ = "Saved Game #" + LTRIM$(STR$(RecNo)) + " is at "
    a$ = a$ + TempText$ + "."
    AddLine 2, a$, 1
    t = AskYesNo("`2Is this what you want to restore? `0(`%Y`7`2/`%N`7`0)`2:", 1)
    IF TextMode > 0 THEN Oprint "`7`7"
    IF t <> 1 THEN VerbLoad2 = 1: EXIT FUNCTION
END IF

FOR x = 1 TO MaxItems: O(x) = Tempo(x): NEXT x
FOR x = 1 TO MaxSpecial: Special(x) = TempSpecial(x): NEXT x
lo = TempLo
Score = TempScore
MovesMade = TempMovesMade

'SetStandardErrorTrap
ON ERROR GOTO 0
IF WhichType = 1 THEN
    IF MusicOn <> 0 THEN PlayAndSleep 0, 1, "@fcf"
    SetUndoInfo 'Make sure we initialize our undo registers
    nul = StoreUndo("RESET") 'Reset the undo counters too!
END IF
IF WhichType = 2 THEN
    AddLine 2, "`2" + UCASE$(TempText$) + " is now undone.", 1
END IF
VerbLoad2 = 2

EXIT FUNCTION

VerbLoad2Error:
CLOSE #2
IF WhichType = 1 THEN
    AddLine 2, "`2Error: `2Your game could not be loaded. A problem was encountered trying to use the file `0" + GameFile$ + ".SGM`2.", 1
END IF
IF WhichType = 2 THEN
    AddLine 2, "`2An error exists in the undo information. Cannot undo the last move.", 1
END IF
'SetStandardErrorTrap
ON ERROR GOTO 0
VerbLoad2 = 1

END FUNCTION

FUNCTION VerbSave2 (a$, Comment$)

b$ = a$
ErrorFound = 0

IF IsVerb(b$, "SAVE") <> 0 THEN
    WhichType = 1
    GameFile$ = "LunaTix"
    IF LEN(b$) > 4 THEN
        RecNo = VAL(RIGHT$(b$, 2))
        IF RecNo < 1 OR RecNo > 9 THEN RecNo = 0
    ELSE
        RecNo = 0
    END IF
    GOTO VSaveCont
END IF

IF IsVerb(b$, "UNDO") <> 0 THEN
    WhichType = 2: RecNo = VAL(RIGHT$(b$, LEN(b$) - 5))
    IF RecNo > 0 THEN
        'GameFile$ = "LunUndo"
        GameFile$ = "LunaTix"
        RecNo = RecNo + 9
        GOTO VSaveCont
    END IF
END IF

VerbSave2 = 0: EXIT FUNCTION

VSaveCont:
SSize = 6 'Size to allot for SPECIALS
OSize = 3 'Size to allot for OBJECT LOCATIONS
CSize = 4 'Size to allot for the SCORE
RSize = 2 'Size to allot for the ROOM #
MSize = 8 'Size to allot for moves made.
TSize = 80 'Size to allot for "text or comments"
Vsize = 20 'Size to allot for the "validation" checksum number.
RecSize = (SSize * MaxSpecial) + (OSize * MaxItems) + RSize + CSize + MSize + TSize + Vsize

IF RecNo = 0 THEN
    RecNo = AskYesNo("`2Which position do you wish to SAVE? `0(`%1 `7to `%9`7`0)`2:", 2)
    IF TextMode > 0 THEN Oprint "`7`7"
    IF RecNo = 0 THEN VerbSave2 = 1: EXIT FUNCTION
END IF

'*** Otherwise, SAVE the position in the game!!! :)

ON ERROR GOTO WatchError

OPEN GameFile$ + ".SGM" FOR RANDOM SHARED AS #2 LEN = RecSize
FIELD #2, SSize * MaxSpecial AS b1$, OSize * MaxItems AS b2$, RSize AS b3$, CSize AS b4$, MSize AS B5$, TSize AS b6$, Vsize AS b7$
IF ErrorFound <> 0 THEN GOTO VerbSave2Error
Check$ = "": c1! = 0: c2! = 0

a$ = ""
FOR x = 1 TO MaxSpecial
    IF WhichType = 1 THEN
        a1$ = LTRIM$(RTRIM$(STR$(Special(x))))
        c1! = c1! + Special(x) + 3
    END IF
    IF WhichType = 2 THEN
        a1$ = LTRIM$(RTRIM$(STR$(UndoSpecial(x))))
        c1! = c1! + UndoSpecial(x) + 3
    END IF
    IF LEN(a1$) < SSize THEN a1$ = a1$ + STRING$(SSize - LEN(a1$), " ")
    a$ = a$ + a1$
NEXT x
LSET b1$ = a$

IF ErrorFound <> 0 THEN GOTO VerbSave2Error

a$ = ""
FOR x = 1 TO MaxItems
    IF WhichType = 1 THEN
        a1$ = LTRIM$(RTRIM$(STR$(O(x))))
        c2! = c2! + O(x) + 4
    END IF
    IF WhichType = 2 THEN
        a1$ = LTRIM$(RTRIM$(STR$(UndoO(x))))
        c2! = c2! + UndoO(x) + 4
    END IF
    IF LEN(a1$) < OSize THEN a1$ = a1$ + STRING$(OSize - LEN(a1$), " ")
    a$ = a$ + a1$
NEXT x
LSET b2$ = a$
IF WhichType = 1 THEN
    c2! = c2! + MovesMade
END IF
IF WhichType = 2 THEN
    c2! = c2! + UndoMovesMade
END IF

IF ErrorFound <> 0 THEN GOTO VerbSave2Error

IF WhichType = 1 THEN
    LSET b3$ = LTRIM$(RTRIM$(STR$(lo)))
    LSET b4$ = LTRIM$(RTRIM$(STR$(Score)))
    LSET B5$ = LTRIM$(RTRIM$(STR$(MovesMade)))
END IF
IF WhichType = 2 THEN
    LSET b3$ = LTRIM$(RTRIM$(STR$(UndoLo)))
    LSET b4$ = LTRIM$(RTRIM$(STR$(UndoScore)))
    LSET B5$ = LTRIM$(RTRIM$(STR$(UndoMovesMade)))
END IF

LSET b6$ = Comment$

'Checksum digit to prevent "TAMPERING" with save-game file heheheh
IF WhichType = 1 THEN
    LSET b7$ = LTRIM$(RTRIM$(STR$(c1!))) + "295" + LTRIM$(RTRIM$(STR$(Score))) + LTRIM$(RTRIM$(STR$(c2!))) + "56" + LTRIM$(RTRIM$(STR$(lo * 13)))
END IF
IF WhichType = 2 THEN
    LSET b7$ = LTRIM$(RTRIM$(STR$(c1!))) + "295" + LTRIM$(RTRIM$(STR$(UndoScore))) + LTRIM$(RTRIM$(STR$(c2!))) + "56" + LTRIM$(RTRIM$(STR$(UndoLo * 13)))
END IF

IF ErrorFound <> 0 THEN GOTO VerbSave2Error
PUT #2, RecNo
CLOSE #2

IF ErrorFound <> 0 THEN GOTO VerbSave2Error

IF WhichType = 1 THEN
    IF MusicOn <> 0 THEN PlayAndSleep 0, 1, "#F$C"
    AddLine 2, "`2Game Saved as #" + LTRIM$(STR$(RecNo)) + ". To restore later, type `0LOAD.`2", 1
END IF
VerbSave2 = 1
'SetStandardErrorTrap
ON ERROR GOTO 0
EXIT FUNCTION

VerbSave2Error:
CLOSE #2
'SetStandardErrorTrap
ON ERROR GOTO 0
IF WhichType = 1 THEN
    AddLine 2, "`7Error: `2Game could not be SAVED. A problem was encountered saving the file `0" + GameFile$ + ".SGM`2.", 1
END IF
VerbSave2 = 1

END FUNCTION

FUNCTION VerbUndo (b$)

IF IsVerb(b$, "UNDO") = 0 THEN EXIT FUNCTION 'Wasn't trying to talk after all
nul = StoreUndo("UNDO")

VerbUndo = 1

END FUNCTION

