/*
 *      ADVDEF.H - #defines and typedefs for ADV.C
 *      (C) 1986 Ravi Bhavnani
 *      All rights reserved
 *
 *      4 more #defines available due to cls() fix in advinit.c 2/14/87
 */

#include "stdio.h"
#include "ctype.h"
#include "errno.h"
#include "time.h"
// #include "smgdef.h"
// #include "descrip.h"
// #include "ssdef.h"
// #include "iodef.h"

#ifdef vms
char	*malloc();
#endif

#include "messages.h"
#include "places.h"
#include "objects.h"
#include "vocab.h"

#define MAJOR		2		/* major version	*/
#define MINOR		0		/* minor version 	*/
#define RELEASE		0		/* release number 	*/
#define RELEASED	"16-Sep-1988"	/* release date 	*/
#define COMPATIBLE	2000		/* games saved BEFORE this versions are incompatible */

/* VARIOUS MACROS */

#define forever         while (1)
#define TRACE_MARGIN	3
#define RETURN		{ margin -= TRACE_MARGIN; return; }

/* VARIOUS ERRORS */

#define CANTOPENMSGFILE		0
#define BADMSGFILE		1
#define TOOMANYMSGS		2
#define NOTENUFMSGMEM		3
#define CANTOPENLONGFILE	4
#define BADLONGFILE		5
#define TOOMANYLONGS		6
#define NOTENUFLONGMEM		7
#define CANTOPENSHORTFILE	8
#define BADSHORTFILE		9
#define TOOMANYSHORTS		10
#define NOTENUFSHORTMEM		11
#define CANTOPENVOCABFILE	12
#define BADVOCABFILE		13
#define BADVOCABWORD		14
#define VOCAB2BIG		15
#define CANTOPENOBJFILE		16
#define BADOBJFILE		17
#define TOOMANYOBJECTS		18
#define OBJ2MANYVALS		19
#define NOTENUFOBJMEM		20

#define BADQUERY		200

/* DATA FILES */

#define LONGFILE	"ADV1.DAT"
#define MSGFILE		"ADV2.DAT"
#define OBJFILE		"ADV3.DAT"
#define SHORTFILE	"ADV4.DAT"
#define VOCABFILE	"ADV5.DAT"

/* VARIOUS CONSTANTS */

#define MAXVALS		11	/* max number of values an object can have */
#define MAXMESSAGES	500	/* number of messages */
#define MAXPLACES	310	/* number of locations */
#define MAXVOCAB	450	/* size of vocabulary */

#define WORDLEN		16	/* max size of vocabulary word */
#define STRINGLEN	85	/* max size of char string */

#define MAXDEMO		50	/* length of demo game */
#define MAXGAME		1000	/* length of normal game */
#define DETAIL		3	/* long descriptions said every so often */
#define MAXDIE		3	/* max # of reincarnations allowed */
#define MAXRETORT	10	/* max # of different retorts to obscenities */
#define HINTCOST	5	/* cost of a hint */

/* DATA STRUCTURES */

typedef char string [STRINGLEN];
typedef char parray [MAXPLACES];
typedef int  oarray [MAXOBJECTS];

typedef struct
	{
	  int	meaning;
	  char	word [WORDLEN];
	}
	v_struct;	/* vocabulary entry */

typedef struct ts
	{
	  char		*line;
	  struct ts	*next;
	}
	t_struct;	/* text entry */

typedef struct os
	{
	  char		*invdesc;		/* inventory description */
	  t_struct	vdesc [MAXVALS];	/* view descriptions */
	}
	o_struct;
