/*
 *      ADVMAC.C - "Macros" for Collosal Cave Adventure
 *      (C) 1986 Ravi Bhavnani
 *      All rights reserved
 *
 *      THE UTILITY FUNCTIONS IN THIS FILE WERE ORIGINALLY DEFINED AS
 *      MACROS IN advdef.h.  THEY HAVE BEEN CONVERTED TO FUNCTIONS DUE
 *      TO AN INTERNAL STACK OVERFLOW IN Microsoft C 3.0's PARSER.  THE
 *      COMPILATION WAS DONE ON A 512k 8Mhz IBM-AT RUNNING DOS 3.2, WITH
 *      444k AVAILABLE FOR USE.
 *
 *      isobj()         object word
 *      isutil()        utility verb
 *      isverb()        action verb
 *      isdir()         directional verb
 *      isplace()       place word
 *      ismagic()       magic word
 *
 *      dropit()        drop object at current loc
 *      getit()         pick up object
 *
 *      at()            are we at this loc?
 *      near()          are we near this object?
 *      carrying()      are we carrying this object?
 *      apport(x,y)     send object x to loc y
 *
 *      random(x)       return a random number between 0..(x-1)
 *      chance(x)       return true x% of the time
 */

#include "adv.h"


isobj (x)
int     x;
{
        return (x>=MINOBJECTS && x<=MAXOBJECTS);
}

isutil (x)
int     x;
{
        return (x>=MINUTIL && x<=MAXUTIL);
}

isverb (x)
int     x;
{
        return (x>=MINACTION && x<=MAXACTION);
}

isdir (x)
int     x;
{
        return (x>=MINDIR && x<=MAXDIR);
}

isplace (x)
int     x;
{
        return (x>=MINPLACE && x<=MAXPLACE);
}

ismagic (x)
int     x;
{
        return (x>=MINMAGIC && x<=MAXMAGIC);
}

dropit (x)
int     x;
{
        where_is [x] = here;
}

getit (x)
int     x;
{
        where_is [x] = inhand;
}

at (x)
int     x;
{
        return (here == x);
}

near (x)
int     x;
{
int     derf;

        derf = where_is [x];
        return (derf==inhand || derf==here);
}

carrying (x)
int     x;
{
        return (where_is [x] == inhand);
}

apport (x, y)
int     x, y;
{
        where_is [x] = y;
}

random (x)
/*
 *      RETURNS A RANDOM # IN THE RANGE 0..x-1.  NOTE, x IS ASSUMED
 *      TO BE < 1000.
 */
int     x;
{
static
struct timeb
        {
          long  time;
          unsigned short millitm;
          short   timezone;
          short   dstflag;
        }
        tbuff;

        ftime (&tbuff);
	if (x > 0)
           return ((tbuff.millitm / 10) % x);
	else
	   return (0);
}


chance (x)
int     x;
{
        return (random(100) < x);
}

