#version 330 core
out vec4      fs_color;
uniform vec2  resolution;
uniform float time;
uniform vec2  center;
uniform float width;
uniform float height;

void main() {
	vec2 scaled_center = center / 2.0;
	float scaled_width = width / 2.0;
	float scaled_height = height / 2.0;
	
    vec2 uv = gl_FragCoord.xy / resolution;

    vec2 xaxis = vec2(1.0, 0.0);
    vec2 yaxis = vec2(0.0, 1.0);

	float diff = length(uv - center);
    float sinv = (2.0 + sin(time)) / 4.0;
	float alpha = diff * sinv;

    //vec3 color = vec3(center.x, 1.0, 0.0);
    //vec3 color = vec3(width, height, .63);
    vec3 color = vec3(.31, .2, .63);
	fs_color = vec4(color, diff * sinv * 1.5);
	
    // Normalized pixel coordinates (from 0 to 1)
    /* float dx = dot(uv, xaxis); */
    /* float dy = dot(uv, yaxis); */

    /* vec3 color = vec3(.31, .2, .63); */
	/* color = vec3(center.x, width, height); */
    
    /* float bx = 1.0 - (2.0 * dx - 1.0) * (2.0 * dx - 1.0); */
    /* float by = 1.0 - (2.0 * dy - 1.0) * (2.0 * dy - 1.0); */
    /* float sv = (2.0 + sin(time)) / 4.0; */
    /* float blend = (2.5 * sv * bx * by); */
    
    /* // Output to screen */
    /* fs_color = vec4(color, 1.0 - blend); */
}
