-- take.i
-- Library version 0.1
-- version for skipbrek with
--      get defined as separate verb from take
--      'take all' disabled

DEFAULT ATTRIBUTES
    InAnimate.

OBJECT ATTRIBUTES
    takeable.

ACTOR ATTRIBUTES
    NOT InAnimate.


SYNONYMS
    carry, obtain, grab, steal, confiscate, hold = take.


SYNTAX
    take = take (obj) --*   (ie: disabled "take all")
    WHERE obj ISA OBJECT
	    ELSE "You can't take that with you!"

    get  = get  (obj) --*
    WHERE obj ISA OBJECT
	    ELSE "You can't take that with you!"

    pick_up1 = pick up (obj)--*
    WHERE obj ISA OBJECT
	    ELSE "You can't take that with you!"

    pick_up2 = pick (obj) up --* up
    WHERE obj ISA OBJECT
	    ELSE "You can't take that with you!"


VERB get, take, pick_up1, pick_up2
    CHECK hero IS NOT tied
        ELSE "You're tied so tightly to a tree that you can hardly
              breathe let alone take hold of something."
    AND (hero IS NOT on_stones OR obj = rope)
        ELSE "You'll have to get off the stones first."
    AND (hero IS NOT on_tree OR obj = rope)
        ELSE "You'll have to climb down the tree first."
    AND obj IS takeable
        ELSE "You can't take that!"
    AND obj NOT IN inventory
        ELSE "You've already got that." 
    DOES
        LOCATE obj IN inventory.
        "Taken."
END VERB.



SYNONYMS
    discard = drop.

SYNTAX
    drop = drop (obj) *
    WHERE obj ISA OBJECT OR ACTOR
	    ELSE "You can't put that anywhere."

SYNTAX
    put_down1 = put (obj) * down
    WHERE obj ISA OBJECT OR ACTOR
	    ELSE "You can't put that anywhere."

SYNTAX
    put_down2 = put down (obj) * 
    WHERE obj ISA OBJECT OR ACTOR
	    ELSE "You can't put that anywhere."


VERB drop, put_down1, put_down2
    CHECK obj IN inventory
        ELSE "You haven't got that."
    DOES
        LOCATE obj HERE.
        "Dropped."
END VERB.



SYNTAX
  take_from = 'take' (obj) 'from' (holder)
        WHERE obj ISA OBJECT
           ELSE "You can only take objects."
        AND holder ISA CONTAINER ACTOR OR CONTAINER OBJECT
           ELSE "You can't take things from that!"

VERB take_from
    CHECK obj NOT IN Inventory
        ELSE "You already have the $1"
    DOES
        IF holder=hero THEN
            "You can't take things from yourself!"
        ELSIF holder IS InAnimate THEN
            "You take the"
            SAY obj.
            LOCATE obj IN Inventory.
        ELSE    
            SAY holder.
            "won't let you take the"
            SAY obj.
        END IF.
END VERB.

