/*
 * Decompiled with CFR 0.152.
 */
package Modules.Consumers;

import Adventure.DataStore.DataStoreXMLRegistry;
import Modules.Consumers.AbstractConsumer;
import Modules.Consumers.IConsumer;
import Modules.Consumers.IConsumerFactory;
import Modules.Queues.IQueue;
import Modules.streamOut.IEscribirSalida;

public class ConsumerFactory
implements IConsumerFactory {
    protected IEscribirSalida salida;
    protected DataStoreXMLRegistry registry;
    protected IQueue messages;
    protected String packageName = "Modules.Consumers.";

    public ConsumerFactory(IEscribirSalida salida, DataStoreXMLRegistry registry, IQueue messages) {
        this.salida = salida;
        this.registry = registry;
        this.messages = messages;
    }

    public void setPackage(String packageName) {
        this.packageName = packageName + ".";
    }

    public IConsumer createConsumer(String consumerType, String consumerName) throws Exception {
        try {
            AbstractConsumer consumer = (AbstractConsumer)Class.forName(this.packageName + consumerType).newInstance();
            consumer.setName(consumerName);
            consumer.setSalida(this.salida);
            consumer.setRegistry(this.registry);
            consumer.setMessages(this.messages);
            return consumer;
        }
        catch (ClassNotFoundException e) {
            throw new Exception("Clase [" + consumerType + "] no encontrada. \n" + e);
        }
        catch (IllegalAccessException e) {
            throw new Exception("Clase o contructor no accesible. \n" + e);
        }
        catch (InstantiationException e) {
            throw new Exception("Clase no inicializable o error en su instanciaci\u00f3n. \n" + e);
        }
        catch (ExceptionInInitializerError e) {
            throw new Exception("La inciialziaci\u00f3n de la clase ha provocado un error. \n" + e);
        }
        catch (SecurityException e) {
            throw new Exception("Error de seguridad. No hay permisos para crear una nueva clase. \n" + e);
        }
    }

    public IConsumer createConsumer(String consumerType) throws Exception {
        return this.createConsumer(consumerType, consumerType);
    }
}

