/*
 * Decompiled with CFR 0.152.
 */
package eu.irreality.age.swing.sdi;

import eu.irreality.age.AGESoundClient;
import eu.irreality.age.ColoredSwingClient;
import eu.irreality.age.CommonClientUtilities;
import eu.irreality.age.FiltroFicheroEstado;
import eu.irreality.age.FiltroFicheroLog;
import eu.irreality.age.FiltroFicheroMundo;
import eu.irreality.age.GameEngineThread;
import eu.irreality.age.InputOutputClient;
import eu.irreality.age.ObjectCode;
import eu.irreality.age.SwingAetheriaGameLoaderInterface;
import eu.irreality.age.SwingMenuAetheria;
import eu.irreality.age.World;
import eu.irreality.age.debug.Debug;
import eu.irreality.age.filemanagement.Paths;
import eu.irreality.age.filemanagement.WorldLoader;
import eu.irreality.age.swing.config.AGEConfiguration;
import eu.irreality.age.swing.sdi.LoadFromLogListener;
import eu.irreality.age.swing.sdi.LoadFromStateListener;
import eu.irreality.age.swing.sdi.NewFromFileListener;
import eu.irreality.age.util.VersionComparator;
import eu.irreality.age.windowing.AGEClientWindow;
import eu.irreality.age.windowing.UpdatingRun;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.DisplayMode;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.util.Vector;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;

public class SwingSDIInterface
extends JFrame
implements AGEClientWindow {
    private World mundo;
    private boolean fullScreenMode;
    private InputOutputClient io;
    private JPanel mainPanel;
    private Vector gameLog;
    private Thread loaderThread = null;
    private GameEngineThread maquinaEstados;
    private String moduledir;
    private boolean usarLog;
    private String logFile;
    private String stateFile;
    private Object mundoSemaphore = new Object();
    private boolean standalone = false;
    protected Runnable updateCode = new UpdatingRun(this);

    public void setMainPanel(JPanel panel) {
        if (this.mainPanel != null) {
            this.getContentPane().remove(this.mainPanel);
        }
        this.mainPanel = panel;
        this.getContentPane().add(panel);
    }

    public void write(String s) {
        this.io.write(s);
    }

    public static String getVersion() {
        return "Swing-based simplified SDI client, v1.0";
    }

    private void stopGameSaveAndUnlink() {
        if (this.maquinaEstados != null) {
            this.maquinaEstados.exitNow();
        } else {
            this.saveAndFreeResources();
        }
    }

    public void saveWindowCoordinates() {
        try {
            if ((this.getExtendedState() & 6) != 6) {
                AGEConfiguration.getInstance().setProperty("sdiWindowWidth", String.valueOf(this.getWidth()));
                AGEConfiguration.getInstance().setProperty("sdiWindowHeight", String.valueOf(this.getHeight()));
                AGEConfiguration.getInstance().setProperty("sdiWindowMaximized", "false");
                AGEConfiguration.getInstance().setProperty("sdiWindowLocationX", String.valueOf(this.getX()));
                AGEConfiguration.getInstance().setProperty("sdiWindowLocationY", String.valueOf(this.getY()));
            } else {
                AGEConfiguration.getInstance().setProperty("sdiWindowMaximized", "true");
            }
            AGEConfiguration.getInstance().storeProperties();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public void exitNow() {
        this.saveWindowCoordinates();
        this.stopGameSaveAndUnlink();
        this.dispose();
    }

    public void setStandalone(boolean standalone) {
        this.standalone = standalone;
    }

    public void saveAndFreeResources() {
        this.io.write("Guardando la partida...\n");
        try {
            CommonClientUtilities.guardarLog(new File("autosave.alf"), this.gameLog);
        }
        catch (Exception exc) {
            this.io.write("\u00a1No se ha podido guardar la partida!\n");
        }
        this.io.write("\u00a1Hasta la pr\u00f3xima!\n");
        if (this.getClient() instanceof ColoredSwingClient) {
            ((ColoredSwingClient)this.getClient()).uninitClientMenu(this);
            ((ColoredSwingClient)this.getClient()).exit();
        }
        if (this.maquinaEstados != null) {
            this.maquinaEstados.uninitServerMenu(this);
        }
        this.maquinaEstados = null;
        Runtime.getRuntime().gc();
    }

    public JPanel getMainPanel() {
        return this.mainPanel;
    }

    public void unlinkWorld() {
        this.mundo = null;
    }

    public InputOutputClient getClient() {
        return this.io;
    }

    public World getMundo() {
        return this.mundo;
    }

    public JMenuBar getTheJMenuBar() {
        return this.getJMenuBar();
    }

    public boolean isFullScreenMode() {
        return this.fullScreenMode;
    }

    public void setFullScreenMode(boolean onOrOff) {
        if (onOrOff) {
            System.out.println("Setting full-screen dedicated mode ON");
            if (this.fullScreenMode) {
                return;
            }
            this.fullScreenMode = true;
            GraphicsEnvironment env = GraphicsEnvironment.getLocalGraphicsEnvironment();
            GraphicsDevice[] devices = env.getScreenDevices();
            this.dispose();
            this.setUndecorated(true);
            this.setResizable(false);
            devices[0].setFullScreenWindow(this);
            DisplayMode dm = devices[0].getDisplayMode();
            this.setSize(new Dimension(dm.getWidth(), dm.getHeight()));
            this.validate();
            this.paintAll(this.getGraphics());
            this.requestFocus();
            UpdatingRun updateCode = new UpdatingRun(this);
            Thread c = new Thread(updateCode);
            c.setPriority(10);
            c.start();
            this.setVisible(true);
            this.requestFocus();
            if (this.io instanceof ColoredSwingClient) {
                ((ColoredSwingClient)this.io).refreshFocus();
            }
        } else {
            System.out.println("Setting full-screen dedicated mode OFF");
            if (!this.fullScreenMode) {
                return;
            }
            this.fullScreenMode = false;
            this.dispose();
            this.setUndecorated(false);
            this.setResizable(true);
            GraphicsEnvironment env = GraphicsEnvironment.getLocalGraphicsEnvironment();
            GraphicsDevice[] devices = env.getScreenDevices();
            devices[0].setFullScreenWindow(null);
            DisplayMode dm = devices[0].getDisplayMode();
            this.setVisible(true);
        }
    }

    public void setTheJMenuBar(JMenuBar jmb) {
        this.setJMenuBar(jmb);
    }

    private void maximizeIfPossible() {
        int state = this.getExtendedState();
        this.setExtendedState(state |= 6);
    }

    public SwingSDIInterface(String title) {
        super(title);
        this.setSize(AGEConfiguration.getInstance().getIntegerProperty("sdiWindowWidth"), AGEConfiguration.getInstance().getIntegerProperty("sdiWindowHeight"));
        this.setLocation(AGEConfiguration.getInstance().getIntegerProperty("sdiWindowLocationX"), AGEConfiguration.getInstance().getIntegerProperty("sdiWindowLocationY"));
        if (AGEConfiguration.getInstance().getBooleanProperty("sdiWindowMaximized")) {
            this.maximizeIfPossible();
        }
        try {
            Image iconito = this.getToolkit().getImage(this.getClass().getClassLoader().getResource("images/intficon.gif"));
            this.setIconImage(iconito);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        new SwingMenuAetheria(this).addToWindow();
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.out.println("Frame closed.");
                SwingSDIInterface.this.exitNow();
            }
        });
        JMenu menuArchivo = this.getTheJMenuBar().getMenu(0);
        JMenuItem itemNuevo = new JMenuItem("Nuevo juego...");
        menuArchivo.add((Component)itemNuevo, 0);
        itemNuevo.addActionListener(new NewFromFileListener(this));
        JMenuItem itemLoadLog = new JMenuItem("Cargar partida...");
        menuArchivo.add((Component)itemLoadLog, 1);
        itemLoadLog.addActionListener(new LoadFromLogListener(this));
        JMenuItem itemLoadState = new JMenuItem("Cargar estado...");
        menuArchivo.add((Component)itemLoadState, 2);
        itemLoadState.addActionListener(new LoadFromStateListener(this));
        menuArchivo.add((Component)new JSeparator(), 3);
    }

    public void startGame(String moduledir, boolean usarLog, String logFile, String stateFile) {
        if (this.loaderThread != null) {
            this.stopGameSaveAndUnlink();
        }
        this.moduledir = moduledir;
        this.usarLog = usarLog;
        this.logFile = logFile;
        this.stateFile = stateFile;
        System.out.println("B");
        Thread.currentThread().setPriority(10);
        if (moduledir.equalsIgnoreCase("")) {
            this.setTitle("Aetheria Game Engine. M\u00f3dulo: aetherworld");
        } else {
            this.setTitle("Aetheria Game Engine. M\u00f3dulo: " + moduledir);
        }
        this.setVisible(true);
        this.loaderThread = new LoaderThread();
        this.loaderThread.start();
    }

    public SwingSDIInterface(String moduledir, boolean usarLog, String logFile, String stateFile) {
        this(moduledir);
        this.startGame(moduledir, usarLog, logFile, stateFile);
    }

    public void reinit() {
        if (this.loaderThread != null) {
            this.maquinaEstados.exitNow();
            Thread thr = new Thread(){

                public void run() {
                    SwingSDIInterface.this.loaderThread = new LoaderThread();
                    SwingSDIInterface.this.loaderThread.start();
                    try {
                        SwingSDIInterface.this.loaderThread.join();
                    }
                    catch (InterruptedException ie) {
                        ie.printStackTrace();
                    }
                }
            };
            thr.start();
        }
    }

    public void updateNow() {
        Thread c = new Thread(this.updateCode);
        c.setPriority(10);
        c.start();
    }

    public void guardarLog() {
        File elFichero = null;
        JFileChooser selectorFichero = new JFileChooser(Paths.SAVE_PATH);
        selectorFichero.setFileSelectionMode(0);
        FiltroFicheroLog filtro = new FiltroFicheroLog();
        selectorFichero.setFileFilter(filtro);
        int returnVal = selectorFichero.showSaveDialog(this);
        if (returnVal == 0) {
            elFichero = selectorFichero.getSelectedFile();
            try {
                if (!elFichero.toString().toLowerCase().endsWith(".alf")) {
                    elFichero = new File(elFichero.toString() + ".alf");
                }
                CommonClientUtilities.guardarLog(elFichero, this.gameLog);
            }
            catch (Exception exc) {
                this.write("No se ha podido guardar la partida...");
                this.write(exc.toString());
            }
        }
    }

    public void guardarEstado() {
        File elFichero = null;
        JFileChooser selectorFichero = new JFileChooser(Paths.SAVE_PATH);
        selectorFichero.setFileSelectionMode(0);
        FiltroFicheroEstado filtro = new FiltroFicheroEstado();
        selectorFichero.setFileFilter(filtro);
        int returnVal = selectorFichero.showSaveDialog(this);
        if (returnVal == 0) {
            elFichero = selectorFichero.getSelectedFile();
            try {
                if (!elFichero.toString().toLowerCase().endsWith(".asf")) {
                    elFichero = new File(elFichero.toString() + ".asf");
                }
                CommonClientUtilities.guardarEstado(elFichero, this.mundo);
            }
            catch (Exception exc) {
                this.write("No se ha podido guardar la partida...");
                this.write(exc.toString());
            }
        }
    }

    public static void main(String[] args) {
        SwingAetheriaGameLoaderInterface.loadFont();
        JFileChooser selector = new JFileChooser("worlds");
        selector.setFileSelectionMode(2);
        selector.setDialogTitle("Selecciona el directorio del juego o el fichero world.dat");
        selector.setFileFilter(new FiltroFicheroMundo());
        int returnVal = selector.showOpenDialog(null);
        if (returnVal == 0) {
            System.out.println("Nombre: " + selector.getSelectedFile().getAbsolutePath());
            new SwingSDIInterface(selector.getSelectedFile().getAbsolutePath(), false, null, null);
        }
    }

    public boolean supportsFullScreen() {
        return true;
    }

    public void cover() {
        JPanel glass = new JPanel();
        glass.setBackground(Color.WHITE);
        glass.setOpaque(true);
        this.setGlassPane(glass);
        glass.setVisible(true);
    }

    public void uncover() {
        JPanel glass = (JPanel)this.getGlassPane();
        glass.setVisible(false);
    }

    class LoaderThread
    extends Thread {
        LoaderThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            SwingSDIInterface.this.gameLog = new Vector();
            Debug.println("1");
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        SwingSDIInterface.this.getContentPane().removeAll();
                        SwingSDIInterface.this.mainPanel = new JPanel();
                        SwingSDIInterface.this.setMainPanel(SwingSDIInterface.this.mainPanel);
                        SwingSDIInterface.this.io = new ColoredSwingClient(SwingSDIInterface.this, SwingSDIInterface.this.gameLog);
                        if (SwingSDIInterface.this.logFile != null) {
                            ((ColoredSwingClient)SwingSDIInterface.this.io).hideForLogLoad();
                            if (((ColoredSwingClient)SwingSDIInterface.this.io).getSoundClient() instanceof AGESoundClient) {
                                AGESoundClient asc = (AGESoundClient)((ColoredSwingClient)SwingSDIInterface.this.io).getSoundClient();
                                asc.deactivate();
                            }
                        }
                        SwingSDIInterface.this.write("Aetheria Game Engine v 1.0\n");
                        SwingSDIInterface.this.write("\u00a9 1999-2011 Carlos G\u00f3mez (solrac888@yahoo.com)\n");
                        SwingSDIInterface.this.write("V\u00e9ase license.txt para consultar la licencia de AGE y del software de terceros incluido.\n");
                        SwingSDIInterface.this.write("\n=============================================================");
                        SwingSDIInterface.this.write("\n" + SwingSDIInterface.this.io.getColorCode("information") + "Engine-related Version Info:");
                        SwingSDIInterface.this.write("\n" + SwingSDIInterface.this.io.getColorCode("information") + "[OS Layer]           " + System.getProperty("os.name") + " " + System.getProperty("os.version") + " " + System.getProperty("os.arch") + SwingSDIInterface.this.io.getColorCode("reset"));
                        SwingSDIInterface.this.write("\n" + SwingSDIInterface.this.io.getColorCode("information") + "[Java Layer]         " + System.getProperty("java.version") + SwingSDIInterface.this.io.getColorCode("reset"));
                        SwingSDIInterface.this.write("\n" + SwingSDIInterface.this.io.getColorCode("information") + "[Simulation Layer]   " + GameEngineThread.getVersion() + SwingSDIInterface.this.io.getColorCode("reset"));
                        SwingSDIInterface.this.write("\n" + SwingSDIInterface.this.io.getColorCode("information") + "[Object Code Layer]  " + ObjectCode.getInterpreterVersion() + SwingSDIInterface.this.io.getColorCode("reset"));
                        SwingSDIInterface.this.write("\n" + SwingSDIInterface.this.io.getColorCode("information") + "[UI Layer]           " + SwingSDIInterface.getVersion() + SwingSDIInterface.this.io.getColorCode("reset"));
                        SwingSDIInterface.this.write("\n=============================================================\n");
                    }
                });
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            System.out.println("2");
            World theWorld = null;
            if (SwingSDIInterface.this.moduledir == null || SwingSDIInterface.this.moduledir.length() == 0) {
                SwingSDIInterface.this.moduledir = "aetherworld";
            }
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        SwingSDIInterface.this.repaint();
                        SwingSDIInterface.this.updateNow();
                    }
                });
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            System.out.println("3");
            try {
                theWorld = WorldLoader.loadWorld(SwingSDIInterface.this.moduledir, SwingSDIInterface.this.gameLog, SwingSDIInterface.this.io, SwingSDIInterface.this.mundoSemaphore);
            }
            catch (Exception e) {
                SwingSDIInterface.this.write("Exception on loading world: " + e);
            }
            if (theWorld == null) {
                return;
            }
            SwingSDIInterface.this.mundo = theWorld;
            final World theFinalWorld = theWorld;
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        SwingSDIInterface.this.updateNow();
                        if (theFinalWorld.getModuleName() != null && theFinalWorld.getModuleName().length() > 0) {
                            SwingSDIInterface.this.setTitle(theFinalWorld.getModuleName());
                        }
                    }
                });
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (new VersionComparator().compare(GameEngineThread.getVersionNumber(), theWorld.getRequiredAGEVersion()) < 0) {
                String mess = "Est\u00e1s usando la versi\u00f3n " + GameEngineThread.getVersionNumber() + " de AGE; pero el mundo " + theWorld.getModuleName() + " requiere la versi\u00f3n " + theWorld.getRequiredAGEVersion() + " como m\u00ednimo. Podr\u00eda no funcionar " + " si no te bajas una nueva versi\u00f3n de AGE en http://code.google.com/p/aetheria";
                JOptionPane.showMessageDialog(SwingSDIInterface.this, mess, "Aviso", 2);
            }
            if (SwingSDIInterface.this.stateFile != null) {
                try {
                    theWorld.loadState(SwingSDIInterface.this.stateFile);
                }
                catch (Exception exc) {
                    SwingSDIInterface.this.write("\u00a1No se ha podido cargar el estado!\n");
                    SwingSDIInterface.this.write(exc.toString());
                    exc.printStackTrace();
                }
            }
            if (SwingSDIInterface.this.usarLog) {
                try {
                    theWorld.prepareLog(SwingSDIInterface.this.logFile);
                    theWorld.setRandomNumberSeed(SwingSDIInterface.this.logFile);
                }
                catch (Exception exc) {
                    SwingSDIInterface.this.write("Excepci\u00f3n al leer el fichero de log: " + exc + "\n");
                    exc.printStackTrace();
                    return;
                }
            } else {
                theWorld.setRandomNumberSeed();
            }
            SwingSDIInterface.this.gameLog.addElement(String.valueOf(theWorld.getRandomNumberSeed()));
            SwingSDIInterface.this.setVisible(true);
            SwingSDIInterface.this.mundo = theWorld;
            Object exc = SwingSDIInterface.this.mundoSemaphore;
            synchronized (exc) {
                SwingSDIInterface.this.mundoSemaphore.notifyAll();
            }
            SwingSDIInterface.this.maquinaEstados = new GameEngineThread(theWorld, SwingSDIInterface.this, false);
            System.out.println("STARTING ENGINE THREAD");
            SwingSDIInterface.this.maquinaEstados.start();
            System.out.println("ENGINE THREAD STARTED");
            System.out.println("noSerCliente = false");
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        SwingSDIInterface.this.repaint();
                        SwingSDIInterface.this.updateNow();
                    }
                });
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (SwingSDIInterface.this.io instanceof ColoredSwingClient) {
                ((ColoredSwingClient)SwingSDIInterface.this.io).refreshFocus();
            }
        }
    }
}

