/*
 * Decompiled with CFR 0.152.
 */
package eu.irreality.age;

import eu.irreality.age.StringMethods;
import eu.irreality.age.Utility;
import eu.irreality.age.spell.Correction;
import eu.irreality.age.spell.SimpleReverseCorrector;
import eu.irreality.age.spell.SpellingCorrector;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.StringTokenizer;

public class NaturalLanguage {
    public static String pathVerbos = "lang/verbos.lan";
    public static String pathSinonimos = "lang/sinon.lan";
    public static String pathAlias = "lang/alias.lan";
    public static String pathVerbos32 = "lang/verbos32.lan";
    private Hashtable imperativoAInfinitivo;
    private Hashtable infinitivoAImperativo;
    private Hashtable sinonimos;
    private Hashtable alias;
    private Hashtable terceraASegunda;
    private SpellingCorrector corrector;
    private Set guessable = new LinkedHashSet();
    private Set unguessable = new LinkedHashSet();
    private boolean defaultGuessPolicy = true;

    public void setUnguessable(String verb) {
        this.unguessable.add(verb);
        this.guessable.remove(verb);
    }

    public void setGuessable(String verb) {
        this.unguessable.remove(verb);
        this.guessable.add(verb);
    }

    public void setAllGuessable() {
        this.unguessable.clear();
        this.guessable.clear();
        this.defaultGuessPolicy = true;
    }

    public void setAllUnguessable() {
        this.unguessable.clear();
        this.guessable.clear();
        this.defaultGuessPolicy = false;
    }

    public boolean isGuessable(String verb) {
        if (this.defaultGuessPolicy) {
            return !this.unguessable.contains(verb);
        }
        return this.guessable.contains(verb);
    }

    private Hashtable loadTableFromPath(String f, char separator) throws IOException, FileNotFoundException {
        return this.loadTableFromPath(f, separator, true);
    }

    private Hashtable loadInvertedTableFromPath(String f, char separator) throws IOException, FileNotFoundException {
        return this.loadInvertedTableFromPath(f, separator, true);
    }

    private Hashtable loadTableFromPath(String f, char separator, boolean dejarRepeticiones) throws IOException, FileNotFoundException {
        String linea;
        BufferedReader filein = new BufferedReader(Utility.getBestInputStreamReader(this.getClass().getClassLoader().getResourceAsStream(f)));
        int nlineas = 0;
        while (filein.readLine() != null) {
            ++nlineas;
        }
        Hashtable<String, String> tabla = new Hashtable<String, String>((int)Math.round((double)nlineas * 1.5));
        filein = new BufferedReader(Utility.getBestInputStreamReader(this.getClass().getClassLoader().getResourceAsStream(f)));
        while ((linea = filein.readLine()) != null) {
            String laClave = StringMethods.getTok(linea, 1, separator).trim();
            String elValor = StringMethods.getTok(linea, 2, separator).trim();
            if (dejarRepeticiones && tabla.get(laClave) != null) continue;
            tabla.put(laClave, elValor);
        }
        return tabla;
    }

    private Hashtable loadInvertedTableFromPath(String f, char separator, boolean dejarRepeticiones) throws IOException, FileNotFoundException {
        String linea;
        BufferedReader filein = new BufferedReader(Utility.getBestInputStreamReader(this.getClass().getClassLoader().getResourceAsStream(f)));
        int nlineas = 0;
        while (filein.readLine() != null) {
            ++nlineas;
        }
        Hashtable<String, String> tabla = new Hashtable<String, String>((int)Math.round((double)nlineas * 1.5));
        filein = new BufferedReader(Utility.getBestInputStreamReader(this.getClass().getClassLoader().getResourceAsStream(f)));
        while ((linea = filein.readLine()) != null) {
            String laClave = StringMethods.getTok(linea, 2, separator).trim();
            String elValor = StringMethods.getTok(linea, 1, separator).trim();
            if (dejarRepeticiones && tabla.get(laClave) != null) continue;
            tabla.put(laClave, elValor);
        }
        return tabla;
    }

    public NaturalLanguage() {
        try {
            this.imperativoAInfinitivo = this.loadTableFromPath(pathVerbos, '=');
            this.infinitivoAImperativo = this.loadInvertedTableFromPath(pathVerbos, '=', false);
        }
        catch (Exception exc) {
            System.err.println("Aviso: no se ha encontrado fichero de verbos, la tabla de verbos estar\u00e1 vac\u00eda.");
            exc.printStackTrace();
            this.imperativoAInfinitivo = new Hashtable(1);
        }
        try {
            this.sinonimos = this.loadTableFromPath(pathSinonimos, '=');
        }
        catch (Exception exc) {
            System.err.println("Aviso: no se ha encontrado fichero de sin\u00f3nimos, la tabla de sin\u00f3nimos estar\u00e1 vac\u00eda.");
            this.sinonimos = new Hashtable(1);
        }
        try {
            this.alias = this.loadTableFromPath(pathAlias, '=');
        }
        catch (Exception exc) {
            System.err.println("Aviso: no se ha encontrado fichero de alias, la tabla de alias estar\u00e1 vac\u00eda.");
            this.alias = new Hashtable(1);
        }
        try {
            this.terceraASegunda = this.loadTableFromPath(pathVerbos32, ' ');
        }
        catch (Exception exc) {
            System.err.println("Aviso: no se ha encontrado fichero de conjugaci\u00f3n en 2\u00aa persona, la tabla estar\u00e1 vac\u00eda.");
            this.terceraASegunda = new Hashtable(1);
        }
    }

    public String imperativoAInfinitivo(String presente) {
        return this.toInfinitive(presente);
    }

    public String toInfinitive(String presente) {
        return (String)this.imperativoAInfinitivo.get(presente.toLowerCase());
    }

    public String obtenerSinonimo(String palabra) {
        return (String)this.sinonimos.get(palabra.toLowerCase());
    }

    public String obtenerAlias(String palabra) {
        return this.getAlias(palabra);
    }

    public String getAlias(String palabra) {
        return (String)this.alias.get(palabra.toLowerCase());
    }

    public String sustituirSinonimos(String s) {
        StringTokenizer st = new StringTokenizer(s, " ", true);
        String nueva = "";
        while (st.hasMoreTokens()) {
            String tok = st.nextToken();
            String sin = this.obtenerSinonimo(tok);
            if (sin == null) {
                nueva = nueva + tok;
                continue;
            }
            nueva = nueva + sin;
        }
        return nueva;
    }

    public String sustituirVerbos(String s) {
        StringTokenizer st = new StringTokenizer(s, " ", true);
        String nueva = "";
        while (st.hasMoreTokens()) {
            String tok = st.nextToken();
            String sin = this.toInfinitive(tok);
            if (sin == null) {
                nueva = nueva + tok;
                continue;
            }
            nueva = nueva + sin;
        }
        return nueva;
    }

    public String sustituirVerbo(String s) {
        StringTokenizer st = new StringTokenizer(s, " ", true);
        String nueva = "";
        int tokcnt = 0;
        while (st.hasMoreTokens()) {
            String tok = st.nextToken();
            String sin = this.toInfinitive(tok);
            nueva = sin == null || tokcnt > 0 ? nueva + tok : nueva + sin;
            ++tokcnt;
        }
        return nueva;
    }

    public boolean esVerboComando(String s) {
        return this.isVerb(s);
    }

    public boolean isVerb(String s) {
        return this.infinitivoAImperativo.get(s.toLowerCase().trim()) != null || this.imperativoAInfinitivo.get(s.toLowerCase().trim()) != null;
    }

    public void addVerbEntry(String imperative, String infinitive) {
        this.imperativoAInfinitivo.put(imperative, infinitive);
        this.infinitivoAImperativo.put(infinitive, imperative);
    }

    public void removeVerbEntry(String imperative, String infinitive) {
        this.imperativoAInfinitivo.remove(imperative);
        this.infinitivoAImperativo.remove(infinitive);
    }

    public void removeVerbEntry(String infinitive) {
        String imper = (String)this.infinitivoAImperativo.get(infinitive);
        this.infinitivoAImperativo.remove(infinitive);
        if (imper != null) {
            this.imperativoAInfinitivo.remove(imper);
        }
    }

    public Set getVerbForms() {
        return this.imperativoAInfinitivo.keySet();
    }

    public void addAlias(String source, String target) {
        this.alias.put(source, target);
    }

    public void removeAlias(String source, String target) {
        if (this.alias.get(source).equals(target)) {
            this.removeAlias(source);
        }
    }

    public void removeAlias(String source) {
        this.alias.remove(source);
    }

    public boolean isVerb(String s, boolean includeLe) {
        if (!includeLe) {
            return this.isVerb(s);
        }
        if (this.isVerb(s)) {
            return true;
        }
        if (s.endsWith("le")) {
            String verbForm = s.substring(0, s.length() - 2);
            return this.isVerb(verbForm);
        }
        if (s.endsWith("les")) {
            String verbForm = s.substring(0, s.length() - 3);
            return this.isVerb(verbForm);
        }
        return false;
    }

    public String sustituirAlias(String s) {
        StringTokenizer st = new StringTokenizer(s, " ", true);
        String nueva = "";
        while (st.hasMoreTokens()) {
            String tok = st.nextToken();
            String sin = this.getAlias(tok);
            if (sin == null) {
                nueva = nueva + tok;
                continue;
            }
            nueva = nueva + sin;
        }
        return nueva;
    }

    public String terceraASegunda(String verbo) {
        return (String)this.terceraASegunda.get(verbo.toLowerCase());
    }

    public String gramaticalizar(String s) {
        if (s == null) {
            return null;
        }
        String temp = StringMethods.textualSubstitution(StringMethods.textualSubstitution(s, " a el", " al"), " de el", " del");
        if ((temp = temp.trim()).length() > 0) {
            temp = Character.toUpperCase(temp.charAt(0)) + temp.substring(1);
        }
        if (temp.length() > 0 && temp.charAt(temp.length() - 1) != '.') {
            temp = temp + ".";
        }
        return temp;
    }

    public String gramaticalizarSinTrimear(String s) {
        if (s == null) {
            return null;
        }
        String temp = StringMethods.textualSubstitution(StringMethods.textualSubstitution(s, " a el", " al"), " de el", " del");
        if (temp.length() > 0) {
            temp = Character.toUpperCase(temp.charAt(0)) + temp.substring(1);
        }
        if (temp.length() > 0 && temp.charAt(temp.length() - 1) != '\n' && temp.charAt(temp.length() - 1) != '.') {
            temp = temp + ".";
        }
        return temp;
    }

    public String removeAccents(String s) {
        s = s.replaceAll("[\u00e8\u00e9\u00ea\u00eb]", "e");
        s = s.replaceAll("[\u00fb\u00f9\u00fa\u00fc]", "u");
        s = s.replaceAll("[\u00ef\u00ee\u00ed]", "i");
        s = s.replaceAll("[\u00e0\u00e2\u00e1]", "a");
        s = s.replaceAll("[\u00f3\u00f2\u00f4]", "o");
        s = s.replaceAll("[\u00c8\u00c9\u00ca\u00cb]", "E");
        s = s.replaceAll("[\u00db\u00d9\u00da\u00dc]", "U");
        s = s.replaceAll("[\u00cf\u00ce\u00cd]", "I");
        s = s.replaceAll("[\u00c0\u00c2\u00c1]", "A");
        s = s.replaceAll("[\u00d3\u00d2]", "O");
        return s;
    }

    public void initVerbSpellingCorrector() {
        String nextWord;
        this.corrector = new SimpleReverseCorrector();
        Iterator iter = this.infinitivoAImperativo.keySet().iterator();
        while (iter.hasNext()) {
            nextWord = (String)iter.next();
            this.corrector.addDictionaryWord(nextWord);
        }
        iter = this.imperativoAInfinitivo.keySet().iterator();
        while (iter.hasNext()) {
            nextWord = (String)iter.next();
            this.corrector.addDictionaryWord(nextWord);
        }
    }

    private Correction getBestCorrection(String tentativeVerb) {
        if (this.corrector == null) {
            if (this.isVerb(tentativeVerb)) {
                return new Correction(tentativeVerb, 0.0);
            }
            return null;
        }
        return this.corrector.getBestCorrection(tentativeVerb);
    }

    public String correctVerb(String commandString) {
        StringTokenizer st;
        if (this.corrector == null) {
            this.initVerbSpellingCorrector();
        }
        if (!(st = new StringTokenizer(commandString)).hasMoreTokens()) {
            return commandString;
        }
        String verb = st.nextToken();
        Correction c = this.getBestCorrection(verb);
        if (verb.length() > 2 && c != null && c.getWord() != null) {
            verb = c.getWord();
        }
        if (!st.hasMoreTokens()) {
            return verb;
        }
        return verb + " " + st.nextToken("");
    }

    public SpellingCorrector getVerbSpellingCorrector() {
        if (this.corrector == null) {
            this.initVerbSpellingCorrector();
        }
        return this.corrector;
    }
}

