/*
 * Decompiled with CFR 0.152.
 */
package eu.irreality.age;

import eu.irreality.age.StringMethods;
import eu.irreality.age.filemanagement.Paths;
import eu.irreality.age.filemanagement.URLUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Serializable;
import java.text.DateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class GameInfo
implements Serializable {
    private String[] theInfo;
    private String f = null;
    static Vector allInstances = new Vector();

    public boolean equals(Object obj) {
        if (!(obj instanceof GameInfo)) {
            return false;
        }
        return (this.f == null ? ((GameInfo)obj).f == null : this.f.equals(((GameInfo)obj).f)) && (this.theInfo == null ? ((GameInfo)obj).theInfo == null : Arrays.equals(this.theInfo, ((GameInfo)obj).theInfo));
    }

    public static GameInfo getGameInfoFromFile(String f) {
        for (int i = 0; i < allInstances.size(); ++i) {
            if (((GameInfo)allInstances.elementAt(i)).getFile() == null || !((GameInfo)allInstances.elementAt(i)).getFile().equals(f)) continue;
            return (GameInfo)allInstances.elementAt(i);
        }
        try {
            return GameInfo.getGameInfo(f);
        }
        catch (Exception e) {
            return null;
        }
    }

    public GameInfo(String[] info, String f) {
        this.theInfo = info;
        this.f = f;
        allInstances.add(this);
    }

    public GameInfo() {
        this.theInfo = new String[5];
        for (int i = 0; i < 5; ++i) {
            this.theInfo[i] = "";
        }
        allInstances.add(this);
    }

    public String getFile() {
        return this.f;
    }

    public boolean isValid() {
        return this.f != null;
    }

    public String getName() {
        return this.theInfo[0];
    }

    public String getAuthor() {
        return this.theInfo[1];
    }

    public String getDate() {
        return this.theInfo[3];
    }

    public String getVersion() {
        return this.theInfo[2];
    }

    public String getAGEVersion() {
        return this.theInfo[4];
    }

    public String toString() {
        return this.theInfo[0] + " " + this.theInfo[2];
    }

    public String toLongString() {
        return "Nombre: " + this.getName() + "\nAutor: " + this.getAuthor() + "\nFecha: " + this.getDate() + "\nVersi\u00f3n: " + this.getVersion() + "\nVersi\u00f3n AGE requerida: " + this.getAGEVersion() + "\nFichero: " + this.getFile();
    }

    public static GameInfo getGameInfo(String modulefile) throws FileNotFoundException, IOException {
        System.out.println("getGameInfo called on " + modulefile);
        String linea = "";
        String token = "";
        String[] moduleInfo = new String[]{"?", "?", "?", "?", "?"};
        boolean useAlternativeFile = false;
        if (modulefile.toLowerCase().endsWith(".xml") || modulefile.toLowerCase().endsWith(".asf")) {
            File resFile = null;
            if (new File(modulefile).exists()) {
                resFile = new File(new File(modulefile).getAbsolutePath().substring(0, new File(modulefile).getAbsolutePath().length() - 4) + ".res");
            }
            if (resFile != null && resFile.exists()) {
                System.out.println("RES file exists.\n");
                useAlternativeFile = true;
            } else {
                System.out.println("RES file doesn't exist.\n");
                Document d = null;
                try {
                    InputStream str = URLUtils.openFileOrURL(modulefile);
                    DocumentBuilder db = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                    d = db.parse(str);
                }
                catch (FileNotFoundException fnfe) {
                    System.out.println("[Exception: The game from which this savefile comes could have been deleted or moved]");
                    fnfe.printStackTrace();
                    throw fnfe;
                }
                catch (ParserConfigurationException pce) {
                    System.out.println(pce);
                }
                catch (SAXException se) {
                    System.out.println(se);
                }
                catch (IOException ioe) {
                    System.out.println("RES file, nay2.");
                    ioe.printStackTrace();
                    throw ioe;
                }
                Element n = d.getDocumentElement();
                if (n.hasAttribute("moduleName")) {
                    moduleInfo[0] = n.getAttribute("moduleName");
                }
                if (n.hasAttribute("author")) {
                    moduleInfo[1] = n.getAttribute("author");
                }
                if (n.hasAttribute("version")) {
                    moduleInfo[2] = n.getAttribute("version");
                }
                if (n.hasAttribute("date")) {
                    moduleInfo[3] = n.getAttribute("date");
                }
                if (n.hasAttribute("parserVersion")) {
                    moduleInfo[4] = n.getAttribute("parserVersion");
                }
                if (resFile != null) {
                    PrintWriter pw = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(resFile), "UTF-8"));
                    pw.println("comment Fichero resumen de informaci\u00f3n de mundo generado por Aetheria Game Engine el " + DateFormat.getDateTimeInstance().format(new Date()) + " a partir de " + modulefile);
                    pw.println("modulename " + moduleInfo[0]);
                    pw.println("author " + moduleInfo[1]);
                    pw.println("version " + moduleInfo[2]);
                    pw.println("date " + moduleInfo[3]);
                    pw.println("parserversion " + moduleInfo[4]);
                    pw.flush();
                    pw.close();
                    System.out.println("Print Writer closed");
                }
                return new GameInfo(moduleInfo, modulefile);
            }
        }
        FileInputStream fp = null;
        BufferedReader filein = null;
        if (useAlternativeFile) {
            File resFile = new File(new File(modulefile).getAbsolutePath().substring(0, new File(modulefile).getAbsolutePath().length() - 4) + ".res");
            fp = new FileInputStream(resFile);
            filein = new BufferedReader(new InputStreamReader((InputStream)fp, "UTF-8"));
        } else {
            fp = new FileInputStream(modulefile);
            filein = new BufferedReader(new InputStreamReader((InputStream)fp, "UTF-8"));
        }
        while ((linea = filein.readLine()) != null) {
            String id_linea;
            token = StringMethods.getTok(linea, 1, ' ');
            if (token.equalsIgnoreCase("modulename")) {
                moduleInfo[0] = StringMethods.getToks(linea, 2, StringMethods.numToks(linea, ' '), ' ');
                continue;
            }
            if (token.equalsIgnoreCase("author")) {
                moduleInfo[1] = StringMethods.getToks(linea, 2, StringMethods.numToks(linea, ' '), ' ');
                continue;
            }
            if (token.equalsIgnoreCase("version")) {
                moduleInfo[2] = StringMethods.getToks(linea, 2, StringMethods.numToks(linea, ' '), ' ');
                continue;
            }
            if (token.equalsIgnoreCase("date")) {
                moduleInfo[3] = StringMethods.getToks(linea, 2, StringMethods.numToks(linea, ' '), ' ');
                continue;
            }
            if (token.equalsIgnoreCase("parserversion")) {
                moduleInfo[4] = StringMethods.getToks(linea, 2, StringMethods.numToks(linea, ' '), ' ');
                continue;
            }
            if (token.equalsIgnoreCase("begin_eva_code")) {
                boolean terminamos = false;
                while (!terminamos) {
                    linea = filein.readLine();
                    id_linea = StringMethods.getTok(linea, 1, ' ');
                    if (!id_linea.equalsIgnoreCase("end_eva_code")) continue;
                    terminamos = true;
                }
                continue;
            }
            if (!token.equalsIgnoreCase("begin_bsh_code")) continue;
            boolean terminamos = false;
            while (!terminamos) {
                linea = filein.readLine();
                id_linea = StringMethods.getTok(linea, 1, ' ');
                if (!id_linea.equalsIgnoreCase("end_bsh_code")) continue;
                terminamos = true;
            }
        }
        return new GameInfo(moduleInfo, modulefile);
    }

    public static GameInfo[] getListOfGames() {
        System.out.println("getListOfGames() called\n");
        File cwd = new File(Paths.getWorkingDirectory());
        File worldsDirectory = new File(cwd.getAbsolutePath() + File.separatorChar + "worlds");
        if (!worldsDirectory.exists()) {
            if (worldsDirectory.mkdir()) {
                System.out.println("Worlds directory didn't exist, created at worlds");
            } else {
                System.err.println("Could not create worlds directory at worlds");
            }
        }
        File[] worldsSubdirectories = worldsDirectory.listFiles();
        Vector<GameInfo> result = new Vector<GameInfo>();
        for (int i = 0; i < worldsSubdirectories.length; ++i) {
            if (!worldsSubdirectories[i].isDirectory()) continue;
            File[] fl2 = worldsSubdirectories[i].listFiles();
            for (int j = 0; j < fl2.length; ++j) {
                if (!fl2[j].getName().equalsIgnoreCase("world.dat") && !fl2[j].getName().equalsIgnoreCase("world.xml")) continue;
                try {
                    result.addElement(GameInfo.getGameInfo(fl2[j].getAbsolutePath()));
                    continue;
                }
                catch (IOException ioe) {
                    System.out.println(ioe);
                    ioe.printStackTrace();
                }
            }
        }
        Object[] objetos = result.toArray();
        GameInfo[] ficheros = new GameInfo[objetos.length];
        for (int i = 0; i < objetos.length; ++i) {
            ficheros[i] = (GameInfo)objetos[i];
        }
        return ficheros;
    }
}

