/*
 * Decompiled with CFR 0.152.
 */
package eu.irreality.age;

import bsh.TargetError;
import eu.irreality.age.EVASemanticException;
import eu.irreality.age.Player;
import eu.irreality.age.SwingAetheriaGameLoader;
import eu.irreality.age.World;
import eu.irreality.age.debug.Debug;
import eu.irreality.age.debug.ExceptionPrinter;
import eu.irreality.age.swing.applet.SwingSDIApplet;
import eu.irreality.age.swing.sdi.SwingSDIInterface;
import eu.irreality.age.windowing.AGEClientWindow;
import eu.irreality.age.windowing.AGELoggingWindow;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.SwingUtilities;

public class GameEngineThread
extends Thread {
    public static long DEFAULT_REAL_TIME_QUANTUM = 1500L;
    protected static long timeCount;
    protected static boolean exitFlag;
    World theWorld;
    AGELoggingWindow ventana;
    boolean realTimeEnabled;
    long realTimeQuantum = DEFAULT_REAL_TIME_QUANTUM;
    private JMenu serverConfigurationMenu;

    public static String getVersion() {
        return "Aetheria Game Engine v " + GameEngineThread.getVersionNumber();
    }

    public static String getVersionNumber() {
        return "1.1.1";
    }

    public GameEngineThread(World theWorld, AGELoggingWindow ventana, boolean realTimeEnabled) {
        this.theWorld = theWorld;
        this.ventana = ventana;
        this.realTimeEnabled = realTimeEnabled;
        if (ventana != null) {
            this.initServerMenu(ventana);
            ventana.repaint();
        }
    }

    public void setRealTimeQuantum(long quantum) {
        this.realTimeQuantum = quantum;
    }

    public boolean isRealTimeEnabled() {
        return this.realTimeEnabled;
    }

    public void setRealTimeEnabled(boolean b) {
        this.realTimeEnabled = b;
    }

    public void initServerMenu(final AGELoggingWindow window) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.doInitServerMenu(window);
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        GameEngineThread.this.doInitServerMenu(window);
                        window.repaint();
                    }
                });
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void uninitServerMenu(final AGELoggingWindow window) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.doUninitServerMenu(window);
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        GameEngineThread.this.doUninitServerMenu(window);
                        window.repaint();
                    }
                });
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void doInitServerMenu(AGELoggingWindow window) {
        this.doInitServerMenu(window, "Opciones de juego");
    }

    public void doUninitServerMenu(AGELoggingWindow window) {
        JMenuBar menubar = window.getTheJMenuBar();
        menubar.remove(this.serverConfigurationMenu);
    }

    private void setJMenuBarAsNeeded(AGELoggingWindow window, JMenuBar mb) {
        window.setTheJMenuBar(mb);
    }

    private JMenuBar getJMenuBarAsNeeded(AGELoggingWindow window) {
        return window.getTheJMenuBar();
    }

    public void doInitServerMenu(final AGELoggingWindow window, String menuName) {
        this.serverConfigurationMenu = new JMenu(menuName);
        JMenu timeConfigurationMenu = new JMenu("Modo de juego");
        JMenuBar mb = this.getJMenuBarAsNeeded(window);
        if (mb == null) {
            mb = new JMenuBar();
            this.setJMenuBarAsNeeded(window, mb);
        }
        this.serverConfigurationMenu.add(timeConfigurationMenu);
        JRadioButtonMenuItem itemTurns = new JRadioButtonMenuItem("Turnos", true);
        JRadioButtonMenuItem itemRealTime = new JRadioButtonMenuItem("Tiempo real", false);
        ButtonGroup bg = new ButtonGroup();
        bg.add(itemTurns);
        bg.add(itemRealTime);
        if (this.realTimeEnabled) {
            itemRealTime.setSelected(true);
        }
        itemTurns.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GameEngineThread.this.setRealTimeEnabled(false);
            }
        });
        itemRealTime.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GameEngineThread.this.setRealTimeEnabled(true);
            }
        });
        timeConfigurationMenu.add(itemTurns);
        timeConfigurationMenu.add(itemRealTime);
        if (window instanceof AGEClientWindow) {
            JMenuItem reinitItem = new JMenuItem("Reiniciar juego");
            reinitItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    ((AGEClientWindow)window).reinit();
                }
            });
            this.serverConfigurationMenu.add(reinitItem);
        }
        mb.add(this.serverConfigurationMenu);
        mb.revalidate();
        window.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        int timeCount = 0;
        exitFlag = false;
        try {
            this.theWorld.execCode("serverintro", "");
            this.theWorld.execCode("serverintro", new Object[0]);
        }
        catch (EVASemanticException esm) {
            this.theWorld.write("EVASemanticException found at serverintro routine");
        }
        catch (TargetError bshte) {
            this.theWorld.write("bsh.TargetError found at serverintro routine");
            this.theWorld.write(bshte.printTargetError((Throwable)bshte) + bshte.inNativeCode());
            Debug.println(bshte.printTargetError(bshte.getTarget()));
            this.theWorld.write(bshte.printTargetError(bshte.getTarget()));
        }
        catch (Exception e) {
            this.theWorld.writeError("Exception thrown by serverIntro routine:");
            this.theWorld.writeError(ExceptionPrinter.getExceptionReport(e));
        }
        finally {
            Debug.println("Gonna notify.");
            Object esm = this.theWorld.serverIntroSyncObject;
            synchronized (esm) {
                this.theWorld.serverIntroExeccedFlag = true;
                this.theWorld.serverIntroSyncObject.notifyAll();
            }
            Debug.println("Notified.");
        }
        Debug.println("Gonna exec player intros.");
        List l = this.theWorld.getPlayerList();
        Debug.println("List gotten: " + l);
        if (l != null) {
            for (int i = 0; i < l.size(); ++i) {
                Debug.println("Intro " + i);
                Player p = (Player)l.get(i);
                this.theWorld.executePlayerIntro(p);
            }
        }
        Debug.println("Player intros execced.");
        while (!exitFlag) {
            ++timeCount;
            Debug.println("A world cycle.");
            try {
                this.theWorld.update();
            }
            catch (Exception e) {
                if (this.theWorld != null) {
                    this.theWorld.writeError("" + e);
                }
                System.err.println("Exception during world update:");
                e.printStackTrace();
                this.theWorld.writeError(ExceptionPrinter.getExceptionReport(e));
            }
            if (exitFlag) break;
            if (this.realTimeEnabled) {
                this.esperarCuanto();
            }
            if (exitFlag) break;
            if (this.theWorld.getNumberOfConnectedPlayers() <= 0) {
                try {
                    GameEngineThread.sleep(2000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            Debug.println("Flag = " + exitFlag);
        }
    }

    public synchronized void esperarCuanto() {
        try {
            this.wait(this.realTimeQuantum);
        }
        catch (InterruptedException intex) {
            System.err.println(intex);
        }
    }

    public void exitNow() {
        Debug.println("Gonna x-it.");
        if (this.ventana instanceof SwingAetheriaGameLoader) {
            ((SwingAetheriaGameLoader)this.ventana).unlinkWorld();
            ((SwingAetheriaGameLoader)this.ventana).saveAndFreeResources();
        }
        if (this.ventana instanceof SwingSDIInterface) {
            ((SwingSDIInterface)this.ventana).unlinkWorld();
            ((SwingSDIInterface)this.ventana).saveAndFreeResources();
        }
        if (this.ventana instanceof SwingSDIApplet) {
            ((SwingSDIApplet)this.ventana).unlinkWorld();
            ((SwingSDIApplet)this.ventana).saveAndFreeResources();
        }
        exitFlag = true;
        this.theWorld = null;
        this.ventana = null;
        this.serverConfigurationMenu = null;
        Debug.println("Flag set.");
    }

    public void exitForReinit() {
        Debug.println("Gonna x-it.");
        exitFlag = true;
        Debug.println("Flag set.");
    }
}

