/*
 * Decompiled with CFR 0.152.
 */
package eu.irreality.age;

import eu.irreality.age.BroadcastEchoServer;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.Socket;
import java.util.Enumeration;

class BroadcastClientHandler
extends Thread {
    protected Socket incoming;
    protected int id;
    protected BufferedReader in;
    protected PrintWriter out;

    public BroadcastClientHandler(Socket incoming, int id) {
        this.incoming = incoming;
        this.id = id;
        try {
            if (incoming != null) {
                this.in = new BufferedReader(new InputStreamReader(incoming.getInputStream()));
                this.out = new PrintWriter(new OutputStreamWriter(incoming.getOutputStream()));
            }
        }
        catch (Exception e) {
            System.out.println("Error: " + e);
        }
    }

    public synchronized void putMessage(String msg) {
        if (this.out != null) {
            this.out.println(msg);
            this.out.flush();
        }
    }

    public void run() {
        System.out.println("Client handler " + this.id + " started.");
        if (this.in != null && this.out != null) {
            this.putMessage("Hello! This is Java BroadcastEchoServer. Enter BYE to exit.");
            try {
                String str;
                while ((str = this.in.readLine()) != null) {
                    this.putMessage("Echo: " + str);
                    System.out.println("Received (" + this.id + "): " + str);
                    if (str.trim().equals("BYE")) break;
                    Enumeration en = BroadcastEchoServer.activeThreads.elements();
                    while (en.hasMoreElements()) {
                        BroadcastClientHandler t = (BroadcastClientHandler)en.nextElement();
                        if (t == this) continue;
                        t.putMessage("Broadcast(" + this.id + "): " + str);
                    }
                }
                this.incoming.close();
                BroadcastEchoServer.activeThreads.removeElement(this);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        System.out.println("Client thread " + this.id + " stopped.");
    }
}

