/*
 * Decompiled with CFR 0.152.
 */
package eu.irreality.age;

import eu.irreality.age.ARSPConstants;
import eu.irreality.age.MultimediaInputOutputClient;
import eu.irreality.age.ServerProxy;
import eu.irreality.age.SwingAetheriaGameLoader;
import eu.irreality.age.SwingRemoteClientWindow;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.Socket;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JTextPane;

class ARSPSocket
extends Thread
implements ARSPConstants {
    Socket socket;
    SwingRemoteClientWindow ventana;
    JTextPane logPane;
    private BufferedReader in;
    private PrintWriter out;

    public ARSPSocket(Socket s, SwingRemoteClientWindow srcw) {
        this.socket = s;
        this.ventana = srcw;
        this.logPane = this.ventana.getLogPane();
    }

    public void run() {
        try {
            boolean terminamos;
            this.logPane.setText(this.logPane.getText() + "Socket connected.\n");
            System.out.println("Socket connected.\n");
            this.in = new BufferedReader(new InputStreamReader(this.socket.getInputStream()));
            this.out = new PrintWriter(this.socket.getOutputStream()){

                public void println(String linea) {
                    this.print(linea);
                    this.print("\r\n");
                }
            };
            this.writeSocket("protocol_version_statement 1.0");
            System.out.println("B4 readSocket()");
            String line = this.readSocket();
            System.out.println("After readSocket(). Line=" + line);
            StringTokenizer st = new StringTokenizer(line);
            String tok = st.nextToken();
            if (tok.equalsIgnoreCase("protocol_version_ack")) {
                String tok2 = st.nextToken();
                if (!tok2.equalsIgnoreCase("OK")) {
                    this.logPane.setText(this.logPane.getText() + "Protocol error.\n");
                    return;
                }
            } else {
                this.logPane.setText(this.logPane.getText() + "Protocol error.\n");
                return;
            }
            Vector<String> servicios = new Vector<String>();
            Vector<String> partidas = new Vector<String>();
            this.writeSocket("service_list_request");
            line = this.readSocket();
            st = new StringTokenizer(line);
            tok = st.nextToken();
            if (tok.equalsIgnoreCase("service_list_begin")) {
                terminamos = false;
                while (!terminamos) {
                    line = this.readSocket();
                    st = new StringTokenizer(line);
                    tok = st.nextToken();
                    if (tok.equalsIgnoreCase("service_list_line")) {
                        servicios.add(st.nextToken());
                        continue;
                    }
                    if (tok.equalsIgnoreCase("service_list_end")) {
                        terminamos = true;
                        continue;
                    }
                    this.logPane.setText(this.logPane.getText() + "Protocol error.\n");
                    return;
                }
            } else {
                this.logPane.setText(this.logPane.getText() + "Protocol error.\n");
                return;
            }
            System.out.println("Services gotten.");
            if (servicios.contains("gamelist")) {
                this.writeSocket("call_service gamelist");
                line = this.readSocket();
                st = new StringTokenizer(line);
                tok = st.nextToken();
                if (tok.equalsIgnoreCase("game_list_begin")) {
                    terminamos = false;
                    while (!terminamos) {
                        line = this.readSocket();
                        st = new StringTokenizer(line);
                        tok = st.nextToken();
                        if (tok.equalsIgnoreCase("game_list_line")) {
                            partidas.add(st.nextToken(""));
                            continue;
                        }
                        if (tok.equalsIgnoreCase("game_list_end")) {
                            terminamos = true;
                            continue;
                        }
                        this.logPane.setText(this.logPane.getText() + "Protocol error.\n");
                        return;
                    }
                }
            }
            System.out.println("Games gotten.\n");
            if (partidas.size() > 0) {
                this.ventana.initPartidasTab(partidas, servicios);
            }
        }
        catch (IOException ioe) {
            this.logPane.setText(this.logPane.getText() + ioe + "\n");
        }
    }

    public void joinGame(int id) {
        this.writeSocket("call_service gamejoin " + id);
        SwingAetheriaGameLoader sagl = new SwingAetheriaGameLoader("Partida remota", this.ventana.getEscritorio());
        ServerProxy sp = new ServerProxy(this.socket, (MultimediaInputOutputClient)sagl.getClient());
        sp.start();
    }

    private void writeSocket(String s) {
        this.out.println(s);
        this.out.flush();
        this.logPane.setText(this.logPane.getText() + "[client] " + s + "\n");
    }

    private String readSocket() throws IOException {
        String s = this.in.readLine();
        this.logPane.setText(this.logPane.getText() + "[server] " + s + "\n");
        return s;
    }
}

