------------- now got inside!!! -----------------------
napil = obj {
	nam = 'ヤスリ',
	dsc = 'ゲートの下に{ヤスリ}がある。',
	inv = '少し錆びているが。',
	tak = 'ヤスリを取った。',
	use = function(s, w)
		if w == 'knife' and not knife._oster then
			knife._oster = true;
			return '俺はヤスリでナイフを研いだ。刃先が鋭くなった！切れ味抜群！';
		elseif w == 'gun' and not gun._obrez then
			if here() == wside or here() == sside then
				return 'ここには人が大勢いるのでやめよう。';
			end
			gun._obrez = true;
			return '俺は座ってショットガンのバレルを短く切り離した。';
		else
			return 'ここじゃそんなことをしても役に立たんだろう。';
		end
	end
};

eside = room {
	pic = 'gfx/eside.png',
	nam = '研究所の裏側',
	dsc = [[研究施設の裏の壁に来た。列車のレールが敷かれている。]],
	act = function(s,w)
		if w == 1 then
			return 'マシンガンは研究所の南側に配置されている。近づかないほうがいい。';
		end
		if w == 2 then
			return 'ゲートは鉄で出来ているようだ。内側からロックされている。';
		end
	end,
	obj = {
	vobj(1,'監視塔', 'レールが続く入り口は銃座のついた{監視塔}に守られている。'),
	vobj(2,'ゲート', 'レールは鉄の{ゲート}のそばに敷かれている。物資補給のために使われているようだ。'),	
	'napil',
	},
	exit = function(s, t)
		if t == 'sside' then
			return '南側はマシンガンが怖い。危険すぎる。'
				, false
		end
	end,
	enter = function(s, f)
		if f == 'onwall' then
			-- end of episode 1
			inmycar = nil;
			deepforest = nil;
			road = nil;
			forest = nil;
			home = nil;
			shop = nil;
			village = nil;
			kpp = nil;
			inst = nil;
			onwall = nil;
			backwall = nil;
			guydlg = nil;
			shop2 = nil;
			shopdlg = nil;
			guarddlg = nil;
			set_music("mus/ice.s3m");
		end
	end,
	way = {'nside','sside'},
};

card = obj {
	nam = 'IDカード',
	inv = [[誰かのIDカードらしい。ヘビメタ風の顔写真が貼られている電子認証カードだ。“アレクセイ・パッドコービン／レベル3／カテゴリ：物質”と名前が書いてある。ほう……。]],
};

alienwear = obj {
	xnam = {'デニムジャケット', '赤いジャケット', 'オーバーコート', 'ジャケット', '白いジャケット', 
	'コート', '黒い皮のジャケット', 'スポーツジャケット',},
	xinv = {
		'この季節には少し寒いが、これが正しいファッションだな。',
		'雪景色にはよく似合うだろう。',
		'ロングコートだ。ややレトロな感じだ。',
		'俺はターミネーターだ！',
		'セイピース！戦争反対！',
		'俺にぴったりかもしれない。',
		'"そして誰もいなくなった。"',
		'俺も以前は登山が好きだったが。',
	},
	nam = function(s)
		return s.xnam[s._num];
	end,
	inv = function(s)
		if s._num == 7 and not have('card') then
			inv():add('card');
			return '俺は皮のジャケットのポケットを探ってなにかのカードを見つけた。';
		end
		return s.xinv[s._num];
	end,
};

garderob = obj {
	nam = 'ワードローブ',
	dsc = '右手に客用の上着がずらりと吊るされた{ワードローブ}がある。',
	act = function(s, w)
		if have('mywear') or have('alienwear') then
			return 'ここでは人が多すぎる。人目を引かずに着替えるのは難しいだろう。';
		elseif tonumber(w) and tonumber(w) > 0 and tonumber(w) <= 8 then
			if not me()._walked then
				return '今ここで着替えると目立ちすぎるな。';
			end
			alienwear._num = w;
			inv():add('alienwear');
			ref(s.obj[w]):disable();
			me()._walked = false;
			inv():add('gun');
			return '余裕のある素振りで誰のものか分からない上着を取って着替え、俺のショットガンを取った。';
		else
			return 'ここでなにをするのかさっさと決めたほうがよさそうだ。';
		end
	end,
	used = function(s, w)
		if w == 'mywear' then
			garderob.obj:add('mywear');
			inv():del('mywear');
			inv():del('gun');
			return 'キルティングコートを脱いだ。ショットガンをそれに隠した。';
		end
		if w == 'alienwear' then
			local v = alienwear._num;
			ref(s.obj[v]):enable();
			inv():del('alienwear');
			inv():del('gun');
			return '俺は誰のものか分からない上着をワードローブに戻した。ショットガンはキルティングコートに隠した。';
		end
	end,
	obj = {
		vobj(1,'デニムジャケット','{デニム地のジャケット}。'),
		vobj(2,'赤いジャケット','{赤い色のジャケット}。'),
		vobj(3,'オーバーコート','{オーバーコート}。'),
		vobj(4,'ターミネータージャケット', 'アイル・ビー・バックな{ジャケット}。'),
		vobj(5,'ヒナギクが生い茂るようなジャケット', 'ヒナギクの{白いジャケット}。'),
		vobj(6,'コート', '{ウール地のジャケット}。'),
		vobj(7,'皮のジャケット','{かっこいい皮製のジャケット}。'),
		vobj(8,'スポーツジャケット', '{オレンジ色のスポーツジャケット}。'),
	}
};
portrait = obj {
	nam = '肖像画',
	dsc = '豪勢な木の額縁に飾られた{肖像画}が壁にかかっている。',
	act = 'どれも同じ顔の肖像画だ。背筋がぞっとするような冷たい背景に冷たい微笑を浮かべた40歳くらいの男が描かれている。',
};

salo = obj {
	nam = 'ラード',
	inv = 'このラードの固まりを食べるのはちょっと気持ち悪いな。',
	use = function(s, w)
		if w == 'trap' and not trap._salo then
			inv():del('salo');
			trap._salo = true;
			return 'ほう……こいつはいいネズミ捕りができたぞ。';
		end
	end
};

food = obj {
	nam = '食べ物',
	inv = function (s) 
		inv():del('food');
		return 'そういえば腹減ってたんだよな俺。立ったままでも今すぐ全部食ってやる。ふぅ……、食った食った。じゃあ空になったプレートを食器返却口に戻しに行くか。';
	end
};

knife = obj {
	nam = 'ナイフ',
	dsc = '俺はトレーに乗った{ナイフ}をまじまじと見つめた。',
	inv = function(s)
		if s._oster then
			return 'ステンレスのナイフだ。とても鋭い。';
		end
		return 'ステンレスのナイフだ。切れ味はあまりよくない。';
	end,
	use = function(s, w)
		if w == 'shells' then
			if not s._oster then
				return 'このナイフは道具として使うには切れ味が悪すぎる。';
			end
			if have('poroh') then
				return 'すでに火薬を持っている。';
			end
			inv():add('poroh');
			return '薬莢をひとつ分解して火薬を取り出した。';
		end
	end,
	tak = function(s)
		if have('knife') then
			return 'すでに1個持っている。', false
		end
		return 'なにかに使えるかもしれないのでとりあえず持っていよう。';
	end
};

ostatki = obj {
	nam = '食べかす',
	dsc = '食事の{食べかす}がプレートの上に散らばっている。',
	tak = function(s)
		if food._num ~= 2 or have('salo') then
			return '使い道がない。', false;
		else 
			take('salo');
			return 'ラードをこすり取った。', false;
		end
	end
};

podnos = obj {
	nam = 'トレー',
	dsc = 'テーブルの上に{トレー}がある。',
	act = function(s, w)
		if w == 1 then
			return 'フォークっぽいフォークがある。あまり清潔じゃなさそうだが。';
		end
		if w == 2 then
			return 'このスプーンの形はとくに珍しくはない。';
		end
		return '青いプラスチックだ。触ると少し油がついている。';
	end,
	obj = { 'ostatki',
		vobj(1, 'フォーク', '{フォーク}と'), 
		vobj(2, 'スプーン', '{スプーン}が並んでいる。') 
	},
};

moika = room {
	nam = '食器返却口',
	enter = function()
		return cat('トレーを食器返却口に持っていった。^^', walk('kitchen')), false;
	end
};

eating = room {
	pic = 'gfx/podnos.png',
	enter = function(s, f)
		podnos.obj:add('knife');
		inv():del('food');
		if not me()._kitchendlg then
			me()._kitchendlg = true;
			return walk('kitchendlg'), false;
		end
		if f ~= 'kitchendlg' then
			return '俺は空いているテーブルについて飯を食った。';
		end
	end,
	nam = 'テーブルにて',
	dsc = '俺は自分の手の下にテーブルの平らな表面を感じた。',
	obj = { 'podnos' },
	way = { 'moika' },
	exit = function(s)
	end
};

gotfood = function(w)
	inv():add('food');
	food._num = w;
	return back();
end

invite = obj {
	nam = '招待状',
	inv = '招待状には“ベリンの講義：レベル4、ホール2”と書かれていた。うーむ、これは行くしかない。あいつが俺の猫を持っているからな。',
}

povardlg = dlg {
	nam = 'カウンター',
	pic = 'gfx/povar.png',
	dsc = 'シェフの白い帽子を被り、疲れきった様子の太った女性がいる。',
	obj = {
	[1] = phr('その緑色のやつと……そう、豆をください！', '「さあどうぞ」', [[pon(1); return gotfood(1);]]),
	[2] = phr('ポテトとベーコン炒めをください。', '「ボナペティ！」', [[pon(2); return gotfood(2);]]),
	[3] = phr('ガーリックスープを2つください。', '「シェフの自信作ですよ！」', [[pon(3);return gotfood(3);]]),
	[4] = phr('なんでもいいから、柔らかくて食べやすいものをください。俺って胃が悪くて……。', '「オートミールいっちょ！」', [[pon(4); return gotfood(4);]]),
	},
};
kitchendlg = dlg {
	nam = '職員との会話',
	pic = 'gfx/ilya.png',
	dsc = 'トレーを持って空いているテーブルに座った。数分して男がテーブルに座ろうとして尋ねた「ここ、空いてる？」',
	obj = {
	[1] = phr('ああ、空いてる。', 'ありがと。どうだい調子は？どこの部署だっけ？', [[pon(3,4,5); poff(2);]]),
	[2] = phr('空いてないよ……。', 'ははは、ナイスジョーク！どこの部署だっけ？', [[pon(3,4,5); poff(1);]]),
	[3] = _phr('うーん……空間の歪み理論。', '「ほう、そりゃまた古いネタをやってるんだね」', [[pon(6);poff(4,5)]]),
	[4] = _phr('えーと、量子飛躍理論。', '「は？聞いたことないな」', [[pon(6);poff(3,5)]]),
	[5] = _phr('おぅ、擬似空間の研究部署だ。', '「ほぅ！そりゃすごい」', [[pon(6);poff(3,4)]]),
	[6] = _phr('うーん……', '「きみのセキュリティレベルはいくつだい？」', [[pon(7,8)]]),
	[7] = _phr('それはトップシークレットだ。', '「へえ！」', [[poff(8); pon(9)]]),
	[8] = _phr('俺はここでは匿名なんだ。', '「ほんとに？聞いたことないなぁ。たぶん僕より機密クラスが高いんだろうね」', 
[[poff(7); pon(9)]]),
	[9] = _phr('えーとだな……', '「僕はイリヤだ」^彼はテーブルに肘をついて頬杖をついた。^「それで、きみの名前は？」', [[pon(10, 11, 12)]]),
	[10] = _phr('えーっと、パ、パ、パプキン。バシリー・パプキンだ。', '「珍しい苗字だね。よろしく」', [[poff(11,12); pon(13)]]),
	[11] = _phr('俺はサージェイだ。', '「じゃあハイタッチして！」', [[poff(10,12); pon(13)]]),
	[12] = _phr('ジョージだ。', '「そう。よろしくね、ゴーシャ！」', [[poff(10,11); pon(13)]]),
	[13] = _phr('あー……', 
[[「きみはなんとなく妙だな。でも問題ないよ、ここにいるみんなそうだしね」^イリヤは意味深な表情をしてみせた。^「僕はベリン氏の講義の招待状を配ってるんだ……、親しい友達だけにね。けど、きみはいい人みたいだし、セキュリティレベルも高いし、それでね」]], [[pon(14)]]),

	[14] = _phr('彼はどこにいるんだ？その講義とやらはどこでやるんだ？', 

[[「ホール2のセキュリティレベル4でやる予定だよ。きっと来てくれよな。彼に会うのには……絶好のチャンスだから」^イリヤは壁にかかっている肖像画を示した。^「ああ、忘れるところだった」彼はそういって1枚の薄い白いプラスチックカードをくれた。^「それじゃ、またね」^^なん……だと？おぉ!!]],[[inv():add('invite');return walk('eating');]]), 
	}
};
kitchen = room {
	nam = '食堂',
	pic = 'gfx/kitchen.png',
	dsc = '小さな食堂だ。',
	act = function(s, w)
		if w == 4 then
			return '誰かの手が使い終わったトレーを取って運んでいるのが見えた。';
		end
		if w == 1 then
			if not have('food') then
				return '空いているテーブルに座った。ふう……休んだら少し楽になった。それじゃ行こうか。';
			end
			return walk('eating');
		end
		if w == 2 then
			return '彼らは蜂の巣に群れる蜂のようにせわしなく動いている。';
		end
		if w == 3 and not have('food') then
			return cat([[キッチンカウンターの列に並んでトレーを取り、ナイフとフォークを乗せた。注文をする行列はゆるゆるとしか進まず俺は待ちくたびれた。ようやく俺の順番が来て注文することになった。^^]], walk('povardlg'));
		end
	end,
	used = function(s, w, ww)
		if w == 1 and ww == 'food' then
			return s:act(1);
		end
	end,
	enter = function(s)
		if not have('mywear') and not have('alienwear') then
			me()._walked = true;
		end
		set_music('mus/foot.mod');
	end, 
	exit = function(s, t)
		if have('food') and t ~= 'eating' then
			return 'トレーを持ったまま外に出るのか？そりゃ無理だろ。', false;
		end
		if t == 'stolcorridor' then
			set_music('mus/ice.s3m');
		end
	end,
	obj = { 'portrait', 
		vobj(1, 'テーブル', '食堂のホールで四人から八人がひとつの{テーブル}についている。'), 
		vobj(2, '人々', '食堂は飯を食う{人々}で賑わっている。'),
		vobj(3, '行列', '腹を空かせた連中の{行列}が、はやく食べ物が出てこないかと待ちわびている。'),
		vobj(4, '食器返却口', 'ホールの隅に、使い終わったトレーの食べかすを捨てて洗浄するための{食器返却口}がある。'), 
	},
	way = { 'stolcorridor' },
};

stolcorridor = room {
	nam = '食堂の入り口',
	pic = 'gfx/kitchencor.png',
	dsc = '天井の蛍光灯で照らされた狭くて長い廊下がある。',
	act = function(s, w)
		if w == 1 then
			return 'ああ、職員はみんなここで飯を食うんだ。';
		end
	end,
	obj = {'garderob', vobj(1,'люди', '{人々}は廊下に沿って出たり入ったりしている。')},
	way = {'sside', 'kitchen'},
	exit = function(s, t)
		if t == 'sside' and not have('mywear') and not have('alienwear') then

			return '外はすごく寒い。コートなしでは出たくない……やめよう。', 
				false;
		end
	end,
	enter = function(s)
		-- generate garderob
		if have('gun') and not gun._hidden then
			return 'ショットガンを持ったまま中に入れば怪しまれてなにか質問されるだろう。', false;
		end
		local i
		for i=1, 8 do
			local o = garderob.obj[i];
			ref(o):disable();
		end
		local k = 7;
		for i=1, 5 do
			if not have('alienwear') or k ~= alienwear._num then
				local o = garderob.obj[k];
				ref(o):enable();
			end
			k = rnd(8);
		end
	end
};

sside = room {
	nam = '南側',
	pic = 'gfx/sside.png',
	dsc = [[研究施設の南側の壁にいる。]],
	act = function(s, w)
		if w == 1 then
			ways():add('stolcorridor');
			return "俺は建物の別の入り口に来た。見上げると食堂と書いてある。^^ほう……ここから中に入れるかもしれんな。";
		end
		if w == 2 then
			return '誰かが出てきたが、そいつの表情は入っていくやつよりは満足そうだった。';
		end
	end,
	way = {'eside','wside'},
	obj = { vobj(1, "入り口", "東の隅に{入り口}がある。"),
		vobj(2, "人々", "ときどき入り口のドアが開いて{人々}が出入りしている。")},
	exit = function(s, t)
		if t == 'eside' then
			return '俺がそっちに行けばマシンガンのいい標的になるだろう。', false
		end
	end
};

nside = room {
	nam = '北側',
	pic = 'gfx/nside.png',
	dsc = '研究施設の北側の壁にいる。',
	way = {'eside','wside' },
	act = function(s, w)
		if w == 1 then
			return 'おう、雨樋のパイプだな。頑丈にできているようだ。これを伝って登るのはちょっと無理だが。';
		end
	end,
	obj = { vobj(1, '雨樋', '東の隅に{雨樋}が取り付けられている。')},
};


wside = room {
	nam = '正面',
	pic = 'gfx/wside.png',
	dsc = '研究所の正面だ。',
	way = {'entrance', 'nside','sside' },
	act = function(s, w)
		if w == 1 then
			return 'この話がはじまるきっかけになったバンだ。';
		end
		if w == 5 then
			return 'ハシゴは上から2階まで伸びてはいるが手は届きそうにない。それにロックされている。たぶん火事が起こったときの避難用だろう。使えるのかどうか怪しいもんだが。'
		end
		if w == 2 then
			return '警備員はすぐに俺の顔に見覚えがあることに気がつくだろう。先にバルシクを探さないといけない。';
		end
		if w == 3 then
			return '正面玄関の景観は悪くないな。だが俺のイメージじゃ研究所の入り口が人間を飲みこんでいるようにしか見えん。';
		end
		if w == 4 then
			return '外はそろそろ暗くなってきた。でもまだ建物に入ろうとする人が多い。';
		end
	end,
	obj = { vobj(3, '入り口', '正面の{入り口}には大きな回転ドアがある。'),
		vobj(4, '人々', '{人々}が出たり入ったりしている。'), 
		vobj(1, 'バン', 'ドアの前に黒い{バン}が止まっている。'),
		vobj(2, '検問所', '60メートルほど先に{検問所}らしきものが見える。'),
		vobj(5, 'ハシゴ', '壁の南側に避難用の{ハシゴ}が取り付けられている。2階から5階まで伸びているようだ。' ),
	}
};

turn1 = obj {
	nam = 'セキュリティゲート',
	dsc = '建物のエレベータの手前にメタリックに光る{セキュリティゲート}が並んでいる。駅で見かける自動改札機に似ている。“すべてのカテゴリとセキュリティレベル”と書かれた緑色の文字が流れている。',
	act = function(s, w)
		if s._inside then
			s._inside = false;
			here().way:del('lift');
			return '俺はセキュリティゲートに歩み寄りIDカードを使った。ゲートを通り抜けて制限エリアから外に出た。';
		end
		if s._unlocked then
			s._inside = true;
			here().way:add('lift');
			return '俺はセキュリティゲートに歩み寄りIDカードを使った。ゲートを通り抜けてエレベータに向かった。';
		end
		return '俺はセキュリティゲートに歩み寄った。だが赤い×印が表示されて通してくれなかった。素通りしようなんて不味いアイデアだったか。';
	end,
	used = function(s,w)
		if w == 'card' then
			s._unlocked = true;
			s._inside = true;
			here().way:add('lift');
			return 'ゲートのカードリーダーにカードをかざすと緑色のライトが点灯した。無事通過できたのでエレベータに向かった。';
		end
	end
};

lustra = obj {
	nam = 'シャンデリア',
	dsc = 'きらきら光る大きな{シャンデリア}が頭の上にある。',
	act = '近づいて調べることは無理だろう。たぶんクリスタル製じゃないかとは思うが。';

};

divan = obj {
	nam = 'ソファー',
	dsc = '部屋の隅に、警備員の机に向かい合わせになった客用{ソファー}がある。',
	act = function(s)
		return '黒革の柔らかいソファーだ。';
	end,
};

entrance = room {
	nam = '1階ホール',
	pic = 'gfx/entrance.png', 
	dsc = '研究所の1階ホールの室内装飾には目を見張るものがあった。かなり金をかけているようだ。',
	act = function(s, w)
		if w == 2 then
			return 'ゲートにはスチール製のフラップドアが立ちはだかっている。';
		end
		if w == 3 then
			if not turn1._inside then
				return 'セキュリティゲートが俺とエレベータホールの間に陣取って行く手を阻んでいる。';

			end
			return '4つあるエレベータはすべての従業員が階を移動するには数が足りていないようだ。';
		end
		if w == 4  then
			return 'テーブルはガラスかクリスタルで出来ているようだ。テーブルの向こうにコンピュータ端末がある。'; 
		end
		if w == 5 then
			return '近寄りたくない。顔を覚えられないほうがいいだろう。'; 
		end
		if w == 6 then
			return '人が多すぎる。こんなにたくさんの人間を見るのは俺にとっては滅多にないことだ。';
		end
	end,
	obj = {
		'lustra',
		vobj(2, 'ゲート', '下に線路が延びた鉄製の{ゲート}が建物の東側の壁を占拠している。'),
		vobj(3, 'エレベータ', 'ホールの真ん中に{エレベータ}がある。'),
		'turn1',
		vobj(4, 'テーブル', 'セキュリティゲートのこちら側に{テーブル}がある。'),
		vobj(5, '警備員', '{警備員}がテーブルの向こうに座っている。'),
		vobj(6, '人々', '行き交う{人々}がエレベータのそばに行列を作っている。'),
		'divan',
	},
	way = { 'wside' },
	enter = function(s, f)
		if have('gun') and f == 'wside' and not gun._hidden then
			return 'ショットガンを持ったまま中に入ると怪しまれていろいろと質問されるだろう。どうにかして隠したいわけだが。', false;
		end
	end,
	exit = function(s, t)
		if t == 'wside' then
			turn1._inside = false;
			s.way:del('lift');
		end
	end,
};

pinlift = obj {
	nam = function(s)
		if s._num == 3 then
			return '';
		end
		return 'people';
	end,
	act = function(s)
		return '空虚でまるで押し殺して息をするような雰囲気。この沈黙には耐えられん。';
	end,
	dsc = function(s)
		if s._num == 1 then
			return 'エレベータの中は職員の{人々}で満員だ。';
		end
		if s._num == 2 then
			return 'エレベータには{男}が何人か乗っている。';
		end
		if s._num == 3 then
			return 'エレベータには誰も乗っていない。'
		end
	end
};

lift = room {
	nam = 'エレベータ',
	pic = 'gfx/lift.png',
	dsc = 'エレベータの中は明るくて快適だが、あいにく俺は閉所恐怖症なのでな。操作パネルにボタンがある：',
	enter = function(s, t)
		if here() == entrance then
			s._from = 1;
			pinlift._num = 1;
			return 'エレベータが来るのを待って中に入った。';
		end
		pinlift._num = rnd(3);
		if here() == floor2 then
			s._from = 2;
		elseif here() == floor3 then
			s._from = 3;
		elseif here() == floor4 then
			s._from = 4;
		elseif here() == floor5 then
			s._from = 5;
		end
		return '壁にあるボタンを押してエレベータを待った。ドアが開いて俺は中に入った。';
	end,
	act = function(s, w)
		local to,st
		if not tonumber(w) then
			return
		end
		if w == s._from then
			return cat('ここから出してくれ！閉所恐怖症の発作が!!^^', 
				back());
		end
		if w == 8 then
			st = '';
			if galstuk._wear then
				st = 'ところで、俺はネクタイを持っている。';
			end
			if me()._brit then
				return '俺は鏡を覗き込んだ。疲れている。だがヒゲを剃ってすっきりした顔つきだ。うん、これが俺だな。' .. st;
			end
			return '俺は鏡を覗き込んだ。ひどく疲れている上に無精ヒゲが伸びている。これ、俺？'..st;
		end
		if w == 6 or w == 7 then
			return '俺は神経が張り詰めていたせいか少しビクついていた。だがナーバスになってる場合じゃないよな。';
		end
		if w == 1 then
			to = 'entrance';
		else 
			to = 'floor'..w;
		end
		return cat('俺はボタンを押して待った。閉所恐怖症にかられて俺は手を握り締めた。ぬおぉぉ、やっと長い旅が終わった！^^',
			walk(to));
	end,
	exit = function()
		return 'エレベータのドアが俺の後ろで閉まった。';
	end,
	obj = {
		vobj(1,'1', '{1},'),
		vobj(2,'2', '{2},'),
		vobj(3,'3', '{3},'),
		vobj(4,'4', '{4},'),
		vobj(5,'5', '{5},'),
		vobj(6,'停止','{停止}'),
		vobj(7,'再開','と{再開}。'),
		vobj(8,'鏡', 'エレベータの中は後ろの壁が{鏡}になっている。'),
		'pinlift',
	},
};

floor2 = room {
	nam = '2階ホール',
	pic = 'gfx/floor2.png',
	dsc = "2階には窓がひとつもない。低い天井と灰色がかった緑の壁だ。ここは寒くてなにも音がしない。",
	act = function(s, w)
		if w == 1 then
			return 'ドアは鉛で出来ているようだ。どうやって入ればいいのか分からないが、無理して入ることもないだろう。ドアのラベルには“レベル2　カテゴリ：原子力”と書かれている。';
		end
		if w == 2 then
			return 'ええぃくそ、エレベータのやつめ。こんなやばい場所に俺を置いていきやがって。';
		end
	end,
	obj = { 
		vobj(1, 'ドア', '見るからに重そうなどっしりとした{ドア}があり、“注意：高出力の放射線”と書かれたプレートが貼ってある。'),
		vobj(2, 'エレベータ', 'エレベータのドアが四つあり、俺の姿がぼんやりと写りこんでいる。'),
	},
	way = { 'lift' },
};

resh = obj {
	nam = 'bars',
	dsc = function(s)
		if not s._unscrew then
			return '空調の穴には{金属メッシュ}がはまっている。';
		end
		if vent._off then
			return '空調ダクトにファンの大きな羽が見えた。{金属メッシュ}が床に落ちている。';
		end
		return 'ファンの大きな羽が回っている。{金属メッシュ}が床の上に落ちている。';
	end,
	act = function(s)
		if s._unscrew then
			return 'これこそが、この切れないナイフの使い道だったわけだ。もちろん俺の根気とテクニックがあったからだがな。';
		end
		if not stoly._moved then
			return 'うーんっと、だめだ届かない。';
		end
		return '金属メッシュは12本ものネジできつく固定されている。';
	end,
	used = function(s, w)
		if w == 'knife' and not s._unscrew and stoly._moved then
			s._unscrew = true;
			return '俺はテーブルの上に登ってナイフでネジを外そうとした。少し時間がかかったがすべてのネジを外すことができた。金属メッシュのカバーは床に落ちた。俺はテーブルから降りた。';
		end
		if w ~= 'stol' then
			return '無理だろう……。';
		end
	end,
};

vent = obj {
	nam = '空調ダクト',
	dsc = '天井の真ん中に、空調用の大きな正方形の{穴}が開いている。',
	act = function(s)
		if not stoly._moved then
			return 'うんっ、っと。届かねえな。';
		end
		if not resh._unscrew then
			return '俺はテーブルに乗って穴を調べた。金属で出来た網のカバーがかかっているようだ。もっと近づいて見ようとしたのだが、残念ながら俺はテーブルから落ちてしまった。';
		end
		if not s._off then
			return '俺はテーブルに乗って、高速で回転している空調のファンを調べた。すまんが、こいつに触るのは危険すぎる。';
		end
		if not s._trap then
			return '俺はテーブルの上に乗った。穴の縁をつかんで中に入ろうとした。ダクトの中は暗くて濡れている。中に入り込んだとき、赤い目をして歯をむき出しにしたでかいネズミが飛び出てきた！で、出たぁぁ、俺はテーブルの上に落ちて床に転がった。';
		end
-- here we go!
		return walk('toilet');
	end,

	used = function(s, w)
		if w == 'stol' then
			return
		end
		if not stoly._moved  then
			return 'やってみたが、穴まで届かない。';
		end
		if not resh._unscrew then
			return '穴は金属製の網で覆われている。';
		end
		if not s._off then
			return '回転しているファンの刃が危険すぎて無理だ。';
		end
		if w == 'gun' and not s._trap then
			gun._loaded = false;
			return '俺はテーブルの上に乗ってショットガンをダクトに向けた。両方のバレルが火を噴いて同時に轟音を発した。俺は耳を澄ました。穴はシンと静まり返っている。俺はテーブルから降りた。……まったく役に立ってないじゃないか！';
		end
		if w == 'trap' then
			if not trap._salo then
				return '俺はダクトの縁にネズミ捕りを仕掛けた。ひたすら待った。しかしネズミはバカじゃない。俺はネズミ捕りを取り戻した。なにかエサになるようなものが必要だな。';
			end
			inv():del('trap');
			vent._trap = true;
			return '俺はテーブルの上に乗って、エサを仕掛けたネズミ捕りをダクトの縁に置いた。ひたすら待ち続けた。しばらくするとバネがはじける音がしてネズミの断末魔が聞こえた。やったぞ、成功だ！';
		end
	end,
	obj = {
		'resh'
	}
};

stol = obj {
	nam = 'テーブル',
	inv = '俺はテーブルの端を持った。このテーブルはオーク材で出来ているようだな。',
	use = function(s, w)
		if w == 'vent' or w == 'resh' then
			inv():del('stol');
			stoly._moved = true;
			return '俺は額に汗をかきながら重たいテーブルを部屋の真ん中に押した。';
		end
	end
};

stoly = obj {
	nam = 'テーブルセット',
	dsc = function(s, w)
		if not s._moved then
			return 'オークの{テーブルセット}が4つ、部屋の四隅にそれぞれ置いてある。';
		end
		return '3つの{テーブルセット}が部屋の隅に陣取っている。そのうちのひとつは部屋の真ん中に動かしてある。';
	end,
	act = function(s, w)
		if s._moved then
			return 'この重たいテーブルを重ねるつもりか？それはちょっと無理だな。';
		end
		inv():add('stol');

		return [[高級感溢れるいい家具だ。でも俺んちのテーブルのほうがいい。あれは俺の自信作だからな。俺はテーブルの角を持った。]];
	end
};

eroom = room {
	nam = '特殊相対論部門',
	pic = function()
		if not stoly._moved then
			return 'gfx/sto.png';
		end
		if not resh._unscrew then	
			return 'gfx/sto2.png';
		end
		return 'gfx/sto3.png';

	end, 
	dsc = [[ベージュ色の壁の小さな部屋にいる。]],
	enter = function(s, f)
		if f == 'cor3' then
			return [[ドアを開けて中を覗きこんだ。おお、誰もいないぜ。この部屋はよく調べたほうがよさそうだ。]];
		end
		if f == 'toilet' then
			return '俺はトイレの床に取り付けられている金属製のカバーを持ち上げて中に入り込んだ。数分して俺は空調ダクトからテーブルの上に降り立った。';
		end
	end,
	act = function(s, w)
		if w == 1 then
			return '俺は窓に近寄って外の暗闇を見た。暗い窓に俺の顔が映っている。離れたところにマシンガンを装備した監視塔と列車のレールが見えた。';
		end
		if w == 2 then
			return 'ただの端末だ。研究所のサーバに繋がったクライアントマシンにすぎない。もっとも、俺自身はもう興味すらないしな。ここ10年くらいコンピュータに触っていない。';
		end
	end,
	obj = { 
		vobj(1, '窓', '東に面した大きな{窓}だ。'),
		'stoly',
		vobj(2, 'コンピュータ端末', 'テーブルにはそれぞれ17インチモニタが繋がった{端末}がある。'),
		'vent',
		'portrait',
	},
	way = { 'cor3' },
	exit = function()
		inv():del('stol');
	end
};

key = obj {
	nam = '鍵',
	dsc = '誰かがドアに{鍵}を挿したまま忘れているようだ。',
	tak = '俺はこっそりと鍵を抜いてポケットにしまった。',
	inv = '驚いたことに、たいていこの建物のドアは複雑な組み合わせの電子キーになっているのだが。',
};

room33 = room {
	nam = '部屋',
	pic = 'gfx/bholes.png',
	dsc = [[俺は数秒間ドアの前に立っていた。ドアを開けて中に入った。]],
	act = function(s, w)
		if w == 1 then
			return cat('厚みのある眼鏡をかけた白髪混じりの男が振り向いて俺をじっと見た。^^「誰だお前は？さっさと出て行け!!」^^',back());
		end
	end,
	obj = { 
		vobj(1, 'people', [[ドクターウェアを着た数人のグループが部屋の真ん中にあるホワイトボードの前に立ち、互いに議論しあっている。]]),
		'portrait',
		'key' 
		};
	way = { 'cor3' },
	exit = [[俺は静かにその部屋を出た。]];
};

room3x = room {
	nam = 'room',
	enter = function(s, f)
		if s._num == 2 then
			return [[俺はドアを少しだけ開けて隙間から中を覗き込んだ。
			正方形の部屋に窓が2つある。
			そこにいる全員が壁に沿って端末の前に座っている。
			俺は急いでドアを閉めた。]], false;
		end
		if s._num == 4 then
			return [[俺は冷たいドアノブを握って用心深くドアを開けた。^「シミュレーション実行中!!」^誰かの叫び声が中から聞こえた。俺はドアノブから手を離してドアを閉めた。]],
			false;
		end
		if s._num == 5 then
			ref(f).way:add('eroom');
			return walk('eroom'), false;
		end
		if s._num == 6 then
			return [[俺はゆっくりとドアを開けたが、中から奇妙な音が聞こえてきて、しかもだんだんとでかくなっていった。^
「おい、なんでドアを閉めてないんだ!!」^中から誰かが起こって叫んだ。俺は急いでドアを閉めた。]], 
			false;
		end
	end,
};

switch = obj {
	nam = 'スイッチ',
	dsc = function(s)
		local t
		if vent._off then
			t = '<<オフ>>になっている。';
		else
			t = '<<オン>>になっている。';	
		end
		return '部屋の入り口の隅に{スイッチ}がある。'..t;
	end,
	act = function(s)
		if vent._off then
			vent._off = false;
			return 'スイッチをオンにした！'
		end
		if not cor3._locked then
			return [[俺はスイッチをオフにしてその場を立ち去った。だがドアのひとつが突然開き、誰かの叫び声が硬い廊下に響き渡った。^
「な、なんじゃこりゃあ、まったくありえん!!今すぐスイッチを戻せ!!」^俺は慌ててスイッチに戻りオンにした。]];
		end
		vent._off = true;
		return 'スイッチをオフにした！';
	end
};

cor3 = room {
	nam = '3階の廊下',
	pic = 'gfx/cor3.png',
	enter = function(s, f)
		if f == 'floor3' then
			return '俺はカードリーダーにIDカードをかざした。赤い表示がしばらく点滅した後に緑になった。これで自由に入れる！';
		end
	end,
	dsc = '長い廊下が建物の端まで伸びている。天井の蛍光灯が薄暗い光を落とし、緑のカーペットが通路に敷かれている。',
	act = function(s, w)
		if w == 1 then
			return '俺はドアのひとつに向かって歩み寄り、小さなのぞき窓から中を覗いた。何人かが白衣を着て奇妙な機械のまわりを蜂のように忙しく動き回っていた。たぶんこの階にある部屋はどれも実験室だろう。';
		end
		if not tonumber(w) then
			return nil, false
		end
		if w == 3 then
			if s._locked then
				return 'このドアは鍵がかかっている。でかくはないが強烈な音が聞こえた。開けないほうがいい。';
			end
			return walk('room33');
		end
		if tonumber(w) >=2 and tonumber(w) <=6 then
			room3x._num = w;
			return walk('room3x');
		end
		if w == 7 then
			return '窓は南側に面している。とくに目を引くものはないが粉雪が窓ガラスに当たって流れている。';
		end
		if w == 8 then
			return '見学するのか？';
		end
	end,
	used = function(s, w, ww)
		if w == 1 or w == 2 or w == 4 or w == 5 or w == 6 then
			return '無理っぽいな。';
		end 
		if w == 3 and ww == 'key' then
			if s._locked then
				return 'すでに鍵がかかっている。';
			end
			s._locked = true;
			return '鍵穴に鍵を差し込んで2回まわしてロックした。俺は鍵を抜いてポケットに戻した。';
		end
	end,
	obj = {
		vobj(1, '白いドア', '右側にメタリックな{白いドア}が並んでいる。'),
		vobj(2, '重力', '左側にはプレートに{重力}と書かれたドアが並んでいる。'),
		vobj(4, 'シミュレーション', '{シミュレーション}、'),
		vobj(5, '特殊相対論効果','{特殊相対論効果}、'),
		vobj(3, 'ブラックホール', '{ブラックホール}、'),
		vobj(6, '擬似空間', '{擬似空間}。'), 
		vobj(7, '窓', '廊下の突き当たりに{窓}がある。'),
		vobj(8, 'トイレ', '窓の隣に{トイレ}がある。'),
		'switch',
		'portrait',
	},
	way = {'floor3', 'toilet3', 'toiletw'},
};

mylo = obj {
	nam = '石鹸',
	inv = function(s)
		if s._pena then
			return '泡のついた石鹸。';
		end
		return '石鹸。';
	end,
	dsc = '{石鹸}が洗面台の上に乗っている。',
	tak = 'ツルツルした石鹸を取った。一度手から滑って洗面台に落ちたが、また取ってポケットに入れた。';
};

sushka = obj {
	nam = 'ドライヤー',
	dsc = '手を乾かすハンド{ドライヤー}が壁に取り付けてある。',
	act = function(s,w)
		return 'ドライヤーに手をかざすと温かい空気が流れ出してきた。なぜだかデジャヴを感じる……。';
	end,
};

umyvalnik = obj {
	nam = '洗面台',
	dsc = '{洗面台}は入り口のそばにある。',
	act = function(s)
		if me()._mylo then
			me()._mylo = false;
			return '俺は顔についた石鹸の泡を洗い落とした。';
		end
		return '俺は塩素くさい水をがぶがぶを飲んだ。ああ、俺んちの近くの小川の水とはぜんぜん風味が違う。'; 
	end,
	used = function(s, w)
		if w == 'mylo' then
			mylo._pena = true;
			return '石鹸をぬるま湯に浸した。';
		end
	end
};

toilet3 = room {
	nam = 'トイレ',
	pic = 'gfx/toil3.png',
	dsc = 'トイレに入った。よくある造りだ。窓はない。白いタイルが貼られている。',
	act = function(s, w)
		if w == 2 then
			return 'どれも使用中だ。';
		end
		if w == 3 then
			return 'トイレに着た連中は等間隔で小用便器に並んでいる。個室はすべて塞がっていた。数人の男が順番を待っている。';
		end
	end,
	obj = { 
		'umyvalnik',
		'mylo',
		'tzerkalo',
		'sushka',
		vobj(2, '個室', 'このトイレには4つの{個室}がある。'),
		vobj(3, '人々', '何人かの{人々}が居合わせている。'),
	},
	way = { 'cor3' }, 
	exit = function()
		if me()._mylo then
			return '顔に泡をつけたまま行くのか？', false
		end
		objs():del('face');
	end
};

floor3 = room {
	nam = '3階ホール',
	pic = 'gfx/floor3.png',
	dsc = [[3階のホールはかなり広い。ベージュの壁に高い天井。]],
	act = function(s, w)
		if w == 1 then
			return '俺はじっと窓に目を凝らした。白い雪原が暗闇に続いている。俺はふつと自分が侵入者であることを思い出した。';
		end
		if w == 2 then
			if not s._unlocked then
				return '革と金属で装飾したドア。カードリーダーが備え付けてある。プレートには“レベル3　カテゴリ：応用物理”と書かれている。';
			end
			return walk('cor3');
		end
		if w == 3 then
			return 'かなり頑丈なドアであることは認めよう。すくなくとも俺の小屋のドアよりはな。ドアにはカードリーダーが備え付けてある。プレートには“レベル3　カテゴリ：ナノテクノロジー”と書かれている。';
		end
	end,
	used = function(s,w,ww)
		if ww ~= 'card' then
			return 'It won\'t help...';
		end
		if w == 2 then
			s._unlocked = true;
			s.way:add('cor3');
			return walk('cor3');
		end
		if w == 3 then
			return 'カードリーダーにIDカードをかざした。うるさいビープ音がして不許可のメッセージが出た。';
		end
	end,
	obj = { 
		vobj(1, '窓', '広い{窓}が西に面している。'),
		vobj(2, '茶色のドア', '茶色の{ドア}が窓の右側にある。'),
		vobj(3, '白いドア', '白い{ドア}が左側にある。'),
	},
	way = { 'lift' },
};

britva = obj {
	nam = 'カミソリ',
	dsc = '{カミソリ}が洗面台の上に乗っている。',
	tak = '誰も見てないように願ってカミソリをポケットに忍ばせた。',
	inv = 'カミソリ。少し錆びている。',
};

face = obj {
	nam = '顔',
	dsc = '鏡が俺の{顔}を写している。',
	act = function(s)
		local st = '';
		if me()._brit then
			st = 'よく剃れた。';
		elseif me()._mylo then
			st = '石鹸の泡をつけた。';
		end
		if galstuk._wear then
			st = st..'ついでにネクタイ。';
		end
		return 'これが鏡に写った俺の顔だ。'..st;
	end,
	used = function(s, w)
		if w == 'mylo' then
			if me()._brit then
				return 'すでに剃ってある。';
			end
			if not mylo._pena then
				return '石鹸は乾いている。';
			end
			if not have('britva') then
				return '俺は石鹸で顔を洗って汚れを落とした。おぉう。';
			end
			me()._mylo = true;
			return '俺は石鹸の泡を顔につけた。';
		end
		if w == 'britva' then
			if me()._brit then
				return 'すでに剃ってある。';
			end
			if not me()._mylo then 
				return '泡が必要だ。';
			end
			me()._brit = true;
			me()._mylo = false;
			return 'ヒゲを剃っている。それから顔を洗った。';
		end
	end
};

tzerkalo = obj {
	nam = '鏡',
	dsc = '{鏡}があるべきところに取り付けてある。もちろん洗面台の上だ。',
	act = function(s)
		local st = '';
		objs():add('face');
		if galstuk._wear then
			st = 'それ以外に……ちゃんとしたネクタイ。';
		end
		if me()._brit then
			return '憂鬱な表情だ。だがよく剃れてすっきりした顔だ。' .. st;
		end
		return '無精ヒゲを生やした顔が鏡の向こうからこっちを見ている。' .. st;
	end,	
};

toilet = room {
	nam = 'トイレ',
	pic = 'gfx/toil4.png',
	dsc = '広いトイレだ。白いタイル張りに黄色い壁、湿気と水が流れる音。木製のドアが廊下との間を仕切っている。',
	enter = function(s, f)
		if f == 'eroom' then
			return '俺は空調ダクトの穴に上った。ダクトの中はほこりにまみれている。頭上に明かりが見えるところに来るまで俺は空調システムの迷路をうろうろとさまよった。金属製のカバーを押し上げてトイレの床に出た。';
		end
	end,
	act = function(s, w)
		if w == 2 then
			return 'おお、ここに出れたのはラッキーだった。男子トイレだ。';
		end
		if w == 3 then
			return 'それにしても妙な空調システムだな。まあ、そのおかげで俺はここにいるわけだが。';
		end
	end,
	obj = { 
		vobj(2, '個室', 'ここのトイレには{個室}が2つしかない。'),
		'umyvalnik',
		'britva',
		'tzerkalo',
		'sushka',
		vobj(3, '金属メッシュ', '床の上に{金属メッシュ}のカバーがある。');
	},
	way = { 'eroom', 'cor4'},
	exit = function(s, t)
		if me()._mylo then
			return '顔に泡をつけたまま出るのか？', false
		end
		objs():del('face');
		if t ~= 'eroom' then
			return '俺は様子を見てトイレの外に出た。';
		end
	end
};

toiletw = room {
	nam = '女子トイレ',
	enter = function(s, w)
		return 'おっと、間違うところだった。', false;
	end
};

function room4x_hear()
	local ph = {
	[1] = '^「……不確定性原理により、粒子の座標と運動量を同時に測定することは不可能であり……」^',
	[2] = '^「……量子力学の理論により、ある瞬間の波動関数の収縮において量子システムの描画が観測可能な固有の状態になる要因となり、値が測定された……」^',
	[3] = '^「……波束の収縮は、観測者との相互作用の後の状態のうち、そのひとつを縮小させると思われる波動の事象である……」^',
	[4] = '^「……この理論は粒子の両方の値を知ることはできないと予言しており、EPRパラドックスの実験が見せたとおり未だ測定できていない……」^',

	[5] = '^「……局所性の原理は、一点で発生するいくつかの物理的作用は、別の場所においてはすぐには現実の要素に影響を与えないと述べている……」^';

	[6] = '^「……彼らは与えられた独自の実験について主張している。測定値が測定が行われる前にすでに知られているとすれば、現実世界には“現実の要素”のようななにかが存在するはずであり、測定結果を決定付けるものである……」^',

	[7] = '^「……多世界解釈は、普遍的な波動関数の客観的な実在を主張する量子力学のひとつの仮定である。しかし波動関数の崩壊の現実は否定しており、別々の過去と未来のすべての可能性がそれぞれの実際の“世界”または“宇宙”を現す実数であることを意味している……」^',

	[8] = '^「……エヴェレットの独自の理論にはキーになるアイデアがひとつ含まれている：組み込み観測者なしの時間発展系モデルの物理方程式は観測者を含めた系のモデリングに適応できる。コペンハーゲンの解釈が提唱している、観測によって起こる波動関数の収縮がない特殊な状態である……」^',

	[9] = '^「……粒子はこのようにもつれていると言われている。これは2つの量子の重ね合わせの状態と見ることができ、我々はこれらを状態1と状態2と呼ぶことにする……」^',

	[10] = '^「……アリスはZ軸に沿ってスピンを計ろうとしており、彼女は2つの可能性のうちひとつを得ることができる。つまり+zまたは-zである。おそらく+zを得るだろう。量子力学では系の量子状態が収縮して状態1になる。量子状態は系の上で実行した複数の測定値の確率を決定付ける。このケースでは、次にボブがZ軸に沿ってスピンを測定すると、その結果は100パーセントの確率で-zになる。相似的に、アリスが-zを測定した場合、ボブは+zを得ることになる……」^',
	};
	return ph[rnd(10)];
end

room4x = room {
	nam = 'room',
	enter = function(s, f)
		if s._num == 1 then
			return '俺は用心深くドアノブを握ってドアを開けようとした。……鍵がかかっている。'
			, false;
		elseif s._num == 2 then
			return '俺はドアに近寄って耳を済ませた。'..room4x_hear()..
			'な、何語をしゃべてるんだ……、入らないほうがよさそうだぞ。',
			false;
		elseif s._num == 3 then
			return '俺はドアに近寄って耳を済ませた。猛烈な勢いでなにごとかをまくしたてているやつがいる。近づかないほうがよさそうだ。', false;
		elseif s._num == 4 then
			return '俺はドアを開けて中に入り込んだ。12ペアの瞳が机に座って俺をじっと見つめた。もうひとつのペアの瞳は黒板の前に立った男のものだった。^「すいません、入るドア間違えちゃいましたぁ」^このシチュエーションではそれしか言えることがなかった。俺は照れたような表情を見せていそいそと外に出た。', false;
		elseif s._num == 5 then
			return '鍵がかかっている。', false;
		end
	end,
};

galstuk = obj {
	nam = function(s)
		if s._gal then
			return 'ネクタイ';
		end
		return '布切れ';
	end,
	inv = function(s, w)
		if not s._gal then
			s._gal = true;
			return '俺は布切れを調べているうちに、それが元はネクタイとして使われていたものだと分かった。'
		end
		if s._hot then
			if not s._wear then
				s._wear = true;
				return '俺はネクタイをキリリと締め上げた。';
			end
			return '俺はネクタイを絞めた。';
		end
		if s._mylo then
			return '石鹸にまみれている。';
		end
		if not s._water then
			return '汚れている！そんなもん身に付けたくない。';
		end
		if not s._hot then
			return '濡れている！そんなもん身に付けたくない。';
		end
	end,
	used = function(s, w)
		if s._wear then
			return '俺はネクタイを絞めた。';
		end
		if w == 'mylo' then
			if not mylo._pena then
				return '石鹸は乾いている。';
			end
			s._mylo = true;
			if not s._gal then
				s._gal = true;
				return '布切れに石鹸をこすりつけているうちに、俺はこれがネクタイだということに気がついた。';
			end
			return '俺はネクタイに石鹸をこすりつけた。';
		end
	end,
	use = function(s, w)
		if s._wear and w ~= 'hand' then
			return 'ネクタイを締めた。', false;
		end
		if w == 'umyvalnik' then
			if not s._mylo  then
				return '水だけでか？それだけじゃ布についたチョークは落ちない気がするが。';
			end
			s._water = true;
			s._mylo = false;
			return '俺はネクタイをぬるま湯で洗った。';
		end
		if w == 'sushka' then
			if not s._water then
				return '別に乾かさなくても濡れてはいないと思う。';
			end
			s._hot = true;
			s._water = false;
			return '5分ほど乾かすとネクタイはきれいに仕上がった。';
		end
	end
};

room46 = room {
	nam = '講義室6',
	pic = 'gfx/room4.png',
	enter = '俺はドアを開けて中に入った。部屋の中には誰もいなかった。',
	dsc = '講義室の中にいる。黒板に向けてテーブルが2列に並んでいる。',
	act = function(s, w)
		if w == 1 then
			if not have('galstuk') then
				inv():add('galstuk');
				return '黒板に布切れを見つけた。俺はそれを取った。';
			end
			return 'なにか記号の羅列が書かれているようだが、うーん、とても理解できん。';
		end
		if w == 2 then
			return 'サーチライトの光が雪原の上をすべるように走っているのが見えた。';
		end
		if w == 3 then
			return '俺はキーボードの前に座った。昔に覚えた知識を呼び戻そうとしたが無理だった。俺はもうハッカーじゃない。森に暮らす住民だ。';
		end
	end,
	obj = {
		vobj(3,'端末', 'すべてのテーブルの上に{端末}が乗っている。');
		vobj(1,'黒板', '{黒板}に奇妙な数式がうねうねと書かれている。'),
		vobj(2,'窓', '{窓}は東に面している。'),
		'portrait',
	},
	way = { 'cor4' },
};

facectrl = dlg {
	nam = '顔認証システム',
	pic = 'gfx/guard4.png',
	dsc = '感じの悪い、あからさまに意地の悪そうな顔をした太った警備員がいる。',
	obj = {
		[1] = phr('ベリン氏の講義を聞きに来たんだが。',
		'「見ない顔だな。お前は誰だ？」^警備員はニヤリと笑った。^「まともなやつしか中に入れないようにと言われてるんでな」',
		[[pon(2);]]),

		[2] = _phr('俺は招待状を持ってるぞ！', 
		'「知ったことか！自分の姿を鏡で見てみろ！ベリン氏の講義を聞きに来ただと？」^警備員はベリンの名前を口にして一瞬だけ迷ったが、^「ともかく出て行け！」',
		[[pon(3,4)]]),

		[3] = _phr('お前の顔に蹴りを入れてやる！', '「へえ。やってみろ」力強い腕が俺をつかんで廊下に放り出した。バラバラにされなかったのはラッキーかもしれん。',
		[[poff(4)]]),

		[4] = _phr('このイボイノシシ野郎！招待状を持ってるって言ってるだろうが。',
			'「なんだとお!?」警備員の目が充血してきた。強力なキックで廊下に蹴り出された。最悪だ……。',
		[[poff(3)]]),

		[5] = _phr('ベリン氏の講義を聞きたいんだが。',
		'「まず言っとくが、ベリン“博士”だ。それから、ネクタイなしじゃ入れてやれん」',
		[[pon(2)]]),

		[6] = _phr('ベリン博士の講義を聞きたい。とても聞きたいっ！',
		'警備員は怪しい人物を見るような視線で俺をまじまじと眺めた挙句、気が乗らないような口調で言った。「ふん。招待状を見せろ」',
		[[pon(7)]]),

		[7] = _phr('うぬぬ、こ、このブ……郎……招待状です。', '「ふん。オーケー、さっさと入れ。講義はもうはじまってるぞ」',
		[[inv():del('invite'); return walk('hall42')]]);
	},
	exit = function(s,w)
		s:pon(1);
	end
};

hall42 = room {
	nam = 'ホール2',
	pic = 'gfx/hall2.png',
	dsc = '大勢の人が椅子に座っている。静かだ。講義がはじまっているらしい。',
	obj = {
		vobj(1, 'ベリン', '黒板の前に立っている男が{ベリン}だ！俺の猫をさらっていったやつ。'),
		vobj(2, '椅子', '3番目の列に空いている{椅子}があるようだ。'),
		vobj(3, '窓', '3つの広い{窓}が西に面している。'),
		vobj(4, '照明', 'ホールは蛍光灯の{照明}で照らされている。'), 
	},
	act = function(s, w)
		if w == 1 then
			return '彼は俺が見たようなコートも着ていないし帽子も被っていない。ここまで近づけば彼の姿を詳しく見ることができる。とても太っているが背は高い。ずる賢そうな微笑だが実直そうな顔つきをしている。彼は講義を続けていた。俺は彼に話しかけるのを講義が終わるまで待つことにした。';
		end
		if w == 2 then
			return walk('lection');
		end
		if w == 3 then
			return '外は暗くてなにも見えない。蛍光灯の明かりに照らし出された白い粉雪だけがときおり流れる。';
		end
		if w == 4 then
			return '蛍光灯が6つ。俺はこのチラつく光源が嫌いだ。';
		end
	end,
	exit = function(s, t)
		if t == 'cor4' then
			return 'ベリンをここで見失うわけにはいかない。', false;
		end
	end,
	enter = function(s, f)
		if f == 'facectrl' then
			return '講義室に入った。';
		end
		if not galstuk._wear then
			facectrl:pon(5);
			facectrl:poff(1);
		end
		if not me()._brit or not galstuk._wear then
			return cat(
'俺は講義室に入ろうとした。だが見知らぬ男が俺を引きとめた。名札の上に警備と書いてある。彼はショットガンを持っている。^^', walk('facectrl')), false;
		end
		facectrl:poff(1, 5);
		facectrl:pon(6);
		return walk('facectrl'), false;
	end,
	way = { 'cor4' },
};

hall41 = room {
	nam = 'ホール1',
	dsc = [[俺は誰もいないホールに入った。広い講義室のひとつのようだ。部屋の前から後ろの壁まで、何列にも並んだ椅子が天井に届くまで段々に並んでいる。]],
	pic = 'gfx/hall1.png',
	act = function(s, w)
		if w == 1 then
			return 
'外の暗闇を見て、俺は憂鬱そうな表情をしたバルシクを思い浮かべた。';
		end
		if w == 2 then
			return 'そんなふうに考えていた時期が俺にも……。いや、なんでもない。';
		end
		if w == 3 then
			return '俺はすべてを思い出せる……忘れちまった。';
		end
	end,
	obj = {
		vobj(1, '窓', '大きな{窓}が3つ、西側に面している。'),
		vobj(2, 'テーブル', '長い{テーブル}が黒板のそばに据えてある。'),
		vobj(3, '黒板', '以前の講義で説明に使われたらしい数式が{黒板}にぎっしりと書かれている。'),
		'portrait',
	},
	way = {
		'cor4',
	},
};

cor4 = room {
	nam = '4階の廊下',
	pic = 'gfx/cor4.png',
	dsc = '俺は廊下にいる。天井が高い。廊下の突き当たりにトイレが見える。通路には緑のカーペットが敷かれている。',
	act = function(s, w)
		if not tonumber(w) then
			return;
		end
		if w == 11 then
			return '何人かはホール2に向かっているようだ。';
		end
		if w == 1 then
			return '俺は憂鬱になりながら暗い窓の外を見た。かなり疲れているかもしれない。だが最後までやり遂げねばな。';
		end
		if w == 12 then
			return 'このドアにはほかのと同じようにカードリーダーが備え付けられている。赤い表示が点灯している。';
		end
		if tonumber(w) >=5 and tonumber(w) <=9 then
			room4x._num = w - 4;
			return walk('room4x');
		end
		if w == 10 then
			ways():add('room46');
			return walk('room46');
		end
		if w == 2 then
			ways():add('hall41');
			return walk('hall41');
		end
		if w == 3 then
			ways():add('hall42');
			return walk('hall42');
		end
	end,
	used = function(s, w, ww)
		if w == 12 and ww == 'card' then
			return 
			'俺はIDカードをリーダーにかざした。ビープ音が鳴った。“不許可”だ。';
		end
	end,
	obj = {
	vobj(1, '窓', '南に向いた{窓}がある。'),
	vobj(2, 'ホール1','西側に大きめのドアが2つある。{ホール1}、'),
	vobj(3, 'ホール2', '{ホール2}。'),
	vobj(5, '講義室1', '西側に少し大きめのドアが並んでいる。ドアのプレートには{講義室1}、'),
	vobj(6, '講義室2', '{講義室2}、'),
	vobj(7, '講義室3', '{講義室3}、'),
	vobj(8, '講義室4', '{講義室4}、'),
	vobj(9, '講義室5', '{講義室5}、'),
	vobj(10, '講義室6', '{講義室6}とある。'),
	vobj(11, '人々', 'ときどき廊下を行き来する{人々}を見かける。'),
	vobj(12, '前面ドア', '廊下の北の端に{ドア}がある。'),
	'portrait',
	},
	way = {
		'toilet',
		'toiletw',
	}
};
floor4 = room {
	nam = '4階ホール',
	pic = 'gfx/floor4.png',
	dsc = '4階ホールの天井は高い。',
	act = function(s, w)
		if w == 1 then
			return '暗闇……まったく光がない。星すらも見えない。ぼんやりと光る大きな蛍光灯が外を照らしているのだが。';
		end
		if w == 2 then
			return 'エレベータなんか嫌いだ……。';
		end
		if w == 3 or w == 4 then
			return 'よくあるドアだ。この建物のどこにでもある。電子錠が備え付けてある。IDカードがないと入れないだろう。';
		end
	end,
	used = function(s, w, ww)
		if ww == 'card' then
			if w == 3 or w == 4 then
				return [[俺はIDカードをリーダーにかざした。ビープ音が鳴った。進入不許可だそうだ。]];
			end
		end
	end,
	obj = {
		vobj(1, '窓','広い{窓}が西に面している。'),
		vobj(2, 'エレベータ', '4つの{エレベータ}が並ぶホールに薄暗くライトが灯っている。'),
		vobj(3, '南のドア', '廊下の北と南にそれぞれドアがある。南の{ドア}のプレートには“レベル4　カテゴリ：理論物理”と書かれている。'),
		vobj(4, '北のドア', '北の{ドア}のプレートには“レベル4　カテゴリ：生物学”と書かれている。'),
	},
	way = { 'lift' },
};

floor5 = room {
	nam = '5階ホール',
	pic = 'gfx/floor5.png',
	dsc = [[5階の天井はとても高い。]],
	act = function(s, w)
		if w == 1 then
			return '俺の足が赤いベルベットのカーペットの上をなぞって足跡をつけている。ここで足跡を残さないように注意しないと。';
		end
		if w == 2 then
			return 'ああ、クリスタル製だろう。ガラスではなさそうだ。';
		end
		if w == 3 then
			return '俺は窓に近づいた。ほう、この窓からは広い屋根が見渡せる。屋根は建物の正面に伸びている。';
		end
		if w == 4 or w == 5 then
			return '警備員がいるのでドアを調べることは無理なようだ。それに俺のIDカードはこの階では使えない。';
		end
		if w == 6 then
			return '警備員はまだ俺に気付いていないようだ。注意を引かないほうがいいだろう。';
		end
	end,
	used = function(s, w)
		if not tonumber(w) then
			return
		end
		if w == 6 then
			return '警備員に見咎められるのでやめよう。';
		end
		if w >=1 and w <=5 then
			return '警備員がいるので行けない。';
		end
	end,
	obj = {
	vobj(1, 'カーペット', '床は一面赤い{カーペット}が敷かれている。'),
	vobj(2, 'シャンデリア', 'クリスタルの{シャンデリア}が頭上に下がっている。'),
	vobj(3, '窓', '広めの{窓}が西に面している。'),
	vobj(4, '情報', '廊下の北と南にそれぞれドアがある。南の{ドア}のプレートには“レベル5　カテゴリ：情報”と書かれている。'),
	vobj(5, '赤いドア', '北の{ドア}にはプレートが貼られていない。赤い革で装飾が施された、どっしりとした重そうなドアだ。'),
	vobj(6, '警備員', 
		'ドアに続く通路の手前には警備員の机が立ちはだかっている。');
	},
	way = { 'lift' },
};

