mywear = obj {
	nam = 'キルティングコート',
	dsc = function(s)
		if here() == stolcorridor then	
			local st='';
			if not have('gun') then
				st = 'その下に俺のショットガンを隠している。';
			end
			return 'さらにハンガーに俺の{キルティングコート}がかかっている。'..st;
		else
			return 'ドアに取り付けてあるフックには{キルティングコート}がかかっている。';
		end
	end,
	inv = '今は冬だが俺はキルティングコートを着ている。',
	tak = function(s)
		if here() == stolcorridor then
			if have('alienwear') then
				return 'すでに着ている。脱いだら怪しまれるだろう。', false;
			end
			if me()._walked then
				me()._walked = false;
				inv():add('gun');
				return 'だがキルティングコートは最高！';
			end
			return 'それもまた怪しく見えるんじゃないか……。', false;
		else
			return 'フックから俺のコートを取った。';
		end
	end, 
	use = function(s, o)
		if o == 'guy' then
			return '俺は少し躊躇したが、着ているコートを交換してやった。';
		end
	end
};

money = obj {
	nam = '現金',
	inv = '大金は人間をダメにする。俺は貧乏でよかった……。',
	use = function(s, w)
		if w == 'shopman' then
			if shopman._wantmoney then
				shopman._wantmoney = false;
				return 'ウラジミールに代金を払った。';
			end
			return '別に払うものはないと思うが……。';
		end
	end
};

mybed = obj {
	nam = 'ベッド',
	dsc = '窓のそばに{ベッド}がある。',
	act = '寝てる場合じゃないぞ。',
};

mytable = obj {
	nam = 'テーブル',
	dsc = '左の隅に引き出し付きのオークの{テーブル}がある。',
	act = function()
		if not have(money) then
			take('money');
			return '引き出しの中を引っ掻き回して金を見つけた。';
		end
		return 'このテーブル……俺が作ったんだ。';
	end,
};

foto = obj {
	nam = '写真',
	dsc = 'テーブルの上にフレームに入った{写真}がある。',
	tak = '俺は写真を取った。',
	inv = 'この写真には俺とバルシクが写っている。',
};

gun = obj {
	nam = 'ショットガン',
	dsc = '部屋の隅に{ショットガン}がある。',
	tak = '俺はショットガンを取り背中に吊るした。',
	inv = function(s)
		local st = '';
		if s._obrez then
			st = 'さっきヤスリで銃身を短くしたものだ。';
			if s._hidden then
				st = st..'上着の内側に隠している。';
			end
		end
		if s._loaded then
			return '弾が装填されている。'..st;
		else	
			return '弾が装填されていない……。森の中ではいつも使っていたものだが。'..st;
		end
	end,
	use = function(s, w)
		if not s._loaded then
			return '装填していない……', false;
		end
		if w == '警備員' then
			return 'ああ、こいつらは悪党に違いない。しかしそれ以前にこいつらも人間なわけで、そんなことをしても解決にならないだろう……。', false;
		end
		if w == 'ワイヤー' then
			return 'ワイヤーカッターのようなものが必要だな……。', false;
		end
		if w == 'cam' and not cam._broken then
			cam._broken = true;
			s._loaded = false;
			return 'カメラを狙って弾を二発とも撃った……。鈍い銃声が吹雪の中に消えた……。';
		end
		if not s._hidden then
			if w == 'mywear' or w == 'alienwear' then
				if not s._obrez then
					return '俺はショットガンを服の中に隠そうとしたが、銃身が長すぎて無理なようだ。'
				else
					s._hidden = true;
					return '銃身を短くしたショットガンをうまく隠すことができた。';
				end
			end
		end
		if w == 'mycat' or w == 'shopman' or w == 'guy' then
			return 'そりゃ俺の考えていることと違うな。', false;
		end
	end
};

fireplace = obj {
	nam = '暖炉',	
	dsc = '壁に{暖炉}がある。ゆれる炎が部屋の中を照らしている。',
	act = '俺は長い冬の夜を暖炉の前で過ごすのが好きだ。',
};

mycat = obj {
	nam = 'バルシク',
	_lflast = 0,
	lf = {
		[1] = 'バルシクがボストンバックの中で動いている。',
		[2] = 'バルシクがボストンバックの中から見つめている。',
		[3] = 'バルシクがボストンバックの中でのどを鳴らしているようだ。',
		[4] = 'バルシクがボストンバックの中で震えている。',
		[5] = 'ボストンバックの中にいるバルシクの暖かい体温を感じた。',
		[6] = 'バルシクはボストンバックから身を乗り出してまわりを見回した。',
	},
	life = function(s)
		local r = rnd(6);
		if r > 2 then
			return;
		end 
		r = rnd(6);
		while (s._lflast == r) do
			r = rnd(6);
		end
		s._lflast = r;
		return s.lf[r];
	end,
	desc = { [1] = '俺の小さなユキヒョウ、{バルシク}が暖炉の前で丸くなって眠っている。',
		 [2] = '{バルシク}は小屋のまわりの様子を観察した。',
		 [3] = '{バルシク}が前の座席に座っている。',
		 [4] = '{バルシク}がゴミバケツを熱心に研究しているようだ……。',
		 [5] = '{バルシク}が俺の脚にまとわりついている。',
	},
	inv = '俺のかわいい仔猫、バルシクがボストンバックの中にいる。絶対守ってやるからな。お前と、それからこの世界をな！',
	dsc = function(s)
		local state
		if here() == home then
			state = 1;
		elseif here() == forest then
			state = 2;
		elseif here() == inmycar then
			state = 3;
		elseif here() == village then
			state = 4;
		elseif here() == escape3 then
			state = 5;
		end
		return s.desc[state];
	end,
	act = function(s)
		if here() == escape3 then
			take('mycat');
			lifeon('mycat');
			return 'バルシクをボストンバックに押し込んだ。';
		end
		return '俺はバルシクの耳の後ろをかいてやった……。';
	end,
};

inmycar = room {
	nam = '車の中',
	dsc = '車の中にいる。役に立つ俺の足だ。',
	pic = 'gfx/incar.png',
	way = {'forest', 'village'},
	enter = function(s, f)
		local s = '車のドアを開けた。';
		if have('mybox') then
			return 'この箱を持ったままじゃ乗れないな……。', false;
		end
		if seen('mycat') then
			s = s..'バルシクが車に飛び乗った。'
			move('mycat','inmycar');
		elseif not me()._know_where then
			return 'いいや、先にバルシクを探さないと！', false
		end
		if f == 'guarddlg' then
			return 'うーん……なにか別の方法を考えたほうがよさそうだ。';
		end
		return cat(s, 'じゃあ行くとするか。');
	end,
	exit = function(s, t)
		local s=''
		if seen('mycat') then
			s = 'バルシクが俺より先に車から飛び出た。';
			move('mycat',t);
		end
		if ref(t) ~= from() then
			from().obj:del('mycar');
			move('mycar', t);
			return [[
車はしぶしぶエンジンを回し始めた……。長い道のりを行って、俺はエンジンを切りドアを開けた……。]]..s;
		end
		return 'おい待て、なにか忘れてることがないか？'..s;
	end
};

mycar = obj {
	nam = '俺の車',
	desc = {
	[1] = '小屋の前には俺のトヨタの{ピックアップトラック}がある。',
	[2] = '駐車場に俺の{ピックアップトラック}がある。',
	[3] = '検問所のそばに俺の{ピックアップトラック}がある。',
	[4] = '角の後ろに俺の{ピックアップトラック}がある。',
	},
	dsc = function(s)
		local state
		if here() == forest then
			state = 1;
		elseif here() == village then
			state = 2;
		elseif here() == inst then
			state = 3;
		elseif here() == backwall then
			state = 4;
		end
		return s.desc[state];
	end,
	act = function(s)
		return walk('inmycar');
	end
};

iso = obj {
	nam = '絶縁テープ',
	inv = '絶縁テープだ。ビニルテープともいうが。色は青。',
	use = function(s, o)
		if o == 'trap' and not trap._iso then
			trap._iso = true;
			return '罠にテープを巻いた。';
		end
		if o == 'wire' then
			return 'なんのために？そんなことをしても有刺鉄線を潜り抜けられないし、絶縁するのは無理だ。その前に感電してしまうぜ！';		end
	end
};

trap = obj {
	nam = '罠',
	dsc = '草むらに鉄製の{罠}がある。', -- !!!!
	tak = 'また密猟者か！俺は罠を拾い上げた。',
	inv = function(s)
		if s._salo then
			return 'しかしでかいネズミ捕りだな！さっき絶縁テープを巻いた。';
		end
		if s._iso then
			return '鉄製だ。刃は鋭い。絶縁テープを巻いてある。';
		else
			return '鉄製だ。刃は鋭い。';
		end
	end,
	use = function(s, o)
		if o == 'wire' and not wire._broken then 
			if not s._iso then
				return '罠は鉄でできている。俺は感電死してしまうだろう。一貫の終わりだ。';
			end
			wire._broken = true;
			onwall.way:add('eside');
			return '俺は用意した罠の刃でワイヤを挟んだ。予想どおりワイヤを切ることができた！';
		end
	end
};

deepforest = room {
	i = 0,
	nam = '森の奥',
	pic = 'gfx/deepforest.png',
	dsc = function(s)
		local st = '深い森の中にいる……。';
		if s._i == 1 then
			return st..'松とモミの木が並んでいるだけだ……。';
		elseif s._i == 2 then
			return st..'美しいシラバカの木だ。ここで迷子にならないようにしないと……。';
		elseif s._i == 3 then
			return st..'通り抜けられない雑木林だ。俺は遭難したのか？';
		elseif s._i == 4 then
			return st..'美しい湖に出た。戻るべきか？';
		elseif s._i == 5 then
			s._trap = true;
			return st..'森のやぶが続いている。';
		else
			return st..'切り株がある。美しい切り株。';
		end
	end, 
	enter = function(s,f)
		if f == 'forest' then
			s._trap = false;
		end
		s._lasti = s._i;
		while (s._i == s._lasti) do
			s._i = rnd(6);
		end
		s.obj:del('trap');
		s.way:del('forest');
		if s._i == 5 and not inv():srch('trap') then
			s.obj:add('trap');
		end
		if s._i == 3 and s._trap then
			s.way:add('forest');
		end
		if f == 'forest' and inv():srch('trap') then
			return [[ありがとよ。俺はすでに森の中を歩いてるぜ。]], false;
		end
		if f == 'deepforest' then
			return 'さて、どっちに行けば……。';
		end
		return [[森の中に入るのか？歩いて？
ああ、まあそれが俺の仕事だからな。密猟者がいたら追い払えるしな……。]], true;
--Я пол часа бродил по лесу, когда наткнулся на капкан...
--Проклятые браконьеры! Я взял капкан с собой.]], false;
	end,
	way = {'deepforest'},
};

road = room {
	nam = '道路',
	enter = function()
		return '歩いていくのか？やめてくれ……', false;
	end
};

forest = room {
	nam = '丸太小屋の前',
	pic = 'gfx/forest.png',
	dsc = [[丸太小屋の前にはあらゆるものに雪が吹き溜まっている。深い森が小屋を取り囲んでいる。町へ続く道路も深い雪で覆われている。]],
	way = { 'home', 'deepforest', 'road' },
	obj = { 'mycar' },
};

home = room {
	nam = '小屋の中',
	pic = function(s)
		if not seen('mycat') then
			return "gfx/house-empty.png"
		end
		return "gfx/house.png";
	end,
	dsc = [[
この小さな小屋で10年暮らした。10年前に自分の手でこれを建てた。狭苦しいが俺にとっては居心地がいい。]],
	obj = { 'fireplace', 'mytable', 'foto', 'mycat', 'gun', 
	vobj(1,'window', 'キャビンには{窓}がひとつだけある。'), 
	'mybed', 'mywear' },
	way = { 'forest' },
	act = function(s,o)
		if o == 1 then
			return '窓の外はすべてが真っ白だ……。';
		end
	end,
	exit = function()
		if not have('mywear') then
			return '外は寒いだろう……。キルティングコートなしで外に出たくないな。', false
		end
		if seen(mycat) then
			move('mycat','forest');
			return [[俺が外に出ると、バルシクが不意に起き上がって走り寄ってきた。俺は耳の後ろをかいてやった。「お前も一緒に行くか？」]]
		end
	end
};
---------------- here village begins
truck = obj {
	nam = '黒い車',
	dsc = '店の前に窓ガラスもボディも{黒い車}が止まっている。',
	act = 'この車……装甲が施されたバンだな。タイヤにかかっている重さで分かる。',
};

guydlg = dlg {
	pic = 'gfx/guy.png',
	nam = 'ホームレスとの会話',
	dsc = 'ホームレスに近づくと彼は振り向いてこっちを見た。古いキルティングコートを着て帽子をかぶっていて、身長は低い。',
	obj = {
		[1] = phr('よう、寒くないか？', '「ああ……まあな」'),
		[2] = phr('通りからここまでどうやって来たんだ？', 
[[「俺は博士号を取るために働いていたんだ……物質の構造の論文を書いてた……神経がまいってしまって……俺は落ち着こうとした……それでここにいる……」]]),
		[3] = phr('あんたの名前は？', 'エドワルド……'),
		[4] = _phr('俺が店に入ったとき、あんたのそばに猫がいたよな。どこにいったか見なかったか？', '「ええ……ああ」', 'pon(5)'),
		[5] = _phr('ああ、オス猫だ。ふつうの猫でゴミバケツのまわりをうろうろしてたんだが。', '「あれ、あんたの猫だったのか？うーん……」', 'pon(6)');
		[6] = _phr('あれは俺の猫なんだ。教えてくれ！', 
'「ええ……。男が猫を捕まえていったと思うよ。んー、あー背中が寒い。」', 'pon(7)'),
		[7] = _phr('どこだ？どこに行ったんだそいつは？', '「すまんなぁ……見てなかったもんで」', 'shopdlg:pon(4); pon(8);'),
		[8] = phr('いや、もういい。', '……。', 'pon(8); back()'),
	},
	exit = function()
		pon(1);
		return '彼は後ろを向いてまたゴミバケツを漁るのに戻った……。';
	end
};

guy = obj {
	nam = 'ホームレス',
	dsc = '{ホームレス}がゴミバケツを引っ掻き回している。',
	act = function()
		return walk('guydlg');
	end,
	used = function(s, w)
		if w == '現金' then
			return [[
俺は彼に近寄って金を差し出した。だが彼は断り、「俺は他人の金をほしがったりしないよ……」]];
		else
			return 'こいつにそれが必要とも思えないんだが。';
		end
	end,
};

nomoney = function()
	pon(1,2,3,4,5);
	shopdlg:pon(2);
	return cat('気がついたのだが、部屋から金を持ってくるのを忘れた。小銭すら持っていない。^',back());
end

ifmoney ='if not have("money") then return nomoney(); end; shopman._wantmoney = true; ';

dshells = obj {
	nam = '薬莢',
	dsc = function(s)
		-- Note for translators: 
		-- this block picks the appropriate plural form 
		-- for “shells” for a given numeral. Since English has 
		-- only 1 form, I commented it out. 
		-- Uncomment and use form-number combinations
		-- appropriate for your language 
		-- if here()._dshells > 4 then
			return '足元に空になったショットガンの{薬莢}が'..here()._dshells..'個転がっている。';
		-- else 
			-- return '足元に空になったショットガンの{薬莢}が'..here()._dshells..'個転がっている。';
		-- end
	end,
	act = 'そいつらはもう必要ない。';
};

function dropshells()
	if here() == deepforest then
		return;
	end
	if not here()._dshells then
		here()._dshells = 2;
	else
		here()._dshells = here()._dshells + 2;
	end
	here().obj:add('dshells');
end

shells = obj {
	nam = 'カートリッジ',
	inv = 'ショットガンの弾倉。俺はたまにしか使わないが、たいていは密猟者から身を守るためのものだ。',
	use = function(s, on)
		if on == 'gun' then
			if gun._loaded then
				return 'すでに装填されている。';
			end
			if gun._loaded == false then
				gun._loaded = true;
				dropshells();
				return 'ショットガンを開いて弾を2発込め、リロードした。';
			end
			gun._loaded = true;
			return 'カートリッジを2つ取り、ツインバレルのショットガンに装填した。';
		end
	end
};

news = obj {
	nam = '新聞',
	inv = [[
今日の新聞。“最近森林の中に建てられた量子技術研究所が、頻発する異常現象との関連性を否定。”……だと。へえ。]],
	used = function(s, w)
		if w == 'poroh' then
			if have('trut') then
				return 'すでに導火線を持っている。';
			end
			inv():add('trut');
			inv():del('poroh');
			return '新聞紙に火薬を注いで巻いた。';
		end
	end,
};

hamb = obj {
	nam = 'ハンバーガー',
	inv = function()
		inv():del('hamb');
		return 'おやつを食べた。ジャンクフードだが。';
	end
};

zerno = obj {
	nam = '穀物',
	inv = 'ただの穀物だ。そば粉の元だ。',
};

shop2 = dlg {
	nam = '買う',
	pic = 'gfx/shopbuy.png',
	obj = { 
	[1] = phr('ショットガンのカートリッジと火薬をくれ', '「ほい、値段はいつもどおりな」', ifmoney..'inv():add("shells")'),
	[2] = phr('ええっと、穀物だな……', '「いいとも」', ifmoney..'inv():add("zerno")'),
	[3] = phr('それからハンバーガーをくれ。', '「分かった」', ifmoney..'inv():add("hamb")'),
	[4] = phr('新聞も', '「もちろんあるよ」', ifmoney..'inv():add("news")'),
	[5] = phr('それと絶縁テープを一本欲しい。', '「さあどうぞ」', ifmoney..'inv():add("iso")'),
	[6] = phr('ほかに欲しいものはない。', '「おおせのとおりに」', 'pon(6); back()'),
	[7] = _phr('ハシゴとワイヤーカッターが欲しいんだが。', '「すまんな、それは在庫がないんだ」^ウラジミールは顔を振りながら言った。'), 
	},
	exit = function(s)
		if have('news') then
			s.obj[4]:disable();
		end
	end
};

shopdlg = dlg {
	nam = '店員との会話',
	pic = 'gfx/shopman.png',
	dsc = '小さな目がじっと俺を見つめた。',
	obj = {
	[1] = phr('おう、ウラジミール！商売の調子はどうだ？', '「やあ、いらっしゃい。まあぼちぼちってところだな」^ウラジミールはニヤリと笑ってみせた。', 'pon(2)'),
	[2] = _phr('買いたいものがある。', '「オーケー、なにがいる？」', 'pon(2); return walk("shop2")'),
	[3] = phr('じゃあまたな。', '「まいどあり。気をつけてな」', 'pon(3); return back();'),
	[4] = _phr('さっきここにいた男、あれは誰だ？', '「ああん？」^ウラジミールの細い眉毛が少しだけ持ち上がった……。','pon(5)'),
	[5] = _phr('なぜだか知らんが俺の猫を盗んでいきやがった……。最初はホームレスかと思ったが、グレーのコートを着たやつだ。あれはいったい誰だ？',
[[
「実はな、彼はあそこのお偉いさんらしい」^
ウラジミールはヒゲを剃っていない自分のあごをゴシゴシとかきながら言った。^
「あの新しい研究所のさ、数年前に森の奥に建ったやつな……」^
ウラジミールの鼻の上に乗った眼鏡がピクピクと動いた。^
「あいつはたまにこの店に来るが、人に会うのは嫌いらしい。^　あいつら物理学者どもは……分かるだろ？奇妙な集団だしな」^
そう言って肩をすくめた……。]],'pon(6)'),
	[6] = _phr('その研究所はどこに建ってるんだ？', 
'「127番の道路標識あるところさ。でもな、知ってるかもしれんが、」^ウラジミールは声を落とした。^「あの研究所にはいろいろと妙な噂があってな……」', 'me()._know_where = true; inmycar.way:add("inst");pon(7)'),
	[7] = _phr('俺はただ猫を取り戻したいだけだ。', '「気をつけてな……。ワシもついていけたらいいんだが」^ウラジミールは顔を横に振った。^だが突然思い出したように「おお、そういえばやつの名前はベリンだ。前にクレジットカードを見たことがある。でもな、とてもあいつらを受け入れる気にはなれん」^ウラジミールの唇がもぐもぐと動き、それに合わせて眼鏡も揺れた。'),
	},
};

shopman = obj {
	nam = '店員',
	dsc = 'カウンターの向こうに{店員}がいる。でかい顔のあごに無精ヒゲが生え、鼻眼鏡をかけている。',
	act = function()
		return walk('shopdlg');
	end
};

shop = room {
	nam = '店',
	pic = 'gfx/inshop.png',
	enter = function(s, f)
		if village.obj:look('truck') then
			village.obj:del('truck');
			village.obj:del('mycat');
			return [[
店の中に入ると、つばの広い帽子を被ってグレーのコートを着たいやな感じの男がいた。彼はかすれるような声で謝り、帽子のつばを上げるふうな仕草をしてみせた。やけに白い歯が帽子の下に見えた。俺がカウンターに歩み寄ったとき外でエンジンの音がするのが聞こえた。]];
		end
	end, 
	act = function(s,w)
		if w == 1 then
			return '広い駐車場に俺の車だけが残されている。';
		end
	end,
	dsc = [[
この店はちょっと風変わりで、工具や鍋にフライパン、食品に加えて弾薬なども売っている。この辺で100キロ四方にはこの店しかないからだろう。]],

	way = { 'village' },
	obj = {'shopman',vobj(1, 'окно', '{窓}の外には広い駐車スペースが見える。') },
	exit = function(s, t)
		if t ~= 'village' then
			return;
		end
		if shopman._wantmoney then
			return '俺は外に出ようとしたが、ウラジミールに呼び止められた。ああ、金を払うのを忘れていた。', false;
		end
		if not have('news') then
			shop2.obj[4]:disable();
			inv():add('news');
			return '店を出ようとしたが、ウラジミールに呼び止められた。^「おいおい、新聞をもってゆけよ。タダでいい」^俺はカウンターまで引き返して新聞を受け取ってから店を出た。';
		end
	end
};

carbox = obj {
	_num = 0,
	nam = function(s)
		if s._num > 1 then
			return '箱がいくつか車に載っている。';
		else
			return '箱がひとつ車に載っている。';
		end
	end,
	act = function(s)
		if inv():srch('mybox') then
			return 'すでに箱を抱えて両手が塞がっている。';
		end
		s._num = s._num - 1;
		if s._num == 0 then
			mycar.obj:del('carbox');
		end
		take('mybox');
		return '車から箱をひとつ取り出した。';
	end,
	dsc = function(s)
		if s._num == 0 then
			return;
		elseif s._num == 1 then
			return '^{箱}がひとつ車の荷台に積んである。';
		-- Again not needed, since "boxes" stays the same for all numerals
		-- elseif s._num < 5 then
		--	return 'There are '..tostring(s._num)..' {boxes} in the cargo body of my car.';
		else	
			return '^{箱}が'..tostring(s._num)..'個、車の荷台に積んである。';
		end
	end,
};

mybox = obj {
	nam = '箱1個',
	inv = '木でできた箱を抱えている。丁寧に作られたもののようだ。なにかに使えるかもしれない。',
	use = function(s, o)
		if o == 'boxes' then
			inv():del('mybox');
			return '箱を元に戻した。';
		end
		if o == 'mycar' then
			inv():del('mybox');
			mycar.obj:add('carbox');
			carbox._num = carbox._num + 1;
			return '箱を車の荷台に置いた。';
		end
		if o == 'ewall' or o == 'wboxes' then
			if not cam._broken then
				return 'カメラが監視しているから無理だろう。';
			end
			inv():del('mybox');
			ewall.obj:add('wboxes');
			wboxes._num = wboxes._num + 1;
			if wboxes._num > 1 then
				return '箱をその上に積み重ねた。';
			end
			return '箱を壁に沿って置いた。';
		end
	end
};

boxes = obj {
	nam = 'ящики',
	desc = {
		[1] = '駐車場のそばに木でできた{箱}がいくつか置いてある。中身は空だが、釘で蓋をされていたもののようだ。',
	},
	dsc = function(s)
		local state = 1;
		return s.desc[state];
	end,
	act = function(s, t)
		if carbox._num >= 5 then
			return '5個もあるし、もう必要ないだろう？';
		end
		if inv():srch('mybox') then
			return 'すでに箱をひとつ抱えて両手が塞がっている。';
		end
		take('mybox');
		return '箱をひとつ持った。';
	end,
};

village = room {
	nam = '店の前の駐車場',
	dsc = '店のそばの駐車場。雪に覆われている。',
	pic = 'gfx/shop.png',
	act = function(s, w)
		if w == 1 then
			return 'よくあるゴミバケツだ。雪で覆われている。';
		end	
	end,
	exit = function(s, t)
		if t == 'shop' and seen('mycat') then
			return 'バルシクを呼んだが彼はゴミバケツのほうが気になるようだ。いいさ、買い物は長くかからない。';
		end
	end,
	enter = function(s, f)
		if ewall:srch('wboxes') and wboxes._num == 1 then
			ewall.obj:del('wboxes');
			ewall._stolen = true;
			wboxes._num = 0;
		end
		if f == 'shop' and not s._ogh then
			s._ogh = true;
			set_music("mus/revel.s3m");
			guydlg:pon(4);
			guydlg:poff(8);
			return '俺は駐車場を見回して呼んだ。バルシク！おーいバルシク！……いったいどこに行っちまったんだ？';
		end
	end,
	way = { 'road', 'shop' },
	obj = { 'truck', vobj(1,'ゴミバケツ', '汚れた{ゴミバケツ}が雪で覆われている。'), 'guy','boxes' },
};

----------- trying to go over wall
function guardreact()
	pon(7);
	if inst:srch('mycar') then
		inst.obj:del('mycar');
		inmycar.way:add('backwall');
		inst.way:add('backwall');
		return cat([[マシンガンを持った4人の男に追い立てられて車まで戻ってきた。エンジンをかけて車を出し研究所から離れた。ルームミラーに映った軍用ジープと警備員が見えなくなるまで数キロばかり走った。]], walk('inmycar'));
	end
	return cat([[銃を構えた4人の男から検問所を追い出された。^^]], walk('inst'));
end

guarddlg = dlg {
	nam = '警備員',
	pic = 'gfx/guard.png',
	dsc = [[ごつい顔つきをした警備員が見える。彼の目はまわりのものを睨みつけている。彼の口の端は下に曲がっていて、あまりいい反応は期待しないほうがよさそうだ。]],
	obj = {
	[1] = phr('研究所の職員が間違えて俺の猫を持っていったようなので返してもらいたい。中に入れてもらえないか。','「IDカードを見せろ」', 'poff(2); pon(3);'),
	[2] = phr('IDカードを忘れてしまったんだけど、入れてくれないかな？','「だめだ」', 'poff(1); pon(3);'),
	[3] = _phr('ベリンを知ってるか？彼が俺の猫を持って行っちまってな。取り返したいんだが。', '「IDカードはないのか？」', 'pon(4)'),
	[4] = _phr('俺は猫を取り返しに来ただけだ！ベリンの電話番号を教えろ！', 
[[警備員の表情が険しくなった。口の端がキリリと持ち上がった。^「あんた、IDカードがないってんじゃ入れてはやれない。出て行ってくれ」]], 'pon(5, 6)'),
	[5] = _phr('ぶん殴るぞ！', '警備員の手がマシンガンを握り締めた。', 'poff(6); return guardreact();'), 
	[6] = _phr('分かった、出て行くよ。', '「ゆっくりとな」 警備員は薄い笑顔を見せた。俺は明らかに嫌われている。','poff(5); return guardreact()'),
	[7] = _phr('お前ら全員、ショットガンで吹っ飛ばしてやろうか。', '今度は警備員は何も答えなかった。彼の血走った目がすべてを語っていた。','return guardreact()'),
	},
};
guard = obj {
	nam = '警備員達',
	dsc = [[
{警備員達}が詰め所にたむろしている。彼らはカラシニコフのサブマシンガンを装備しているようだ。
]],
	act = function(s)
		return walk('guarddlg');
	end,
};
kpp = room {
	nam = '検問所',
	pic = 'gfx/kpp.png',
	dsc = [[検問所は疑いようもなく不審な人物を研究所に入れないためのもので、いわば防衛線だ。鉄格子で囲まれた警備員詰め所がある。まわりは静かだ。
]],
	obj = { 'guard' },
	way = { 'inst' }
};
inst = room {
	nam = '研究所',
	pic = 'gfx/inst.png',
	dsc = [[
建物はがらんとした雪原にぽつりとそびえていて、気味の悪い造りは研究施設というよりは刑務所のように見える。建物の後ろから貨物用らしき線路が延びている。
]],
	act = function(s, w)
		if w == 1 then  
			return '壁の高さが5メートルはあるだろう。さらに壁の上にトゲのついたワイヤが張られていて、たぶん高圧の電気が流れているだろう。';
		end
		if w == 2 then
			return 'ウラジミールの言ったことは本当だった。まるで軍の司令部のようだ。';
		end
		if w == 3 then	
			return 'あれはバルシクを連れて行った男のバンのようだ。';
		end
	end,
	used = function(s, w, b)
		if b == 'mybox' and w == 1 then
			return '警備員がすぐに気付いて注意されるだろう。';
		end
		if w == 2 and b == 'gun' and gun._loaded then
			return '追い払われるか、あるいは単に撃たれるだろう。警備員がすぐそばにいるわけだし。';
		end
		if w == 3 and b == 'gun' and gun._loaded then
			return '猫を探さないと。そのために来たわけだし。';
		end
	end,
	obj = {vobj(1, '壁', '研究所の建物は分厚いコンクリートの{壁}で囲まれている。真ん中に検問所がある。'),
		vobj(2, 'カメラ', '監視用の{カメラ}が高い塔の上から見張っている。'),
		vobj(3, 'バン', '門の向こうに黒い{バン}が見える。')},
	way = { 'road', 'kpp' },
	exit = function(s, t)
		if have('mybox') and t ~= 'inmycar' then
			return '箱を抱えたままじゃうろうろできない。', false;
		end
	end,
};

cam = obj {
	nam = '監視カメラ',
	dsc = function(s)
		if not s._broken then
			return '{カメラ}のひとつがすぐそこにある。俺は気付かれないように壁に張り付いた。';
		end
		return 'バラバラになったカメラの部品が散らばっている。ゴミのように雪に埋もれている。';
	end,
	act = function(s)
		if not s._broken then
			return 'ムカつくカメラだぜ。';
		end
		return 'あーあ、やっちまったな。警備員がいつ現れるか心配だ。';
	end,
};

wire = obj {
	nam = '有刺鉄線',
	dsc = function(s)
		if s._broken then
			return '{ワイヤ}が寸断されている。';
		end
		return 'トゲのついた{ワイヤ}が見える。';
	end,
	act = function(s)
		if s._broken then
			return 'よし、これで安全に中に入れるぞ。';
		end
		return '大電流が流れてるかもしれない!!';
	end,
};

onwall = room {
	pic = 'gfx/onwall.png',
	nam = '壁の上',
	dsc = '俺は箱のいちばん上に立っている。頭がちょうど壁のてっぺんにある。吹きさらしで寒い……。',
	enter = function(s)
		if have('mybox') then
			return '箱を抱えているので壁をよじ登れない。', false;
		end
		if wboxes._num < 5 then
			return '壁をよじ登ろうとした……でもまだ高すぎる。',false;
		end
		return '俺は箱から壁の向こう側に越えた。';
	end,
	obj = { 'wire' },
	way = { 'backwall' }
};

wboxes = obj {
	_num = 0,
	nam = function(s)
		if (s._num > 1) then
			return '壁のそばに積んだ箱';
		end
		return '壁のそばに置いた箱が1個';
	end,
	act = function(s)
		return walk('onwall');
	end,
	dsc = function(s)
		if s._num == 0 then
			return;
		elseif s._num == 1 then
			return '^{箱}がひとつ壁のそばにある。';
		-- And again only one plural form
		-- elseif s._num < 5 then
		--	return 'There are '..tostring(s._num)..' {boxes}, stacked by the wall.';
		else	
			return '^壁のそばに積まれた{箱}が'..tostring(s._num)..'個ある。';
		end
	end,
};

ewall = obj {
	nam = '壁',
	dsc = '4メートルくらいの高い{壁}がある。吹き付ける風が壁の下に雪の固まりを作っている。',
	act = function(s)
		if not s._ladder then
			s._ladder = true;
			shop2:pon(7);
		end
		return '高すぎる。ハシゴが必要だ。';
	end
};

backwall = room {
	pic = 'gfx/instback.png',
	enter = function(s, f)
		local st = '';
		if ewall._stolen then
			ewall._stolen = false;
			st = 'ああっ誰かが箱を盗んで行っちまった！くそ！';
		end
		if f == 'inmycar' then
			return '誰にも気付かれないように車に乗った。'..st;
		end
		return '雪の中をうろうろと歩いて後ろの壁に来た。'..st;
	end,
	nam = '研究所の東の壁',
	dsc = '研究所の後ろ側に来ている。',
	obj = { 'ewall', 'cam' },
	way = { 'inst', },
	exit = function(s, t)
		if have('mybox') and t ~= 'inmycar' then
			return '箱を持ったままじゃうろうろできないだろう。', false;
		end
	end,
};
