/*																				*/
/*																				*/
/*				File:		  	gkey.c										*/
/*				Returns:	  	true if not error							*/
/*				Parameters:	int xkey[2] - key to search for		*/
/*								FILE **unit - key file					*/
/*								int *rec - record where key found	*/
/*								int k1 [18], k2 [18] - key record	*/
/*								int rptr [18] - key record - r ptr	*/
/*								char bptr [18] - key record - b ptr	*/
/*								int *knum - number of keys in cache	*/
/*								int **kbase - pointer cache start	*/
/*								int *rpt - record pointer to data	*/
/*								int *oldkey - previous major key		*/
/*								char *bpt - char pointer to data		*/
/*																				*/

#include <stdio.h>
#include <process.h>

#include "advm.h"

#include "check.h"



int gkey (xkey, unit, rec, k1, k2, rptr, bptr, knum, kbase, rpt, oldkey, bpt)
int xkey [2];
FILE **unit;
int *rec;
int k1 [18];
int k2 [18];
int rptr [18];
char bptr [18];
int *knum;
int **kbase;
int *rpt;
int *oldkey;
char *bpt;

	{
	int key1,key2;
	int i;
	int low,high;
	int newkey,find;
	int newrec;
	int flag;

	flag = 0;
	key1 = xkey[0];
	key2 = xkey[1];
	if (*rec && (i=check(key1,key2,k1,k2))>0)
		{
		*rpt = rptr[i-1];
		*bpt = bptr[i-1];
		return (0);
		}
	if (key2 != *oldkey)
		{
		low = 0;
		high = *knum -1;
		for (;;)
			{
			find = (low+high)/2;
			if ((newkey = *(*kbase+2*find)) == key2)
				break;
			if (low >= high)
				return (1);
			if (newkey > key2)
				high = find - 1;
			else
				low = find + 1;
			}
		newrec = *(*kbase+2*find+1);
		}
	else
		newrec = *rec;		/* suppress the read in the next loop */
	for (;;)
		{
		if (*rec != newrec)
			{
			if (fseek(*unit, (long)128*(newrec-1), 0) ||
				fread((char *)k1, sizeof(k1[0]), 18, *unit) != 18 ||
				fread((char *)k2, sizeof(k2[0]), 18, *unit) != 18 ||
				fread((char *)rptr, sizeof(rptr[0]), 18, *unit) != 18 ||
				fread((char *)bptr, sizeof(bptr[0]), 18, *unit) != 18)
				{
				printf ("Error while reading key: %d.%03d\n",key2,key1);
				exit(1);
				}
			*rec = newrec;
			}
		if ((i=check(key1,key2,k1,k2)) > 0)
			{
			*rpt = rptr[i-1];
			*bpt = bptr[i-1];
			return (0);
			}
		assert (i>= -2 && i <=0);
		if (i == -1)
			return (1);
		if (i == 0)
			{
			if (flag<0)
				return(1);
			flag = 1;
			newrec = *rec + 1;
			continue;
			}
		else
			{
			if (flag > 0 || *rec == 1) 
				return (1);
			flag = -1;
			newrec = *rec - 1;
			continue;
			}
		}
	}
