/* (c) Copyright 1987 Michael Goetz																				*/
/*																				*/
/*				File:	fastrd	  	  										*/
/*				Returns:	true if EOF										*/
/*				Parameters:	FILE **unit - which file to read		*/
/*								char line[141] - input line			*/
/*								int *record - line #						*/
/*								int *bline - first non blank char	*/
/*								int *eline - last non-blank char		*/
/*																				*/
/*																				*/

#include <stdio.h>
#include <memory.h>
#include <ctype.h>

#include "advm.h"
#include "string.h"
#include "values.h"
#include "units.h"
#include "arg.h"



int fastrd(unit, line, record, bline, eline)
FILE **unit;
char line [141];
int *record, *bline, *eline;

	{
	static int oldfil = 0;
	int file;					/* true if reading from a file */
	int i;

	if (*unit != inmain)
		{					/* include file processing */
		if (fnum != oldfil)
			{
			*record = 0;
			oldfil = fnum;
			}
		}
	else		/* 100 */
		{		/* main file */
		if (!opened)
			{			/* 130 */
			opened = TRUE;
			if (xargc < 2)		/* file name supplied? */
				file = FALSE;
			else
				{
			 	if (!(inmain = fopen(xargv[1], "rt")))
					return (TRUE);
				*unit = inmain;
				file = TRUE;
				}
			}
		}
	/* 200 */
	memset (line, ' ', 140);
	line[140] = 0;
	if (*unit == inmain && !file)
		printf ("> ");
	if (!fgets (line, 140, *unit))
		{
		if (*unit == inmain && file)
			fclose(*unit);
		return (TRUE);
		}
	if (*unit != inmain)
			(*record)++;
	if ((i=strlen(line)) < 140)		/* pad with blanks to full size */
		memset (line+i, ' ', 140-i);
	for (*bline = 0; *bline < strlen(line); (*bline)++)
		if (!isspace(line[*bline]))
			break;
	for (*eline = strlen(line)-1; *eline > *bline; (*eline)--)
		if (!isspace(line[*eline]))
			break;
	return (FALSE);
	}


