/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Date;
import java.util.Vector;

class SaveInfo {
    File fichSalv;
    Date fecha;
    String name;
    GameInfo infoJuego;

    public SaveInfo() {
    }

    public SaveInfo(File fichSalv, Date fecha, File fichJuego) {
        this.fichSalv = fichSalv;
        this.fecha = fecha;
        this.name = fichSalv.getName();
        this.infoJuego = GameInfo.getGameInfoFromFile(fichJuego);
    }

    public File getFile() {
        return this.fichSalv;
    }

    public File getGameFile() {
        if (this.infoJuego == null) {
            return null;
        }
        return this.infoJuego.getFile();
    }

    public GameInfo getGameInfo() {
        return this.infoJuego;
    }

    public String getName() {
        return this.name;
    }

    public Date getDate() {
        return this.fecha;
    }

    public String toString() {
        return this.getName();
    }

    public String toLongString() {
        if (this.infoJuego == null) {
            return "Nombre: " + this.getName() + "\nFecha: " + this.getDate();
        }
        return "Nombre: " + this.getName() + "\nFecha: " + this.getDate() + "\nJuego: " + this.infoJuego.toString();
    }

    public static SaveInfo getSaveInfo(File savefile) throws FileNotFoundException, IOException {
        FileInputStream fp = new FileInputStream(savefile);
        BufferedReader filein = new BufferedReader(new InputStreamReader(fp));
        String dirJuego = filein.readLine();
        Date fecha = new Date(savefile.lastModified());
        System.out.println(savefile);
        System.out.println(dirJuego);
        try {
            return new SaveInfo(savefile, fecha, new File(dirJuego));
        }
        catch (Exception fnfe) {
            return null;
        }
    }

    public static SaveInfo[] getListOfSaves() {
        File f = new File(System.getProperty("user.dir"));
        File[] fl = f.listFiles();
        Vector<SaveInfo> result = new Vector<SaveInfo>();
        int i = 0;
        while (i < fl.length) {
            if (fl[i].isDirectory()) {
                File[] fl2 = fl[i].listFiles();
                int j = 0;
                while (j < fl2.length) {
                    if (fl2[j].getName().toLowerCase().endsWith(".alf")) {
                        try {
                            result.addElement(SaveInfo.getSaveInfo(fl2[j]));
                        }
                        catch (IOException ioe) {
                            System.out.println(ioe);
                            ioe.printStackTrace();
                        }
                    }
                    ++j;
                }
            } else if (fl[i].getName().toLowerCase().endsWith(".alf")) {
                try {
                    result.addElement(SaveInfo.getSaveInfo(fl[i]));
                }
                catch (IOException ioe) {
                    System.out.println(ioe);
                    ioe.printStackTrace();
                }
            }
            ++i;
        }
        Object[] objetos = result.toArray();
        SaveInfo[] ficheros = new SaveInfo[objetos.length];
        int i2 = 0;
        while (i2 < objetos.length) {
            ficheros[i2] = (SaveInfo)objetos[i2];
            ++i2;
        }
        return ficheros;
    }
}

