/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Hashtable;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Sequence;
import javax.sound.midi.Sequencer;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;
import javax.sound.sampled.UnsupportedAudioFileException;
import micromod.MicroMod;
import micromod.Module;
import micromod.ModuleLoader;
import micromod.output.JavaSoundOutputDevice;
import micromod.output.PCM16StreamOutputDevice;
import micromod.output.converters.AudioFormatConverter;
import micromod.output.converters.SS16LEAudioFormatConverter;
import micromod.resamplers.LinearResampler;
import micromod.resamplers.Resampler;

public class AGESoundClient
implements SoundClient {
    private Sequencer seqr;
    private Sequence curseq;
    private Hashtable midiPreloaded = new Hashtable();
    private Hashtable audioPreloaded = new Hashtable();
    PlayerThread pt;
    static /* synthetic */ Class class$0;

    private Sequence getPreloadedSequence(File f) {
        try {
            return (Sequence)this.midiPreloaded.get(f.getCanonicalPath());
        }
        catch (IOException ioe) {
            return null;
        }
    }

    public void midiInit() throws MidiUnavailableException {
        this.seqr = MidiSystem.getSequencer();
        this.seqr.open();
    }

    public void midiPreload(File midfile) throws InvalidMidiDataException, IOException {
        Sequence seq = MidiSystem.getSequence(midfile);
        this.midiPreloaded.put(midfile.getCanonicalPath(), seq);
    }

    public void midiUnload(File midfile) throws IOException {
        this.midiPreloaded.remove(midfile.getCanonicalPath());
    }

    public void midiUnload(String s) throws IOException {
        this.midiUnload(new File(s));
    }

    public void midiStart(File midfile) throws InvalidMidiDataException, IOException {
        this.curseq = this.getPreloadedSequence(midfile);
        if (this.curseq == null) {
            this.curseq = MidiSystem.getSequence(midfile);
        }
        if (this.seqr.isRunning()) {
            this.seqr.stop();
        }
        this.seqr.setSequence(this.curseq);
        this.seqr.start();
    }

    public void midiStart(String f) throws InvalidMidiDataException, IOException {
        this.midiStart(new File(f));
    }

    public void midiPreload(String f) throws InvalidMidiDataException, IOException {
        this.midiPreload(new File(f));
    }

    public void midiOpen(File midfile) throws InvalidMidiDataException, IOException {
        this.curseq = this.getPreloadedSequence(midfile);
        if (this.curseq == null) {
            this.curseq = MidiSystem.getSequence(midfile);
        }
    }

    public void midiOpen(String f) throws InvalidMidiDataException, IOException {
        this.midiOpen(new File(f));
    }

    public void midiStart() throws InvalidMidiDataException {
        if (this.seqr.isRunning()) {
            this.seqr.stop();
        }
        this.seqr.setSequence(this.curseq);
        this.seqr.start();
    }

    public void midiStop() {
        this.seqr.stop();
    }

    public void midiClose() {
        this.curseq = null;
    }

    public void audioPreload(File f) throws UnsupportedAudioFileException, LineUnavailableException, IOException {
        AudioInputStream aii = AudioSystem.getAudioInputStream(f);
        AudioFormat af = aii.getFormat();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("javax.sound.sampled.Clip");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Clip cl = (Clip)AudioSystem.getLine(new DataLine.Info(clazz, af));
        cl.open(aii);
        this.audioPreloaded.put(f.getCanonicalPath(), cl);
    }

    public void audioUnload(File afile) throws IOException {
        this.audioPreloaded.remove(afile.getCanonicalPath());
    }

    public void audioUnload(String s) throws IOException {
        this.audioUnload(new File(s));
    }

    public void audioPreload(String s) throws UnsupportedAudioFileException, LineUnavailableException, IOException {
        this.audioPreload(new File(s));
    }

    private Clip getPreloadedClip(File f) {
        try {
            return (Clip)this.audioPreloaded.get(f.getCanonicalPath());
        }
        catch (IOException ioe) {
            return null;
        }
    }

    public void audioStart(File f) throws UnsupportedAudioFileException, LineUnavailableException, IOException {
        Clip cl = this.getPreloadedClip(f);
        if (cl == null) {
            this.audioPreload(f);
        }
        cl.start();
    }

    public void audioStop(File f) {
        Clip cl = this.getPreloadedClip(f);
        if (cl == null) {
            return;
        }
        cl.stop();
    }

    public void audioStart(String s) throws UnsupportedAudioFileException, LineUnavailableException, IOException {
        this.audioStart(new File(s));
    }

    public void audioStop(String s) {
        this.audioStop(new File(s));
    }

    void playMOD(File f, int iRepeat) throws Exception {
        JavaSoundOutputDevice out = new JavaSoundOutputDevice((AudioFormatConverter)new SS16LEAudioFormatConverter(), 44100, 1000);
        Module module = ModuleLoader.read((DataInput)new DataInputStream(new FileInputStream(f)));
        MicroMod microMod = new MicroMod(module, (PCM16StreamOutputDevice)out, (Resampler)new LinearResampler());
        MODThread mt = new MODThread(microMod, out, iRepeat);
        this.pt = mt;
        this.pt.setVolume(65536);
        mt.start();
    }

    void playMOD(String s, int iRepeat) throws Exception {
        this.playMOD(new File(s), iRepeat);
    }

    public void stopMOD() throws Exception {
        if (this.pt != null) {
            this.pt.stopPlaying();
        }
    }

    class MODThread
    extends Thread
    implements PlayerThread {
        int soundId;
        boolean running;
        boolean stopped;
        JavaSoundOutputDevice out;
        MicroMod mm;
        int iRepeat;

        MODThread(MicroMod mm, JavaSoundOutputDevice out, int iRepeat) {
            this.mm = mm;
            this.out = out;
            this.iRepeat = iRepeat;
            this.running = false;
            this.stopped = false;
        }

        public synchronized void setVolume(int vol) {
            SourceDataLine l = this.out.getLine();
            FloatControl ctl = (FloatControl)l.getControl(FloatControl.Type.MASTER_GAIN);
            double gain = (double)vol / 65536.0;
            float dB = (float)(Math.log(gain) / Math.log(10.0) * 20.0);
            if (ctl != null) {
                ctl.setValue(dB);
            }
        }

        public synchronized void stopPlaying() {
            if (!this.stopped) {
                this.running = false;
                this.stopped = true;
                this.out.stop();
                this.out.close();
            }
        }

        synchronized void donePlaying() {
            AGESoundClient.this.pt = null;
        }

        public void run() {
            this.out.start();
            int i = 0;
            while (!(this.stopped || this.iRepeat != -1 && i >= this.iRepeat)) {
                this.running = true;
                this.mm.setCurrentPatternPos(0);
                while (this.running && this.mm.getSequenceLoopCount() == 0) {
                    MODThread mODThread = this;
                    synchronized (mODThread) {
                        System.out.println("Real Time.");
                        this.mm.doRealTimePlayback();
                        try {
                            Thread.sleep(20L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
                ++i;
            }
            MODThread mODThread = this;
            synchronized (mODThread) {
                if (!this.stopped) {
                    this.running = false;
                    this.out.stop();
                    this.out.close();
                    this.donePlaying();
                }
            }
        }
    }
}

