Walkthrough for Erehwon
By Patrick Hardlentil - patrick@dogslobber.demon.co.uk
------------------------------------------------------------
Disclaimer: the physics, topology and philosophy of Erehwon
can get a little confusing. I've explained them as well as
I can, but my academic specialism is watching TV, so I may
have over-simplified or got things entirely wrong. At least
the walkthrough works: I can vouch for that.
-PH, 26 September 1999
------------------------------------------------------------

You need to turn off the random number generator if
you want this walkthrough to work exactly as written:
>UNRANDOM

Before you get started, there's something you should know about
yourself:
>I
>X BAGGAGE
>DROP IT

You might want to keep an eye on your emotional state as the
game progresses.

We begin in the centre of Erehwon, Aksarben, a name which will
immediately mean something to fans of Dylan Thomas and anyone who has
visited the Aragain Falls. The startup message tell you that your goal
is to gain the approval of Smurf and his gang, and to join in their
game, but there's no sign of them here. Let's start out with a little
exploration:

>N
>E
>X FERRET
>X FOREST
>N,N

Not much to do here, but getting your bearings now will pay off later.

>S,S,S,S
>READ SIGN

Note the name of the desert. We won't enter it yet, because we're
not equipped for desert travel.

>N,N,E,E,N
>GET BIRDSEED
>X BRIDGE
>READ EQUATIONS

Who? Just file this away for now.

At this point, you might want to go North and take a look at the
Haunted Maze. It's not too hard to find your way around, and it's
even mappable, but there's nothing of interest and only one exit.
The maze is, in fact, a dodecahedron, but there's no wumpus in there.
If you're a topologist, you will probably have an idea what to do
with it, but the rest of us need a clue, which we'll find in a while.

>S
>S

Well, we've found the gang, anyway. We need to get to know these
characters better: Stanley, in particular, can be quite helpful.

>X STANLEY
>STANLEY, HELLO
>ACCRINGTON, HELLO

Make a note of your name: you'll need to know it later.

>ASK ACCRINGTON ABOUT HIMSELF

Don't worry if this means nothing to you.

>ASK ACCRINGTON ABOUT DESERT
>ASK ACCRINGTON ABOUT MAZE
>ASK ACCRINGTON ABOUT JUKEBOX
>X JUKEBOX
>LISTEN TO IT

Feel free to listen to some more tunes while you're here.

>X SMURF
>SMURF, HELLO
>X GAME
>ASK SMURF ABOUT IT
>PLAY IT
>PLAY GAME
>LOOK UNDER TABLE

Now we're cooking: you have your first die. Four more to go, and
you'll be able to role-play with Smurf and the boys.

>S
>X JUNK
>GET HELMET, RECORD, COMPASS, HANGER THEN WEAR HELMET
>N
>SHOW RECORD TO ACCRINGTON

Now we know exactly what Stanley wants us to give him, but this
old vinyl copy is no use.

>DROP IT
>N,W,W,W,W,NW

The ATM card will do you no good, but it's harmless to play
around with it if you want to.

>GET CARD
>X MACHINE
>SE,W,S
>X EXHIBITS
>READ PLAQUE
>X GAME

If Sir William's initials look familiar, that's because they are
carved on the bridge outside the Haunted Maze. The Maze is, in fact,
an Icosian game. To solve it, you must complete a Hamiltonian Circuit
of it. In English, that means to traverse it, visiting each node
exactly once (except for the node you start from and return to).

We'll do that in a moment, pausing only to find a vital object:

>X PLAQUE
>LOOK IN GAP
>N,E,E,E,E,E,N,N

Now to traverse the maze. There are sixty possible solutions;
this is one of them.

>NW,N,SE,S,S,E,N,N,NE,N,E,NE,S,NW,N,W,S,S,SW,S

You may be thinking, "How was I supposed to work THAT out?". Actually,
there are two more aids to solving the maze, both of which we'll come
across later: the deck of cards and, more important, the budgerigar.
The cards are just 52 objects handy for mapping, but the budgie
has a special talent for maze-solving. In the walkthrough, though,
we haven't waited for them to show up, because we're on the fast track.

So, thanks to an informative ghost, you now have some numbers
that you'll need again. The game author has kindly provided
the "REMEMBER" command, which will save you from writing
them down and will come in useful for something else, too.

Now, there's one more, optional, piece of preparation before we
cross the desert. The sign at the entrance to the desert said
that travellers in it often become disoriented. In game terms,
this means that N, S, E and W won't work (actually, they move you
in a random direction, which is almost as bad). However, it is
possible to move around consistently by going LEFT, RIGHT, FORWARD
or BACK. You can also FACE in any direction, which won't help
you in the desert but will be useful later on. Luckily, you
have a compass to help you get the hang of these commands.

>S,S,W,W
>X COMPASS
>RIGHT THEN X COMPASS
>BACK THEN X COMPASS
>LEFT THEN X COMPASS
>BACK THEN X COMPASS
>FACE SOUTH THEN X COMPASS
>FORWARD

Feel free to experiment further if you need to; there is also
some HELP available on these commands. If you haven't followed
the above directions exactly, you'll need to find your way back
to the crossroads and go SOUTH to get back in step with the
walkthrough.

>S,S
>READ SIGN
>FORWARD
>X DOUBLOON

To find out the hard way what's going on here, try taking the
doubloon or continuing on your way FORWARD. Since this is a
walkthrough, here's the gist of it. You started out in Erehwon,
which is a town made of antimatter. You are also, at the moment,
made of antimatter. On the other side of the desert is the town
of Nowhere, Nebraska, which is made of matter, as is the doubloon
at your feet. The Klein desert is shaped like a Klein Bottle, or
as close to one as a desert can be. By traversing the desert in the
right way, you can wind up on the other side of the bottle, changing
from antimatter to matter, or vice-versa, in the process. Have I
got that right, Jos?

Here's one way to change yourself into matter:

>RIGHT
>FORWARD
>G,G,G,G,G,G,G

Now you're back where you're started, but in the same state as the
doubloon. Examining it will no longer give you premonitions, and
you can safely pick it up (but it's better to leave it where it is,
as it's a useful landmark). Now, too, you can explore Nowhere, Nebraska
without getting blown to pieces.

>RIGHT
>FORWARD
>GET DIE

Now we're one step closer to impressing Smurf.

>READ SIGN
>N
>N

Nowhere, Nebraska is the real-world analogue of Erehwon, Aksarben.
You already know your way around, although things will look a little
different.

>N,N,N
>X BIRD
>GET BIRD
>GIVE SEED TO BIRD

I hope you like budgerigars, because this one is going to be
your only friend in the game.

>PET BIRD
>S,S,S,E,E,N
>GET DECK

The deck is useful for mapping the desert and the maze, but,
since the walkthrough is omniscient, we won't refer to it again.

Poke around Nowhere if you wish, but to get on with the game
you need to find your way back to the edge of the desert:

>S,W,W,S,S
>READ SIGN

There is a clue in this sign. Reading right-to-left the letters that have
been obliterated yields the message:

DROP ANTIBIRD AT DESERT EDGE ALAS

OK, so perhaps we should do that.

>S

Hm, uncharacteristic aggression from Mr Bird. Bearing in mind the
clue embedded in the sign, maybe this is where we should drop him?

>DROP BIRD

Oops. He's a bird at the moment, not an antibird.

>BACK
>GET BIRD
>BACK
>FORWARD

Now to change state again:

>RIGHT
>FORWARD
>G,G,G,G,G,G,G
>LEFT
>DROP BIRD

That's the puzzle solved, but losing your only friend sucks:

>I
>X BURDEN

Oh dear. What's worse, by doing this so soon we've lost the
opportunity to make Mr Bird attack Smurf, which would have been
a lot of fun (try it). And what's worse still is that we've not
had the pleasure of taking him to the Haunted Maze, where you could
have marvelled at the mysterious avian instinct that tells him
whether or not you're on the right track each time you take a turning.
This is, in fact, the easiest way to solve the maze, but, if you
wanted to savour the process of discovery, resorting to the walkthrough
was perhaps not the way to do it.

Anyway, let's explore the new area that's opened up.

>FORWARD
>N
>U
>GET BOX
>X IT
>X ARMS
>OPEN BOX

Don't try to get the new die yet. We have to change its state first.

>GET BOOK
>READ IT

Thanks for that explanation, Jos. _Dr Who_ is always on the
lookout for new scriptwriters, you know.

>U

Nothing to do here except get an idea of what to look out for
down below.

>D,D,S,E,E,E,E,N
>X DOOR
>READ NOTICE
>DOOR, HELLO

Clearly, you need help with the password.

>W
>W
>X FOUNTAIN
>SIT ON RIM
>BLOODCHUCK, HELLO

Luckily, Accrington Stanley has already told you your name.

>SAY "CEDRIC"
>ASK PORTNOY ABOUT COMPLAINT
>ASK PORTNOY ABOUT DOOR

Captain Beefheart fans can award then selves a "Trainspotter"
bonus at this point.

>STAND
>E
>E
>SAY "FAST AND BULBOUS"
>E
>E,NE,N
>GET DISC THEN X IT

Just what Stanley is looking for. In case you're not a
woolly-jumper-wearing, kipper-eating folkie, Cecil Sharp
was a famous collector of English traditional songs.

>LOOK IN HOLE
>BEND HANGER
>GET GRENADE WITH HANGER
>S,SW,W,W
>SAY "FAST AND BULBOUS"

There are no more bloodchucks around to help you out here. Clearly
more drastic measures are called for, and your ability to face
in arbitrary directions will come in useful at last.

>E
>FACE WEST
>PULL PIN
>THROW GRENADE
>W
>W
>W
>N
>X DOORFRAME
>X KEYPAD
>TYPE 1729

This is the less "interesting" number that Sir William Hamilton
told you about. Interesting or not, it is useful, but you can't
go through the door just now (try it and UNDO if you're curious).

>N,W,W
>GET PAPER THEN READ IT

This has been left here to help you with the maze, but as you've
already solved that, just admire the ASCII-art.

>S,S,S,W,W
>I
>FORWARD

At this point, we need to change state again so that we can
safely re-enter Erehwon (this is why we couldn't go through
the transportation node in the park). While we're about it,
we may as well do something about that dangerous-looking die
in the box.

>DROP BOX
>RIGHT
>FORWARD
>G,G,G,G,G,G,G
>X BOX
>X ARMS

Good: the box has changed state. Well, no, actually you have, but it
amounts to the same thing.

>GET BOX
>GET DIE

You now have three of the five dice that you need to give to
Smurf so you can all play _Nowhere_. Now, you can give Stanley
the shiny new CD of his favourite album. You could get back
to Erehwon by going across the desert, but let's try that
transportation node instead.

>LEFT
>FORWARD
>E,E,E,N,N
>W
>E,E,E,E,E,S
>GIVE CD TO ACCRINGTON
>GET KEY
>N,W,W,S,S,S
>FORWARD
>G
>G
>D
>UNLOCK DOOR WITH KEY
>N

Strange things are going to happen in here. The machine in front
of you belongs to the Llanfairpwllgwyngyll park rangers, and
lets you alter past events. But meddling with time can have
unintended side-effects.

>X CONSOLE
>TURN ON CONSOLE
>PRESS INTERVENE

Congratulations, you just saved a Klingon. Did you notice the
glove that just appeared on the console? The smith in Stanley's
song wore a glove on his right hand, so this is worth having.

>GET GLOVE
>X IT
>WEAR IT
>PRESS NEXT

At this point, you can chose to save Mr Bird or not. It is a lot
simpler to leave him dead, but, if you choose to intervene, you
can still win the game *and* feel better about yourself. This
walkthrough assumes that you:

>PRESS INTERVENE
>I
>X LOSS
>DROP IT
>GET GLOVE
>X GLOVE

Unfortunately, you now have a left-handed glove, which makes it
a little harder to win the game (the right-handed one was magic,
but this one is just useless). Still, having managed to swap
round the sinister and dexter supporters on the coat of
arms on the metal box, you should have no trouble turning a
left-hand glove into a right-hand one.

>S
>U
>W
>FORWARD
>DROP GLOVE
>RIGHT
>FORWARD
>G,G,G,G,G,G,G
>GET GLOVE
>WEAR IT

...and, for taking the humanitarian route, you get bonus points.
Congratulations!

>LEFT
>FORWARD
>E,E,E,E,N,E,E,E,SE
>X PAVING
>S

OK, let's take the hint and fish:

>SIT ON BENCH
>FISH
>Z,Z,Z,Z,Z,Z
>GET TROUT

This trout is behaving rather like the lady magician in
Stanley's song. How did that go again?

>REMEMBER LYRICS
>TURN INTO DRAKE
>TURN INTO GREYHOUND
>TURN INTO SADDLE
>TURN INTO CAKE
>TURN INTO COVERING
>PUT TROUT IN WATER
>FISH
>Z,Z,Z,Z,Z
>GET HERRING
>FISH
>Z,Z,Z
>GET BASS

You now have all five of the dice that you need to play
Smurf's game. You may have noticed certain game responses
suggesting that you are no longer such an admirer of Smurf
and his game as you once were. Still, there seems no choice
but to continue the quest.

If you're a topologist by trade, or a student of Plato, you
may be feeling dissatisfied with your collection of dice.
Nature's spume plays upon an eternal paradigm that consists
of five different Platonic solids, dammit, not four with an
extra dodecahedron. Fear not, the Duality Machine will sort
that out for you.

>N,NW,W,W,W,N,W
>W
>W,E,E,NW
>PUT DUALITY CARD IN SLOT

Now you need that "interesting" number that Sir William told you
about.

>REMEMBER NUMBERS
>TYPE 8840
>PUT TWELVE-SIDED DIE IN RECEPTACLE
>PRESS GO
>LOOK IN RECEPTACLE
>GET TWENTY-SIDED DIE
>SE,E,E,E,E,S

Well, if he's going to be snotty about it:

>MOONWALK

Oops. Now, back to the quest:

>GIVE DICE TO SMURF

You might like to try out some different possible endings by
sitting in the blue chair, as Smurf suggests, or the red chair.
The best response to your existential dilemma, however, is:

>N
Well, existential dilemmas tend not to have especially happy
solutions. Sorry about that.
