-- $Name: I.A.G. Alpha$
-- $Version: 1.0$
-- $Author: Serhii “techniX” Mozhaiskyi$
-- $Info:Tested by: Vyacheslav Dobranov, Peter Kosyh, Yurii Pavlenko, Andrey Serebrennikov\nEnglish version is proofread and tested by: Jack Welch, Josh Grams$

--[[

]]--

require "noinv"
require "snd"
require "fmt"
require "theme"
require "timer"
require "sprite"
require "keyboard"

global {
  G_current_theme = '';
  name_of_myid = 'My ID card';
  name_of_guardid = 'Red ID card';
  name_of_rod = 'Rod';
  name_of_smallkey = 'Small key';
  name_of_camera = 'Camera';
  name_of_fotoplenka = 'Film cartridge';
  name_of_topor = 'Axe';
  name_of_tape = 'Tape';
  name_of_key = 'Key';
  name_of_paper = 'Scrap of paper';
  name_of_lightbulb = 'Light bulb';
  name_of_brokenlightbulb = 'Burned-out light bulb';
  name_of_ladder = 'Ladder';
  name_of_ruslan = 'Ruslan';
  name_of_kuvalda = 'Sledgehammer';
}

-- doencfile "game.dat"
dofile "game/owntheme.lua"
dofile "game/obj_inventory.lua"
dofile "game/part1.lua"
dofile "game/part2.lua"
dofile "game/part3.lua"
dofile "game/part4.lua"
dofile "game/part5.lua"
dofile "game/part6.lua"
dofile "game/part7.lua"
dofile "game/source.lua"
dofile "game/titles.lua"
dofile "game/diary.lua"

keyboard.alt_xlat = true

guest = player {
  nam = "Player";
  obj = { 'DEBUGGER' };
}

source = player {
  nam = "Debugger";
  obj = { 'close_source' };
}

game.player = guest
game.use = function()
  local msg = {
    "Why would I do that?",
    "I don't see the logic.",
    "No, that would be pointless.",
    "I can't imagine why that would matter.",
    "Nothing is likely to come of that.",
  }
  p(msg[rnd(#msg)])
end

function init() 
  if theme.name() ~= '.' then
    std.err("Please, enable game own themes.", 2)
  end
  std.strip_call = false
  std.phrase_show = false
  fmt.para = true
  fmt.dash = true
  fmt.quotes = false
end

function sound_player(file)
  if file then
    snd.play(file)
  end
end

function music_player(file)
  if file then
    snd.music(file)
  else
    snd.stop_music()
  end
end

function title_music_player(file)
  if file then
    snd.music(file, 1)
  end
end

function start()
  snd.vol(80)
  snd.music_fading(1000)
  theme_switch(G_current_theme)
end

room {
  nam = "main",
  disp = "From the Author",
  noinv = true,
  decor = [[
In 2013 I was planning to write an entry for the game jam "Insteadose-2".
^The game had to meet three conditions:
^-- a bridge should be featured in the plot;
^-- one of the game items must be a camera;
^-- at some point, the player must be on the roof of the building.
^At first, work was easy. In the first couple of weeks, I drew a map of the area and wrote puzzles and code for three game locations. I carefully jotted down every idea that came into my head and the plot outline became more and more clear.
^But then the inspiration left me. It became clear that I would not finish the game by the deadline. In a desperate attempt to save the game, I discarded unfinished locations, pared down the plot and came up with what I thought at the time was the perfect ending.
^And at that moment I suddenly realized that I did not have the slightest desire to finish the game. Assuming that this was a temporary bout of writer’s block, I closed the text editor. As it turns out, though, I never got back to work on this game.
^It cannot be said that this was a useless experience. I recycled sections of the game code in other projects -- alas, also unfinished. Puzzles involving the camera were especially lucky -- they became the basis for the game "Photo Hunt", which was completed (Yay!) and released as part of the Insteadose-5 compilation. 
Several times I thought about publishing the game’s source. But who needs the source code of someone else's unfinished game, when every author has their own incomplete games?
^In the end, I did just that -- I took the game in the form that I had left it and added all the notes and comments made while working on the game.
^^
  ]] .. fmt.c('{#start|I hope you will find it interesting to play.}'),
  enter = function ()
    theme_switch('author')
  end
}:with {
  obj {
    nam = "#start",
    act = function()
      theme_switch('game')
      walk('menu')
    end
  }
}

room {
  nam = "menu";
  disp = false;
  pic = "gfx/nii.png",
  enter = function()
    music_player('snd/Ryan_Andersen_-_Flawless.ogg')
  end,
  decor = [[
  {#intro|Backstory} <i>[Nikolai's diaries]</i>
  ^
  <b>{#play|Start game}</b>
  ^
  {#howto|How to play}
  ^
  Settings
  ^
  About
  ]] .. fmt.em([[
  ^ ^
  -- TODO: finish the scene on the roof^
  -- TODO: comment out the debugger^
  ]])
}:with {
  obj {
    nam = "#intro",
    act = function()
      walk('diary1')
    end,
    used = function(s,w)
      if w^'DEBUGGER' then
        view_source('menu');
      end
    end
  },
  obj {
    nam = "#howto",
    act = function()
      theme_switch('finale')
      walk('howto')
    end,
    used = function(s,w)
      if w^'DEBUGGER' then
        view_source('menu');
      end
    end
  },
  obj {
    nam = "#play",
    act = function()
      walk('game_start')
    end,
    used = function(s,w)
      if w^'DEBUGGER' then
        view_source('menu');
      end
    end
  }
}


room {
  nam = "howto";
  disp = "How to play",
  decor = [[
  The scene occupies most of the screen, with the inventory shown to the right. Active items are shown in a different text color and are highlighted on mouseover.^
  ^
  <b>Examine item in the scene</b>^
  Click the item. If the item can be taken, it will immediately appear in your inventory.^
   ^  
  <b>Go to another location</b>^
  Locations that can be visited are listed under the scene name. New places to go can appear after you interact with items in the scene.^
   ^  
  <b>Examine item in inventory</b>^
  Double click the item.^
   ^
  <b>Use the item from inventory</b>^
  Click on the item in the inventory; the cursor will change its appearance. Then click on the target item, which can be in the scene or in inventory. Click elsewhere to deselect the item.^
   ^
  ]] .. fmt.c('{#back|Return to menu}')
}:with {
  obj {
    nam = "#back",
    act = function()
      theme_switch('game')
      walk('menu')
    end
  }
}

