room {
  nam = "loc_mypc",
  disp = "My Computer",
  pic = "gfx/pc.png",
  decor = function(s, w)
    p [[ ^ There is only one icon on the desktop -- a blue book with two golden gears.^
    Below that is the text "I.A.G. Alpha". ]]
  end,
  way = {
    path {'#close_pc', "Move away", 'loc_4f_workspace_myplace'},
    path {'#close_pc', [["I.A.G. Alpha"]], 'loc_nii_alpha_1'}
  }
}

room {
  nam = "loc_nii_alpha_1",
  disp = "I.A.G. Alpha",
  noinv = true,
  enter = function ()
    theme_switch('pc')
    music_player('snd/dubmood_-_intro14.ogg')
  end,
  dsc = function(s, w)
    pn " ^I.ncomplete^A.dventure^G.ame^ALPHA"
    pn (' ')
    pn "{#next|New game}"
  end
}:with {
  obj { nam = "#next", act = function() walk('loc_nii_alpha_2') end }
}


room {
  nam = "loc_nii_alpha_2",
  disp = "I.A.G. Alpha",
  noinv = true,
  dsc = function(s, w)
    pn(fmt.l([[
    Anton is sitting at his computer. He just launched an unfinished game and after reading the game text stares in disbelief.^
      Ruslan enters. He throws Anton a short glance, in which can be read both surprise and hope.^
      Approaching Anton, Ruslan dares not speak. Finally, he gathers himself and asks in a low voice:^
      "Did you understand the meaning of my messages?"^
     ^
    {#next|"It's you!" Anton breaks into a cry. "It's all your fault!!!"}^
    ]]))
  end
}:with {
  obj { nam = "#next", act = function() walk('loc_nii_alpha_3') end }
}

room {
  nam = "loc_nii_alpha_3",
  disp = "I.A.G. Alpha",
  noinv = true,
  dsc = function(s, w)
    pn(fmt.l([[
    "It's you!" Anton breaks into a cry. "It's all your fault!!!"^
     ^
    Ruslan ignores Anton's cry and continues calmly: "Actually, I'm not talking to you, Anton. 
    You are just a player character, and    I need to talk with the player himself. Or herself?^
    Either way -- with whomever is reading these lines now. And you are reading them, aren't you?"^
     ^
    {#next|"What's happening?"}^
    ]]))
  end
}:with {
  obj { nam = "#next", act = function() walk('loc_nii_alpha_4') end }
}

room {
  nam = "loc_nii_alpha_4",
  disp = "I.A.G. Alpha",
  noinv = true,
  dsc = function(s, w)
    pn(fmt.l([[
    "What's happening?"^
     ^
     After hearing the answer, Ruslan says thoughtfully: "Yes, indeed, I didn’t think about that. The interface of the game won’t let us communicate freely ..."^
     After a pause, he continues: "Let's try this method: if you choose the second dialogue option -- 
     I will take that as a "yes". Anything else would be a "no." 
     So, the question is: do you understand what I am writing to you?"^
     ^
     {#next2|"Who are you talking to now?"}^
     {#next1|"I don't understand..."}^
     {#next3|"What are you carrying on about?"}
    ]]))
  end
}:with {
  obj { nam = "#next1", act = function() walk('loc_nii_alpha_5') end },
  obj { nam = "#next2", act = function()
    _'loc_nii_alpha_end_fail'.phrase1 = [[Anton is totally confused: "Who are you talking to now?"]]
    _'loc_nii_alpha_end_fail'.phrase2 = [["Sigh. What a pity... Give it another go when you understand. I'll wait."]]
    walk('loc_nii_alpha_end_fail')
  end },
  obj { nam = "#next3", act = function()
    _'loc_nii_alpha_end_fail'.phrase1 = [[Anton is totally confused: "What are you carrying on about?"]]
    _'loc_nii_alpha_end_fail'.phrase2 = [["Sigh. What a pity... Give it another go when you understand. I'll wait."]]
    walk('loc_nii_alpha_end_fail')
  end }

}

room {
  nam = "loc_nii_alpha_5",
  disp = "I.A.G. Alpha",
  noinv = true,
  dsc = function(s, w)
    pn(fmt.l([[
     "I don't understand..."^
     ^
     A smile appears on Ruslan's face.^
    "Terrific!" he exclaims. "A real player, at last!"^
     Winking at Anton, he continues:^
     "Let's not waste our time. You have already noticed that this game
     is not finished. But even worse, the game will never be completed!
     You see, the whole point of my existence is to face the main
     character in the climax of the game.
     But it's not there and never will be!"^
     ^
     {#next|-- ...}
    ]]))
  end
}:with {
  obj { nam = "#next", act = function() walk('loc_nii_alpha_6') end },
}


room {
  nam = "loc_nii_alpha_6",
  disp = "I.A.G. Alpha",
  noinv = true,
  dsc = function(s, w)
    pn(fmt.l([[
    Anton listens to Ruslan.^
    ^
    "However, there is still hope. Fortunately, the author of the game
    forgot to remove the debugger from the game code, and I found
    a way to enable it. And just before you came, I managed
    to activate the name editing feature so you can rename objects."^
    "I checked -- all locations and items, although unfinished, 
    are in their places. Therefore, with the help of a debugger,
    you can get through the game, reach its end, and then my existence
    will finally have meaning. After so many years!"^
     ^
    {#next|-- ...}
    ]]))
  end
}:with {
  obj { nam = "#next", act = function() walk('loc_nii_alpha_7') end },
}


room {
  nam = "loc_nii_alpha_7",
  disp = "I.A.G. Alpha",
  noinv = true,
  -- pic = "gfx/",
  dsc = function(s, w)
    pn(fmt.l([[
    Anton waits.^
    ^
    Ruslan asks hopefully, "You'll help me, won’t you?"^
    Then he adds, "Just a small reminder: The second options is "yes", all the rest are "no", just as before."^
     ^
    {#next3|"No, I will never do it."}^
    {#next1|"You're saying some weird things."}^
    {#next2|"What should I do?"}
    ]]))
  end
}:with {
  obj { nam = "#next1", act = function() walk('loc_nii_alpha_end_success') end },
  obj { nam = "#next2", act = function()
    _'loc_nii_alpha_end_fail'.phrase1 = [["What should I do?" Anton wonders.]]
    _'loc_nii_alpha_end_fail'.phrase2 = [["I'm so sorry to hear that. Let me know if you change your mind. I'll wait."]]
    walk('loc_nii_alpha_end_fail')
  end },
  obj { nam = "#next3", act = function()
    _'loc_nii_alpha_end_fail'.phrase1 = [["No, I will never do it," Anton says firmly.]]
    _'loc_nii_alpha_end_fail'.phrase2 = [["I'm so sorry to hear that. Let me know if you change your mind. I'll wait."]]
    walk('loc_nii_alpha_end_fail')
  end }

}


room {
  nam = "loc_nii_alpha_end_fail",
  disp = "I.A.G. Alpha",
  phrase1 = '',
  phrase2 = '',
  noinv = true,
  dsc = function(s, w)
    pn(fmt.l(s.phrase1 ..[[
    ^ ^
    The smile instantly disappears from Ruslan’s face. A minute ago his face was radiant with hope, now not a sign of it remains.^
    After a little while, he goes to the exit. In the doorway, he turns around and says: ]]
    .. s.phrase2 ..
    [[^Ruslan leaves. The text on the monitor blinks several times and slowly fades out.^
     ^
    {#next|Anton stares at a black screen.}^
    ]]))
  end
}:with {
  obj { nam = "#next", act = function()
    theme_switch('game')
    music_player('snd/Ryan_Andersen_-_Flawless.ogg')
    walk('loc_mypc')
  end }
}

room {
  nam = "loc_nii_alpha_end_success",
  disp = "I.A.G. Alpha",
  noinv = true,
  dsc = function(s, w)
    pn(fmt.l([[
    "You're saying strange things." Anton still cannot get his head around what he has heard.
    ^
    Ruslan smiles hesitantly, not daring to believe what is happening.
    When he decides to speak again, there a touch of hope in his voice:^
    "If -- or rather, when -- you succeed, we will meet again. On the roof. Good luck."      
    ^
    Ruslan leaves. The text on the monitor blinks several times and slowly fades out.^
    ^
    {#next|Anton stares at a black screen.}^
    ]]))
  end
}:with {
  obj { nam = "#next", act = function()
    theme_switch('game')
    walk('loc_anotherpc')
  end }
}

room {
  nam = "loc_anotherpc",
  disp = "My Computer",
  pic = "gfx/pc-empty.png", 
  dsc = function(s, w)
    p [[ ^ There are no icons on the desktop now. ]]
  end,
  way = {
    path {'#close_pc', "Move away", 'loc_4f_cabinetX1'}
  },
  onexit = 'Then I noticed that the room had changed. I was sitting at one of the computers in our computer lab, in Block 4B. How did I get there?';
  enter = function(s,w)
    music_player('snd/Ryan_Andersen_-_Solitude.ogg')
    -- переместить фотоаппарат в нужную локацию, если игрок его не взял
    if not have 'photo_smena' then
      place('photo_smena', 'loc_4f_cabinetX2')
    end
  end
}

