obj {
  nam = "labentrance_plant",
  disp = "Plant",
  dsc = function (s,w)
    p[[By the window, there is a {plant} in a huge pot. ]]
  end,
  act = function (s,w)
    p[[In the five years that I've worked here, I have not bothered to find out what it is. I know for sure that it's not a ficus.]]
    if _"loc_4f_labentrance".search_password and not have "box_key" then
      p[[^I go a bit closer to the pot and notice a small key behind the stem of the plant.]]
      enable "box_key"
    end
  end,
  used = function(s,w)
    if w^'DEBUGGER' then
      view_source('labentrance_plant')
      return
    elseif w.HIDDEN_name == name_of_rod then
      p [[Having nothing better to do, I stick the metal rod into the ground and suddenly catch sight of  something behind the plant’s stem. Is it a key?]]
      enable "box_key"
      return
    end
    return false
  end,
  obj = {
    _"box_key":disable()
  },
}


obj {
  nam = "labentrance_lounge",
  disp = "Armchairs",
  dsc = [[There are also two {armchairs} ]],
  act = [[There is no question that these chairs remember the <i>perestroika</i> era -- and they look it. We should have replaced them with new ones years ago.]],
  used = function(s,w)
    if w^'DEBUGGER' then
      view_source('labentrance_lounge')
      return
    end
    return false
  end,
}


room {
  nam = "read_labentrance_newspaper",
  noinv = true,
  pic = "gfx/characters.png",
  disp = [["Pravda" newspaper]],
  dsc = function (s,w)
    p[[ TODO: newspaper article. ]]
  end,
  obj = {
    obj { dsc=[[{Put down the newspaper} ^ ]], act= function () walk("loc_4f_labentrance") end }
  }
}

obj {
  nam = "labentrance_newspaper",
  disp = "Newspaper",
  dsc = function (s,w)
    p[[On the table is a current {newspaper}.]]
  end,
  act = function (s,w)
    walk 'read_labentrance_newspaper'
  end, 
  used = function(s,w)
    if w^'DEBUGGER' then
      view_source('labentrance_newspaper')
      return
    end
    return false
  end
}


obj {
  nam = "labentrance_table",
  disp = "Table",
  dsc = function (s,w)
    p[[and a {coffee table}.]]
  end,
  act = function (s,w)
    p[[Usually, the only thing on the table is dust. But today's newspaper now lies on it. Apparently, our "security guy" brought it.]]
    enable "labentrance_newspaper"
    if _"loc_4f_labentrance".search_password then
      p[[^I look under the table. Of course, there is nothing on the bottom. It was silly to expect that the password would be in such a prominent place.]]
    end
  end,
  used = function(s,w)
    if w^'DEBUGGER' then
      view_source('labentrance_table')
      return
    end
    return false
  end,
  obj = {
    _"labentrance_newspaper":disable()
  }
}

-- =======================================

obj {
  nam = "labentrance_security_terminal",
  is_seen = false,
  disp = "Terminal",
  dsc = function (s,w)
    p[[On the desk is a {security terminal}.]]
  end,
  act = function (s,w)
    walk 'interact_security_terminal'
  end,
  used = function(s,w)
    if w^'DEBUGGER' then
      view_source('labentrance_security_terminal')
      return
    elseif w.HIDDEN_name == name_of_myid or w.HIDDEN_name == name_of_guardid then
      p [[It looks like I need to launch the program first.]]
      return
    elseif w.HIDDEN_name == name_of_rod then
      p [[Well, no, I need the terminal in one piece.]]
      return
    end
    return false
  end,
}

obj {
  nam = "labentrance_security_phone",
  disp = "Phone",
  dsc = function (s,w)
    p[[Next to it is an old {dial phone}.]]
  end,
  act = function (s,w)
    if _"loc_4f_labentrance".search_password then
      p[[I turned the phone over, expecting to see a sticker with a password. But there wasn’t any.]]
    else
      p[[I picked up the phone. Instead of the usual ringtone, there was a rustling in the receiver. I even thought that I heard someone's voice, but I could not make out the words.
         ^
		 I waited a few seconds and hung up. It is high time to dump these ancient phones and have a modern PBX installed.]]
    end
  end,
  used = function(s,w)
    if w^'DEBUGGER' then
      view_source('labentrance_security_phone')
      return
    end
    return false
  end
}

obj {
  nam = "labentrance_security_box",
  is_open = false,
  disp = "Desk drawers",
  dsc = function (s,w)
    p[[On the side of the desk there is a {drawer} ]]
  end,
  act = function (s,w)
    if s.is_open then
      p[[In the drawer are some papers.]]
      enable "labentrance_papers"
    else
      p[[I pull the handle. Apparently, the drawer is locked.]]
    end
  end,
  used = function(s,w)
    if w^'DEBUGGER' then
      view_source('labentrance_security_box')
      return
    elseif w.HIDDEN_name == name_of_rod then
      p [[Using the metal rod as a lever, I broke the drawer.]]
      s.is_open = true
      return
    elseif w.HIDDEN_name == name_of_smallkey then
      p [[I open the drawer with the key.]]
      sound_player('snd/lock.ogg')
      s.is_open = true
      return
    end
    return false
  end
}

obj {
  nam = "labentrance_security_tumb",
  disp = "Storage compartment",
  dsc = function (s,w)
    p[[and a {storage compartment}.]]
  end,
  act = function (s,w)
    p[[In the storage compartment stand a cup, a kettle, a box of sugar and a packet of cookies. I’m not sure if I need any of this.]]
  end,
  used = function(s,w)
    if w^'DEBUGGER' then
      view_source('labentrance_security_tumb')
      return
    end
    return false
  end
}


obj {
  nam = "labentrance_papers",
  disp = "Papers",
  dsc = [[There are some {papers} in the drawer.]],
  act = function (s, w)
    sound_player('snd/paper.ogg')
    p [[In a small bundle of papers, I found an invoice for the purchase of a plant (it turned out to be called monstera), some instructions and job applications, and a yellow Post-It note with the inscription "MindIsABlackBox", under which someone penciled in "Don’t forget to change." I hope that he had forgotten to change the password...]]
    _"loc_4f_labentrance".search_password = false
    _"loc_4f_labentrance".password_found = true
  end,
  used = function(s,w)
    if w^'DEBUGGER' then
      view_source('labentrance_papers')
      return
    end
    return false
  end
}

obj {
  nam = "labentrance_security",
  is_seen = false,
  disp = "Security desk",
  dsc = function (s,w)
    p[[^The {security desk} is on the left. ]]
  end,
  act = function (s,w)
    if s.is_seen == false then
      p[[Our guard likes to call himself "The Security Guy". Let him call himself whatever he wants as long as he does his job.^
        But where did he go? He probably went to the front gate to smoke with the new recruit.]]
      enable "labentrance_security_terminal"
      enable "labentrance_security_phone"
      s.is_seen = true
    else
      p[[There is nothing else on the desk, except for the terminal and the phone.]]
      if _"loc_4f_labentrance".search_password then
        p[[I suspect that it is worth examining the desk drawers, perhaps there is a paper inside with a password or at least a hint.]]
        enable "labentrance_security_box"
        enable "labentrance_security_tumb"
      end
    end
  end,
  used = function(s,w)
    if w^'DEBUGGER' then
      view_source('labentrance_security')
      return
    end
    return false
  end,
  obj = {
    _"labentrance_security_terminal":disable(),
    _"labentrance_security_phone":disable(),
    _"labentrance_security_box":disable(),
    _"labentrance_security_tumb":disable(),
    _"labentrance_papers":disable(),
  }
}

obj {
  nam = "labentrance_door",
  disp = "Door",
  dsc = function (s,w)
    p[[^ Ahead is the {door} leading to our complex. It is equipped with a card reader.]]
  end,
  act = function (s,w)
    p[[The door is securely closed. I need to use the ID card to get inside.]]
  end,
  used = function (s,w)
    if w^'DEBUGGER' then
      view_source('labentrance_door')
      return
    elseif w^"personal_passcard" then
      if _"personal_passcard".level < 3 then
        p [[I swipe my ID card through the reader. The message "Insufficient access level" appears on the display. ]]
      else
        p [[I swipe guard's ID card through the reader. The indicator change color to green, and hear the lock click. Finally, I can get to my workplace.]]
        enable "path_block_a1"
      end
      return
    elseif w.HIDDEN_name == name_of_guardid then
      p [[I swipe a card through the reader, but the indicator says that the access level of this card is not sufficient. It seems that the guard's card doesn't work here.]]
      return
    end
    return false
  end,
}


room {
  nam = "loc_4f_labentrance",
  search_password = false,
  password_found = false,
  disp = "Fourth floor",
  -- pic = "gfx/",
  dsc = function(s, w)
    pn ()
    p [[The fourth floor. The entrance to our research complex was here.^
    -- TODO: description needed ]]
  end,
  obj = {
    "labentrance_plant",
    "labentrance_lounge",
    "labentrance_table",
    "labentrance_security",
    "labentrance_door"
  },
  way = {
    path {"path_block_a1", "Enter the complex ^", 'loc_enter_complex'}:disable(),
  },
}



dlg {
  nam = "interact_security_terminal",
  title = 'Security terminal',
  noinv = true,
  -- pic = "gfx/",
  enter = function(s,w)
    if visits() < 1 then
        p[[The security terminal was only supposed to be used for work purposes. Looking at the screen, I am once again convinced that nobody cares about regulations -- not only had “Security Guy” not locked the screen, but he had left his game of solitaire open on it. 
            ^I exit the solitaire game and launched our "Sentinel" system.]]
        end
  end,
  dsc = [[ Welcome to Sentinel system (c) 2005-2013 I.A.G. Security Inc.^ Please, choose your option:]],
  phr = {
    {
      always = true, 
      "/ System status", 
      function(s)
        p [[
        ---[ System status ]----- ^
        Entrance: Activated, access level 3. ^
        4A block: Activated, access level 3.^
        4B block: Activated, access level 3.^
        5A block: connection lost. ^
        5B block: connection lost. ^
        --------
        ]];
      end
    },
    {
      always = true, 
      "/ Read ID card", 
      function(s)
        p [[
        ---[ Read ID card ]----- ^
        Please, insert the ID card into the reader. ^
        --------
        ]]
      end,
      {
        always = true,
        "[Insert my ID card into the reader]",
        function(s)
          p([[
          ---[ ID card Information ]----- ^
          Full name: Anton Golubev  ^
          Position: Senior researcher ^
          Department: Chemical Synthesis ^
          Access level: ]] .. _"personal_passcard".level .. [[ ^^
          Recent security log records: ^ ]])
          if _"personal_passcard".level > 1 then
              p([[- [today] access level changed from 1 to ]] .. _"personal_passcard".level .. [[^]])
          end
          p [[
          - [yesterday] access level changed from 4 to 1 ^
          - [a week ago] access level changed from 3 to 4 ^
          --------
          ]];
        end
      },
      {
        always = true,
        "[Insert guard's ID card into the reader]",
        function(s)
          p [[
          ---[ ID card Information ]----- ^
          Full name: $%&**&23#%#!@#$ $*#@$*%$43!# @%$!2!@# ^
          Position: Guard ^
          Department: Internal Security Service ^
          Access level: 2 ^^
          Recent security log records: ^
          - [yesterday] $3434%$% @#@# @#!@ 5$%$34!!! ^
          - GENERAL FAILURE. Can't read log records. ^
          --------
          ]];
        end
      },
      {
        always = true,
        "/ Return to the main menu",
        function(s) pop() end 
      }
    },
    {
      always = true, 
      "/ Change access level", 
      function(s)
        p [[
        ---[ Change access level ]----- ^
        Enter password: _ ^
        --------
        ]]
        if not _"loc_4f_labentrance".password_found then
          -- we still do not know password
          _"loc_4f_labentrance".search_password = true
        end
      end,
      {
        always = true,
        "[Try to guess the password]",
        function(s)
          p [[
            -------- ^
            [!] The password is incorrect. Please enter the correct password. ^
            --------
          ]];
        end
      },
      { 
        cond = function ()
          return _"loc_4f_labentrance".password_found
        end, 
        always = true,
        "MindIsABlackBox",
        function(s)
          p [[
          ---[ Change access level ]----- ^
          Please, insert the ID card into the reader. ^
          --------
          ]];
        end,
        {
          always = true,
          "[Insert my ID card into the reader]",
          function(s)
            p([[
            ---[ Change access level ]----- ^
            Full name: Anton Golubev ^
            Current access level: ]] .. _"personal_passcard".level .. [[^
            New access level: ^
            --------
            ]]);
          end,
          {
            always = true,
            "Level 2",
            function(s)
              p [[
              ---[ Change access level ]----- ^
              New access level: 2 ^
              --------
              ]]
              _"personal_passcard".level = 2
              pop()
            end
          },
          {
            always = true,
            "Level 3",
            function(s)
              p [[
              ---[ Change access level ]----- ^
              New access level: 3 ^
              --------
              ]] 
              _"personal_passcard".level = 3
              pop()
            end
          },
          {
            always = true,
            "Level 4",
            function(s)
              p [[
              ---[ Change access level ]----- ^
              Granting access level 4 requires the department head's approval. ^
              --------
              ]]
              pop()
            end
          },
          {
            always = true,
            "Level 5",
            function(s)
              p [[
              ---[ Change access level ]----- ^
              Granting access level 5 requires the department head's approval. ^
              --------
              ]]
              pop()
            end
          },
          {
            always = true,
            "/ Return to the main menu",
            function(s) pop() end
          }
        },
        {
          always = true,
          "[Insert guard's ID card into the reader]",
          function(s)
            p [[
            ---[ Change access level ]----- ^
            GENERAL FAILURE. Cannot update ID card. Please contact the system administrator. ^
            --------
            ]];
          end
        },
        {
          always = true,
          "/ Disconnect",
          function(s)
            walk "loc_4f_labentrance"
          end
        }
      },
      {
        always = true,
        "/ Return to the main menu",
        function(s) pop() end
      },
    },
    {
      always = true,
      "/ - Logoff -", 
      function(s)
        if _"loc_4f_labentrance".search_password then
          p "To change the access level, I need a password. Where could it be?"
        end
        walk "loc_4f_labentrance"
      end
    },
  }
}


