function taker_detail(ob)
  obj_taker(ob, "Red ID card")
end

function taker_photo(ob)
  obj_taker(ob, "Film cartridge")
end

function obj_taker(ob, obj_name)
  if not ob then
    return
  end
  if ob.HIDDEN_name == obj_name then
    if ob.nam == "ruslan" then
      p "^Ruslan no longer hangs from the rebar -- somehow he moved to the edge of the roof."
      ob.is_standing = true
      _'armatura'.with_ruslan = false
      place(ob)
    else
      take(ob)
    end
  end
end


obj {
  nam = "personal_passcard",
  HIDDEN_name = name_of_myid,
  level = 1,
  disp = function(s)
    p(s.HIDDEN_name)
  end,
  inv = [[An ID card for the factory: a plastic card with an electronic chip. Below my photo, my name is printed on the card: Anton Golubev.]],
  nouse = [[I thoughtfully turn the ID card in my hands and put it back in my pocket.]],
  used = function(s,w)
    if w^'DEBUGGER' then
      view_source('personal_passcard');
      return
    end
    return false
  end
}


obj {
  nam = "security_passcard",
  HIDDEN_name = name_of_guardid,
  disp = function(s)
    p(s.HIDDEN_name)
  end,
  dsc = [[Inside, a {red plastic card} lies on the table. It looks like a guard’s ID card.]],
  tak = function (s,w)
    p [[I put my hand between through the grill and try to get the card. Can't reach it -- it's too far.]]
    return false
  end,
  inv = [[The personal ID card of a security guard. It must be brand new -- it hasn’t even been stamped with a name yet.]],
  nouse = [[I turn the guard's card in my hands.]],
  used = function(s,w)
    if w^'DEBUGGER' then
      view_source('security_passcard');
      return
    end
    return false
  end
}


obj {
  nam = "box_detail",
  thrown = false,
  HIDDEN_name = name_of_rod,
  disp = function(s)
    p(s.HIDDEN_name)
  end,
  dsc = function (s)
    if s.thrown then
      p [[A metal {rod} is lying on the floor.]]
    else
      p [[Among other odds and ends in the box there is a metal {rod}.]]
    end
  end,
  tak = "I take the rod.",
  inv = "A metal rod, about a foot and a half long.",
  use = function(s,w)  
    if w.HIDDEN_name == name_of_guardid then
      p [[Using the rod, I manage to pull the card closer. I put my hand through the grill and take red ID card.]]
      objs():for_each(taker_detail)
      return
    end
    return false
  end,
  used = function(s,w)
    if w^'DEBUGGER' then
      view_source('box_detail');
      return
    end
    return false
  end
}


obj {
  nam = "box_key",
  HIDDEN_name = name_of_smallkey,
  disp = function(s)
    p(s.HIDDEN_name)
  end,
  dsc = "A {small key} lies behind the stem of the plant. ",
  tak = "I take the key and put it in my pocket.",
  inv = "A small key. The sort that might fit a lock on a desk drawer.",
  nouse = "Why would I do that?",
  used = function(s,w)
    if w^'DEBUGGER' then
      view_source('box_key');
      return
    end
    return false
  end
}


obj {
  nam = "photo_smena",
  HIDDEN_name = name_of_camera,
  disp = function(s)
    p(s.HIDDEN_name)
  end,
  dsc = "On the floor is an old {film camera}.",
  tak = "I take the camera.",
  inv = function(s,w)
    p 'Opening the lid of the camera, I take out a film cartridge with the inscription "Svema."'
    take 'photo_film'
    objs():for_each(taker_photo)
  end,
  used = function(s,w)
    if w^'DEBUGGER' then
      view_source('photo_smena');
      return
    end
    return false
  end
}

obj {
  nam = "photo_film",
  HIDDEN_name = name_of_fotoplenka,
  disp = function(s)
    p(s.HIDDEN_name)
  end,
  tak = "I take the film cartridge.",
  inv = function(s,w)
    p "The film is undeveloped. I don’t want to expose it."
  end,
  used = function(s,w)
    if w^'DEBUGGER' then
      view_source('photo_film');
      return
    end
    return false
  end
}

obj {
  nam = "topor",
  HIDDEN_name = name_of_topor,
  is_working = false,
  disp = function(s)
    p(s.HIDDEN_name)
  end,
  dsc = function (s)
    if s.is_working then
      p "The {axe} lies on the floor."
    else
      p "On the floor is an {axe} with a cracked handle."
    end
  end,
  act = "A common axe.",
  inv = function (s, w)
    if s.is_working then
      p [[An excellent, sharp axe.]]
    else
      p [[The axe has a cracked handle, making it dangerous to use. How can I fix it?]]
    end
  end,
  used = function(s,w)
    if w^'DEBUGGER' then
      view_source('topor');
      return
    end
    if w.HIDDEN_name == name_of_tape then
      p "I carefully wind tape around the handle of the axe. I hope that's enough."
      s.is_working = true
      return
    end
    return false
  end
}
