/*
 * Decompiled with CFR 0.152.
 */
package simplenlg.xmlrealiser;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import simplenlg.xmlrealiser.wrapper.DocumentRealisation;
import simplenlg.xmlrealiser.wrapper.NLGSpec;
import simplenlg.xmlrealiser.wrapper.RecordSet;
import simplenlg.xmlrealiser.wrapper.XmlDocumentElement;

public class Recording {
    boolean recordingOn = false;
    String recordingFolder;
    RecordSet record = null;
    File recordingFile;

    public Recording(String directoryPath) {
        this.recordingFolder = directoryPath;
    }

    public boolean RecordingOn() {
        return this.recordingOn;
    }

    public String GetRecordingFile() {
        if (this.recordingOn) {
            return this.recordingFile.getAbsolutePath();
        }
        return "";
    }

    public void start() throws IOException {
        if (this.recordingFolder.isEmpty() || this.recordingOn) {
            return;
        }
        File recordingDir = new File(this.recordingFolder);
        if (!recordingDir.exists()) {
            boolean ok = recordingDir.mkdirs();
            if (!ok) {
                return;
            }
            this.recordingFile = File.createTempFile("xmlrealiser", ".xml", recordingDir);
            this.recordingOn = true;
            this.record = new RecordSet();
        }
    }

    public void addRecord(XmlDocumentElement input, String output) {
        if (!this.recordingOn) {
            return;
        }
        DocumentRealisation t = new DocumentRealisation();
        Integer testNumber = this.record.getRecord().size() + 1;
        String testName = "TEST_" + testNumber.toString();
        t.setName(testName);
        t.setDocument(input);
        t.setRealisation(output);
        this.record.getRecord().add(t);
    }

    public void finish() throws JAXBException, IOException, TransformerException {
        if (!this.recordingOn) {
            return;
        }
        this.recordingOn = false;
        FileOutputStream os = new FileOutputStream(this.recordingFile);
        os.getChannel().truncate(0L);
        Recording.writeRecording(this.record, os);
    }

    public static void writeRecording(RecordSet record, OutputStream os) throws JAXBException, IOException, TransformerException {
        JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{NLGSpec.class});
        Marshaller m = jc.createMarshaller();
        NLGSpec nlg = new NLGSpec();
        nlg.setRecording(record);
        StringWriter osTemp = new StringWriter();
        m.marshal((Object)nlg, (Writer)osTemp);
        StreamSource xmlInput = new StreamSource(new StringReader(osTemp.toString()));
        StreamResult xmlOutput = new StreamResult(new OutputStreamWriter(os, "UTF-8"));
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        if (transformer != null) {
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            transformer.transform(xmlInput, xmlOutput);
        }
    }
}

