/*
 * Decompiled with CFR 0.152.
 */
package simplenlg.syntax.english;

import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import simplenlg.features.DiscourseFunction;
import simplenlg.features.Form;
import simplenlg.features.InterrogativeType;
import simplenlg.features.NumberAgreement;
import simplenlg.features.Tense;
import simplenlg.framework.CoordinatedPhraseElement;
import simplenlg.framework.InflectedWordElement;
import simplenlg.framework.LexicalCategory;
import simplenlg.framework.ListElement;
import simplenlg.framework.NLGElement;
import simplenlg.framework.NLGFactory;
import simplenlg.framework.PhraseCategory;
import simplenlg.framework.PhraseElement;
import simplenlg.framework.StringElement;
import simplenlg.framework.WordElement;
import simplenlg.phrasespec.SPhraseSpec;
import simplenlg.syntax.english.PhraseHelper;
import simplenlg.syntax.english.SyntaxProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class VerbPhraseHelper {
    VerbPhraseHelper() {
    }

    static NLGElement realise(SyntaxProcessor parent, PhraseElement phrase) {
        ListElement realisedElement = null;
        Stack<NLGElement> vgComponents = null;
        Stack<NLGElement> mainVerbRealisation = new Stack<NLGElement>();
        Stack<NLGElement> auxiliaryRealisation = new Stack<NLGElement>();
        if (phrase != null) {
            vgComponents = VerbPhraseHelper.createVerbGroup(parent, phrase);
            VerbPhraseHelper.splitVerbGroup(vgComponents, mainVerbRealisation, auxiliaryRealisation);
            realisedElement = new ListElement();
            if (!phrase.hasFeature("realise_auxiliary") || phrase.getFeatureAsBoolean("realise_auxiliary").booleanValue()) {
                VerbPhraseHelper.realiseAuxiliaries(parent, realisedElement, auxiliaryRealisation);
                PhraseHelper.realiseList(parent, realisedElement, phrase.getPreModifiers(), DiscourseFunction.PRE_MODIFIER);
                VerbPhraseHelper.realiseMainVerb(parent, phrase, mainVerbRealisation, realisedElement);
            } else if (VerbPhraseHelper.isCopular(phrase.getHead())) {
                VerbPhraseHelper.realiseMainVerb(parent, phrase, mainVerbRealisation, realisedElement);
                PhraseHelper.realiseList(parent, realisedElement, phrase.getPreModifiers(), DiscourseFunction.PRE_MODIFIER);
            } else {
                PhraseHelper.realiseList(parent, realisedElement, phrase.getPreModifiers(), DiscourseFunction.PRE_MODIFIER);
                VerbPhraseHelper.realiseMainVerb(parent, phrase, mainVerbRealisation, realisedElement);
            }
            VerbPhraseHelper.realiseComplements(parent, phrase, realisedElement);
            PhraseHelper.realiseList(parent, realisedElement, phrase.getPostModifiers(), DiscourseFunction.POST_MODIFIER);
        }
        return realisedElement;
    }

    private static void realiseAuxiliaries(SyntaxProcessor parent, ListElement realisedElement, Stack<NLGElement> auxiliaryRealisation) {
        NLGElement aux = null;
        NLGElement currentElement = null;
        while (!auxiliaryRealisation.isEmpty()) {
            aux = auxiliaryRealisation.pop();
            currentElement = parent.realise(aux);
            if (currentElement == null) continue;
            realisedElement.addComponent(currentElement);
            currentElement.setFeature("discourse_function", (Object)DiscourseFunction.AUXILIARY);
        }
    }

    private static void realiseMainVerb(SyntaxProcessor parent, PhraseElement phrase, Stack<NLGElement> mainVerbRealisation, ListElement realisedElement) {
        NLGElement currentElement = null;
        NLGElement main = null;
        while (!mainVerbRealisation.isEmpty()) {
            main = mainVerbRealisation.pop();
            main.setFeature("interrogative_type", phrase.getFeature("interrogative_type"));
            currentElement = parent.realise(main);
            if (currentElement == null) continue;
            realisedElement.addComponent(currentElement);
        }
    }

    private static void realiseComplements(SyntaxProcessor parent, PhraseElement phrase, ListElement realisedElement) {
        ListElement indirects = new ListElement();
        ListElement directs = new ListElement();
        ListElement unknowns = new ListElement();
        Object discourseValue = null;
        NLGElement currentElement = null;
        for (NLGElement complement : phrase.getFeatureAsElementList("complements")) {
            discourseValue = complement.getFeature("discourse_function");
            currentElement = parent.realise(complement);
            if (currentElement == null) continue;
            currentElement.setFeature("discourse_function", (Object)DiscourseFunction.COMPLEMENT);
            if (DiscourseFunction.INDIRECT_OBJECT.equals(discourseValue)) {
                indirects.addComponent(currentElement);
                continue;
            }
            if (DiscourseFunction.OBJECT.equals(discourseValue)) {
                directs.addComponent(currentElement);
                continue;
            }
            unknowns.addComponent(currentElement);
        }
        if (!InterrogativeType.isIndirectObject(phrase.getFeature("interrogative_type"))) {
            realisedElement.addComponents(indirects.getChildren());
        }
        if (!phrase.getFeatureAsBoolean("passive").booleanValue()) {
            if (!InterrogativeType.isObject(phrase.getFeature("interrogative_type"))) {
                realisedElement.addComponents(directs.getChildren());
            }
            realisedElement.addComponents(unknowns.getChildren());
        }
    }

    private static void splitVerbGroup(Stack<NLGElement> vgComponents, Stack<NLGElement> mainVerbRealisation, Stack<NLGElement> auxiliaryRealisation) {
        boolean mainVerbSeen = false;
        for (NLGElement word : vgComponents) {
            if (!mainVerbSeen) {
                mainVerbRealisation.push(word);
                if (word.equals("not")) continue;
                mainVerbSeen = true;
                continue;
            }
            auxiliaryRealisation.push(word);
        }
    }

    private static final Stack<NLGElement> createVerbGroup(SyntaxProcessor parent, PhraseElement phrase) {
        String actualModal = null;
        Object formValue = phrase.getFeature("form");
        Tense tenseValue = (Tense)((Object)phrase.getFeature("tense"));
        String modal = phrase.getFeatureAsString("modal");
        boolean modalPast = false;
        Stack<NLGElement> vgComponents = new Stack<NLGElement>();
        boolean interrogative = phrase.hasFeature("interrogative_type");
        if (Form.GERUND.equals(formValue) || Form.INFINITIVE.equals(formValue)) {
            tenseValue = Tense.PRESENT;
        }
        if (Form.INFINITIVE.equals(formValue)) {
            actualModal = "to";
        } else if (formValue == null || Form.NORMAL.equals(formValue)) {
            if (Tense.FUTURE.equals((Object)tenseValue) && modal == null && (!(phrase.getHead() instanceof CoordinatedPhraseElement) || phrase.getHead() instanceof CoordinatedPhraseElement && interrogative)) {
                actualModal = "will";
            } else if (modal != null) {
                actualModal = modal;
                if (Tense.PAST.equals((Object)tenseValue)) {
                    modalPast = true;
                }
            }
        }
        VerbPhraseHelper.pushParticles(phrase, parent, vgComponents);
        NLGElement frontVG = VerbPhraseHelper.grabHeadVerb(phrase, tenseValue, modal != null);
        VerbPhraseHelper.checkImperativeInfinitive(formValue, frontVG);
        if (phrase.getFeatureAsBoolean("passive").booleanValue()) {
            frontVG = VerbPhraseHelper.addBe(frontVG, vgComponents, Form.PAST_PARTICIPLE);
        }
        if (phrase.getFeatureAsBoolean("progressive").booleanValue()) {
            frontVG = VerbPhraseHelper.addBe(frontVG, vgComponents, Form.PRESENT_PARTICIPLE);
        }
        if (phrase.getFeatureAsBoolean("perfect").booleanValue() || modalPast) {
            frontVG = VerbPhraseHelper.addHave(frontVG, vgComponents, modal, tenseValue);
        }
        frontVG = VerbPhraseHelper.pushIfModal(actualModal != null, phrase, frontVG, vgComponents);
        if ((frontVG = VerbPhraseHelper.createNot(phrase, vgComponents, frontVG, modal != null)) != null) {
            VerbPhraseHelper.pushFrontVerb(phrase, vgComponents, frontVG, formValue, interrogative);
        }
        VerbPhraseHelper.pushModal(actualModal, phrase, vgComponents);
        return vgComponents;
    }

    private static void pushModal(String actualModal, PhraseElement phrase, Stack<NLGElement> vgComponents) {
        if (actualModal != null && !phrase.getFeatureAsBoolean("ignore_modal").booleanValue()) {
            vgComponents.push(new InflectedWordElement(actualModal, LexicalCategory.MODAL));
        }
    }

    private static void pushFrontVerb(PhraseElement phrase, Stack<NLGElement> vgComponents, NLGElement frontVG, Object formValue, boolean interrogative) {
        Object interrogType = phrase.getFeature("interrogative_type");
        if (Form.GERUND.equals(formValue)) {
            frontVG.setFeature("form", (Object)Form.PRESENT_PARTICIPLE);
            vgComponents.push(frontVG);
        } else if (Form.PAST_PARTICIPLE.equals(formValue)) {
            frontVG.setFeature("form", (Object)Form.PAST_PARTICIPLE);
            vgComponents.push(frontVG);
        } else if (Form.PRESENT_PARTICIPLE.equals(formValue)) {
            frontVG.setFeature("form", (Object)Form.PRESENT_PARTICIPLE);
            vgComponents.push(frontVG);
        } else if ((formValue != null && !Form.NORMAL.equals(formValue) || interrogative) && !VerbPhraseHelper.isCopular(phrase.getHead()) && vgComponents.isEmpty()) {
            if (!InterrogativeType.WHO_SUBJECT.equals(interrogType) && !InterrogativeType.WHAT_SUBJECT.equals(interrogType)) {
                frontVG.setFeature("non_morph", true);
            }
            vgComponents.push(frontVG);
        } else {
            NumberAgreement numToUse = VerbPhraseHelper.determineNumber(phrase.getParent(), phrase);
            frontVG.setFeature("tense", phrase.getFeature("tense"));
            frontVG.setFeature("person", phrase.getFeature("person"));
            frontVG.setFeature("number", (Object)numToUse);
            if (!phrase.getFeatureAsBoolean("negated").booleanValue() || !InterrogativeType.WHO_OBJECT.equals(interrogType) && !InterrogativeType.WHAT_OBJECT.equals(interrogType)) {
                vgComponents.push(frontVG);
            }
        }
    }

    private static NLGElement createNot(PhraseElement phrase, Stack<NLGElement> vgComponents, NLGElement frontVG, boolean hasModal) {
        NLGElement newFront = frontVG;
        if (phrase.getFeatureAsBoolean("negated").booleanValue()) {
            boolean addDo;
            NLGFactory factory = phrase.getFactory();
            Object interrType = phrase.getFeature("interrogative_type");
            boolean bl = addDo = !InterrogativeType.WHAT_OBJECT.equals(interrType) && !InterrogativeType.WHO_OBJECT.equals(interrType);
            if (!vgComponents.empty() || frontVG != null && VerbPhraseHelper.isCopular(frontVG)) {
                vgComponents.push(new InflectedWordElement("not", LexicalCategory.ADVERB));
            } else {
                if (frontVG != null && !hasModal) {
                    frontVG.setFeature("negated", true);
                    vgComponents.push(frontVG);
                }
                vgComponents.push(new InflectedWordElement("not", LexicalCategory.ADVERB));
                if (addDo) {
                    newFront = factory != null ? factory.createInflectedWord("do", LexicalCategory.VERB) : new InflectedWordElement("do", LexicalCategory.VERB);
                }
            }
        }
        return newFront;
    }

    private static NLGElement pushIfModal(boolean hasModal, PhraseElement phrase, NLGElement frontVG, Stack<NLGElement> vgComponents) {
        NLGElement newFront = frontVG;
        if (hasModal && !phrase.getFeatureAsBoolean("ignore_modal").booleanValue()) {
            if (frontVG != null) {
                frontVG.setFeature("non_morph", true);
                vgComponents.push(frontVG);
            }
            newFront = null;
        }
        return newFront;
    }

    private static NLGElement addHave(NLGElement frontVG, Stack<NLGElement> vgComponents, String modal, Tense tenseValue) {
        NLGElement newFront = frontVG;
        if (frontVG != null) {
            frontVG.setFeature("form", (Object)Form.PAST_PARTICIPLE);
            vgComponents.push(frontVG);
        }
        newFront = new InflectedWordElement("have", LexicalCategory.VERB);
        newFront.setFeature("tense", (Object)tenseValue);
        if (modal != null) {
            newFront.setFeature("non_morph", true);
        }
        return newFront;
    }

    private static NLGElement addBe(NLGElement frontVG, Stack<NLGElement> vgComponents, Form frontForm) {
        if (frontVG != null) {
            frontVG.setFeature("form", (Object)frontForm);
            vgComponents.push(frontVG);
        }
        return new InflectedWordElement("be", LexicalCategory.VERB);
    }

    private static void checkImperativeInfinitive(Object formValue, NLGElement frontVG) {
        if ((Form.IMPERATIVE.equals(formValue) || Form.INFINITIVE.equals(formValue) || Form.BARE_INFINITIVE.equals(formValue)) && frontVG != null) {
            frontVG.setFeature("non_morph", true);
        }
    }

    private static NLGElement grabHeadVerb(PhraseElement phrase, Tense tenseValue, boolean hasModal) {
        NLGElement frontVG = phrase.getHead();
        if (frontVG != null) {
            if (frontVG instanceof WordElement) {
                frontVG = new InflectedWordElement((WordElement)frontVG);
            }
            if (tenseValue != null) {
                frontVG.setFeature("tense", (Object)tenseValue);
            }
            if (hasModal) {
                frontVG.setFeature("negated", false);
            }
        }
        return frontVG;
    }

    private static void pushParticles(PhraseElement phrase, SyntaxProcessor parent, Stack<NLGElement> vgComponents) {
        Object particle = phrase.getFeature("particle");
        if (particle instanceof String) {
            vgComponents.push(new StringElement((String)particle));
        } else if (particle instanceof NLGElement) {
            vgComponents.push(parent.realise((NLGElement)particle));
        }
    }

    private static NumberAgreement determineNumber(NLGElement parent, PhraseElement phrase) {
        Object numberValue = phrase.getFeature("number");
        NumberAgreement number = null;
        number = numberValue != null && numberValue instanceof NumberAgreement ? (NumberAgreement)((Object)numberValue) : NumberAgreement.SINGULAR;
        if (parent instanceof PhraseElement && parent.isA(PhraseCategory.CLAUSE) && (PhraseHelper.isExpletiveSubject((PhraseElement)parent) || InterrogativeType.WHO_SUBJECT.equals(parent.getFeature("interrogative_type")) || InterrogativeType.WHAT_SUBJECT.equals(parent.getFeature("interrogative_type"))) && VerbPhraseHelper.isCopular(phrase.getHead())) {
            number = VerbPhraseHelper.hasPluralComplement(phrase.getFeatureAsElementList("complements")) ? NumberAgreement.PLURAL : NumberAgreement.SINGULAR;
        }
        return number;
    }

    private static boolean hasPluralComplement(List<NLGElement> complements) {
        boolean plural = false;
        Iterator<NLGElement> complementIterator = complements.iterator();
        NLGElement eachComplement = null;
        Object numberValue = null;
        while (complementIterator.hasNext() && !plural) {
            eachComplement = complementIterator.next();
            if (eachComplement == null || !eachComplement.isA(PhraseCategory.NOUN_PHRASE) || (numberValue = eachComplement.getFeature("number")) == null || !NumberAgreement.PLURAL.equals(numberValue)) continue;
            plural = true;
        }
        return plural;
    }

    public static boolean isCopular(NLGElement element) {
        boolean copular = false;
        if (element instanceof InflectedWordElement) {
            copular = "be".equalsIgnoreCase(((InflectedWordElement)element).getBaseForm());
        } else if (element instanceof WordElement) {
            copular = "be".equalsIgnoreCase(((WordElement)element).getBaseForm());
        } else if (element instanceof PhraseElement) {
            NLGElement head;
            NLGElement nLGElement = head = element instanceof SPhraseSpec ? ((SPhraseSpec)element).getVerb() : ((PhraseElement)element).getHead();
            if (head != null) {
                copular = head instanceof WordElement && "be".equals(((WordElement)head).getBaseForm());
            }
        }
        return copular;
    }
}

