/*
 * Decompiled with CFR 0.152.
 */
package simplenlg.server;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;

public class SimpleClient {
    static final String testData = "<?xml version=\"1.0\" encoding=\"utf-8\"?>\n<nlg:NLGSpec xmlns=\"http://simplenlg.googlecode.com/svn/trunk/res/xml\"\n    xmlns:nlg=\"http://simplenlg.googlecode.com/svn/trunk/res/xml\"\n    xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n    xsi:schemaLocation=\"http://simplenlg.googlecode.com/svn/trunk/res/xml \">\n    <nlg:Request>\n        <Document cat=\"PARAGRAPH\">\n            <child xsi:type=\"SPhraseSpec\" FORM=\"IMPERATIVE\">\n                <vp xsi:type=\"VPPhraseSpec\">\n                    <head xsi:type=\"WordElement\" cat=\"VERB\">\n                        <base>put</base>\n                    </head>\n                    <compl xsi:type=\"CoordinatedPhraseElement\" conj=\"and\" discourseFunction=\"OBJECT\">\n                        <coord xsi:type=\"NPPhraseSpec\">\n                            <spec xsi:type=\"WordElement\" cat=\"DETERMINER\">\n                                <base>the</base>\n                            </spec>\n                            <head xsi:type=\"WordElement\" cat=\"NOUN\">\n                                <base>piano</base>\n                            </head>\n                        </coord>\n                        <coord xsi:type=\"NPPhraseSpec\">\n                            <spec xsi:type=\"WordElement\" cat=\"DETERMINER\">\n                                <base>the</base>\n                            </spec>\n                            <head xsi:type=\"WordElement\" cat=\"NOUN\">\n                                <base>drum</base>\n                            </head>\n                        </coord>\n                    </compl>\n                    <compl xsi:type=\"PPPhraseSpec\">\n                        <head xsi:type=\"WordElement\" cat=\"PREPOSITION\">\n                            <base>into</base>\n                        </head>\n                        <compl xsi:type=\"NPPhraseSpec\">\n                            <spec xsi:type=\"WordElement\" cat=\"DETERMINER\">\n                                <base>the</base>\n                            </spec>\n                            <head xsi:type=\"WordElement\" cat=\"NOUN\">\n                                <base>truck</base>\n                            </head>\n                        </compl>\n                    </compl>\n                </vp>\n            </child>\n        </Document>\n    </nlg:Request>\n</nlg:NLGSpec>\n";

    public static void main(String[] args) {
        int port;
        String serverName = args.length > 0 ? args[0] : "localhost";
        try {
            port = Integer.parseInt(args[1]);
        }
        catch (Exception e) {
            port = 50007;
        }
        new SimpleClient().run(serverName, port);
    }

    public String run(String serverName, int port) {
        try {
            System.out.println("Connecting to " + serverName + " on port " + port);
            Socket client = new Socket(serverName, port);
            OutputStream outToServer = client.getOutputStream();
            DataOutputStream out = new DataOutputStream(outToServer);
            byte[] tmp = testData.getBytes("UTF-8");
            out.writeInt(tmp.length);
            out.write(tmp);
            InputStream inFromServer = client.getInputStream();
            DataInputStream in = new DataInputStream(inFromServer);
            int len = in.readInt();
            byte[] data = new byte[len];
            in.readFully(data);
            String text = new String(data, "UTF-8");
            System.out.println("Realisation: " + text);
            client.close();
            return text;
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
            return "";
        }
    }
}

