/*
 * Decompiled with CFR 0.152.
 */
package simplenlg.features;

import simplenlg.framework.ElementCategory;
import simplenlg.framework.LexicalCategory;
import simplenlg.framework.PhraseCategory;

public abstract class LexicalFeature {
    public static final String ACRONYM_OF = "acronym_of";
    public static final String ACRONYMS = "acronyms";
    public static final String DEFAULT_INFL = "default_infl";
    public static final String SPELL_VARS = "spell_vars";
    public static final String DEFAULT_SPELL = "default_spell";
    public static final String BASE_FORM = "base_form";
    public static final String CLASSIFYING = "classifying";
    public static final String COLOUR = "colour";
    public static final String COMPARATIVE = "comparative";
    public static final String DITRANSITIVE = "ditransitive";
    public static final String GENDER = "gender";
    public static final String INTENSIFIER = "intensifier";
    public static final String INTRANSITIVE = "intransitive";
    public static final String PAST = "past";
    public static final String PAST_PARTICIPLE = "pastParticiple";
    public static final String PLURAL = "plural";
    public static final String PREDICATIVE = "predicative";
    public static final String PRESENT_PARTICIPLE = "presentParticiple";
    public static final String PRESENT3S = "present3s";
    public static final String PROPER = "proper";
    public static final String QUALITATIVE = "qualitative";
    public static final String REFLEXIVE = "reflexive";
    public static final String SENTENCE_MODIFIER = "sentence_modifier";
    public static final String SUPERLATIVE = "superlative";
    public static final String TRANSITIVE = "transitive";
    public static final String VERB_MODIFIER = "verb_modifier";
    public static final String EXPLETIVE_SUBJECT = "expletive_subject";

    private LexicalFeature() {
    }

    public static String[] getInflectionalFeatures(ElementCategory cat) {
        if (PhraseCategory.NOUN_PHRASE.equals(cat) || LexicalCategory.NOUN.equals(cat)) {
            return new String[]{PLURAL};
        }
        if (PhraseCategory.VERB_PHRASE.equals(cat) || LexicalCategory.VERB.equals(cat)) {
            return new String[]{PAST, PAST_PARTICIPLE, PRESENT_PARTICIPLE, PRESENT3S};
        }
        if (PhraseCategory.ADJECTIVE_PHRASE.equals(cat) || LexicalCategory.ADJECTIVE.equals(cat)) {
            return new String[]{COMPARATIVE, SUPERLATIVE};
        }
        return null;
    }
}

