/*
 * Decompiled with CFR 0.152.
 */
package simplenlg.aggregation;

import java.util.Arrays;
import java.util.List;
import simplenlg.aggregation.Periphery;
import simplenlg.features.DiscourseFunction;
import simplenlg.framework.ElementCategory;
import simplenlg.framework.ListElement;
import simplenlg.framework.NLGElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FunctionalSet {
    private List<NLGElement> components;
    private DiscourseFunction function;
    private ElementCategory category;
    private Periphery periphery;

    public static FunctionalSet newInstance(DiscourseFunction func, ElementCategory category, Periphery periphery, NLGElement ... components) {
        FunctionalSet pair = null;
        if (components.length >= 2) {
            pair = new FunctionalSet(func, category, periphery, components);
        }
        return pair;
    }

    FunctionalSet(DiscourseFunction func, ElementCategory category, Periphery periphery, NLGElement ... components) {
        this.function = func;
        this.category = category;
        this.periphery = periphery;
        this.components = Arrays.asList(components);
    }

    public boolean formIdentical() {
        boolean ident = true;
        NLGElement firstElement = this.components.get(0);
        for (int i = 1; i < this.components.size() && ident; ++i) {
            ident = firstElement.equals(this.components.get(i));
        }
        return ident;
    }

    public boolean lemmaIdentical() {
        return false;
    }

    public void elideLeftMost() {
        for (int i = 0; i < this.components.size() - 1; ++i) {
            this.recursiveElide(this.components.get(i));
        }
    }

    public void elideRightMost() {
        for (int i = this.components.size() - 1; i > 0; --i) {
            this.recursiveElide(this.components.get(i));
        }
    }

    private void recursiveElide(NLGElement component) {
        if (component instanceof ListElement) {
            for (NLGElement subcomponent : component.getFeatureAsElementList("components")) {
                this.recursiveElide(subcomponent);
            }
        } else {
            component.setFeature("elided", true);
        }
    }

    public DiscourseFunction getFunction() {
        return this.function;
    }

    public ElementCategory getCategory() {
        return this.category;
    }

    public Periphery getPeriphery() {
        return this.periphery;
    }

    public List<NLGElement> getComponents() {
        return this.components;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        for (NLGElement elem : this.components) {
            buffer.append("ELEMENT: ").append(elem.toString()).append("\n");
        }
        return buffer.toString();
    }
}

