/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.jdbc;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.sql.Clob;
import java.sql.SQLException;
import org.hsqldb.jdbc.Util;
import org.hsqldb.lib.java.JavaSystem;

public class JDBCClob
implements Clob {
    private static final long MIN_POS = 1L;
    private static final long MAX_POS = 0x80000000L;
    private volatile String data;
    private final boolean createdByConnection;

    @Override
    public long length() throws SQLException {
        String string = this.data;
        this.checkValid(string);
        return string.length();
    }

    @Override
    public String getSubString(long l, int n) throws SQLException {
        String string = this.data;
        this.checkValid(string);
        int n2 = string.length();
        if (l < 1L || l > (long)n2) {
            Util.outOfRangeArgument("pos: " + l);
        }
        if (n < 0 || (long)n > (long)n2 - --l) {
            throw Util.outOfRangeArgument("length: " + n);
        }
        return l == 0L && n == n2 ? string : string.substring((int)l, (int)l + n);
    }

    @Override
    public Reader getCharacterStream() throws SQLException {
        String string = this.data;
        this.checkValid(string);
        return new StringReader(string);
    }

    @Override
    public InputStream getAsciiStream() throws SQLException {
        this.checkValid(this.data);
        try {
            return new ByteArrayInputStream(this.data.getBytes("US-ASCII"));
        }
        catch (IOException iOException) {
            return null;
        }
    }

    @Override
    public long position(String string, long l) throws SQLException {
        int n;
        String string2 = this.data;
        this.checkValid(string2);
        if (l < 1L) {
            throw Util.outOfRangeArgument("start: " + l);
        }
        if (string == null || l > 0x80000000L) {
            return -1L;
        }
        return (n = string2.indexOf(string, (int)(--l))) < 0 ? -1L : (long)(n + 1);
    }

    @Override
    public long position(Clob clob, long l) throws SQLException {
        long l2;
        String string = this.data;
        this.checkValid(string);
        if (l < 1L) {
            throw Util.outOfRangeArgument("start: " + l);
        }
        if (clob == null) {
            return -1L;
        }
        long l3 = string.length();
        if (--l > l3 - (l2 = clob.length())) {
            return -1L;
        }
        String string2 = clob instanceof JDBCClob ? ((JDBCClob)clob).data() : clob.getSubString(1L, (int)l2);
        int n = string.indexOf(string2, (int)l);
        return n < 0 ? -1L : (long)(n + 1);
    }

    @Override
    public int setString(long l, String string) throws SQLException {
        if (string == null) {
            throw Util.nullArgument("str");
        }
        return this.setString(l, string, 0, string.length());
    }

    @Override
    public int setString(long l, String string, int n, int n2) throws SQLException {
        StringBuffer stringBuffer;
        if (!this.createdByConnection) {
            throw Util.notSupported();
        }
        String string2 = this.data;
        this.checkValid(string2);
        if (string == null) {
            throw Util.nullArgument("str");
        }
        int n3 = string.length();
        if (n < 0 || n > n3) {
            throw Util.outOfRangeArgument("offset: " + n);
        }
        if (n2 > n3 - n) {
            throw Util.outOfRangeArgument("len: " + n2);
        }
        if (l < 1L || l > 1L + (long)(Integer.MAX_VALUE - n2)) {
            throw Util.outOfRangeArgument("pos: " + l);
        }
        int n4 = (int)(l - 1L);
        int n5 = string2.length();
        if (n4 > n5 - n2) {
            stringBuffer = new StringBuffer(n4 + n2);
            stringBuffer.append(string2.substring(0, n4));
            string2 = null;
            stringBuffer.append(string.substring(n, n + n2));
            string = null;
        } else {
            stringBuffer = new StringBuffer(string2);
            string2 = null;
            int n6 = n4;
            for (int i = 0; i < n2; ++i) {
                stringBuffer.setCharAt(n6, string.charAt(n + i));
                ++n6;
            }
            string = null;
        }
        this.checkValid(this.data);
        this.data = stringBuffer.toString();
        return n2;
    }

    @Override
    public OutputStream setAsciiStream(final long l) throws SQLException {
        if (!this.createdByConnection) {
            throw Util.notSupported();
        }
        this.checkValid(this.data);
        if (l < 1L || l > 0x80000000L) {
            throw Util.outOfRangeArgument("pos: " + l);
        }
        return new ByteArrayOutputStream(){

            @Override
            public synchronized void close() throws IOException {
                try {
                    JDBCClob.this.setString(l, new String(this.toByteArray(), "US-ASCII"));
                }
                catch (SQLException sQLException) {
                    throw JavaSystem.toIOException(sQLException);
                }
                finally {
                    super.close();
                }
            }
        };
    }

    @Override
    public Writer setCharacterStream(final long l) throws SQLException {
        if (!this.createdByConnection) {
            throw Util.notSupported();
        }
        this.checkValid(this.data);
        if (l < 1L || l > 0x80000000L) {
            throw Util.outOfRangeArgument("pos: " + l);
        }
        return new StringWriter(){

            @Override
            public synchronized void close() throws IOException {
                try {
                    JDBCClob.this.setString(l, this.toString());
                }
                catch (SQLException sQLException) {
                    throw JavaSystem.toIOException(sQLException);
                }
                finally {
                    super.close();
                }
            }
        };
    }

    @Override
    public void truncate(long l) throws SQLException {
        String string = this.data;
        this.checkValid(string);
        long l2 = string.length();
        if (l != l2) {
            if (l < 0L || l > l2) {
                throw Util.outOfRangeArgument("len: " + l);
            }
            this.data = string.substring(0, (int)l);
        }
    }

    @Override
    public void free() throws SQLException {
        this.data = null;
    }

    @Override
    public Reader getCharacterStream(long l, long l2) throws SQLException {
        if (l2 > Integer.MAX_VALUE) {
            throw Util.outOfRangeArgument("length: " + l2);
        }
        return new StringReader(this.getSubString(l, (int)l2));
    }

    public JDBCClob(String string) throws SQLException {
        this.init(string);
        this.createdByConnection = false;
    }

    protected JDBCClob() {
        this.data = "";
        this.createdByConnection = true;
    }

    protected void init(String string) throws SQLException {
        if (string == null) {
            throw Util.nullArgument("data");
        }
        this.data = string;
    }

    protected void checkValid(Object object) {
        if (object == null) {
            throw new RuntimeException("null data");
        }
    }

    protected String data() throws SQLException {
        String string = this.data;
        this.checkValid(string);
        return string;
    }
}

