/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.jdbc;

import java.io.IOException;
import java.io.Reader;
import java.sql.SQLException;
import org.hsqldb.error.Error;
import org.hsqldb.jdbc.JDBCClobClient;
import org.hsqldb.jdbc.Util;
import org.hsqldb.lib.java.JavaSystem;

public final class ClobInputStream
extends Reader {
    final JDBCClobClient clob;
    final long availableLength;
    long bufferOffset;
    long currentPosition;
    char[] buffer;
    boolean isClosed;
    int streamBlockSize;

    public ClobInputStream(JDBCClobClient jDBCClobClient, long l, long l2, int n) throws SQLException {
        if (!JDBCClobClient.isInLimits(jDBCClobClient.length(), l, l2)) {
            throw Util.outOfRangeArgument();
        }
        this.clob = jDBCClobClient;
        this.availableLength = l + l2;
        this.currentPosition = l;
        this.streamBlockSize = n;
    }

    @Override
    public int read() throws IOException {
        this.checkClosed();
        if (this.currentPosition >= this.availableLength) {
            return -1;
        }
        if (this.buffer == null || this.currentPosition >= this.bufferOffset + (long)this.buffer.length) {
            try {
                this.readIntoBuffer();
            }
            catch (SQLException sQLException) {
                throw JavaSystem.toIOException(sQLException);
            }
        }
        int n = this.buffer[(int)(this.currentPosition - this.bufferOffset)] & 0xFF;
        ++this.currentPosition;
        return n;
    }

    @Override
    public int read(char[] cArray, int n, int n2) throws IOException {
        this.checkClosed();
        if (this.currentPosition + (long)n2 >= this.availableLength) {
            return -1;
        }
        for (int i = n; i < n2; ++i) {
            cArray[i] = (char)this.read();
        }
        return n2;
    }

    @Override
    public long skip(long l) throws IOException {
        this.checkClosed();
        if (l <= 0L) {
            return 0L;
        }
        if (this.currentPosition + l > this.availableLength) {
            l = this.availableLength - this.currentPosition;
        }
        this.currentPosition += l;
        return l;
    }

    public int available() throws IOException {
        return (int)(this.bufferOffset + (long)this.buffer.length - this.currentPosition);
    }

    @Override
    public void close() throws IOException {
        this.isClosed = true;
    }

    private void checkClosed() throws IOException {
        if (this.isClosed || this.clob.isClosed()) {
            throw new IOException(Error.getMessage(3475));
        }
    }

    private void readIntoBuffer() throws SQLException {
        long l = this.availableLength - this.currentPosition;
        if (l <= 0L) {
            // empty if block
        }
        if (l > (long)this.streamBlockSize) {
            l = this.streamBlockSize;
        }
        this.buffer = this.clob.getChars(this.currentPosition, (int)l);
        this.bufferOffset = this.currentPosition;
    }
}

