/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.ColumnSchema;
import org.hsqldb.HsqlException;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.RangeVariable;
import org.hsqldb.Routine;
import org.hsqldb.Session;
import org.hsqldb.Statement;
import org.hsqldb.StatementExpression;
import org.hsqldb.StatementHandler;
import org.hsqldb.StatementSimple;
import org.hsqldb.error.Error;
import org.hsqldb.lib.HashMappedList;
import org.hsqldb.lib.HashSet;
import org.hsqldb.lib.OrderedHashSet;
import org.hsqldb.lib.OrderedIntHashSet;
import org.hsqldb.result.Result;

public class StatementCompound
extends Statement {
    final boolean isLoop;
    HsqlNameManager.HsqlName label;
    StatementHandler[] handlers = StatementHandler.emptyExceptionHandlerArray;
    boolean hasUndoHandler;
    Statement loopCursor;
    Statement[] statements;
    StatementExpression condition;
    boolean isAtomic;
    ColumnSchema[] variables = ColumnSchema.emptyArray;
    HashMappedList scopeVariables;
    RangeVariable[] rangeVariables = RangeVariable.emptyArray;
    public static final StatementCompound[] emptyStatementArray = new StatementCompound[0];

    StatementCompound(int n, HsqlNameManager.HsqlName hsqlName) {
        super(n, 2007);
        this.label = hsqlName;
        this.isTransactionStatement = false;
        switch (n) {
            case 90: 
            case 95: 
            case 97: {
                this.isLoop = true;
                break;
            }
            case 12: 
            case 88: {
                this.isLoop = false;
                break;
            }
            default: {
                throw Error.runtimeError(201, "StatementCompound");
            }
        }
    }

    @Override
    public String getSQL() {
        return this.sql;
    }

    protected String describe(Session session, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('\n');
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(' ');
        }
        stringBuffer.append("STATEMENT");
        return stringBuffer.toString();
    }

    public void setLocalDeclarations(Object[] objectArray) {
        int n;
        int n2 = 0;
        int n3 = 0;
        for (n = 0; n < objectArray.length; ++n) {
            if (objectArray[n] instanceof ColumnSchema) {
                ++n2;
                continue;
            }
            ++n3;
        }
        this.variables = new ColumnSchema[n2];
        this.handlers = new StatementHandler[n3];
        n2 = 0;
        n3 = 0;
        for (n = 0; n < objectArray.length; ++n) {
            if (objectArray[n] instanceof ColumnSchema) {
                this.variables[n2++] = (ColumnSchema)objectArray[n];
                continue;
            }
            StatementHandler statementHandler = (StatementHandler)objectArray[n];
            statementHandler.setParent(this);
            this.handlers[n3++] = statementHandler;
            if (statementHandler.handlerType != 7) continue;
            this.hasUndoHandler = true;
        }
        this.setVariables();
        this.setHandlers();
    }

    public void setLoopStatement(Statement statement) {
        this.loopCursor = statement;
    }

    void setStatements(Statement[] statementArray) {
        for (int i = 0; i < statementArray.length; ++i) {
            statementArray[i].setParent(this);
        }
        this.statements = statementArray;
    }

    public void setCondition(StatementExpression statementExpression) {
        this.condition = statementExpression;
    }

    @Override
    public Result execute(Session session) {
        Result result;
        switch (this.type) {
            case 12: {
                this.initialiseVariables(session);
                result = this.executeBlock(session);
                break;
            }
            case 90: 
            case 95: 
            case 97: {
                result = this.executeLoop(session);
                break;
            }
            case 88: {
                result = this.executeIf(session);
                break;
            }
            default: {
                throw Error.runtimeError(201, "StatementCompound");
            }
        }
        if (result.isError()) {
            result.getException().setStatementType(this.group, this.type);
        }
        return result;
    }

    private Result executeBlock(Session session) {
        boolean bl;
        Result result = Result.updateZeroResult;
        boolean bl2 = bl = !this.root.isTrigger();
        if (bl) {
            session.sessionContext.push();
            if (this.hasUndoHandler) {
                String string = HsqlNameManager.getAutoSavepointNameString(session.actionTimestamp, session.sessionContext.depth);
                session.savepoint(string);
            }
        }
        for (int i = 0; i < this.statements.length; ++i) {
            result = this.statements[i].execute(session);
            if ((result = this.handleCondition(session, result)).isError() || result.getType() == 42 || result.getType() == 3) break;
        }
        if (result.getType() == 42 && result.getErrorCode() == 89) {
            if (result.getMainString() == null) {
                result = Result.updateZeroResult;
            } else if (this.label != null && this.label.name.equals(result.getMainString())) {
                result = Result.updateZeroResult;
            }
        }
        if (bl) {
            session.sessionContext.pop();
        }
        return result;
    }

    private Result handleCondition(Session session, Result result) {
        String string = null;
        if (result.isError()) {
            string = result.getSubString();
        } else if (session.getLastWarning() != null) {
            string = session.getLastWarning().getSQLState();
        } else {
            return result;
        }
        if (string != null) {
            for (int i = 0; i < this.handlers.length; ++i) {
                StatementHandler statementHandler = this.handlers[i];
                session.clearWarnings();
                if (!statementHandler.handlesCondition(result.getSubString())) continue;
                session.resetSchema();
                switch (statementHandler.handlerType) {
                    case 5: {
                        result = Result.updateZeroResult;
                        break;
                    }
                    case 7: {
                        session.rollbackToSavepoint();
                        result = Result.newPSMResult(89, this.label.name, null);
                        break;
                    }
                    case 6: {
                        result = Result.newPSMResult(89, null, null);
                    }
                }
                Result result2 = statementHandler.statement.execute(session);
                if (result2.isError()) {
                    result = result2;
                    this.handleCondition(session, result);
                    continue;
                }
                return result;
            }
            if (this.parent != null) {
                return this.parent.handleCondition(session, result);
            }
        }
        return result;
    }

    private Result executeLoop(Session session) {
        Result result;
        block9: {
            result = Result.updateZeroResult;
            while (true) {
                if (this.type == 97) {
                    result = this.condition.execute(session);
                    if (result.isError()) break block9;
                    if (!Boolean.TRUE.equals(result.getValueObject())) {
                        result = Result.updateZeroResult;
                        break block9;
                    }
                }
                for (int i = 0; i < this.statements.length && !(result = this.statements[i].execute(session)).isError() && result.getType() != 42 && result.getType() != 3; ++i) {
                }
                if (result.isError()) break block9;
                if (result.getType() == 42) {
                    if (result.getErrorCode() == 102) {
                        if (result.getMainString() == null || this.label != null && this.label.name.equals(result.getMainString())) {
                            continue;
                        }
                        break block9;
                    }
                    if (result.getErrorCode() != 89) break block9;
                    if (result.getMainString() == null) {
                        result = Result.updateZeroResult;
                    }
                    if (this.label != null && this.label.name.equals(result.getMainString())) {
                        result = Result.updateZeroResult;
                    }
                    break block9;
                }
                if (result.getType() == 3) break block9;
                if (this.type != 95) continue;
                result = this.condition.execute(session);
                if (result.isError()) break block9;
                if (Boolean.TRUE.equals(result.getValueObject())) break;
            }
            result = Result.updateZeroResult;
        }
        return result;
    }

    private Result executeIf(Session session) {
        Result result = Result.updateZeroResult;
        boolean bl = false;
        for (int i = 0; i < this.statements.length; ++i) {
            if (this.statements[i].getType() == 1101) {
                if (bl || (result = this.statements[i].execute(session)).isError()) break;
                Object object = result.getValueObject();
                bl = Boolean.TRUE.equals(object);
                ++i;
            }
            result = Result.updateZeroResult;
            if (bl && ((result = this.statements[i].execute(session)).isError() || result.getType() == 42)) break;
        }
        return result;
    }

    @Override
    public void resolve(Session session) {
        int n;
        int n2;
        for (n2 = 0; n2 < this.statements.length; ++n2) {
            if (this.statements[n2].getType() == 89 || this.statements[n2].getType() == 102) {
                if (this.findLabel((StatementSimple)this.statements[n2])) continue;
                throw Error.error(5508, ((StatementSimple)this.statements[n2]).label.name);
            }
            if (this.statements[n2].getType() != 58 || this.root.isFunction()) continue;
            throw Error.error(5602, "RETURN");
        }
        for (n2 = 0; n2 < this.statements.length; ++n2) {
            this.statements[n2].resolve(session);
        }
        for (n2 = 0; n2 < this.handlers.length; ++n2) {
            this.handlers[n2].resolve(session);
        }
        OrderedHashSet orderedHashSet = new OrderedHashSet();
        OrderedHashSet orderedHashSet2 = new OrderedHashSet();
        OrderedHashSet orderedHashSet3 = new OrderedHashSet();
        for (n = 0; n < this.variables.length; ++n) {
            orderedHashSet3.addAll(this.variables[n].getReferences());
        }
        if (this.condition != null) {
            orderedHashSet3.addAll(this.condition.getReferences());
            orderedHashSet2.addAll(this.condition.getTableNamesForRead());
        }
        for (n = 0; n < this.statements.length; ++n) {
            orderedHashSet3.addAll(this.statements[n].getReferences());
            orderedHashSet2.addAll(this.statements[n].getTableNamesForRead());
            orderedHashSet.addAll(this.statements[n].getTableNamesForWrite());
        }
        for (n = 0; n < this.handlers.length; ++n) {
            orderedHashSet3.addAll(this.handlers[n].getReferences());
            orderedHashSet2.addAll(this.handlers[n].getTableNamesForRead());
            orderedHashSet.addAll(this.handlers[n].getTableNamesForWrite());
        }
        orderedHashSet2.removeAll(orderedHashSet);
        this.readTableNames = new HsqlNameManager.HsqlName[orderedHashSet2.size()];
        orderedHashSet2.toArray(this.readTableNames);
        this.writeTableNames = new HsqlNameManager.HsqlName[orderedHashSet.size()];
        orderedHashSet.toArray(this.writeTableNames);
        this.references = orderedHashSet3;
    }

    @Override
    public void setRoot(Routine routine) {
        this.root = routine;
    }

    @Override
    public String describe(Session session) {
        return "";
    }

    @Override
    public OrderedHashSet getReferences() {
        return this.references;
    }

    public void setAtomic(boolean bl) {
        this.isAtomic = bl;
    }

    private void setVariables() {
        int n;
        if (this.variables.length == 0) {
            this.rangeVariables = this.parent == null ? this.root.getParameterRangeVariables() : this.parent.rangeVariables;
            return;
        }
        HashMappedList hashMappedList = new HashMappedList();
        if (this.parent != null) {
            for (n = 0; n < this.parent.scopeVariables.size(); ++n) {
                hashMappedList.add(this.parent.scopeVariables.getKey(n), this.parent.scopeVariables.get(n));
            }
        }
        for (n = 0; n < this.variables.length; ++n) {
            String string = this.variables[n].getName().name;
            boolean bl = hashMappedList.add(string, this.variables[n]);
            if (!bl) {
                throw Error.error(5606, string);
            }
            if (this.root.getParameterIndex(string) == -1) continue;
            throw Error.error(5606, string);
        }
        RangeVariable rangeVariable = new RangeVariable(hashMappedList, true);
        this.rangeVariables = new RangeVariable[]{this.root.getParameterRangeVariables()[0], rangeVariable};
        this.root.variableCount = hashMappedList.size();
    }

    private void setHandlers() {
        if (this.handlers.length == 0) {
            return;
        }
        HashSet hashSet = new HashSet();
        OrderedIntHashSet orderedIntHashSet = new OrderedIntHashSet();
        for (int i = 0; i < this.handlers.length; ++i) {
            int[] nArray = this.handlers[i].getConditionTypes();
            for (int j = 0; j < nArray.length; ++j) {
                if (orderedIntHashSet.add(nArray[j])) continue;
                throw Error.error(5601);
            }
            String[] stringArray = this.handlers[i].getConditionStates();
            for (int j = 0; j < stringArray.length; ++j) {
                if (hashSet.add(stringArray[j])) continue;
                throw Error.error(5601);
            }
        }
    }

    private boolean findLabel(StatementSimple statementSimple) {
        if (this.label != null && statementSimple.label.name.equals(this.label.name)) {
            return this.isLoop || statementSimple.getType() != 102;
        }
        if (this.parent == null) {
            return false;
        }
        return this.parent.findLabel(statementSimple);
    }

    private void initialiseVariables(Session session) {
        Object[] objectArray = session.sessionContext.routineVariables;
        int n = this.parent == null ? 0 : this.parent.scopeVariables.size();
        for (int i = 0; i < this.variables.length; ++i) {
            try {
                objectArray[n + i] = this.variables[i].getDefaultValue(session);
                continue;
            }
            catch (HsqlException hsqlException) {
                // empty catch block
            }
        }
    }

    @Override
    public RangeVariable[] getRangeVariables() {
        return this.rangeVariables;
    }
}

