/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.nls.lvg.Trie;

import gov.nih.nlm.nls.lvg.Trie.PersistentList;
import gov.nih.nlm.nls.lvg.Trie.PersistentListNode;
import java.io.IOException;
import java.io.RandomAccessFile;

public class PersistentExceptionNode
extends PersistentListNode {
    private String key_ = null;
    private String value_ = null;

    public PersistentExceptionNode(long address) {
        super(address);
    }

    public PersistentExceptionNode(long address, long next) {
        super(address, next);
    }

    public PersistentExceptionNode(String key, String value) {
        this.key_ = key;
        this.value_ = value;
    }

    public String GetKey() {
        return this.key_;
    }

    public String GetValue() {
        return this.value_;
    }

    @Override
    public void WriteData(RandomAccessFile raf) throws IOException {
        raf.writeUTF(this.key_);
        raf.writeUTF(this.value_);
    }

    @Override
    public void ReadData(RandomAccessFile raf) throws IOException {
        this.key_ = raf.readUTF();
        this.value_ = raf.readUTF();
    }

    public static PersistentListNode GetNode(RandomAccessFile raf, long address) throws IOException {
        PersistentExceptionNode node = new PersistentExceptionNode(address);
        raf.seek(address);
        node.ReadData(raf);
        long next = raf.readLong();
        node.SetNext(next);
        return node;
    }

    public static void PrintList(String exceptionPath, long address) throws IOException {
        PersistentList persistentException = new PersistentList(exceptionPath);
        RandomAccessFile exceptionRaf = persistentException.GetRaf();
        long curAddress = address + 12L;
        exceptionRaf.seek(curAddress);
        int i = 0;
        while (curAddress != -1L) {
            PersistentExceptionNode curNode = (PersistentExceptionNode)PersistentExceptionNode.GetNode(exceptionRaf, curAddress);
            System.out.println("        E-" + i + ": '" + curNode.GetKey() + "|" + curNode.GetValue() + ";'");
            curAddress = curNode.GetNext();
            ++i;
        }
        persistentException.Close();
    }
}

