/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.nls.lvg.Flows;

import gov.nih.nlm.nls.lvg.Flows.Transformation;
import gov.nih.nlm.nls.lvg.Lib.LexItem;
import gov.nih.nlm.nls.lvg.Util.Strip;
import java.util.Vector;

public class ToStripNecNos
extends Transformation
implements Cloneable {
    private static final String INFO = "Strip NEC and NOS";
    private static Vector<String> necNosList_ = new Vector();

    public static Vector<LexItem> Mutate(LexItem in, boolean detailsFlag, boolean mutateFlag) {
        String term = ToStripNecNos.StripNecNos(in.GetSourceTerm());
        String details = null;
        String mutate = null;
        if (detailsFlag) {
            details = INFO;
        }
        if (mutateFlag) {
            mutate = Transformation.NO_MUTATE_INFO;
        }
        Vector<LexItem> out = new Vector<LexItem>();
        LexItem temp = ToStripNecNos.UpdateLexItem(in, term, 12, -1L, -1L, details, mutate);
        out.addElement(temp);
        return out;
    }

    public static void main(String[] args) {
        String testStr = ToStripNecNos.GetTestStr(args, "Deaf mutism, NEC");
        LexItem in = new LexItem(testStr);
        Vector<LexItem> outs = ToStripNecNos.Mutate(in, true, true);
        ToStripNecNos.PrintResults(in, outs);
    }

    private static String StripNecNos(String inStr) {
        int length;
        String tempStr = inStr + " $";
        String out = Strip.StripStrings(tempStr, necNosList_, true);
        if (out.charAt((length = out.length()) - 1) == '$') {
            out = out.substring(0, out.length() - 1);
        }
        if ((out = out.trim()).charAt((length = out.length()) - 1) == ',') {
            out = out.substring(0, out.length() - 1);
        }
        return out.trim();
    }

    static {
        necNosList_.addElement("NEC AND NOS");
        necNosList_.addElement("NEC/NOS $");
        necNosList_.addElement("NEC NOS $");
        necNosList_.addElement("NEC, NOS $");
        necNosList_.addElement(", NEC $");
        necNosList_.addElement(", NOS $");
        necNosList_.addElement(",NEC $");
        necNosList_.addElement(",NOS $");
        necNosList_.addElement("(NEC)");
        necNosList_.addElement("(NOS)");
        necNosList_.addElement("NEC");
        necNosList_.addElement("NOS");
    }
}

