/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.nls.lvg.Flows;

import com.ibm.icu.text.Normalizer;
import gov.nih.nlm.nls.lvg.Flows.Transformation;
import gov.nih.nlm.nls.lvg.Lib.Configuration;
import gov.nih.nlm.nls.lvg.Lib.GlobalBehavior;
import gov.nih.nlm.nls.lvg.Lib.LexItem;
import gov.nih.nlm.nls.lvg.Util.UnicodeUtil;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class ToSplitLigatures
extends Transformation
implements Cloneable {
    private static final String INFO = "Split Ligatures";
    private static final String NO_OPERATION = "NO";
    private static final String MAPPING = "MP";
    private static final String NORM_NFKC = "NFKC";

    public static Vector<LexItem> Mutate(LexItem in, Hashtable<Character, String> ligatureMap, boolean detailsFlag, boolean mutateFlag) {
        Vector<LexItem> out = ToSplitLigatures.SplitLigatures(in, ligatureMap, INFO, detailsFlag, mutateFlag);
        return out;
    }

    public static Hashtable<Character, String> GetLigatureMapFromFile(Configuration config) {
        String fName = config.GetConfiguration("LVG_DIR") + config.GetConfiguration("LVG_LIGATURES_FILE");
        String line = null;
        Hashtable<Character, String> ligatureMap = new Hashtable<Character, String>();
        try {
            BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(fName), "UTF-8"));
            while ((line = in.readLine()) != null) {
                if (line.length() <= 0 || line.charAt(0) == '#') continue;
                StringTokenizer buf = new StringTokenizer(line, "|");
                char inChar = (char)UnicodeUtil.UnicodeHexToNum(buf.nextToken());
                String splitStr = buf.nextToken();
                Character ligature = new Character(inChar);
                if (UnicodeUtil.IsAsciiChar(inChar)) {
                    System.err.println("** Warning: Illegal format in ligatures file: '" + fName + "'.");
                    continue;
                }
                ligatureMap.put(ligature, splitStr);
            }
            in.close();
        }
        catch (Exception e) {
            System.err.println("Exception: " + e.toString());
            System.err.println("** Error: problem of opening/reading ligature file: '" + fName + "'.");
        }
        return ligatureMap;
    }

    public static String SplitLigature(char inChar, Hashtable<Character, String> ligatureMap) {
        Character key = new Character(inChar);
        String outStr = new String();
        outStr = ligatureMap.containsKey(key) ? ligatureMap.get(key) : Normalizer.normalize((int)inChar, (Normalizer.Mode)Normalizer.NFKC);
        if (outStr.length() > 1) {
            outStr = outStr.trim();
        }
        return outStr;
    }

    public static void main(String[] args) {
        Configuration conf = new Configuration("data.config.lvg", true);
        String testStr = ToSplitLigatures.GetTestStr(args, "sp\u00e6lsau");
        Hashtable<Character, String> ligatureMap = ToSplitLigatures.GetLigatureMapFromFile(conf);
        LexItem in = new LexItem(testStr);
        Vector<LexItem> outs = ToSplitLigatures.Mutate(in, ligatureMap, true, true);
        ToSplitLigatures.PrintResults(in, outs);
    }

    private static Vector<LexItem> SplitLigatures(LexItem in, Hashtable<Character, String> ligatureMap, String infoStr, boolean detailsFlag, boolean mutateFlag) {
        String details = null;
        String mutate = null;
        if (detailsFlag) {
            details = infoStr;
        }
        if (mutateFlag) {
            mutate = new String();
        }
        String inStr = in.GetSourceTerm();
        String fs = GlobalBehavior.GetFieldSeparator();
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < inStr.length(); ++i) {
            char curChar = inStr.charAt(i);
            String opStr = NO_OPERATION + fs;
            Character key = new Character(curChar);
            String outStr = UnicodeUtil.CharToStr(curChar);
            if (ligatureMap.containsKey(key)) {
                outStr = ligatureMap.get(key);
                opStr = MAPPING + fs;
            } else {
                String normStr = Normalizer.normalize((int)curChar, (Normalizer.Mode)Normalizer.NFKC);
                outStr = normStr.length() > 1 ? normStr.trim() : normStr;
                if (!UnicodeUtil.CharToStr(curChar).equals(outStr)) {
                    opStr = NORM_NFKC + fs;
                }
            }
            buffer.append(outStr);
            if (!mutateFlag) continue;
            mutate = mutate + opStr;
        }
        String term = buffer.toString();
        Vector<LexItem> out = new Vector<LexItem>();
        LexItem temp = ToSplitLigatures.UpdateLexItem(in, term, 52, -1L, -1L, details, mutate);
        out.addElement(temp);
        return out;
    }
}

