/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.nls.lvg.Flows;

import gov.nih.nlm.nls.lvg.Db.AntiNormRecord;
import gov.nih.nlm.nls.lvg.Db.DbAntiNorm;
import gov.nih.nlm.nls.lvg.Db.DbBase;
import gov.nih.nlm.nls.lvg.Flows.ToMapSymbolToAscii;
import gov.nih.nlm.nls.lvg.Flows.ToMapUnicodeToAscii;
import gov.nih.nlm.nls.lvg.Flows.ToNormalize;
import gov.nih.nlm.nls.lvg.Flows.ToRemoveS;
import gov.nih.nlm.nls.lvg.Flows.ToSplitLigatures;
import gov.nih.nlm.nls.lvg.Flows.ToStripDiacritics;
import gov.nih.nlm.nls.lvg.Flows.ToStripMapUnicode;
import gov.nih.nlm.nls.lvg.Flows.ToStripStopWords;
import gov.nih.nlm.nls.lvg.Flows.Transformation;
import gov.nih.nlm.nls.lvg.Lib.Configuration;
import gov.nih.nlm.nls.lvg.Lib.GlobalBehavior;
import gov.nih.nlm.nls.lvg.Lib.LexItem;
import gov.nih.nlm.nls.lvg.Trie.RTrieTree;
import gov.nih.nlm.nls.lvg.Trie.RamTrie;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Vector;

public class ToAntiNorm
extends Transformation {
    private static final String INFO = "AntiNorm";

    public static Vector<LexItem> Mutate(LexItem in, int maxTerm, Vector<String> stopWords, Connection conn, RamTrie trie, Hashtable<Character, String> symbolMap, Hashtable<Character, String> unicodeMap, Hashtable<Character, String> ligatureMap, Hashtable<Character, Character> diacriticMap, Hashtable<Character, String> nonStripMap, RTrieTree removeSTree, boolean detailsFlag, boolean mutateFlag) throws SQLException {
        Vector<LexItem> norms = ToNormalize.Mutate(in, maxTerm, stopWords, conn, trie, symbolMap, unicodeMap, ligatureMap, diacriticMap, nonStripMap, removeSTree, detailsFlag, mutateFlag);
        Vector antiNorms = new Vector();
        Vector<LexItem> out = new Vector<LexItem>();
        for (int i = 0; i < norms.size(); ++i) {
            LexItem norm2 = norms.elementAt(i);
            String normStr = norm2.GetTargetTerm();
            Vector<AntiNormRecord> normAntiNorms = DbAntiNorm.GetAntiNorms(normStr, conn);
            for (int j = 0; j < normAntiNorms.size(); ++j) {
                AntiNormRecord cur = normAntiNorms.elementAt(j);
                String details = null;
                String mutate = null;
                if (detailsFlag) {
                    details = INFO;
                }
                if (mutateFlag) {
                    mutate = cur.GetEui() + GlobalBehavior.GetFieldSeparator();
                }
                String term = cur.GetInflectedTerm();
                int cat = cur.GetCategory();
                long infl = cur.GetInflection();
                LexItem temp = ToAntiNorm.UpdateLexItem(in, term, 47, cat, infl, details, mutate);
                out = ToAntiNorm.AddToAntiNormOutput(out, temp);
            }
        }
        return out;
    }

    public static void main(String[] args) {
        Configuration conf = new Configuration("data.config.lvg", true);
        String testStr = ToAntiNorm.GetTestStr(args, "Rendu-Osler disease");
        int minTermLen = Integer.parseInt(conf.GetConfiguration("MIN_TERM_LENGTH"));
        String lvgDir = conf.GetConfiguration("LVG_DIR");
        int maxTerm = Integer.parseInt(conf.GetConfiguration("MAX_RULE_UNINFLECTED_TERMS"));
        Vector<String> stopWords = ToStripStopWords.GetStopWordsFromFile(conf);
        Hashtable<Character, String> symbolMap = ToMapSymbolToAscii.GetSymbolMapFromFile(conf);
        Hashtable<Character, String> unicodeMap = ToMapUnicodeToAscii.GetUnicodeMapFromFile(conf);
        Hashtable<Character, String> ligatureMap = ToSplitLigatures.GetLigatureMapFromFile(conf);
        Hashtable<Character, Character> diacriticMap = ToStripDiacritics.GetDiacriticMapFromFile(conf);
        Hashtable<Character, String> nonStripMap = ToStripMapUnicode.GetNonStripMapFromFile(conf);
        RTrieTree removeSTree = ToRemoveS.GetRTrieTreeFromFile(conf);
        LexItem in = new LexItem(testStr);
        Vector<LexItem> outs = new Vector<LexItem>();
        try {
            Connection conn = DbBase.OpenConnection(conf);
            boolean isInflection = true;
            RamTrie trie = new RamTrie(isInflection, minTermLen, lvgDir, 0);
            if (conn != null) {
                outs = ToAntiNorm.Mutate(in, maxTerm, stopWords, conn, trie, symbolMap, unicodeMap, ligatureMap, diacriticMap, nonStripMap, removeSTree, true, true);
            }
            DbBase.CloseConnection(conn, conf);
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
        }
        ToAntiNorm.PrintResults(in, outs);
    }

    private static Vector<LexItem> AddToAntiNormOutput(Vector<LexItem> in, LexItem cur) {
        boolean existFlag = false;
        Vector<LexItem> out = new Vector<LexItem>(in);
        for (int i = 0; i < in.size(); ++i) {
            LexItem temp = in.elementAt(i);
            if (!temp.GetTargetTerm().equals(cur.GetTargetTerm()) || temp.GetTargetCategory().GetValue() != cur.GetTargetCategory().GetValue() || temp.GetTargetInflection().GetValue() != cur.GetTargetInflection().GetValue()) continue;
            if (temp.GetMutateInformation() == null || cur.GetMutateInformation() == null) {
                existFlag = true;
                break;
            }
            if (!temp.GetMutateInformation().equals(cur.GetMutateInformation())) continue;
            existFlag = true;
            break;
        }
        if (!existFlag) {
            out.addElement(cur);
        }
        return out;
    }
}

