/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.nls.lvg.CmdLineSyntax;

import gov.nih.nlm.nls.lvg.CmdLineSyntax.Option;
import gov.nih.nlm.nls.lvg.CmdLineSyntax.OptionFlag;
import gov.nih.nlm.nls.lvg.CmdLineSyntax.OptionItem;
import gov.nih.nlm.nls.lvg.CmdLineSyntax.OptionList;
import java.util.ListIterator;
import java.util.Vector;

public class OptionUtility {
    public static OptionList ToOptionList(String optionStr) {
        Option option = new Option(optionStr);
        return option.GetOptionList();
    }

    public static String ToOptionString(OptionList optionList) {
        String optionStr = "";
        ListIterator lit = optionList.listIterator();
        while (lit.hasNext()) {
            OptionFlag flag = (OptionFlag)lit.next();
            optionStr = flag.GetLevel() == 0 && optionStr.length() > 0 ? optionStr + " " + Option.SEPARATOR[flag.GetLevel()] + flag.GetName() : optionStr + Option.SEPARATOR[flag.GetLevel()] + flag.GetName();
            if (flag.GetChild() == null) continue;
            optionStr = optionStr + OptionUtility.ToOptionString(flag.GetChild());
        }
        return optionStr;
    }

    public static String ConvertName(String optionStr, Option systemOption, boolean fullNameFlag) {
        String name = null;
        Option option = new Option(optionStr);
        Vector<OptionItem> optionItems = option.GetOptionItems();
        Vector<OptionItem> newItems = new Vector<OptionItem>(1);
        for (int i = 0; i < optionItems.size(); ++i) {
            OptionItem optionItem = optionItems.elementAt(i);
            OptionItem newItem = null;
            newItem = OptionUtility.GetItemByName(optionItem, systemOption, fullNameFlag);
            newItems.addElement(newItem);
        }
        name = OptionUtility.GetOptionStr(newItems);
        return name;
    }

    public static OptionItem GetItemByName(OptionItem inputItem, Option systemOption, boolean fullNameFlag) {
        String itemStr = inputItem.GetOptionItem();
        OptionList<OptionFlag> systemOptionList = systemOption.GetOptionList();
        String itemName = OptionUtility.UpdateItemStrToName(itemStr, 0, systemOptionList, fullNameFlag);
        OptionItem itemByName = new OptionItem(itemName);
        return itemByName;
    }

    public static String GetOptionStr(Vector<OptionItem> optionItems) {
        String optionStr = "";
        OptionItem lastOptionItem = null;
        for (int i = 0; i < optionItems.size(); ++i) {
            OptionItem optionItem = optionItems.elementAt(i);
            optionStr = lastOptionItem == null ? optionItem.GetOptionItem() : optionStr + OptionUtility.GetNewArgument(lastOptionItem.GetOptionItem(), optionItem.GetOptionItem());
            lastOptionItem = optionItem;
        }
        return optionStr;
    }

    public static int GetLevelNum(String item) {
        int level = -1;
        if (item == null) {
            return level;
        }
        for (int i = 0; i < 5; ++i) {
            int index = item.indexOf(Option.SEPARATOR[i]);
            if (index != -1) continue;
            level = i - 1;
            break;
        }
        return level;
    }

    public static String GetLevelFlag(String item, int curLevel) {
        String flag = null;
        int curIndex = item.indexOf(Option.SEPARATOR[curLevel]);
        int nextIndex = item.indexOf(Option.SEPARATOR[curLevel + 1]);
        flag = curIndex != -1 && nextIndex == -1 ? item.substring(curIndex + 1) : (curIndex != -1 && nextIndex != -1 && nextIndex > curIndex ? item.substring(curIndex + 1, nextIndex) : "-- Error --");
        return flag;
    }

    private static String GetNewArgument(String orgItem, String newItem) {
        String newArgument = "";
        if (orgItem.equals(newItem)) {
            newArgument = " " + newItem;
        } else {
            for (int i = 0; i < OptionUtility.GetLevelNum(newItem) + 1; ++i) {
                String newFlag = OptionUtility.GetFlag(newItem, i);
                if (OptionUtility.GetFlag(orgItem, i).equals(newFlag)) continue;
                if (i == 0) {
                    newArgument = " " + OptionUtility.GetArgument(newItem, i);
                    break;
                }
                newArgument = OptionUtility.GetArgument(newItem, i);
                break;
            }
        }
        return newArgument;
    }

    private static String GetFlag(String item, int curLevel) {
        String flag = null;
        int index = item.indexOf(Option.SEPARATOR[curLevel + 1]);
        flag = index == -1 ? item : item.substring(0, index);
        return flag;
    }

    private static String GetArgument(String item, int curLevel) {
        String argument = null;
        int index = item.indexOf(Option.SEPARATOR[curLevel]);
        argument = item.substring(index);
        return argument;
    }

    private static String UpdateItemStrToName(String itemStr, int curLevel, OptionList systemOptionList, boolean fullNameFlag) {
        String nameStr = itemStr;
        if (systemOptionList == null) {
            return nameStr;
        }
        ListIterator lit = systemOptionList.listIterator();
        while (lit.hasNext()) {
            OptionFlag flag = (OptionFlag)lit.next();
            if (flag.GetName().equals(OptionUtility.GetLevelFlag(itemStr, curLevel))) {
                if (fullNameFlag) {
                    String name = flag.GetFullName();
                    if (name == null) {
                        name = flag.GetName();
                    }
                    nameStr = OptionUtility.UpdateItemStr(itemStr, curLevel, name);
                }
                systemOptionList = flag.GetChild();
                if (++curLevel > OptionUtility.GetLevelNum(itemStr)) break;
                nameStr = OptionUtility.UpdateItemStrToName(nameStr, curLevel, systemOptionList, fullNameFlag);
                break;
            }
            if (!OptionUtility.GetLevelFlag(itemStr, curLevel).equals(flag.GetFullName())) continue;
            if (!fullNameFlag) {
                nameStr = OptionUtility.UpdateItemStr(itemStr, curLevel, flag.GetName());
            }
            systemOptionList = flag.GetChild();
            if (++curLevel > OptionUtility.GetLevelNum(itemStr)) break;
            nameStr = OptionUtility.UpdateItemStrToName(nameStr, curLevel, systemOptionList, fullNameFlag);
            break;
        }
        return nameStr;
    }

    private static String UpdateItemStr(String itemStr, int curLevel, String name) {
        String nameStr = itemStr;
        int size = itemStr.length();
        int stIndex = itemStr.indexOf(Option.SEPARATOR[curLevel]);
        int endIndex = -1;
        if (curLevel < 5) {
            endIndex = itemStr.indexOf(Option.SEPARATOR[curLevel + 1]);
        }
        if (endIndex == -1) {
            endIndex = size;
        }
        nameStr = itemStr.substring(0, stIndex + 1) + name + itemStr.substring(endIndex);
        return nameStr;
    }
}

