/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.nls.lvg.Api;

import gov.nih.nlm.nls.lvg.Db.DbBase;
import gov.nih.nlm.nls.lvg.Flows.ToMapSymbolToAscii;
import gov.nih.nlm.nls.lvg.Flows.ToMapUnicodeToAscii;
import gov.nih.nlm.nls.lvg.Flows.ToNormalize;
import gov.nih.nlm.nls.lvg.Flows.ToRemoveS;
import gov.nih.nlm.nls.lvg.Flows.ToSplitLigatures;
import gov.nih.nlm.nls.lvg.Flows.ToStripDiacritics;
import gov.nih.nlm.nls.lvg.Flows.ToStripMapUnicode;
import gov.nih.nlm.nls.lvg.Flows.ToStripStopWords;
import gov.nih.nlm.nls.lvg.Lib.Configuration;
import gov.nih.nlm.nls.lvg.Lib.LexItem;
import gov.nih.nlm.nls.lvg.Trie.RTrieTree;
import gov.nih.nlm.nls.lvg.Trie.RamTrie;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Vector;

public class NormApi {
    private String configFile_ = null;
    private Configuration conf_ = null;
    private Connection conn_ = null;
    private RamTrie ramTrieI_ = null;
    private int maxTerm_ = -1;
    private Vector<String> stopWords_ = null;
    private Hashtable<String, String> properties_ = null;
    private Hashtable<Character, String> symbolMap_ = null;
    private Hashtable<Character, String> unicodeMap_ = null;
    private Hashtable<Character, String> ligatureMap_ = null;
    private Hashtable<Character, Character> diacriticMap_ = null;
    private Hashtable<Character, String> nonStripMap_ = null;
    private RTrieTree removeSTree_ = null;

    public NormApi() {
        this.Init();
    }

    public NormApi(String configFile) {
        this.configFile_ = configFile;
        this.Init();
    }

    public NormApi(Hashtable<String, String> properties) {
        this.properties_ = properties;
        this.Init();
    }

    public NormApi(String configFile, Hashtable<String, String> properties) {
        this.configFile_ = configFile;
        this.properties_ = properties;
        this.Init();
    }

    public NormApi(Connection conn, RamTrie ramTrieI) {
        this.conn_ = conn;
        this.ramTrieI_ = ramTrieI;
    }

    public Vector<LexItem> Mutate(LexItem in) throws Exception {
        Vector<LexItem> outs = new Vector();
        outs = ToNormalize.Mutate(in, this.maxTerm_, this.stopWords_, this.conn_, this.ramTrieI_, this.symbolMap_, this.unicodeMap_, this.ligatureMap_, this.diacriticMap_, this.nonStripMap_, this.removeSTree_, false, false);
        return outs;
    }

    public Vector<String> Mutate(String inTerm) throws Exception {
        LexItem in = new LexItem(inTerm);
        Vector<LexItem> outs = this.Mutate(in);
        Vector<String> outStrs = new Vector<String>();
        for (int i = 0; i < outs.size(); ++i) {
            LexItem cur = outs.elementAt(i);
            outStrs.addElement(cur.GetTargetTerm());
        }
        return outStrs;
    }

    public Vector<LexItem> Mutate(String inTerm, boolean showDetails) throws Exception {
        LexItem in = new LexItem(inTerm);
        Vector<LexItem> outs = new Vector();
        outs = ToNormalize.Mutate(in, this.maxTerm_, this.stopWords_, this.conn_, this.ramTrieI_, this.symbolMap_, this.unicodeMap_, this.ligatureMap_, this.diacriticMap_, this.nonStripMap_, this.removeSTree_, showDetails, false);
        return outs;
    }

    public void CleanUp() {
        try {
            this.Close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Configuration GetConfiguration() {
        return this.conf_;
    }

    public Connection GetConnection() {
        return this.conn_;
    }

    public RamTrie GetTrie() {
        return this.ramTrieI_;
    }

    private void Init() {
        boolean useClassPath = false;
        if (this.configFile_ == null) {
            useClassPath = true;
            this.configFile_ = "data.config.lvg";
        }
        this.conf_ = new Configuration(this.configFile_, useClassPath);
        if (this.properties_ != null) {
            this.conf_.OverwriteProperties(this.properties_);
        }
        int minTermLen = Integer.parseInt(this.conf_.GetConfiguration("MIN_TERM_LENGTH"));
        String lvgDir = this.conf_.GetConfiguration("LVG_DIR");
        if (this.maxTerm_ == -1) {
            this.maxTerm_ = Integer.parseInt(this.conf_.GetConfiguration("MAX_RULE_UNINFLECTED_TERMS"));
        }
        if (this.stopWords_ == null) {
            this.stopWords_ = ToStripStopWords.GetStopWordsFromFile(this.conf_);
        }
        if (this.symbolMap_ == null) {
            this.symbolMap_ = ToMapSymbolToAscii.GetSymbolMapFromFile(this.conf_);
        }
        if (this.unicodeMap_ == null) {
            this.unicodeMap_ = ToMapUnicodeToAscii.GetUnicodeMapFromFile(this.conf_);
        }
        if (this.ligatureMap_ == null) {
            this.ligatureMap_ = ToSplitLigatures.GetLigatureMapFromFile(this.conf_);
        }
        if (this.diacriticMap_ == null) {
            this.diacriticMap_ = ToStripDiacritics.GetDiacriticMapFromFile(this.conf_);
        }
        if (this.nonStripMap_ == null) {
            this.nonStripMap_ = ToStripMapUnicode.GetNonStripMapFromFile(this.conf_);
        }
        if (this.removeSTree_ == null) {
            this.removeSTree_ = ToRemoveS.GetRTrieTreeFromFile(this.conf_);
        }
        try {
            if (this.conn_ == null) {
                this.conn_ = DbBase.OpenConnection(this.conf_);
            }
            if (this.ramTrieI_ == null) {
                this.ramTrieI_ = new RamTrie(true, minTermLen, lvgDir, 0);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void Close() throws IOException, SQLException {
        if (this.conn_ != null) {
            DbBase.CloseConnection(this.conn_, this.conf_);
        }
    }
}

