/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.nls.lexCheck.Lib;

import gov.nih.nlm.nls.lexCheck.Lib.InflVarsAndAgreements;
import gov.nih.nlm.nls.lexCheck.Lib.LexRecord;
import java.util.Vector;

public class CheckContent {
    public static final int OK = 0;
    public static final int WARNING = 1;
    public static final int ERROR = 2;
    private static Vector<String> glregEnds_ = new Vector();
    private static String errMsg_ = new String();
    private static int duplicateFlag_ = 0;
    private static LexRecord fixedLexRecord_ = null;

    public static int Check(LexRecord lexRecord) {
        int validFlag = CheckContent.Check(lexRecord, false);
        return validFlag;
    }

    public static int Check(LexRecord lexRecord, boolean fixFlag) {
        CheckContent.ResetErrMsg();
        int regFlag = CheckContent.CheckGlRefRegD(lexRecord);
        int duplicateFlag = CheckContent.CheckDuplicates(lexRecord, fixFlag);
        int validFlag = CheckContent.CombineValidFlag(regFlag, duplicateFlag);
        return validFlag;
    }

    public static void ResetErrMsg() {
        errMsg_ = new String();
    }

    public static void SetErrMsg(String errMsg) {
        errMsg_ = errMsg;
    }

    public static void AppendErrMsg(String errMsg) {
        errMsg_ = errMsg_ + errMsg;
    }

    public static String GetErrMsg() {
        return errMsg_;
    }

    public static LexRecord GetFixedLexRecord() {
        return fixedLexRecord_;
    }

    private static int CheckDuplicates(LexRecord lexRecord, boolean fixFlag) {
        duplicateFlag_ = 0;
        fixedLexRecord_ = new LexRecord();
        fixedLexRecord_.SetLexRecord(lexRecord);
        String eui = lexRecord.GetEui();
        String cat = lexRecord.GetCategory();
        String base = lexRecord.GetBase();
        Vector<String> spellingVars = lexRecord.GetSpellingVars();
        Vector<String> newSpellingVars = CheckContent.CheckDuplicateBaseSpellingVars(spellingVars, eui, base, cat);
        Vector<String> acronyms = lexRecord.GetAcronyms();
        Vector<String> newAcronyms = CheckContent.CheckDuplicateAcronyms(acronyms, eui, base, cat);
        Vector<String> abbreviations = lexRecord.GetAbbreviations();
        Vector<String> newAbbreviations = CheckContent.CheckDuplicateAbbreviations(abbreviations, eui, base, cat);
        Vector<String> newNominalizations = CheckContent.CheckDuplicateNominalizations(lexRecord, eui, base, cat);
        Vector<String> newVariants = CheckContent.CheckDuplicateVariants(lexRecord, eui, base, cat);
        if (fixFlag) {
            fixedLexRecord_.SetSpellingVars(newSpellingVars);
            fixedLexRecord_.SetAcronyms(newAcronyms);
            fixedLexRecord_.SetAbbreviations(newAbbreviations);
            if (cat.equals("noun")) {
                fixedLexRecord_.GetCatEntry().GetNounEntry().SetNominalization(newNominalizations);
            } else if (cat.equals("verb")) {
                fixedLexRecord_.GetCatEntry().GetVerbEntry().SetNominalization(newNominalizations);
            } else if (cat.equals("adj")) {
                fixedLexRecord_.GetCatEntry().GetAdjEntry().SetNominalization(newNominalizations);
            }
            if (cat.equals("noun")) {
                fixedLexRecord_.GetCatEntry().GetNounEntry().SetVariants(newVariants);
            } else if (cat.equals("verb")) {
                fixedLexRecord_.GetCatEntry().GetVerbEntry().SetVariants(newVariants);
            } else if (cat.equals("adj")) {
                fixedLexRecord_.GetCatEntry().GetAdjEntry().SetVariants(newVariants);
            } else if (cat.equals("adv")) {
                fixedLexRecord_.GetCatEntry().GetAdvEntry().SetVariants(newVariants);
            } else if (cat.equals("pron")) {
                fixedLexRecord_.GetCatEntry().GetPronEntry().SetVariants(newVariants);
            } else if (cat.equals("modal")) {
                fixedLexRecord_.GetCatEntry().GetModalEntry().SetVariant(newVariants);
            } else if (cat.equals("aux")) {
                fixedLexRecord_.GetCatEntry().GetAuxEntry().SetVariant(newVariants);
            }
        }
        return duplicateFlag_;
    }

    private static Vector<String> CheckDuplicateBaseSpellingVars(Vector<String> spellingVars, String eui, String base, String cat) {
        Vector<String> newSpellingVars = new Vector<String>();
        for (int i = 0; i < spellingVars.size(); ++i) {
            String spellingVar = spellingVars.elementAt(i);
            if (spellingVar.equals(base) || newSpellingVars.contains(spellingVar)) {
                duplicateFlag_ = 2;
                CheckContent.AppendErrMsg("** Content Err (Dup-SP): " + spellingVar + " @ (" + eui + "|" + base + "|" + cat + ")\n");
                continue;
            }
            newSpellingVars.addElement(spellingVar);
        }
        return newSpellingVars;
    }

    private static Vector<String> CheckDuplicateAcronyms(Vector<String> acronyms, String eui, String base, String cat) {
        Vector<String> newAcronyms = new Vector<String>();
        for (int i = 0; i < acronyms.size(); ++i) {
            String acronym = acronyms.elementAt(i);
            if (newAcronyms.contains(acronym)) {
                duplicateFlag_ = 2;
                CheckContent.AppendErrMsg("** Content Err (Dup-ACR): " + acronym + " @ (" + eui + "|" + base + "|" + cat + ")\n");
                continue;
            }
            newAcronyms.addElement(acronym);
        }
        return newAcronyms;
    }

    private static Vector<String> CheckDuplicateAbbreviations(Vector<String> abbreviations, String eui, String base, String cat) {
        Vector<String> newAbbreviations = new Vector<String>();
        for (int i = 0; i < abbreviations.size(); ++i) {
            String abbreviation = abbreviations.elementAt(i);
            if (newAbbreviations.contains(abbreviation)) {
                duplicateFlag_ = 2;
                CheckContent.AppendErrMsg("** Content Err (Dup-ABB): " + abbreviation + " @ (" + eui + "|" + base + "|" + cat + ")\n");
                continue;
            }
            newAbbreviations.addElement(abbreviation);
        }
        return newAbbreviations;
    }

    private static Vector<String> CheckDuplicateNominalizations(LexRecord lexRecord, String eui, String base, String cat) {
        Vector<Object> nominalizations = new Vector();
        Vector<String> newNominalizations = new Vector<String>();
        if (cat.equals("noun")) {
            nominalizations = lexRecord.GetCatEntry().GetNounEntry().GetNominalization();
        } else if (cat.equals("verb")) {
            nominalizations = lexRecord.GetCatEntry().GetVerbEntry().GetNominalization();
        } else if (cat.equals("adj")) {
            nominalizations = lexRecord.GetCatEntry().GetAdjEntry().GetNominalization();
        }
        for (int i = 0; i < nominalizations.size(); ++i) {
            String nominalization = (String)nominalizations.elementAt(i);
            if (newNominalizations.contains(nominalization)) {
                duplicateFlag_ = 2;
                CheckContent.AppendErrMsg("** Content Err (Dup-NOM): " + nominalization + " @ (" + eui + "|" + base + "|" + cat + ")\n");
                continue;
            }
            newNominalizations.addElement(nominalization);
        }
        return newNominalizations;
    }

    private static Vector<String> CheckDuplicateVariants(LexRecord lexRecord, String eui, String base, String cat) {
        Vector<Object> variants = new Vector();
        Vector<String> newVariants = new Vector<String>();
        if (cat.equals("noun")) {
            variants = lexRecord.GetCatEntry().GetNounEntry().GetVariants();
        } else if (cat.equals("verb")) {
            variants = lexRecord.GetCatEntry().GetVerbEntry().GetVariants();
        } else if (cat.equals("adj")) {
            variants = lexRecord.GetCatEntry().GetAdjEntry().GetVariants();
        } else if (cat.equals("adv")) {
            variants = lexRecord.GetCatEntry().GetAdvEntry().GetVariants();
        } else if (cat.equals("pron")) {
            variants = lexRecord.GetCatEntry().GetPronEntry().GetVariants();
        } else if (cat.equals("modal")) {
            variants = lexRecord.GetCatEntry().GetModalEntry().GetVariant();
        } else if (cat.equals("aux")) {
            variants = lexRecord.GetCatEntry().GetAuxEntry().GetVariant();
        }
        for (int i = 0; i < variants.size(); ++i) {
            String variant = (String)variants.elementAt(i);
            if (newVariants.contains(variant)) {
                duplicateFlag_ = 2;
                CheckContent.AppendErrMsg("** Content Err (Dup-VAR): " + variant + " @ (" + eui + "|" + base + "|" + cat + ")\n");
                continue;
            }
            newVariants.addElement(variant);
        }
        return newVariants;
    }

    private static int CombineValidFlag(int flag1, int flag2) {
        return flag1 > flag2 ? flag1 : flag2;
    }

    private static int CheckGlRefRegD(LexRecord lexRecord) {
        String base = lexRecord.GetBase();
        String eui = lexRecord.GetEui();
        String cat = lexRecord.GetCategory();
        int validFlag = CheckContent.CheckEnding(base, eui, cat, lexRecord);
        Vector<String> sv = lexRecord.GetSpellingVars();
        for (int i = 0; i < sv.size(); ++i) {
            String svBase = sv.elementAt(i);
            validFlag = CheckContent.CombineValidFlag(validFlag, CheckContent.CheckEnding(svBase, eui, cat, lexRecord));
        }
        return validFlag;
    }

    private static int CheckEnding(String base, String eui, String cat, LexRecord lexRecord) {
        String eui2;
        int validFlag = 0;
        String string = eui2 = eui == null ? new String() : eui + "|";
        if (cat.equals("verb")) {
            Vector<String> variants = lexRecord.GetCatEntry().GetVerbEntry().GetVariants();
            validFlag = CheckContent.CheckRegd(base, eui2, cat, variants);
        } else if (cat.equals("noun")) {
            Vector<String> variants = lexRecord.GetCatEntry().GetNounEntry().GetVariants();
            validFlag = CheckContent.CheckGlreg(base, eui2, cat, variants);
        } else if (cat.equals("adj")) {
            Vector<String> variants = lexRecord.GetCatEntry().GetAdjEntry().GetVariants();
            validFlag = CheckContent.CheckRegd(base, eui2, cat, variants);
        }
        return validFlag;
    }

    private static int CheckRegd(String base, String eui, String cat, Vector<String> variants) {
        int validFlag = 0;
        for (int i = 0; i < variants.size(); ++i) {
            String variant = variants.elementAt(i);
            if (!variant.equals("regd")) continue;
            char lastChar = InflVarsAndAgreements.GetLastChar(base);
            char last2Char = InflVarsAndAgreements.GetLast2Char(base);
            String lastCharStr = new Character(lastChar).toString();
            String last2CharStr = new Character(last2Char).toString();
            if (InflVarsAndAgreements.consonants_.contains(lastCharStr) && InflVarsAndAgreements.vowels_.contains(last2CharStr)) continue;
            validFlag = 2;
            CheckContent.AppendErrMsg("** Content Err (RegD): " + variant + " @ (" + eui + "|" + base + "|" + cat + ")\n");
        }
        return validFlag;
    }

    private static int CheckGlreg(String base, String eui, String cat, Vector<String> variants) {
        int validFlag = 0;
        for (int i = 0; i < variants.size(); ++i) {
            String variant = variants.elementAt(i);
            if (!variant.equals("glreg") && !variant.equals("group(glreg)")) continue;
            validFlag = 2;
            for (int j = 0; j < glregEnds_.size(); ++j) {
                String ending = glregEnds_.elementAt(j);
                if (!base.endsWith(ending)) continue;
                validFlag = 0;
                break;
            }
            if (validFlag != 2) continue;
            CheckContent.AppendErrMsg("** Content Err (GlReg): " + variant + " @ (" + eui + "|" + base + "|" + cat + ")\n");
        }
        return validFlag;
    }

    static {
        glregEnds_.addElement("us");
        glregEnds_.addElement("ma");
        glregEnds_.addElement("a");
        glregEnds_.addElement("um");
        glregEnds_.addElement("on");
        glregEnds_.addElement("sis");
        glregEnds_.addElement("is");
        glregEnds_.addElement("men");
        glregEnds_.addElement("ex");
        glregEnds_.addElement("x");
    }
}

