/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.nls.lexAccess.Api;

import gov.nih.nlm.nls.lexAccess.Util.Out;
import java.io.BufferedWriter;

public class LexAccessHelp {
    private static BufferedWriter bw_ = null;
    private static boolean fileOutput_ = false;

    public static void LexAccessHelp(BufferedWriter bw, boolean fileOutput) {
        bw_ = bw;
        fileOutput_ = fileOutput;
        LexAccessHelp.MenuPrint("");
        LexAccessHelp.MenuPrint("Synopsis:");
        LexAccessHelp.MenuPrint("  lexAccess [options]");
        LexAccessHelp.MenuPrint("");
        LexAccessHelp.MenuPrint("Description:");
        LexAccessHelp.MenuPrint("  LexAccess is a program to retrieve data from the SPECIALIST lexicon");
        LexAccessHelp.MenuPrint("");
        LexAccessHelp.MenuPrint("Options:");
        LexAccessHelp.MenuPrint("  -b:b      Base begins with input term");
        LexAccessHelp.MenuPrint("  -b:c      Base contains input term");
        LexAccessHelp.MenuPrint("  -b:e      Base ends with input term");
        LexAccessHelp.MenuPrint("  -b:ex     Base exact match with input term");
        LexAccessHelp.MenuPrint("  -c:<cat>  Specify category");
        LexAccessHelp.MenuPrint("  -c:h      Help information for specifying category");
        LexAccessHelp.MenuPrint("  -ci       Show configuration information");
        LexAccessHelp.MenuPrint("  -cn:LONG  Specify category in value");
        LexAccessHelp.MenuPrint("  -cnf:LONG Category filter in value");
        LexAccessHelp.MenuPrint("  -f:h      Help information for output format");
        LexAccessHelp.MenuPrint("  -h        Print program help information (this is it)");
        LexAccessHelp.MenuPrint("  -i:STR    Specify input file");
        LexAccessHelp.MenuPrint("  -n        Print -No Records Found-");
        LexAccessHelp.MenuPrint("  -o:STR    Specify output file");
        LexAccessHelp.MenuPrint("  -p        Show prompt");
        LexAccessHelp.MenuPrint("  -q        Print query");
        LexAccessHelp.MenuPrint("  -s:STR    Specify a field separator");
        LexAccessHelp.MenuPrint("  -t        Print total number of retrieved records");
        LexAccessHelp.MenuPrint("  -v        Print the current version of LexAccess");
        LexAccessHelp.MenuPrint("  -x:STR    Specify an alternate configuration file");
    }

    public static void CategoryHelp(BufferedWriter bw, boolean fileOutput) {
        bw_ = bw;
        fileOutput_ = fileOutput;
        LexAccessHelp.MenuPrint("  -c:a     Specify category to Adj (1)");
        LexAccessHelp.MenuPrint("  -c:all   Specify category to all (2047)");
        LexAccessHelp.MenuPrint("  -c:b     Specify category to Adv (2)");
        LexAccessHelp.MenuPrint("  -c:c     Specify category to Compl (8)");
        LexAccessHelp.MenuPrint("  -c:d     Specify category to Det (32)");
        LexAccessHelp.MenuPrint("  -c:h     Help menu for specifying category");
        LexAccessHelp.MenuPrint("  -c:j     Specify category to Conj (16)");
        LexAccessHelp.MenuPrint("  -c:m     Specify category to Modal (64)");
        LexAccessHelp.MenuPrint("  -c:n     Specify category to Noun (128)");
        LexAccessHelp.MenuPrint("  -c:p     Specify category to Prep (256)");
        LexAccessHelp.MenuPrint("  -c:r     Specify category to Pron (512)");
        LexAccessHelp.MenuPrint("  -c:v     Specify category to Verb (1024)");
        LexAccessHelp.MenuPrint("  -c:x     Specify category to Aux (4)");
    }

    public static void FormatHelp(BufferedWriter bw, boolean fileOutput) {
        bw_ = bw;
        fileOutput_ = fileOutput;
        LexAccessHelp.MenuPrint("  -f:b     Print base form");
        LexAccessHelp.MenuPrint("  -f:bd    Print base form with details information");
        LexAccessHelp.MenuPrint("  -f:h     Help menu for print options");
        LexAccessHelp.MenuPrint("  -f:i     Print inflected terms");
        LexAccessHelp.MenuPrint("  -f:id    Print inflected terms with details information");
        LexAccessHelp.MenuPrint("  -f:s     Print base form and spelling variants");
        LexAccessHelp.MenuPrint("  -f:sd    Print base form and spelling variants details");
        LexAccessHelp.MenuPrint("  -f:t     Print lexical records in text format (default)");
        LexAccessHelp.MenuPrint("  -f:tx    Print lexical records in xml & text format");
        LexAccessHelp.MenuPrint("  -f:x     Print lexical records in xml format");
    }

    private static void MenuPrint(String text) {
        try {
            Out.Println(bw_, text, fileOutput_, false);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

