/*
 * Decompiled with CFR 0.152.
 */
package com.fabriziopolo.timecraft.world.map.rendering;

import com.fabriziopolo.textcraft.simulation.Noun;
import com.fabriziopolo.timecraft.world.map.rendering.MapPopulator;
import java.util.ArrayList;
import java.util.List;

public class RectanglesMapPopulator
implements MapPopulator {
    private final List<RectangleAndPopulator> rectanglePopulators = new ArrayList<RectangleAndPopulator>();
    private static final RectangleAndPopulator EMPTY_POPULATOR = new RectangleAndPopulator(new Rectangle(0, 0, Integer.MAX_VALUE, Integer.MIN_VALUE), new MapPopulator(){

        @Override
        public Noun createNewRoomAt(int x, int y) {
            return null;
        }

        @Override
        public void putObjectsInRoom(Noun room, int x, int y) {
        }

        @Override
        public void createExitsAndEntrancesAt(int x, int y, Noun[][] map) {
        }

        @Override
        public void addScenery(Noun room, int x, int y) {
        }

        @Override
        public void finish() {
        }
    });

    public RectanglesMapPopulator add(int left, int top, int width, int height, MapPopulator populator) {
        this.rectanglePopulators.add(new RectangleAndPopulator(new Rectangle(left, top, width, height), populator));
        return this;
    }

    private RectangleAndPopulator findAt(int x, int y) {
        for (RectangleAndPopulator rp : this.rectanglePopulators) {
            if (!rp.rectangle.contains(x, y)) continue;
            return rp;
        }
        return EMPTY_POPULATOR;
    }

    @Override
    public Noun createNewRoomAt(int x, int y) {
        return this.findAt(x, y).createNewRoomAt(x, y);
    }

    @Override
    public void putObjectsInRoom(Noun room, int x, int y) {
        this.findAt(x, y).putObjectsInRoom(room, x, y);
    }

    @Override
    public void createExitsAndEntrancesAt(int x, int y, Noun[][] map) {
        this.findAt(x, y).createExitsAndEntrancesAt(x, y, map);
    }

    @Override
    public void addScenery(Noun room, int x, int y) {
        this.findAt(x, y).addScenery(room, x, y);
    }

    @Override
    public void finish() {
        this.rectanglePopulators.forEach(rp -> rp.finish());
    }

    private static class RectangleAndPopulator
    implements MapPopulator {
        public final Rectangle rectangle;
        public final MapPopulator populator;

        private RectangleAndPopulator(Rectangle rectangle, MapPopulator populator) {
            this.rectangle = rectangle;
            this.populator = populator;
        }

        @Override
        public Noun createNewRoomAt(int x, int y) {
            y = this.rectangle.top;
            return this.populator.createNewRoomAt(x - this.rectangle.left, y);
        }

        @Override
        public void putObjectsInRoom(Noun room, int x, int y) {
            y = this.rectangle.top;
            this.populator.putObjectsInRoom(room, x - this.rectangle.left, y);
        }

        @Override
        public void createExitsAndEntrancesAt(int x, int y, Noun[][] map) {
            y = this.rectangle.top;
            this.populator.createExitsAndEntrancesAt(x - this.rectangle.left, y, map);
        }

        @Override
        public void addScenery(Noun room, int x, int y) {
            this.populator.addScenery(room, x - this.rectangle.left, y - this.rectangle.top);
        }

        @Override
        public void finish() {
            this.populator.finish();
        }
    }

    private static class Rectangle {
        public final int left;
        public final int top;
        public final int width;
        public final int height;

        private Rectangle(int left, int top, int width, int height) {
            this.left = left;
            this.top = top;
            this.width = width;
            this.height = height;
        }

        public boolean contains(int x, int y) {
            return x >= this.left && x < this.left + this.width && y >= this.top && y < this.top + this.height;
        }
    }
}

