/*
 * Decompiled with CFR 0.152.
 */
package com.fabriziopolo.timecraft.world.map.rendering;

import com.fabriziopolo.textcraft.objects.EmptyNoun;
import com.fabriziopolo.textcraft.simulation.Frame;
import com.fabriziopolo.textcraft.simulation.Noun;
import com.fabriziopolo.textcraft.simulation.Simulation;
import com.fabriziopolo.textcraft.states.time.TimeState;
import com.fabriziopolo.textcraft.states.updatable.DelayedUpdateable;
import com.fabriziopolo.textcraft.states.updatable.PutObjectInRoomUpdateable;
import com.fabriziopolo.textcraft.worldbuilder.WorldBuilder;
import com.fabriziopolo.timecraft.world.dsl.Dsl;
import com.fabriziopolo.timecraft.world.map.rendering.MapPopulator;
import com.fabriziopolo.timecraft.world.map.rendering.MapRoomCreator;
import com.fabriziopolo.timecraft.world.map.rendering.RoomPopulator;
import com.fabriziopolo.timecraft.world.map.rendering.Util;
import java.util.function.BiPredicate;
import java.util.function.Supplier;

public class PaintedMapPopulator
extends WorldBuilder
implements MapPopulator {
    protected final Dsl dsl;
    protected final int xLength;
    protected final int yLength;
    protected final MapRoomCreator[][] roomCreatorMap;
    protected final RoomPopulator[][] roomPopulatorMap;
    protected final RoomPopulator[][] sceneryPopulatorMap;

    public PaintedMapPopulator(Simulation simulation, int xLength, int yLength) {
        super(simulation);
        this.dsl = new Dsl(simulation);
        this.xLength = xLength;
        this.yLength = yLength;
        this.roomCreatorMap = new MapRoomCreator[xLength][yLength];
        this.roomPopulatorMap = new RoomPopulator[xLength][yLength];
        this.sceneryPopulatorMap = new RoomPopulator[xLength][yLength];
    }

    @Override
    public Noun createNewRoomAt(int x, int y) {
        Noun room = this.roomCreatorMap[x][y].create(x, y);
        return room;
    }

    @Override
    public void putObjectsInRoom(Noun room, int x, int y) {
        RoomPopulator populator = this.roomPopulatorMap[x][y];
        if (populator == null) {
            return;
        }
        populator.populate(room, x, y);
    }

    @Override
    public void createExitsAndEntrancesAt(int x, int y, Noun[][] map) {
        Util.createOpenExitsAndEntrances(this.dsl, x, y, 0, -1, map);
        Util.createOpenExitsAndEntrances(this.dsl, x, y, 0, 1, map);
        Util.createOpenExitsAndEntrances(this.dsl, x, y, 1, 0, map);
        Util.createOpenExitsAndEntrances(this.dsl, x, y, -1, 0, map);
    }

    @Override
    public void addScenery(Noun room, int x, int y) {
        RoomPopulator populator = this.sceneryPopulatorMap[x][y];
        if (populator == null) {
            return;
        }
        populator.populate(room, x, y);
    }

    @Override
    public void finish() {
    }

    protected RoomPopulator populate(Noun noun) {
        return this.delayedPopulate(noun, 0, 0);
    }

    protected RoomPopulator delayedPopulate(Noun noun, int day, int hour) {
        return this.delayedPopulate(() -> noun, day, hour);
    }

    protected RoomPopulator delayedPopulate(final Supplier<Noun> nounProducer, final int day, final int hour) {
        return new RoomPopulator(){

            @Override
            public void populate(Noun room, Integer x, Integer y) {
                Frame frame = PaintedMapPopulator.this.simulation.getCurrentFrame();
                EmptyNoun updateToken = new EmptyNoun();
                DelayedUpdateable delayedPopulateUpdate = new DelayedUpdateable(TimeState.getGameTimeAt(day, hour, frame), new PutObjectInRoomUpdateable(updateToken, (Noun)nounProducer.get(), room));
                PaintedMapPopulator.this.dsl.setUpdateable(updateToken, delayedPopulateUpdate);
            }
        };
    }

    protected void paintWithPredicate(BiPredicate<Integer, Integer> predicate, MapRoomCreator creator) {
        for (int x = 0; x < this.xLength; ++x) {
            for (int y = 0; y < this.yLength; ++y) {
                if (!predicate.test(x, y)) continue;
                this.roomCreatorMap[x][y] = creator;
            }
        }
    }

    protected void paintVerticalLine(int x, MapRoomCreator creator) {
        this.paintWithPredicate((xx, yy) -> xx == x, creator);
    }

    protected MapRoomCreator chooseRandom(MapRoomCreator ... creators) {
        return creators[this.simulation.getRandom().nextInt(creators.length)];
    }
}

