/*
 * Decompiled with CFR 0.152.
 */
package com.fabriziopolo.timecraft.world.map.alpha;

import com.fabriziopolo.textcraft.player.Player;
import com.fabriziopolo.textcraft.simulation.SinglePlayerSimulation;
import com.fabriziopolo.textcraft.states.coordinate.Coordinates;
import com.fabriziopolo.textcraft.worldbuilder.WorldBuilder;
import com.fabriziopolo.timecraft.world.map.alpha.AlphaMapPopulator;
import com.fabriziopolo.timecraft.world.map.alpha.AlphaPlayerBuilder;
import com.fabriziopolo.timecraft.world.map.rendering.RectangularWorldMapBuilder;

public final class AlphaWorldMapBuilder
extends WorldBuilder {
    private final Player player;
    private static final int eastWestLength = 61;
    private static final int northSouthLength = 61;
    private static final int startX = 40;
    private static final int startY = 30;
    private final AlphaMapPopulator mapPopulator;
    private final RectangularWorldMapBuilder rectangularWorldMapBuilder;

    public AlphaWorldMapBuilder(SinglePlayerSimulation simulation) {
        super(simulation);
        this.player = simulation.player;
        this.mapPopulator = new AlphaMapPopulator(simulation, this.player, 61, 61, 40, 30);
        this.rectangularWorldMapBuilder = new RectangularWorldMapBuilder(simulation, this.mapPopulator, 61, 61, 40, 30);
    }

    public void buildWorld() {
        this.rectangularWorldMapBuilder.buildWorld();
        this.createPlayer();
        this.simulation.update();
        this.simulation.update();
        this.simulation.update();
        this.simulation.update();
        this.rectangularWorldMapBuilder.finish();
    }

    public static boolean isByIsland(Coordinates coord) {
        return 38.0 <= coord.x && coord.x <= 44.0 && 29.0 <= coord.y && coord.y <= 33.0;
    }

    public static boolean isEastOfIsland(Coordinates coord) {
        return 44.0 < coord.x;
    }

    public static int getSouthBeachY() {
        return 32;
    }

    public static int getNorthnBeachY() {
        return 30;
    }

    public static int getWestBeachX() {
        return 39;
    }

    public static int getEastBeachX() {
        return 43;
    }

    private void createPlayer() {
        new AlphaPlayerBuilder(this.simulation).buildPlayer(this.player, this.rectangularWorldMapBuilder.getStartRoom());
    }
}

